(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["main"],{

/***/ "+4dD":
/*!***********************************!*\
  !*** ./src/assets/json/faq_en.ts ***!
  \***********************************/
/*! exports provided: faqData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faqData", function() { return faqData; });
const faqData = {
    data: [
        { "id": 1,
            "Question": "1. What is the eVisa ?",
            "Answer": "The eVisa is a document that certifies that the holder is authorized to enter and stay in the Republic of Djibouti for a specified period. It replaces the visa issued at the point of entry into the country, which is usually an airport or border crossing. Applicants can obtain their visa electronically, after providing the required information and making the payment online. Once the application is approved, the eVisa is sent to the applicant by e-mail. Candidates are required to print their eVisa and keep it with their passport at all times when travelling in the Republic of Djibouti. The eVisa is only valid if the purpose of the trip is tourism, business or transit. Other purposes, such as work and study, require a traditional visa obtained at embassies or consulates. The eVisa, like the tradditional visa, does not guarantee entry into the Republic of Djibouti. The border authorities may refuse entry on rare occasions.",
            "QuestionFrench": "Qu'est-ce l'eVisa?",
            "AnswerFrench": "L'eVisa est un document qui certifie que le titulaire est autorisé à entrer et séjourner en République de Djibouti pour une période déterminée. Il remplace le visa délivré au point d'entrée dans le pays, qui est habituellement un aéroport ou un poste frontalier. Les demandeurs peuvent obtenir leur visa par voie électronique, après avoir fourni les informations requises et effectué le paiement en ligne. Une fois que la demande est approuvée, l'eVisa est envoyé au demandeur par courrier électronique. Les candidats sont tenus d'imprimer leur eVisa et de le conserver avec leur passeport en tout temps, lorsqu'ils voyagent en République de Djibouti. L'eVisa n'est valide que si le but du voyage est le tourisme, le commerce ou le transit. D'autres fins, tels que le travail et les études, exigent un visa traditionnel obtenu aux ambassades ou consulats. L'eVisa, à l'instar du visa traditionnel, ne garantit pas l'entrée en République de Djibouti. Les autorités frontalières peuvent refuser l'entrée en de rares occasions."
        },
        {
            "id": 2,
            "Question": "2. What do I need to apply for an electronic visa ?",
            "Answer": "A passport valid for at least 6 months, a flight reservation (or any other possible means of transport), an accommodation address (Hotel or at your host's), an invitation letter (organisation or host with their contacts) and a credit card (visa, Mastercard or American Express).",
            "QuestionFrench": "Que me faut-il pour faire une demande de visa électronique ?",
            "AnswerFrench": "Un passeport valide pour 6 mois minimum, une réservation de vol (ou tout autre moyen possible de transport), une adresse d’hébergement (Hôtel ou chez votre hôte), une lettre d'invitation (organisation ou hôte avec leurs contacts) et une carte de crédit (visa, Mastercard ou American Express)."
        },
        {
            "Question": "3.What are the advantages of the eVisa ?",
            "Answer": "You can easily get your eVisa from any location connected to the Internet. You will therefore not have to go through the traditional visa application process. You will also make your arrival process easier.",
            "QuestionFrench": "Quels sont les avantages de l'eVisa ?",
            "AnswerFrench": "Vous pouvez facilement obtenir votre eVisa depuis n'importe quel endroit connecté à Internet. Vous n'aurez donc pas à passer par le processus traditionnel de demande de visa. Vous vous faciliterez également votre processus d'arrivée."
        },
        {
            "Question": "4. Who can request an eVisa ?",
            "Answer": "Any person wishing to travel to the Republic of Djibouti is eligible for the eVisa as long as the reason for travel is family, tourist or business. You can also request an e-Visa if you are in transit. If you are a holder of a diplomatic, service or passport or if you are part of a program eligible for a courtesy visa and you travel within the framework, you may be exempt from visa requirements. Please refer to the program that suits you. For any other reason, you must visit the nearest Embassy or Consulate General of the Republic of Djibouti to apply for a visa.",
            "QuestionFrench": "Qui peut demander un eVisa ?",
            "AnswerFrench": "Toute personne voulant se rendre en République de Djibouti est éligible pour l'eVisa. Si vous être détendeur d’un passeport diplomatique, de service ou, ou si vous faites partie d’un programme éligible au visa de courtoisie vous êtes exempté de visa. Si votre motif de séjour est autre que le tourisme ou le commerce, vous devez visiter l'Ambassade / le Consulat général de la République de Djibouti le plus proche pour faire une demande de visa."
        },
        {
            "Question": "5. Do I have to enter the Republic of Djibouti on the exact date specified in my application ?",
            "Answer": "The validity period of your eVisa begins on the date you specified in your application. You may enter the Republic of Djibouti on any date within this validity period.",
            "QuestionFrench": "Dois-je entrer en République de Djibouti à la date exacte spécifiée dans ma demande ?",
            "AnswerFrench": "La période de validité de votre eVisa commence à la date que vous avez spécifié dans votre demande. Vous pouvez entrer en République de Djibouti à n'importe quelle date à l'intérieur de cette période de validité."
        },
        {
            "Question": "6. If my travel date changes, can I change the date on my eVisa ?",
            "Answer": "No. If you do not use your eVisa during its validity period, you will need to request another one.",
            "QuestionFrench": "Si ma date de voyage change, puis-je modifier la date sur mon eVisa ?",
            "AnswerFrench": "Non. Si vous n'utilisez pas votre eVisa pendant sa période de validité, vous devrez en demander un autre."
        },
        {
            "Question": "7. Is it safe ?",
            "Answer": "The Republic of Djibouti shall not sell, rent or otherwise use for commercial purposes to third parties the personal information entered on the eVisa website. Data obtained in each step of the process eVisa are stored in high security conditions. eVisa issued electronically and printed by the are entirely the responsibility of the applicant. The responsibility also rests with the applicant if this information is somehow in the hands of third parties. Information concerning the applicant stored in the barcode on the eVisa, are encrypted by the Ministry of the Interior of the Republic of Djibouti and signed electronically. Access to the content of this information is given to Only to institutions authorized by the Ministry of the Interior of the Republic of Djibouti. Problems caused by an alteration of the barcode are the responsibility of the applicant.",
            "QuestionFrench": "Est-ce sûr?",
            "AnswerFrench": "La République de Djibouti ne vend pas, ne loue pas à des tiers ni n'utilise autrement à des fins commerciales les informations personnelles saisies sur le site Internet du eVisa. Les données obtenues en chaque étape du processus eVisa sont stockés dans des conditions de haute sécurité. Les eVisa émis par voie électronique et imprimés par le demandeur sont entièrement sous sa responsabilité. La responsabilité appartient également au demandeur si cette information se retrouve d'une manière quelconque entre les mains de tierces personnes. Les informations concernant le demandeur stockés dans le code-barres se trouvant sur l'eVisa, sont chiffrés par le Ministère de l’Intérieur de la République de République de Djibouti et signés électroniquement. L'accès au contenu de ces informations est donné seulement aux institutions autorisées par le Ministère de l’Intérieur de la République de République de Djibouti. Les problèmes causés par d'une altération du code-barres sont sous la responsabilité du demandeur."
        },
        {
            "Question": "8. Do I need a separate eVisa for my companions ?",
            "Answer": "Yes, each traveller must have their own eVisa.",
            "QuestionFrench": "Dois-je obtenir un eVisa séparé pour les personnes qui m'accompagnent?",
            "AnswerFrench": "Oui, chaque voyageur doit avoir son propre eVisa."
        },
        {
            "Question": "9. Is the eVisa refundable ?",
            "Answer": "No. Your eVisa will not be refunded even if you do not use it.",
            "QuestionFrench": "L'eVisa est-il remboursable?",
            "AnswerFrench": "Non. Votre eVisa ne vous sera pas remboursé même si vous ne l'utilisez pas."
        },
        {
            "Question": "10. Can I get a multiple-entry eVisa?",
            "Answer": "No, the eVisa is only valid for one entry.",
            "QuestionFrench": "Puis-je entrer en République de Djibouti si une partie des informations sur mon eVisa ne correspond pas aux informations sur mon passeport?",
            "AnswerFrench": "Non, vous ne le pouvez pas. L'eVisa est associé électroniquement avec le passeport d'un passager. Par conséquent, vous devez entrer en République de Djibouti avec le même passeport avec lequel vous avez demandé un eVisa. Sinon, votre eVisa sera invalide."
        },
        {
            "Question": "11. Can I enter the Republic of Djibouti if some of the information on my eVisa does not match the information on my passport ?",
            "Answer": "No, you can't do that. The eVisa is associated electronically with a passenger's passport. Therefore, you must enter the Republic of Djibouti with the same passport with which you applied for an eVisa. Otherwise, your eVisa will be invalid.",
            "QuestionFrench": "Je tiens à rester en République de Djibouti pour une durée plus longue que ne le permet l'eVisa. Que dois-je faire?",
            "AnswerFrench": "Si vous souhaitez rester en République de Djibouti plus que ne le permet votre eVisa, vous devez vous adresser aux services de Police locaux pour un permis de séjour. Veuillez noter que l'eVisa est délivré uniquement à des fins de tourisme et de commerce. La demande d'autres types de visa (visa de travail, visa d'étudiant etc.) doit être fait par le biais des ambassades et consulats djiboutiens. Si vous dépassez la durée de votre visa, vous pouvez être invité à payer des amendes, être déporté ou interdit de voyager en République de Djibouti à l'avenir pour une certain temps."
        },
        {
            "Question": "12. I want to stay in the Republic of Djibouti for a longer period than the eVisa allows. What am I supposed to do ?",
            "Answer": "If you wish to stay in the Republic of Djibouti more than your eVisa allows, you must apply to the local police services for a permit to stay. Please note that the eVisa is issued for tourism and commercial purposes only. The application for other types of visa (work visa, visa student etc.) must be done through Djiboutian embassies and consulates. If you exceed the duration of your visa, you may be required to pay a fine and face deportation or a travel ban to the Republic of Djibouti for a period of time.",
            "QuestionFrench": "Est-il sûr de faire un paiement par carte de crédit sur la page internet du eVisa ?",
            "AnswerFrench": "Le site Web applique des normes de sécurité de niveau élevé. En revanche, nous ne pouvons être tenus pour responsables de toute défaillance de sécurité due à l'ordinateur que vous utilisez ou à votre connexion Internet."
        },
        {
            "Question": "13. Is it safe to make a credit card payment on the eVisa website ?",
            "Answer": "The website has high security standards. However, we cannot be held responsible for any security failure due to the computer you use or your Internet connection.",
            "QuestionFrench": "Je me suis rendu compte qu'une partie des informations que j'ai fournies au cours de ma demande d'eVisa ne correspondent pas à ceux figurant sur mon passeport. Que dois-je faire?",
            "AnswerFrench": "Vous devez faire une nouvelle demande."
        },
        {
            "Question": "14. I have found that some of the information I provided during my eVisa application does not match the information on my passport. What am I supposed to do ?",
            "Answer": "You must apply again.",
            "QuestionFrench": "J'ai complété ma demande. Combien de temps cela prendra-t-il pour que mon eVisa me soit envoyé par courrier électronique?",
            "AnswerFrench": "Votre eVisa vous sera envoyé par courriel habituellement dans les 72 heures ouvrées suivant la date à laquelle vous avez rempli votre demande et que les éléments de décision sont réunis. En République de Djibouti, les jours de weekend sont le Vendredi et le Samedi."
        },
        {
            "Question": "15. I've completed my application. How long will it take for my eVisa to be emailed to me ?",
            "Answer": "Your eVisa will usually be emailed to you within 72 hours of the date you completed your application and the decision elements are in place. In the Republic of Djibouti, weekend days are Friday and Saturday.",
            "QuestionFrench": "Que dois-je faire si ma demande de visa électronique n'est pas approuvée?",
            "AnswerFrench": "Si vous avez reçu un message électronique de notification pour vous informer que votre demande de visa électronique n'a pas été approuvée, vous pouvez entrer en contact avec l'ambassade ou le consulat de République de Djibouti le plus proche pour une demande de visa traditionnel."
        },
        {
            "Question": "16. What do I do if my electronic visa application is not approved ?",
            "Answer": "If you have received an electronic notification message informing you that your electronic visa application has not been approved, you may contact the nearest embassy or consulate of the Republic of Djibouti for a traditional visa application.",
            "QuestionFrench": "Si ma demande d'eVisa est refusée, serai-je remboursé?",
            "AnswerFrench": "Les frais de visa sont des frais administratifs. Ils ne seront donc pas remboursés si votre eVisa n’est pas accordé."
        },
        {
            "Question": "17. If my eVisa application is refused, will I be reimbursed?",
            "Answer": "Visa fees are an administrative fee. They will not be refunded if your eVisa is not granted.",
            "QuestionFrench": "Combien de jours avant la date de mon voyage dois-je demander mon eVisa ?",
            "AnswerFrench": "Vous pouvez demander un eVisa au plus tard 72 heures avant votre voyage. Toutefois, il est conseillé de faire la demande au moins une semaine avant votre voyage."
        },
        {
            "Question": "18. How many days before my travel date should I request my eVisa",
            "Answer": "You can request an eVisa at least 72 hours before your trip. However, it is advisable to apply at least one week before your trip and take into account the weekend days in the Republic of Djibouti (Friday and Saturday).",
            "QuestionFrench": "J'ai fait une demande de visa auprès d'une ambassade (ou consulat général) de République de Djibouti. Je veux faire le point sur ma demande. Puis-je me renseigner à travers ce site web?",
            "AnswerFrench": "Non, vous devez contacter l'ambassade (consulat général) en question pour obtenir des informations sur votre demande."
        },
        {
            "Question": "19. I applied for a visa at an embassy (or consulate general) of the Republic of Djibouti. I want to get an update on my request. Can I get information through this website ?",
            "Answer": "No, you must contact the embassy (consulate general) in question to obtain information about your application.",
            "QuestionFrench": "Je me suis aperçu que certains des renseignements que j'avais fournis lors de ma demande d'eVisa ne correspondent pas aux informations sur mon passeport. J'ai effectué le paiement, et maintenant j'ai un eVisa avec des informations erronées. Puis-je obtenir un remboursement?",
            "AnswerFrench": "Non. Le demandeur est responsable de toute erreur."
        },
        {
            "Question": "20. I have found that some of the information I provided when I applied for an eVisa does not match the information on my passport. I made the payment, and now I have an eVisa with incorrect information. Can I get a refund ?",
            "Answer": "No. The applicant is responsible for any errors.",
            "QuestionFrench": "Je ne veux pas faire une demande d’eVisa. Puis-je toujours obtenir un visa à l'aéroport?",
            "AnswerFrench": "Non, aucun visa ne sera délivré à l’aéroport ou tout autre point frontière à compter du 1er février 2018."
        },
        {
            "Question": "21. No. The applicant is responsible for any errors.",
            "Answer": "No, no visas will be issued at the airport or any other border point as of May 1, 2018.",
            "QuestionFrench": "Je n'ai pas de carte de crédit ou de carte bancaire. Y-a-t-il un autre moyen de payer les frais de mon eVisa ?",
            "AnswerFrench": "Non, vous ne pouvez effectuer le paiement qu'avec une carte de crédit ou une carte bancaire (uniquement Mastercard, Visa ou American Express). Par contre, la carte ne doit pas obligatoirement être à votre nom."
        },
        {
            "Question": "22. I don't have a credit or debit card. Is there another way to pay for my eVisa ?",
            "Answer": "No, you can only pay with a credit card or bank card (Mastercard, Visa or American Express only). However, the card does not have to be in your name.",
            "QuestionFrench": "Je ne peux pas effectuer le paiement. Que dois-je faire?",
            "AnswerFrench": "Veuillez vous assurer que la carte est soit une «MasterCard», soit une «Visa» (elle ne doit pas être obligatoirement à votre nom), soit une «American Express» ou «Amex», qu’elle possède le système « 3D Secure » et qu’elle est ouverte aux transactions internationales. Si votre carte a toutes ces propriétés et que vous ne pouvez toujours pas effectuer le paiement, vous pouvez essayer de payer à un autre moment ou avec une autre carte. Si le problème persiste, vous pouvez contacter votre banque pour demander son assistance. Au cas où vous ne réussissez toujours pas, s'il vous plaît « Contactez-nous» (Page d'accueil)."
        },
        {
            "Question": "23. I can't make the payment. What am I supposed to do ?",
            "Answer": "Please make sure that the card is either a 'MasterCard', 'Visa' or 'American Express' ('Amex') (it does not have to be in your name), that it has the 3D Secure 'system and that it is open to international transactions. If your card has all these properties and you still cannot make the payment, you can try to pay at another time or with another card. If the problem persists, you can contact your bank for assistance. In case you still don't succeed, please 'Contact Us' (Home Page).",
            "QuestionFrench": "Dans la section 'Informations personnelles' il n'y a pas de place pour le deuxième prénom. Où dois-je écrire mon deuxième prénom?",
            "AnswerFrench": "Saisissez votre deuxième prénom dans la case 'Prénom' après votre prénom et un espace blanc."
        },
        {
            "Question": "24. In the 'Personal Information' section there is no space for the middle name. Where do I write my middle name ?",
            "Answer": "Enter your middle name in the 'First name' box after your first name and a blank space.",
            "QuestionFrench": "Je veux que l'adresse sur ma facture soit différente de l'adresse sur mon eVisa. Est-ce possible?",
            "AnswerFrench": "Non. L'adresse sur votre facture est automatiquement prélevée sur votre eVisa."
        },
        {
            "Question": "25. I want the address on my invoice to be different from the address on my eVisa. Is that possible ?",
            "Answer": "Yes, the address on your invoice is the one you provide at the time of payment. It may therefore differ from the address on your eVisa.",
            "QuestionFrench": "Que veut dire numéro CVV / CVC / CVC2 ?",
            "AnswerFrench": "Pour Visa et MasterCard CVV / CVC / CVC2 sont les trois chiffres du numéro imprimé sur la bande de signature au dos de votre carte (Visa, Mastercard) et les quatre numéro à l'avant de votre Amex."
        },
        {
            "Question": "26. What does CVV / CVC / CVC2 number mean?",
            "Answer": "For Visa and MasterCard CVV / CVC / CVC2 are the three digits of the number printed on the signature strip on the back of your card (Visa, Mastercard) or the four numbers on the front of your Amerian Express.",
            "QuestionFrench": "Mon enfant est inscrit dans mon passeport. Dois-je faire une demande de eVisa séparée pour lui /pour elle?",
            "AnswerFrench": "Oui. Veuillez utiliser les données d'identification de votre enfant et les informations de votre passeport pour cette demande."
        },
        {
            "Question": "27. How much does an eVisa cost?",
            "Answer": "eVisa fees vary by visa type; A transit visa (from 1 to 14 days) costs $12 and a short stay visa (from 15 to 90 days) will cost $23.",
            "QuestionFrench": "Combien coûte un eVisa?",
            "AnswerFrench": "Les frais du eVisa varient selon le type de visa ; Un visa de transit (1 à 14 jours) coûte 12$ et un visa de court séjour (15 à 90 jours) vous coutera 23$."
        },
        {
            "Question": "28. How long will my eVisa be valid for ?",
            "Answer": "The validity period of your eVisa will start on the date you enter the Republic of Djibouti. Please note that the duration of validity is different from the duration of the stay. The length of your stay cannot exceed that mentioned on your eVisa.",
            "QuestionFrench": "Quelle sera la durée de validité de mon eVisa?",
            "AnswerFrench": "La durée de validité de votre eVisa débutera à la date de votre entrée en République de Djibouti. Veuillez noter que la durée de validité est différente de la durée du séjour. La durée du séjour ne peut excéder la durée de séjour mentionnée sur votre eVisa."
        },
        {
            "Question": "29. Do I need a transit visa even if I do not leave the airport ?",
            "Answer": "No, you do not need a transit visa if you do not leave the transit area.",
            "QuestionFrench": "Dois-je obtenir un visa de transit même si je ne quitte pas l'aéroport?",
            "AnswerFrench": "Non, vous n'avez pas besoin de visa de transit si vous ne quittez paz la zone de transit."
        }
    ]
};


/***/ }),

/***/ 0:
/*!***************************!*\
  !*** multi ./src/main.ts ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /home/medeni/dev/evisaV2/evisa-deploiement-final-22-01-2025/evisa-applicant-ui/src/main.ts */"zUnb");


/***/ }),

/***/ "1CsG":
/*!*********************************************************************************************!*\
  !*** ./src/app/main/pending-payment/pending-payment-edit/pending-payment-edit.component.ts ***!
  \*********************************************************************************************/
/*! exports provided: PendingPaymentEditComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PendingPaymentEditComponent", function() { return PendingPaymentEditComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @stripe/stripe-js */ "v4r+");
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var ng_popups__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ng-popups */ "iQtR");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");











function PendingPaymentEditComponent_p_54_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "SIDEBAR.Manage Applications"), "");
} }
const _c0 = function () { return ["/main/dashboard"]; };
const _c1 = function () { return ["/main/pending-payment"]; };
class PendingPaymentEditComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__["BaseComponent"] {
    // datePipe: any;
    constructor(inj, ngxLoader, datepipe, ngPopups) {
        super(inj);
        this.ngxLoader = ngxLoader;
        this.datepipe = datepipe;
        this.ngPopups = ngPopups;
        this.paymentDetails = {};
        /* -------------------------------------------------------------------------------------*/
        this.stripePromise = Object(_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__["loadStripe"])(src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].stripe_key);
        this.activatedRoute.params.subscribe((params) => {
            this.paymentDetails = params['id'];
            this.fetchPaymentDetails(this.paymentDetails);
        });
    }
    ngOnInit() {
        this.getDateToday();
        if (localStorage.getItem('Language') === 'en') {
            this.message = "Are you sure, want to pay ?";
            this.moneyRefund = "Payment of the application fee in no way guarantees that you will receive your visa. These fees, which cover administrative procedures, are non-refundable, even in the event of visa refusal or withdrawal of the application.";
        }
        else {
            this.message = "Êtes-vous sûr de vouloir payer?";
            this.moneyRefund = "Le paiement des frais de dossier ne garantit en aucun cas l'obtention du visa. Ces frais, qui couvrent les démarches administratives, ne sont pas remboursables, même en cas de refus de visa ou de retrait de la demande.";
        }
    }
    fetchPaymentDetails(id) {
        this.commonService.callApi('payment/' + id, '', 'get', false, false, 'REG').then(success => {
            this.paymentDetails = success;
            this.paymentDetails.status = "Pending Payment";
            //console.log(this.paymentDetails.createdDate);
            this.paymentDetails.createdDate = this.datepipe.transform(this.paymentDetails.createdDate, "dd-MM-yyyy HH:mm:ss");
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getDateToday() {
        this.ngxLoader.start();
        setTimeout(() => {
            // this.data.instrType = "EVISA_PAY"
            this.commonService.callApi('dateressource', '', 'post', false, false, 'REG').then(success => {
                let successData = success;
                let currentDate = new Date(successData);
                // Ajouter une semaine à la date actuelle
                currentDate.setDate(currentDate.getDate() + 7);
                // Mettre à jour successData avec la nouvelle date
                successData = currentDate.toISOString();
                this.datetoday = successData;
                this.ngxLoader.stop();
            }).catch(e => {
                this.ngxLoader.stop();
                this.toastr.error(e.message, 'Oops!');
            });
        });
    }
    checkout(file, amount, instrType) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            //console.log(amount)
            // Call your backend to create the Checkout session.
            // When the customer clicks on the button, redirect them to Checkout.
            const stripe = yield this.stripePromise;
            this.ngPopups.confirm(this.moneyRefund, { title: this.message }).subscribe(res => {
                if (res) {
                    const payment = {
                        amount: amount * 100,
                        referenceNumber: file,
                        // cancelUrl: 'http://87.106.107.227/applicant-api/#/main/dashboard',
                        // successUrl: 'http://87.106.107.227/applicant-api/#/main/success-payment',
                        //cancelUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/dashboard',
                        //successUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/success-payment',
                        // cancelUrl: 'http://localhost:4200/applicant-api/cancel',
                        // successUrl: 'http://localhost:4200/applicant-api/#/main/success-payment', 
                        cancelUrl: 'https://eastbleu.org/#/main/dashboard',
                        successUrl: 'https://eastbleu.org/#/main/success-payment',
                        // cancelUrl: 'http://217.160.99.180/applicant-api/cancel',
                        // successUrl: 'http://217.160.99.180/applicant-api/#/main/success-payment', 
                        // cancelUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/dashboard',
                        // successUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/success-payment',
                        instrType: instrType
                    };
                    // this is a normal http calls for a backend api
                    this.http
                        .post(`${src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].serverUrl}`, payment)
                        .subscribe((data) => {
                        // I use stripe to redirect To Checkout page of Stripe platform
                        // stripe.redirectToCheckout({
                        //   sessionId: data.refId,
                        // });
                        const result = stripe.redirectToCheckout({
                            sessionId: data.refId,
                        });
                        //console.log(result);
                    });
                }
            });
        });
    }
}
PendingPaymentEditComponent.ɵfac = function PendingPaymentEditComponent_Factory(t) { return new (t || PendingPaymentEditComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](ngx_ui_loader__WEBPACK_IMPORTED_MODULE_5__["NgxUiLoaderService"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_6__["DatePipe"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](ng_popups__WEBPACK_IMPORTED_MODULE_7__["NgPopupsService"])); };
PendingPaymentEditComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: PendingPaymentEditComponent, selectors: [["app-pending-payment-edit"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 80, vars: 43, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], [3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], [1, "portlet-body", "form"], ["role", "form", 1, "form-horizontal"], [1, "form-body"], [1, "form-group"], [1, "col-md-3", "control-label"], [1, "col-md-6"], [1, "form-control-static"], ["class", "form-control-static", 4, "ngIf"], [1, "form-actions", "fluid"], [1, "text-center"], ["routerLinkActive", "active", "type", "button", 1, "btn", "default", 3, "routerLink"]], template: function PendingPaymentEditComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](14, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](19, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](20, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](21, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](22, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](24, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](25, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](26, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](27, "form", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](28, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](29, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](30, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](31, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](32, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](35, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](36, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](38, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](39, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](40, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](41, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](42);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](43, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](44, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](45, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](46);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](47, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](48, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](49, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](50, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](51);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](52, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](53, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](54, PendingPaymentEditComponent_p_54_Template, 3, 3, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](55, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](56, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](57, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](58, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](59);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](60, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](61, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](62, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](63);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](64, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](65, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](66, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](67, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](68);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](69, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](70, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](71, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](72);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](73, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](74, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](75, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](76, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](77, "button", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](78);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](79, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 19, "SIDEBAR.PendingPayment"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](41, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 21, "APPLICATIONSPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](13, 23, "SIDEBAR.PendingPayment"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](17, 25, "PAYMENT.View"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](24, 27, "PAYMENT.View"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](34, 29, "PAYMENT.File Number"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](ctx.paymentDetails == null ? null : ctx.paymentDetails.fileNumber);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](43, 31, "PAYMENT.Due Amount"), " : ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate2"]("", ctx.paymentDetails == null ? null : ctx.paymentDetails.amountDue, " ", ctx.paymentDetails == null ? null : ctx.paymentDetails.paymentCurrency, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](52, 33, "PAYMENT.Instruction Type"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (ctx.paymentDetails == null ? null : ctx.paymentDetails.instrType) === "EVISA_PAY");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](60, 35, "PAYMENT.Status"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx.paymentDetails == null ? null : ctx.paymentDetails.status, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](69, 37, "PAYMENT.Invoiced Date"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx.paymentDetails == null ? null : ctx.paymentDetails.createdDate, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](42, _c1));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](79, 39, "PAYMENT.Cancel"));
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_8__["RouterLinkWithHref"], _angular_forms__WEBPACK_IMPORTED_MODULE_9__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_9__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_9__["NgForm"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], _angular_router__WEBPACK_IMPORTED_MODULE_8__["RouterLinkActive"], _angular_router__WEBPACK_IMPORTED_MODULE_8__["RouterLink"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__["TranslatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJwZW5kaW5nLXBheW1lbnQtZWRpdC5jb21wb25lbnQuY3NzIn0= */"] });


/***/ }),

/***/ "2hPh":
/*!*********************************************************************************************!*\
  !*** ./src/app/main/pending-payment/pending-payment-list/pending-payment-list.component.ts ***!
  \*********************************************************************************************/
/*! exports provided: PendingPaymentListComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PendingPaymentListComponent", function() { return PendingPaymentListComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @stripe/stripe-js */ "v4r+");
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var ng_popups__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-popups */ "iQtR");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ngx-bootstrap/tooltip */ "Mfq2");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ng-select/ng-select */ "ZOsW");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ngx-bootstrap/pagination */ "Lm2G");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");














function PendingPaymentListComponent_tr_52_td_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](data_r3 == null ? null : data_r3.fileNumber);
} }
function PendingPaymentListComponent_tr_52_td_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate2"]("", data_r3 == null ? null : data_r3.amountDue, " ", data_r3 == null ? null : data_r3.paymentCurrency, "");
} }
function PendingPaymentListComponent_tr_52_td_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "SIDEBAR.Manage Applications"));
} }
function PendingPaymentListComponent_tr_52_td_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "Result.PendingPayment"));
} }
function PendingPaymentListComponent_tr_52_td_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind2"](2, 1, data_r3 == null ? null : data_r3.createdDate, "dd-MM-yyyy HH:mm:ss"));
} }
function PendingPaymentListComponent_tr_52_td_6_a_4_Template(rf, ctx) { if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "a", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PendingPaymentListComponent_tr_52_td_6_a_4_Template_a_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r16); const data_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2).$implicit; const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return ctx_r14.checkout(data_r3 == null ? null : data_r3.fileNumber, data_r3 == null ? null : data_r3.amountDue, data_r3 == null ? null : data_r3.instrType); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "button", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](3, 1, "PAYMENT.pay"));
} }
const _c0 = function (a1) { return ["/main/pending-payment/pending-edit/", a1]; };
function PendingPaymentListComponent_tr_52_td_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "a", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](2, "i", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3, " \u00A0\u00A0 ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](4, PendingPaymentListComponent_tr_52_td_6_a_4_Template, 4, 3, "a", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](5, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](6, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction1"](8, _c0, data_r3 == null ? null : data_r3.fileNumber));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind2"](5, 2, data_r3 == null ? null : data_r3.createdDate, "yyyy-MM-ddZ") < _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind2"](6, 5, ctx_r9.datetoday, "yyyy-MM-ddZ"));
} }
function PendingPaymentListComponent_tr_52_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "tr", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](1, PendingPaymentListComponent_tr_52_td_1_Template, 2, 1, "td", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](2, PendingPaymentListComponent_tr_52_td_2_Template, 2, 2, "td", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](3, PendingPaymentListComponent_tr_52_td_3_Template, 3, 3, "td", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](4, PendingPaymentListComponent_tr_52_td_4_Template, 3, 3, "td", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](5, PendingPaymentListComponent_tr_52_td_5_Template, 3, 4, "td", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](6, PendingPaymentListComponent_tr_52_td_6_Template, 7, 10, "td", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.instrType) === "EVISA_PAY");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.instrType) === "EVISA_PAY");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.instrType) === "EVISA_PAY");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.status) === "PP" && (data_r3 == null ? null : data_r3.instrType) === "EVISA_PAY");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.instrType) === "EVISA_PAY");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.instrType) === "EVISA_PAY");
} }
function PendingPaymentListComponent_tr_53_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "tr", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "td", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 1, "RECORDS.NoFound"));
} }
const _c1 = function () { return { standalone: true }; };
function PendingPaymentListComponent_div_54_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "div", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "div", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "ng-select", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("change", function PendingPaymentListComponent_div_54_Template_ng_select_change_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return ctx_r18.rangeChanged(ctx_r18.pagesize); })("ngModelChange", function PendingPaymentListComponent_div_54_Template_ng_select_ngModelChange_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return ctx_r20.pagesize = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "div", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "div", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "div", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](13, "pagination", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function PendingPaymentListComponent_div_54_Template_pagination_ngModelChange_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return ctx_r21.currentPage = $event; })("pageChanged", function PendingPaymentListComponent_div_54_Template_pagination_pageChanged_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r19); const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return ctx_r22.pageChanged($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("items", ctx_r2.rangeList)("ngModel", ctx_r2.pagesize)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](24, _c1))("clearable", false)("searchable", false)("dropdownPosition", "top");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate4"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](7, 18, "PAGINATION.Showing"), " ", ctx_r2.number * ctx_r2.size + 1, " ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](8, 20, "PAGINATION.to"), " ", ctx_r2.number * ctx_r2.size + ctx_r2.noofelements, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](10, 22, "PAGINATION.entries"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("boundaryLinks", ctx_r2.showBoundaryLinks)("rotate", "true")("itemsPerPage", ctx_r2.pagesize)("totalItems", ctx_r2.totalItem)("maxSize", 5)("ngModel", ctx_r2.currentPage)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](25, _c1));
} }
const _c2 = function () { return ["/main/dashboard"]; };
class PendingPaymentListComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__["BaseComponent"] {
    constructor(inj, ngxLoader, ngPopups) {
        super(inj);
        this.ngxLoader = ngxLoader;
        this.ngPopups = ngPopups;
        this.pagesize = 10;
        this.data = {
            pageNumber: 1,
            pageSize: this.pagesize,
        };
        this.loading = false;
        this.pendingPayment = [];
        /******************************************************************************/
        /****************************************************************************
            @PURPOSE      : Pagination
            @PARAMETERS   : pageNumber,PageSize,loggedinuse
            @RETURN       : NA
         ****************************************************************************/
        this.currentPage = 1;
        this.showBoundaryLinks = true;
        this.rangeList = [5, 10, 25, 100];
        this.isFilterApplied = false;
        this.filterObj = {};
        /*******************************************************************************/
        this.stripePromise = Object(_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__["loadStripe"])(src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].stripe_key);
    }
    ngOnInit() {
        this.getPendingPayment(this.data);
        this.getDateToday();
        if (localStorage.getItem('Language') === 'en') {
            this.message = "Are you sure, want to pay ?";
            this.moneyRefund = "Payment of the application fee in no way guarantees that you will receive your visa. These fees, which cover administrative procedures, are non-refundable, even in the event of visa refusal or withdrawal of the application.";
        }
        else {
            this.message = "Êtes-vous sûr de vouloir payer?";
            this.moneyRefund = "Le paiement des frais de dossier ne garantit en aucun cas l'obtention du visa. Ces frais, qui couvrent les démarches administratives, ne sont pas remboursables, même en cas de refus de visa ou de retrait de la demande.";
        }
    }
    refreshPage() {
        this.getPendingPayment(this.data);
    }
    getPendingPayment(data) {
        this.loading = true;
        this.ngxLoader.start();
        setTimeout(() => {
            this.data.loggedUser = this.getToken('username'),
                this.data.status = 'PP';
            // this.data.instrType = "EVISA_PAY"
            this.commonService.callApi('payment/search', data, 'post', false, false, 'REG').then(success => {
                let successData = success;
                this.totalItem = successData.totalElements;
                this.number = successData.number;
                this.size = successData.size;
                this.loading = false;
                this.ngxLoader.stop();
                this.noofelements = successData.numberOfElements;
                this.totalElements = successData.totalElements;
                //console.log(successData);
                if (successData.content.length) {
                    this.pendingPayment = successData.content;
                    //console.log(this.pendingPayment);
                }
                else {
                    this.pendingPayment = [];
                }
            }).catch(e => {
                this.ngxLoader.stop();
                this.toastr.error(e.message, 'Oops!');
            });
        });
    }
    getDateToday() {
        this.loading = true;
        this.ngxLoader.start();
        setTimeout(() => {
            // this.data.instrType = "EVISA_PAY"
            this.commonService.callApi('dateressource', '', 'post', false, false, 'REG').then(success => {
                let successData = success;
                let currentDate = new Date(successData);
                // Ajouter une semaine à la date actuelle
                currentDate.setDate(currentDate.getDate() + 7);
                // Mettre à jour successData avec la nouvelle date
                successData = currentDate.toISOString();
                this.datetoday = successData;
                this.ngxLoader.stop();
            }).catch(e => {
                this.ngxLoader.stop();
                this.toastr.error(e.message, 'Oops!');
            });
        });
    }
    pageChanged(e) {
        if (this.isFilterApplied) {
            this.filterObj.pageNumber = e.page;
            this.filterObj.pageSize = e.itemsPerPage;
            this.getPendingPayment(this.filterObj);
        }
        else {
            this.data.pageNumber = e.page;
            this.data.pageSize = e.itemsPerPage;
            this.getPendingPayment(this.data);
        }
    }
    rangeChanged(e) {
        if (this.isFilterApplied) {
            this.filterObj.pageSize = e;
            this.getPendingPayment(this.filterObj);
        }
        else {
            this.data.pageSize = e;
            this.getPendingPayment(this.data);
        }
    }
    checkout(file, amount, instrType) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            //console.log(amount)
            // Call your backend to create the Checkout session.
            // When the customer clicks on the button, redirect them to Checkout.
            const stripe = yield this.stripePromise;
            this.ngPopups.confirm(this.moneyRefund, { title: this.message }).subscribe(res => {
                if (res) {
                    const payment = {
                        amount: amount * 100,
                        referenceNumber: file,
                        // cancelUrl: 'http://87.106.107.227/applicant-api/#/main/dashboard',
                        // successUrl: 'http://87.106.107.227/applicant-api/#/main/success-payment',
                        //cancelUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/dashboard',
                        //successUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/success-payment',
                        // cancelUrl: 'http://localhost:4200/#/main/dashboard',
                        // successUrl: 'http://localhost:4200/applicant-api/#/main/success-payment', 
                        cancelUrl: 'https://eastbleu.org/#/main/dashboard',
                        successUrl: 'https://eastbleu.org/#/main/success-payment',
                        //  cancelUrl: 'http://217.160.99.180/applicant-api/cancel',
                        // successUrl: 'http://217.160.99.180/applicant-api/#/main/success-payment', 
                        // cancelUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/dashboard',
                        // successUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/success-payment',
                        instrType: instrType
                    };
                    // this is a normal http calls for a backend api
                    //console.log('environment.serverUrl',environment.serverUrl);
                    this.http
                        .post(`${src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].serverUrl}`, payment)
                        .subscribe((data) => {
                        // I use stripe to redirect To Checkout page of Stripe platform
                        // stripe.redirectToCheckout({
                        //   sessionId: data.refId,
                        // }); 
                        const result = stripe.redirectToCheckout({
                            sessionId: data.refId,
                        });
                        //console.log(result);
                    });
                }
            });
        });
    }
}
PendingPaymentListComponent.ɵfac = function PendingPaymentListComponent_Factory(t) { return new (t || PendingPaymentListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](ngx_ui_loader__WEBPACK_IMPORTED_MODULE_5__["NgxUiLoaderService"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](ng_popups__WEBPACK_IMPORTED_MODULE_6__["NgPopupsService"])); };
PendingPaymentListComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: PendingPaymentListComponent, selectors: [["app-pending-payment-list"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 56, vars: 38, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], ["href", "javascript:;", 3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], ["href", "javascript:;", "tooltip", "Refresh", 2, "position", "relative", "top", "-5px", "color", "#e5e5e5", 3, "click"], [1, "fa", "fa-refresh"], [1, "portlet-body"], [1, "table-scrollable"], ["id", "sample_editable_1", 1, "styled-table"], ["class", "odd gradeX", 4, "ngFor", "ngForOf"], ["class", "odd", 4, "ngIf"], ["class", "row", 4, "ngIf"], ["hasProgressBar", "false", "fgsType", "three-strings"], [1, "odd", "gradeX"], [4, "ngIf"], ["href", "javascript:;", "tooltip", "Edit", "routerLinkActive", "active", 3, "routerLink"], [1, "fa", "fa-eye"], ["href", "javascript:;", "tooltip", "Payment", 3, "click", 4, "ngIf"], ["href", "javascript:;", "tooltip", "Payment", 3, "click"], [1, "btn", "btn-blue"], [1, "odd"], ["colspan", "10", 1, "dataTables_empty", 2, "text-align", "center"], [1, "col-md-4", "col-sm-12"], [1, "btn-group"], ["bindLabel", "name", "bindValue", "id", "placeholder", "Select", 3, "items", "ngModel", "ngModelOptions", "clearable", "searchable", "dropdownPosition", "change", "ngModelChange"], ["id", "sample_editable_1_info", 1, "dataTables_info"], [1, "dataTables_paginate", "paging_bootstrap"], ["name", "currentPage", "ngDefaultControl", "", "previousText", "\u2039", "nextText", "\u203A", "firstText", "\u00AB", "lastText", "\u00BB", 1, "page", 3, "boundaryLinks", "rotate", "itemsPerPage", "totalItems", "maxSize", "ngModel", "ngModelOptions", "ngModelChange", "pageChanged"]], template: function PendingPaymentListComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](14, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](19, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](20, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](21, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](22, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](24, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](25, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](26, "a", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PendingPaymentListComponent_Template_a_click_26_listener() { return ctx.refreshPage(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](27, "i", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](28, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](29, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](30, "table", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](31, "thead");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](32, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](33, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](34);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](35, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](36, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](38, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](39, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](40);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](41, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](42, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](43);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](44, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](45, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](46);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](47, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](48, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](49);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](50, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](51, "tbody");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](52, PendingPaymentListComponent_tr_52_Template, 7, 6, "tr", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](53, PendingPaymentListComponent_tr_53_Template, 5, 3, "tr", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](54, PendingPaymentListComponent_div_54_Template, 14, 26, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](55, "ngx-ui-loader", 19);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 15, "SIDEBAR.PendingPayment"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](37, _c2));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 17, "APPLICATIONSPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](13, 19, "SIDEBAR.Manage Visa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](17, 21, "SIDEBAR.PendingPayment"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](24, 23, "SIDEBAR.All payments pending"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](35, 25, "PAYMENT.File Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](38, 27, "PAYMENT.Due Amount"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](41, 29, "PAYMENT.Instruction Type"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](44, 31, "PAYMENT.Status"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](47, 33, "PAYMENT.Invoiced Date"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](50, 35, "PAYMENT.Action"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx.pendingPayment);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", !ctx.pendingPayment.length && !ctx.loading);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.totalElements > 0);
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_7__["RouterLinkWithHref"], ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_8__["TooltipDirective"], _angular_common__WEBPACK_IMPORTED_MODULE_9__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_9__["NgIf"], ngx_ui_loader__WEBPACK_IMPORTED_MODULE_5__["ɵb"], _angular_router__WEBPACK_IMPORTED_MODULE_7__["RouterLinkActive"], _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_10__["NgSelectComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_11__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_11__["NgModel"], ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_12__["PaginationComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_11__["DefaultValueAccessor"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_13__["TranslatePipe"], _angular_common__WEBPACK_IMPORTED_MODULE_9__["DatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJwZW5kaW5nLXBheW1lbnQtbGlzdC5jb21wb25lbnQuY3NzIn0= */"] });


/***/ }),

/***/ "31uo":
/*!***********************************************************************!*\
  !*** ./src/app/main/payment-completed/payment-completed.component.ts ***!
  \***********************************************************************/
/*! exports provided: PaymentCompletedComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PaymentCompletedComponent", function() { return PaymentCompletedComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ "tyNb");


class PaymentCompletedComponent {
    constructor() { }
    ngOnInit() {
    }
}
PaymentCompletedComponent.ɵfac = function PaymentCompletedComponent_Factory(t) { return new (t || PaymentCompletedComponent)(); };
PaymentCompletedComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: PaymentCompletedComponent, selectors: [["app-payment-completed"]], decls: 1, vars: 0, template: function PaymentCompletedComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "router-outlet");
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterOutlet"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJwYXltZW50LWNvbXBsZXRlZC5jb21wb25lbnQuY3NzIn0= */"] });


/***/ }),

/***/ "3WXT":
/*!***************************************************************************!*\
  !*** ./src/app/main/application-preview/application-preview.component.ts ***!
  \***************************************************************************/
/*! exports provided: ApplicationPreviewComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApplicationPreviewComponent", function() { return ApplicationPreviewComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");






function ApplicationPreviewComponent_table_302_tr_12_td_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "ATTACHMENTSINFO.Passport Copy"));
} }
function ApplicationPreviewComponent_table_302_tr_12_td_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "ATTACHMENTSINFO.Photograph"));
} }
function ApplicationPreviewComponent_table_302_tr_12_td_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "ATTACHMENTSINFO.Ticket/Reservation"), " ");
} }
function ApplicationPreviewComponent_table_302_tr_12_td_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "ATTACHMENTSINFO.Hotel Booking/ Invitation Letter"));
} }
function ApplicationPreviewComponent_table_302_tr_12_td_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "ATTACHMENTSINFO.VisaTransit"));
} }
function ApplicationPreviewComponent_table_302_tr_12_Template(rf, ctx) { if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](3, ApplicationPreviewComponent_table_302_tr_12_td_3_Template, 3, 3, "td", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](4, ApplicationPreviewComponent_table_302_tr_12_td_4_Template, 3, 3, "td", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](5, ApplicationPreviewComponent_table_302_tr_12_td_5_Template, 3, 3, "td", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](6, ApplicationPreviewComponent_table_302_tr_12_td_6_Template, 3, 3, "td", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](7, ApplicationPreviewComponent_table_302_tr_12_td_7_Template, 3, 3, "td", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "a", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ApplicationPreviewComponent_table_302_tr_12_Template_a_click_9_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r10); const data_r2 = ctx.$implicit; const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r9.downloadAttachment(data_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r2 = ctx.$implicit;
    const j_r3 = ctx.index;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](j_r3 + 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r2 == null ? null : data_r2.attachmentType) === "PP");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r2 == null ? null : data_r2.attachmentType) === "PG");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r2 == null ? null : data_r2.attachmentType) === "TK");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r2 == null ? null : data_r2.attachmentType) === "HI");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r2 == null ? null : data_r2.attachmentType) === "TS");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r2 == null ? null : data_r2.fileName);
} }
function ApplicationPreviewComponent_table_302_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "table", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "thead");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4, "#");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](12, ApplicationPreviewComponent_table_302_tr_12_Template, 11, 7, "tr", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](7, 3, "ATTACHMENTSINFO.Description"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](10, 5, "ATTACHMENTSINFO.Attach File"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r0.attachmentsPreview);
} }
const _c0 = function () { return ["/main/dashboard"]; };
var FileSaver = __webpack_require__(/*! file-saver */ "Iab2");
class ApplicationPreviewComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj) {
        super(inj);
        this.attachmentsPreview = [];
        this.activatedRoute.params.subscribe((params) => {
            if (params['id']) {
                this.applicationId = params['id'];
            }
        });
    }
    ngOnInit() {
        this.getPreview();
    }
    getPreview() {
        this.commonService.callApi('applicationpreview?applicationNumber=' + this.applicationId, '', 'post', false, false, 'REG').then(success => {
            let successData = success;
            this.personalPreview = successData.applicantPersonalDetails;
            this.passportPreview = successData.applicantPassportTravelDetails;
            this.attachmentsPreview = successData.applicantAttachmentDetailsDTOList.applicantAttachmentDTOs;
            this.attachmentsPreview.forEach((data) => {
                if (data.attachmentType === 'PP') {
                    data['order'] = 2;
                }
                else if (data.attachmentType === 'PG') {
                    data['order'] = 1;
                }
                else if (data.attachmentType === 'TK') {
                    data['order'] = 3;
                }
                else if (data.attachmentType === 'HI') {
                    data['order'] = 4;
                }
            });
            this.attachmentsPreview.sort(function (a, b) {
                return a.order - b.order;
            });
            console.log(this.personalPreview);
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    downloadAttachment(data) {
        let sendData = {
            "applicationNumber": this.getToken('applicationNumber'),
            "attachmentType": data.attachmentType,
            "attachmentId": data.attachmentId
        };
        this.commonService.downloadAttachment('applicantattachments/attachmentid', sendData).subscribe((res) => {
            this.resource = res;
            let blob = new Blob([this.resource], { type: "application/xml;charset=UTF-8" });
            FileSaver.saveAs(blob, data.fileName);
        });
    }
}
ApplicationPreviewComponent.ɵfac = function ApplicationPreviewComponent_Factory(t) { return new (t || ApplicationPreviewComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"])); };
ApplicationPreviewComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ApplicationPreviewComponent, selectors: [["app-application-preview"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 312, vars: 170, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], ["href", "javascript:;", 3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], ["href", "#"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "fa", "fa-globe"], [1, "tools"], [1, "portlet-body"], [1, "portlet-body", "form"], ["action", "#", 1, "form-horizontal"], [1, "form-body"], [1, "form-section"], [1, "col-md-6"], [1, "form-group"], [1, "control-label", "col-md-3"], [1, "col-md-9"], [1, "form-control-static"], ["class", "styled-table", "id", "sample_editable_1", 4, "ngIf"], [1, "form-actions", "fluid"], [1, "col-md-offset-3", "col-md-9"], ["href", "javascript:;", 1, "btn", "default", "button-previous", "pull-right", 3, "routerLink"], [1, "m-icon-swapleft"], ["id", "sample_editable_1", 1, "styled-table"], [4, "ngFor", "ngForOf"], [4, "ngIf"], ["href", "javascript:;", 3, "click"]], template: function ApplicationPreviewComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "a", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](20, "i", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](23, "div", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "form", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](27, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "h3", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](29);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](30, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](34, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](35);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](36, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](37, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](38, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](39);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](41, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](42, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](43);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](44, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](46, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](47);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](48, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](49, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](50, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](51, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](52);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](53, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](54, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](55, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](56);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](57, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](58, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](59, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](60);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](61, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](62, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](63, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](64);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](65, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](66, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](67, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](68, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](69);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](70, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](71, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](72, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](73);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](74, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](75, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](76, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](77);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](78, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](79, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](80, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](81);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](82, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](83, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](84, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](85);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](86, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](87, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](88, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](89);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](90, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](91, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](92, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](93, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](94);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](95, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](96, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](97, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](98);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](99, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](100, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](101, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](102, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](103);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](104, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](105, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](106, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](107);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](108, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](109, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](110, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](111);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](112, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](113, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](114, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](115);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](116, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](117, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](118, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](119, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](120);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](121, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](122, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](123, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](124);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](125, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](126, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](127, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](128);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](129, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](130, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](131, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](132);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](133, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](134, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](135, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](136, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](137);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](138, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](139, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](140, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](141);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](142, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](143, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](144, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](145);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](146, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](147, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](148, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](149);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](150, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](151, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](152, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](153, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](154);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](155, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](156, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](157, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](158);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](159, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](160, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](161, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](162);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](163, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](164, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](165, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](166);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](167, "h3", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](168);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](169, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](170, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](171, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](172, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](173, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](174);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](175, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](176, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](177, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](178);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](179, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](180, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](181, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](182);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](183, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](184, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](185, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](186);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](187, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](188, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](189, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](190, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](191);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](192, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](193, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](194, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](195);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](196, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](197, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](198, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](199);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](200, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](201, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](202, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](203);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](204, "h3", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](205);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](206, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](207, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](208, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](209, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](210, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](211);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](212, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](213, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](214, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](215);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](216, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](217, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](218, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](219);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](220, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](221, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](222, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](223);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](224, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](225, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](226, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](227, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](228);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](229, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](230, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](231, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](232);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](233, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](234, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](235, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](236, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](237);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](238, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](239, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](240, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](241);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](242, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](243, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](244, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](245, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](246, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](247);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](248, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](249, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](250, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](251);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](252, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](253, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](254, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](255);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](256, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](257, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](258, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](259);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](260, "h3", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](261);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](262, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](263, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](264, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](265, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](266, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](267);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](268, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](269, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](270, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](271);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](272, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](273, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](274, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](275);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](276, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](277, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](278, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](279);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](280, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](281, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](282, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](283, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](284);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](285, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](286, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](287, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](288);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](289, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](290, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](291, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](292, "label", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](293);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](294, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](295, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](296, "p", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](297);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](298, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](299, "h3", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](300);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](301, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](302, ApplicationPreviewComponent_table_302_Template, 13, 7, "table", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](303, "div", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](304, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](305, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](306, "div", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](307, "a", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](308, "i", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](309);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](310, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](311, "\u00A0 ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 73, "APPLICATIONPREVIEW.Application Preview"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](168, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 75, "DASHBOARDPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](14, 77, "APPLICATIONPREVIEW.Application Preview"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](22, 79, "DASHBOARDPAGE.My Application Details"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](30, 81, "VISADETAILS.PersonalInformation"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](36, 83, "PERSONALINFO.Title"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.title);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](44, 85, "PERSONALINFO.Surname"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.surname);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](53, 87, "PERSONALINFO.Given Name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.givenName);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](61, 89, "PERSONALINFO.Middle Name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.middleName);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](70, 91, "PERSONALINFO.Gender"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"]((ctx.personalPreview == null ? null : ctx.personalPreview.gender) === "M" ? "MALE" : "FEMALE");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](78, 93, "PERSONALINFO.MaritalStatus"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.maritalStatus);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](86, 95, "PERSONALINFO.Date Of Birth"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](90, 97, ctx.personalPreview == null ? null : ctx.personalPreview.dateOfBirth, "dd-MM-yyyy"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](95, 100, "PERSONALINFO.Profession"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.profession);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](104, 102, "PERSONALINFO.Birth Place"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.birthPlace);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](112, 104, "PERSONALINFO.Birth Country"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.birthCountry);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](121, 106, "PERSONALINFO.Nationality"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.nationality);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](129, 108, "PERSONALINFO.Current Nationality"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", ctx.personalPreview == null ? null : ctx.personalPreview.currentNationality, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](138, 110, "PERSONALINFO.Email Address"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.emailAddress);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](146, 112, "PERSONALINFO.Phone Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.phoneNumber);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](155, 114, "PERSONALINFO.Prefered Language"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", ctx.personalPreview == null ? null : ctx.personalPreview.preferredLanguage, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](163, 116, "PERSONALINFO.OriginCountry"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.originCountry);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](169, 118, "MYPROFILE.Address"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](175, 120, "PERSONALINFO.Residential Address"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", ctx.personalPreview == null ? null : ctx.personalPreview.residentialAddress, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](183, 122, "PERSONALINFO.Address in Djibouti"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.djiboutiAddress);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](192, 124, "PERSONALINFO.City of Residence"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.residenceCity);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](200, 126, "PERSONALINFO.Country Of Residence"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.personalPreview == null ? null : ctx.personalPreview.residenceCountry);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](206, 128, "VISADETAILS.PassportDetails"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](212, 130, "TRAVELINFO.Passport Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.passportPreview == null ? null : ctx.passportPreview.passportNumber);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](220, 132, "TRAVELINFO.Country of Issue"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.passportPreview == null ? null : ctx.passportPreview.issuedCountry);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](229, 134, "TRAVELINFO.Date Of Issue"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](233, 136, ctx.passportPreview == null ? null : ctx.passportPreview.issuedDate, "dd-MM-yyyy"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](238, 139, "TRAVELINFO.Date Of Expiry"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](242, 141, ctx.passportPreview == null ? null : ctx.passportPreview.expiryDate, "dd-MM-yyyy"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](248, 144, "TRAVELINFO.LastVistitedCountries"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", ctx.passportPreview == null ? null : ctx.passportPreview.lastVisitedCountries, " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](256, 146, "TRAVELINFO.AdditionalInformation"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.passportPreview == null ? null : ctx.passportPreview.additionalInformation, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](262, 148, "VISADETAILS.TravelInformation"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](268, 150, "TRAVELINFO.Arrival Location"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.passportPreview == null ? null : ctx.passportPreview.arrivalLocation);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](276, 152, "TRAVELINFO.Purpose of Travel"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.passportPreview == null ? null : ctx.passportPreview.travelPurpose);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](285, 154, "TRAVELINFO.Date of Arrival in Djibouti"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](289, 156, ctx.passportPreview == null ? null : ctx.passportPreview.arrivalDate, "dd-MM-yyyy"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](294, 159, "TRAVELINFO.Date Of Departure from Djibouti"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](298, 161, ctx.passportPreview == null ? null : ctx.passportPreview.departureDate, "dd-MM-yyyy"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](301, 164, "VISADETAILS.Attachments"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.attachmentsPreview.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](169, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](310, 166, "VISADETAILS.Back"), " ");
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterLinkWithHref"], _angular_forms__WEBPACK_IMPORTED_MODULE_3__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_3__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_3__["NgForm"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgIf"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgForOf"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslatePipe"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["DatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJhcHBsaWNhdGlvbi1wcmV2aWV3LmNvbXBvbmVudC5jc3MifQ== */"] });


/***/ }),

/***/ "3pyi":
/*!***************************************************************!*\
  !*** ./src/app/main/new-dashboard/new-dashboard.component.ts ***!
  \***************************************************************/
/*! exports provided: NewDashboardComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NewDashboardComponent", function() { return NewDashboardComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");
/* harmony import */ var ngx_spinner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ngx-spinner */ "JqCM");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ngx-bootstrap/tooltip */ "Mfq2");
/* harmony import */ var _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ng-select/ng-select */ "ZOsW");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ngx-bootstrap/pagination */ "Lm2G");











function NewDashboardComponent_tr_90_a_2_Template(rf, ctx) { if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "a", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function NewDashboardComponent_tr_90_a_2_Template_a_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r11); const data_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r9.downloadApplication(data_r3 == null ? null : data_r3.applicationNumber); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](1, "i", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Content.Download"), " ");
} }
function NewDashboardComponent_tr_90_td_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Result.Granted"));
} }
function NewDashboardComponent_tr_90_td_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Result.Rejected"));
} }
function NewDashboardComponent_tr_90_td_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Result.UnderProcessing"));
} }
function NewDashboardComponent_tr_90_td_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Result.PendingPayment"));
} }
const _c0 = function (a1) { return ["/main/application-preview", a1]; };
function NewDashboardComponent_tr_90_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](2, NewDashboardComponent_tr_90_a_2_Template, 4, 3, "a", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "a", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](5, "i", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "u");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](12, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](15, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](16, NewDashboardComponent_tr_90_td_16_Template, 4, 3, "td", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](17, NewDashboardComponent_tr_90_td_17_Template, 4, 3, "td", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](18, NewDashboardComponent_tr_90_td_18_Template, 4, 3, "td", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](19, NewDashboardComponent_tr_90_td_19_Template, 4, 3, "td", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.visaStatus) === "APR");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](16, _c0, data_r3 == null ? null : data_r3.applicationNumber));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", data_r3 == null ? null : data_r3.applicationNumber, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r3 == null ? null : data_r3.givenName);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](12, 10, data_r3 == null ? null : data_r3.submittedDate, "dd-MM-yyyy HH:mm:ss"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](15, 13, data_r3 == null ? null : data_r3.closedDate, "dd-MM-yyyy HH:mm:ss"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.visaStatus) === "APR");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.visaStatus) === "REJ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.visaStatus) === "UP");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r3 == null ? null : data_r3.visaStatus) === "PP");
} }
function NewDashboardComponent_tr_91_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 1, "RECORDS.NoFound"));
} }
const _c1 = function () { return { standalone: true }; };
function NewDashboardComponent_div_92_Template(rf, ctx) { if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "ng-select", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function NewDashboardComponent_div_92_Template_ng_select_change_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r12.rangeChanged(ctx_r12.pagesize); })("ngModelChange", function NewDashboardComponent_div_92_Template_ng_select_ngModelChange_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r14.pagesize = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "pagination", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function NewDashboardComponent_div_92_Template_pagination_ngModelChange_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13); const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r15.currentPage = $event; })("pageChanged", function NewDashboardComponent_div_92_Template_pagination_pageChanged_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r13); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r16.pageChanged($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("items", ctx_r2.rangeList)("ngModel", ctx_r2.pagesize)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](28, _c1))("clearable", false)("searchable", false)("dropdownPosition", "top");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate7"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](7, 20, "PAGINATION.Showing"), " ", ctx_r2.number * ctx_r2.size + 1, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](8, 22, "PAGINATION.to"), " ", ctx_r2.number * ctx_r2.size + ctx_r2.noofelements, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 24, "PAGINATION.of"), " ", ctx_r2.totalElements, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](10, 26, "PAGINATION.entries"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("boundaryLinks", ctx_r2.showBoundaryLinks)("rotate", "true")("itemsPerPage", ctx_r2.pagesize)("totalItems", ctx_r2.totalItem)("maxSize", 5)("ngModel", ctx_r2.currentPage)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](29, _c1));
} }
const _c2 = function () { return ["/main/manage-applications/apps-details/new"]; };
const _c3 = function () { return ["/main/evisa-extension/apply-visa-list"]; };
class NewDashboardComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj, translate, spinner, renderer, ngxLoader, datepipe) {
        super(inj);
        this.translate = translate;
        this.spinner = spinner;
        this.renderer = renderer;
        this.ngxLoader = ngxLoader;
        this.datepipe = datepipe;
        this.pagesize = 10;
        this.page = 1;
        this.isCollapsed = true;
        this.campaignData = [];
        this.colorTheme = 'theme-blue';
        this.data = {
            pageNumber: 1,
            pageSize: this.pagesize,
        };
        /****************************************************************************
            @PURPOSE      : To retrive the  applications List
            @PARAMETERS   : pageNumber,PageSize,loggedinuser
            @RETURN       : NA
        ****************************************************************************/
        this.Applications = [];
        this.number = 0;
        this.size = 0;
        this.noofelements = 0;
        this.totalElements = 0;
        this.upStatus = false;
        /****************************************************************************/
        /****************************************************************************
         @PURPOSE      : Paginations
         @PARAMETERS   : pageNumber,PageSize,loggedinuse
         @RETURN       : NA
      ****************************************************************************/
        this.currentPage = 1;
        this.showBoundaryLinks = true;
        this.rangeList = [5, 10, 25, 100];
        this.isFilterApplied = false;
        this.filterObj = {};
        translate.use(localStorage.getItem("Language"));
        this.bsConfig = Object.assign({}, { containerClass: this.colorTheme, customTodayClass: 'custom-today-class' });
    }
    ngOnInit() {
        this.getApplications(this.data);
        if ($('li.main.active')) {
            $('li.open').removeClass('open');
            $('ul.sub-menu').css('display', 'none');
        }
    }
    refreshPage() {
        this.getApplications(this.data);
    }
    getApplications(data) {
        data.loggedUser = this.getToken('username');
        this.loading = true;
        this.ngxLoader.start();
        setTimeout(() => {
            this.commonService.callApi('searchapplicationtracker', data, 'post', false, false, 'REG').then(success => {
                let successData = success;
                this.totalItem = successData.totalElements;
                this.number = successData.number;
                this.size = successData.size;
                this.loading = false;
                this.ngxLoader.stop();
                this.noofelements = successData.numberOfElements;
                this.totalElements = successData.totalElements;
                if (successData.content.length) {
                    this.Applications = successData.content;
                    let double = this.Applications.filter(x => x.visaStatus == 'UP');
                    if (double.length > 0) {
                        this.upStatus = true;
                    }
                    else {
                        this.upStatus = false;
                    }
                }
                else {
                    this.Applications = [];
                }
                console.log(this.Applications);
            }).catch(e => {
                this.ngxLoader.stop();
                this.toastr.error(e.message, 'Oops!');
            });
        });
    }
    pageChanged(e) {
        this.Applications = [];
        if (this.isFilterApplied) {
            this.filterObj.pageNumber = e.page;
            this.filterObj.pageSize = e.itemsPerPage;
            this.getApplications(this.filterObj);
        }
        else {
            this.data.pageNumber = e.page;
            this.data.pageSize = e.itemsPerPage;
            this.getApplications(this.data);
        }
    }
    rangeChanged(e) {
        if (this.isFilterApplied) {
            console.log(e);
            this.filterObj.pageSize = e;
            this.getApplications(this.filterObj);
        }
        else {
            this.data.pageSize = e;
            this.getApplications(this.data);
        }
    }
    /***************************************************************/
    spaceTrim(event) {
        this.filterObj.applicationNumber = this.filterObj.applicationNumber.trim();
    }
    /****************************************************************************
        @PURPOSE      : filters.
        @PARAMETERS   : NA
        @RETURN       : NA
    ****************************************************************************/
    applyFilter() {
        if (JSON.stringify(this.filterObj) == "{}") {
            if (localStorage.getItem('Language') === 'en') {
                this.toastr.error("Please Select Any Value  Data to Filter", 'Oops!');
                return 0;
            }
            else {
                this.toastr.error("Veuillez filtrer par categorie", 'Oops!');
                return 0;
            }
        }
        this.isFilterApplied = true;
        this.currentPage = 1;
        this.filterObj.pageNumber = 1;
        this.filterObj.pageSize = this.pagesize;
        this.getApplications(this.filterObj);
    }
    resetFilter() {
        this.isFilterApplied = false;
        this.currentPage = 1;
        this.filterObj = {};
        this.getApplications(this.data);
    }
}
NewDashboardComponent.ɵfac = function NewDashboardComponent_Factory(t) { return new (t || NewDashboardComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__["TranslateService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ngx_spinner__WEBPACK_IMPORTED_MODULE_3__["NgxSpinnerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Renderer2"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ngx_ui_loader__WEBPACK_IMPORTED_MODULE_4__["NgxUiLoaderService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_5__["DatePipe"])); };
NewDashboardComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: NewDashboardComponent, selectors: [["app-new-dashboard"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 93, vars: 34, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], ["href", "javascript:;"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "grid", "p-8", "md:grid-cols-2"], [1, "m-4", "max-w-sm", "rounded-lg", "border", "border-gray-200", "bg-white", "p-6", "shadow"], [1, "mb-8", "text-3xl", "font-extrabold", "tracking-tight", "text-gray-900"], [1, "mb-6", "grid", "grid-cols-2", "divide-x"], [1, "px-4"], [1, "mb-2", "text-2xl", "font-semibold", "tracking-tight", "text-gray-900"], [1, "rounded-md", "bg-blue-100", "px-4", "text-blue-800"], [1, "mb-3", "font-normal", "text-gray-500"], [1, "px-4", "text-right"], ["href", "javascript:;", 1, "inline-flex", "items-center", "rounded-lg", "bg-blue-700", "px-3", "py-2", "text-center", "text-sm", "font-bold", "text-white", "hover:bg-blue-800", "focus:outline-none", "focus:ring-4", "focus:ring-blue-300", 3, "routerLink"], ["aria-hidden", "true", "xmlns", "http://www.w3.org/2000/svg", "fill", "none", "viewBox", "0 0 14 10", 1, "ml-2", "h-3.5", "w-3.5"], ["stroke", "currentColor", "stroke-linecap", "round", "stroke-linejoin", "round", "stroke-width", "2", "d", "M1 5h12m0 0L9 1m4 4L9 9"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], [1, "portlet-body"], [1, "table-scrollable"], [1, "styled-table"], [4, "ngFor", "ngForOf"], [4, "ngIf"], ["class", "row", 4, "ngIf"], ["href", "javascript:;", "style", "cursor: pointer;", "tooltip", "Download", 3, "click", 4, "ngIf"], ["href", "javascript:;", 3, "routerLink"], [1, "fa", "fa-eye"], ["href", "javascript:;", "tooltip", "Download", 2, "cursor", "pointer", 3, "click"], [1, "fa", "fa-download"], [1, "label", "label-sm", "label-success"], [1, "label", "label-sm", "label-danger"], [1, "label", "label-sm", "label-info"], [1, "label", "label-sm", "label-warning"], ["colspan", "10", 1, "dataTables_empty", 2, "text-align", "center"], [1, "col-md-4", "col-sm-12"], [1, "btn-group"], ["bindLabel", "name", "bindValue", "id", "placeholder", "Select", 3, "items", "ngModel", "ngModelOptions", "clearable", "searchable", "dropdownPosition", "change", "ngModelChange"], ["id", "sample_editable_1_info", 1, "dataTables_info"], [1, "dataTables_paginate", "paging_bootstrap"], ["name", "currentPage", "ngDefaultControl", "", "previousText", "\u2039", "nextText", "\u203A", "firstText", "\u00AB", "lastText", "\u00BB", 1, "page", 3, "boundaryLinks", "rotate", "itemsPerPage", "totalItems", "maxSize", "ngModel", "ngModelOptions", "ngModelChange", "pageChanged"]], template: function NewDashboardComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "h2", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](19, "Visa Ordinaire");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "h5", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "span", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](25, "34");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "p", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](27, "Terminer");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "h5", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "span", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](32, "45");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "p", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](34, "En cours");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](35, "a", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](36, " Nouveau Visa ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](37, "svg", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](38, "path", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceHTML"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](39, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "h2", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](41, "Visa Extension");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](42, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](43, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](44, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "h5", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](46, "span", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](47, "34");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](48, "p", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](49, "Terminer");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](50, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](51, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](52, "h5", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](53, "span", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](54, "45");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](55, "p", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](56, "En cours");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](57, "a", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](58, " Nouveau Visa ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](59, "svg", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](60, "path", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceHTML"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](61, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](62, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](63, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](64, "Status de visa ordinaire");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](65, "div", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](66, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](67, "div", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](68, "table", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](69, "thead");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](70, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](71, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](72);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](73, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](74, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](75);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](76, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](77, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](78);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](79, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](80, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](81);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](82, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](83, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](84);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](85, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](86, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](87);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](88, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](89, "tbody");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](90, NewDashboardComponent_tr_90_Template, 20, 18, "tr", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](91, NewDashboardComponent_tr_91_Template, 5, 3, "tr", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](92, NewDashboardComponent_div_92_Template, 14, 30, "div", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 14, "SIDEBAR.Dashboard"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 16, "DASHBOARDPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](13, 18, "SIDEBAR.Dashboard"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](32, _c2));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](33, _c3));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](73, 20, "DASHBOARDPAGE.Action"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](76, 22, "DASHBOARDPAGE.Application No"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](79, 24, "DASHBOARDPAGE.Applicant Name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](82, 26, "DASHBOARDPAGE.Date & Time Submitted"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](85, 28, "DASHBOARDPAGE.Date & Time Closed"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](88, 30, "DASHBOARDPAGE.Application Outcome"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.Applications);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.Applications.length && !ctx.loading);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.totalElements > 0);
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_6__["RouterLinkWithHref"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgIf"], ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_7__["TooltipDirective"], _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_8__["NgSelectComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_9__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_9__["NgModel"], ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_10__["PaginationComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_9__["DefaultValueAccessor"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__["TranslatePipe"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["DatePipe"]], styles: ["*[_ngcontent-%COMP%], [_ngcontent-%COMP%]::before, [_ngcontent-%COMP%]::after {\n  box-sizing: border-box;\n  \n  border-width: 0;\n  \n  border-style: solid;\n  \n  border-color: #e5e7eb;\n  \n}\n\n[_ngcontent-%COMP%]::before, [_ngcontent-%COMP%]::after {\n  --tw-content: '';\n}\n\n\n\nhtml[_ngcontent-%COMP%] {\n  line-height: 1.5;\n  \n  -webkit-text-size-adjust: 100%;\n  \n  -moz-tab-size: 4;\n  \n  -o-tab-size: 4;\n     tab-size: 4;\n  \n  font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, \"Helvetica Neue\", Arial, \"Noto Sans\", sans-serif, \"Apple Color Emoji\", \"Segoe UI Emoji\", \"Segoe UI Symbol\", \"Noto Color Emoji\";\n  \n  font-feature-settings: normal;\n  \n  font-variation-settings: normal;\n  \n}\n\n\n\nbody[_ngcontent-%COMP%] {\n  margin: 0;\n  \n  line-height: inherit;\n  \n}\n\n\n\nhr[_ngcontent-%COMP%] {\n  height: 0;\n  \n  color: inherit;\n  \n  border-top-width: 1px;\n  \n}\n\n\n\nabbr[_ngcontent-%COMP%]:where([title]) {\n  -webkit-text-decoration: underline dotted;\n          text-decoration: underline dotted;\n}\n\n\n\nh1[_ngcontent-%COMP%], h2[_ngcontent-%COMP%], h3[_ngcontent-%COMP%], h4[_ngcontent-%COMP%], h5[_ngcontent-%COMP%], h6[_ngcontent-%COMP%] {\n  font-size: inherit;\n  font-weight: inherit;\n}\n\n\n\na[_ngcontent-%COMP%] {\n  color: inherit;\n  text-decoration: inherit;\n}\n\n\n\nb[_ngcontent-%COMP%], strong[_ngcontent-%COMP%] {\n  font-weight: bolder;\n}\n\n\n\ncode[_ngcontent-%COMP%], kbd[_ngcontent-%COMP%], samp[_ngcontent-%COMP%], pre[_ngcontent-%COMP%] {\n  font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, \"Liberation Mono\", \"Courier New\", monospace;\n  \n  font-size: 1em;\n  \n}\n\n\n\nsmall[_ngcontent-%COMP%] {\n  font-size: 80%;\n}\n\n\n\nsub[_ngcontent-%COMP%], sup[_ngcontent-%COMP%] {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\n\nsub[_ngcontent-%COMP%] {\n  bottom: -0.25em;\n}\n\nsup[_ngcontent-%COMP%] {\n  top: -0.5em;\n}\n\n\n\ntable[_ngcontent-%COMP%] {\n  text-indent: 0;\n  \n  border-color: inherit;\n  \n  border-collapse: collapse;\n  \n}\n\n\n\nbutton[_ngcontent-%COMP%], input[_ngcontent-%COMP%], optgroup[_ngcontent-%COMP%], select[_ngcontent-%COMP%], textarea[_ngcontent-%COMP%] {\n  font-family: inherit;\n  \n  font-feature-settings: inherit;\n  \n  font-variation-settings: inherit;\n  \n  font-size: 100%;\n  \n  font-weight: inherit;\n  \n  line-height: inherit;\n  \n  color: inherit;\n  \n  margin: 0;\n  \n  padding: 0;\n  \n}\n\n\n\nbutton[_ngcontent-%COMP%], select[_ngcontent-%COMP%] {\n  text-transform: none;\n}\n\n\n\nbutton[_ngcontent-%COMP%], [type='button'][_ngcontent-%COMP%], [type='reset'][_ngcontent-%COMP%], [type='submit'][_ngcontent-%COMP%] {\n  -webkit-appearance: button;\n  \n  background-color: transparent;\n  \n  background-image: none;\n  \n}\n\n\n\n[_ngcontent-%COMP%]:-moz-focusring {\n  outline: auto;\n}\n\n\n\n[_ngcontent-%COMP%]:-moz-ui-invalid {\n  box-shadow: none;\n}\n\n\n\nprogress[_ngcontent-%COMP%] {\n  vertical-align: baseline;\n}\n\n\n\n[_ngcontent-%COMP%]::-webkit-inner-spin-button, [_ngcontent-%COMP%]::-webkit-outer-spin-button {\n  height: auto;\n}\n\n\n\n[type='search'][_ngcontent-%COMP%] {\n  -webkit-appearance: textfield;\n  \n  outline-offset: -2px;\n  \n}\n\n\n\n[_ngcontent-%COMP%]::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\n\n\n\n[_ngcontent-%COMP%]::-webkit-file-upload-button {\n  -webkit-appearance: button;\n  \n  font: inherit;\n  \n}\n\n\n\nsummary[_ngcontent-%COMP%] {\n  display: list-item;\n}\n\n\n\nblockquote[_ngcontent-%COMP%], dl[_ngcontent-%COMP%], dd[_ngcontent-%COMP%], h1[_ngcontent-%COMP%], h2[_ngcontent-%COMP%], h3[_ngcontent-%COMP%], h4[_ngcontent-%COMP%], h5[_ngcontent-%COMP%], h6[_ngcontent-%COMP%], hr[_ngcontent-%COMP%], figure[_ngcontent-%COMP%], p[_ngcontent-%COMP%], pre[_ngcontent-%COMP%] {\n  margin: 0;\n}\n\nfieldset[_ngcontent-%COMP%] {\n  margin: 0;\n  padding: 0;\n}\n\nlegend[_ngcontent-%COMP%] {\n  padding: 0;\n}\n\nol[_ngcontent-%COMP%], ul[_ngcontent-%COMP%], menu[_ngcontent-%COMP%] {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n}\n\n\n\ndialog[_ngcontent-%COMP%] {\n  padding: 0;\n}\n\n\n\ntextarea[_ngcontent-%COMP%] {\n  resize: vertical;\n}\n\n\n\ninput[_ngcontent-%COMP%]::-moz-placeholder, textarea[_ngcontent-%COMP%]::-moz-placeholder {\n  opacity: 1;\n  \n  color: #9ca3af;\n  \n}\n\ninput[_ngcontent-%COMP%]::placeholder, textarea[_ngcontent-%COMP%]::placeholder {\n  opacity: 1;\n  \n  color: #9ca3af;\n  \n}\n\n\n\nbutton[_ngcontent-%COMP%], [role=\"button\"][_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n\n\n\n[_ngcontent-%COMP%]:disabled {\n  cursor: default;\n}\n\n\n\nimg[_ngcontent-%COMP%], svg[_ngcontent-%COMP%], video[_ngcontent-%COMP%], canvas[_ngcontent-%COMP%], audio[_ngcontent-%COMP%], iframe[_ngcontent-%COMP%], embed[_ngcontent-%COMP%], object[_ngcontent-%COMP%] {\n  display: block;\n  \n  vertical-align: middle;\n  \n}\n\n\n\nimg[_ngcontent-%COMP%], video[_ngcontent-%COMP%] {\n  max-width: 100%;\n  height: auto;\n}\n\n\n\n[hidden][_ngcontent-%COMP%] {\n  display: none;\n}\n\n*[_ngcontent-%COMP%], [_ngcontent-%COMP%]::before, [_ngcontent-%COMP%]::after{\n  --tw-border-spacing-x: 0;\n  --tw-border-spacing-y: 0;\n  --tw-translate-x: 0;\n  --tw-translate-y: 0;\n  --tw-rotate: 0;\n  --tw-skew-x: 0;\n  --tw-skew-y: 0;\n  --tw-scale-x: 1;\n  --tw-scale-y: 1;\n  --tw-pan-x:  ;\n  --tw-pan-y:  ;\n  --tw-pinch-zoom:  ;\n  --tw-scroll-snap-strictness: proximity;\n  --tw-gradient-from-position:  ;\n  --tw-gradient-via-position:  ;\n  --tw-gradient-to-position:  ;\n  --tw-ordinal:  ;\n  --tw-slashed-zero:  ;\n  --tw-numeric-figure:  ;\n  --tw-numeric-spacing:  ;\n  --tw-numeric-fraction:  ;\n  --tw-ring-inset:  ;\n  --tw-ring-offset-width: 0px;\n  --tw-ring-offset-color: #fff;\n  --tw-ring-color: rgb(59 130 246 / 0.5);\n  --tw-ring-offset-shadow: 0 0 #0000;\n  --tw-ring-shadow: 0 0 #0000;\n  --tw-shadow: 0 0 #0000;\n  --tw-shadow-colored: 0 0 #0000;\n  --tw-blur:  ;\n  --tw-brightness:  ;\n  --tw-contrast:  ;\n  --tw-grayscale:  ;\n  --tw-hue-rotate:  ;\n  --tw-invert:  ;\n  --tw-saturate:  ;\n  --tw-sepia:  ;\n  --tw-drop-shadow:  ;\n  --tw-backdrop-blur:  ;\n  --tw-backdrop-brightness:  ;\n  --tw-backdrop-contrast:  ;\n  --tw-backdrop-grayscale:  ;\n  --tw-backdrop-hue-rotate:  ;\n  --tw-backdrop-invert:  ;\n  --tw-backdrop-opacity:  ;\n  --tw-backdrop-saturate:  ;\n  --tw-backdrop-sepia:  \n}\n\n[_ngcontent-%COMP%]::backdrop{\n  --tw-border-spacing-x: 0;\n  --tw-border-spacing-y: 0;\n  --tw-translate-x: 0;\n  --tw-translate-y: 0;\n  --tw-rotate: 0;\n  --tw-skew-x: 0;\n  --tw-skew-y: 0;\n  --tw-scale-x: 1;\n  --tw-scale-y: 1;\n  --tw-pan-x:  ;\n  --tw-pan-y:  ;\n  --tw-pinch-zoom:  ;\n  --tw-scroll-snap-strictness: proximity;\n  --tw-gradient-from-position:  ;\n  --tw-gradient-via-position:  ;\n  --tw-gradient-to-position:  ;\n  --tw-ordinal:  ;\n  --tw-slashed-zero:  ;\n  --tw-numeric-figure:  ;\n  --tw-numeric-spacing:  ;\n  --tw-numeric-fraction:  ;\n  --tw-ring-inset:  ;\n  --tw-ring-offset-width: 0px;\n  --tw-ring-offset-color: #fff;\n  --tw-ring-color: rgb(59 130 246 / 0.5);\n  --tw-ring-offset-shadow: 0 0 #0000;\n  --tw-ring-shadow: 0 0 #0000;\n  --tw-shadow: 0 0 #0000;\n  --tw-shadow-colored: 0 0 #0000;\n  --tw-blur:  ;\n  --tw-brightness:  ;\n  --tw-contrast:  ;\n  --tw-grayscale:  ;\n  --tw-hue-rotate:  ;\n  --tw-invert:  ;\n  --tw-saturate:  ;\n  --tw-sepia:  ;\n  --tw-drop-shadow:  ;\n  --tw-backdrop-blur:  ;\n  --tw-backdrop-brightness:  ;\n  --tw-backdrop-contrast:  ;\n  --tw-backdrop-grayscale:  ;\n  --tw-backdrop-hue-rotate:  ;\n  --tw-backdrop-invert:  ;\n  --tw-backdrop-opacity:  ;\n  --tw-backdrop-saturate:  ;\n  --tw-backdrop-sepia:  \n}\n\n.m-4[_ngcontent-%COMP%]{\n  margin: 1rem\n}\n\n.mb-2[_ngcontent-%COMP%]{\n  margin-bottom: 0.5rem\n}\n\n.mb-3[_ngcontent-%COMP%]{\n  margin-bottom: 0.75rem\n}\n\n.mb-6[_ngcontent-%COMP%]{\n  margin-bottom: 1.5rem\n}\n\n.mb-8[_ngcontent-%COMP%]{\n  margin-bottom: 2rem\n}\n\n.ml-2[_ngcontent-%COMP%]{\n  margin-left: 0.5rem\n}\n\n.inline-flex[_ngcontent-%COMP%]{\n  display: inline-flex\n}\n\n.grid[_ngcontent-%COMP%]{\n  display: grid\n}\n\n.h-3[_ngcontent-%COMP%]{\n  height: 0.75rem\n}\n\n.h-3\\.5[_ngcontent-%COMP%]{\n  height: 0.875rem\n}\n\n.w-3[_ngcontent-%COMP%]{\n  width: 0.75rem\n}\n\n.w-3\\.5[_ngcontent-%COMP%]{\n  width: 0.875rem\n}\n\n.max-w-sm[_ngcontent-%COMP%]{\n  max-width: 24rem\n}\n\n.grid-cols-2[_ngcontent-%COMP%]{\n  grid-template-columns: repeat(2, minmax(0, 1fr))\n}\n\n.items-center[_ngcontent-%COMP%]{\n  align-items: center\n}\n\n.divide-x[_ngcontent-%COMP%]    > [_ngcontent-%COMP%]:not([hidden])    ~ [_ngcontent-%COMP%]:not([hidden]){\n  --tw-divide-x-reverse: 0;\n  border-right-width: calc(1px * var(--tw-divide-x-reverse));\n  border-left-width: calc(1px * calc(1 - var(--tw-divide-x-reverse)))\n}\n\n.rounded-lg[_ngcontent-%COMP%]{\n  border-radius: 0.5rem\n}\n\n.rounded-md[_ngcontent-%COMP%]{\n  border-radius: 0.375rem\n}\n\n.border[_ngcontent-%COMP%]{\n  border-width: 1px\n}\n\n.border-gray-200[_ngcontent-%COMP%]{\n  --tw-border-opacity: 1;\n  border-color: rgb(229 231 235 / var(--tw-border-opacity))\n}\n\n.bg-blue-100[_ngcontent-%COMP%]{\n  --tw-bg-opacity: 1;\n  background-color: rgb(219 234 254 / var(--tw-bg-opacity))\n}\n\n.bg-blue-700[_ngcontent-%COMP%]{\n  --tw-bg-opacity: 1;\n  background-color: rgb(29 78 216 / var(--tw-bg-opacity))\n}\n\n.bg-white[_ngcontent-%COMP%]{\n  --tw-bg-opacity: 1;\n  background-color: rgb(255 255 255 / var(--tw-bg-opacity))\n}\n\n.p-6[_ngcontent-%COMP%]{\n  padding: 1.5rem\n}\n\n.p-8[_ngcontent-%COMP%]{\n  padding: 2rem\n}\n\n.px-3[_ngcontent-%COMP%]{\n  padding-left: 0.75rem;\n  padding-right: 0.75rem\n}\n\n.px-4[_ngcontent-%COMP%]{\n  padding-left: 1rem;\n  padding-right: 1rem\n}\n\n.py-2[_ngcontent-%COMP%]{\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem\n}\n\n.text-center[_ngcontent-%COMP%]{\n  text-align: center\n}\n\n.text-right[_ngcontent-%COMP%]{\n  text-align: right\n}\n\n.text-2xl[_ngcontent-%COMP%]{\n  font-size: 1.5rem;\n  line-height: 2rem\n}\n\n.text-3xl[_ngcontent-%COMP%]{\n  font-size: 1.875rem;\n  line-height: 2.25rem\n}\n\n.text-sm[_ngcontent-%COMP%]{\n  font-size: 0.875rem;\n  line-height: 1.25rem\n}\n\n.font-bold[_ngcontent-%COMP%]{\n  font-weight: 700\n}\n\n.font-extrabold[_ngcontent-%COMP%]{\n  font-weight: 800\n}\n\n.font-normal[_ngcontent-%COMP%]{\n  font-weight: 400\n}\n\n.font-semibold[_ngcontent-%COMP%]{\n  font-weight: 600\n}\n\n.tracking-tight[_ngcontent-%COMP%]{\n  letter-spacing: -0.025em\n}\n\n.text-blue-800[_ngcontent-%COMP%]{\n  --tw-text-opacity: 1;\n  color: rgb(30 64 175 / var(--tw-text-opacity))\n}\n\n.text-gray-500[_ngcontent-%COMP%]{\n  --tw-text-opacity: 1;\n  color: rgb(107 114 128 / var(--tw-text-opacity))\n}\n\n.text-gray-900[_ngcontent-%COMP%]{\n  --tw-text-opacity: 1;\n  color: rgb(17 24 39 / var(--tw-text-opacity))\n}\n\n.text-white[_ngcontent-%COMP%]{\n  --tw-text-opacity: 1;\n  color: rgb(255 255 255 / var(--tw-text-opacity))\n}\n\n.shadow[_ngcontent-%COMP%]{\n  --tw-shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1);\n  --tw-shadow-colored: 0 1px 3px 0 var(--tw-shadow-color), 0 1px 2px -1px var(--tw-shadow-color);\n  box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)\n}\n\n.hover\\:bg-blue-800[_ngcontent-%COMP%]:hover{\n  --tw-bg-opacity: 1;\n  background-color: rgb(30 64 175 / var(--tw-bg-opacity))\n}\n\n.focus\\:outline-none[_ngcontent-%COMP%]:focus{\n  outline: 2px solid transparent;\n  outline-offset: 2px\n}\n\n.focus\\:ring-4[_ngcontent-%COMP%]:focus{\n  --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);\n  --tw-ring-shadow: var(--tw-ring-inset) 0 0 0 calc(4px + var(--tw-ring-offset-width)) var(--tw-ring-color);\n  box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow, 0 0 #0000)\n}\n\n.focus\\:ring-blue-300[_ngcontent-%COMP%]:focus{\n  --tw-ring-opacity: 1;\n  --tw-ring-color: rgb(147 197 253 / var(--tw-ring-opacity))\n}\n\n@media (min-width: 768px){\n  .md\\:grid-cols-2[_ngcontent-%COMP%]{\n    grid-template-columns: repeat(2, minmax(0, 1fr))\n  }\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm5ldy1kYXNoYm9hcmQuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Q0FFQzs7QUFFRDs7O0NBR0M7O0FBRUQ7OztFQUdFLHNCQUFzQjtFQUN0QixNQUFNO0VBQ04sZUFBZTtFQUNmLE1BQU07RUFDTixtQkFBbUI7RUFDbkIsTUFBTTtFQUNOLHFCQUFxQjtFQUNyQixNQUFNO0FBQ1I7O0FBRUE7O0VBRUUsZ0JBQWdCO0FBQ2xCOztBQUVBOzs7Ozs7O0NBT0M7O0FBRUQ7RUFDRSxnQkFBZ0I7RUFDaEIsTUFBTTtFQUNOLDhCQUE4QjtFQUM5QixNQUFNO0VBQ04sZ0JBQWdCO0VBQ2hCLE1BQU07RUFDTixjQUFXO0tBQVgsV0FBVztFQUNYLE1BQU07RUFDTiw0TkFBNE47RUFDNU4sTUFBTTtFQUNOLDZCQUE2QjtFQUM3QixNQUFNO0VBQ04sK0JBQStCO0VBQy9CLE1BQU07QUFDUjs7QUFFQTs7O0NBR0M7O0FBRUQ7RUFDRSxTQUFTO0VBQ1QsTUFBTTtFQUNOLG9CQUFvQjtFQUNwQixNQUFNO0FBQ1I7O0FBRUE7Ozs7Q0FJQzs7QUFFRDtFQUNFLFNBQVM7RUFDVCxNQUFNO0VBQ04sY0FBYztFQUNkLE1BQU07RUFDTixxQkFBcUI7RUFDckIsTUFBTTtBQUNSOztBQUVBOztDQUVDOztBQUVEO0VBQ0UseUNBQXlDO1VBQ2pDLGlDQUFpQztBQUMzQzs7QUFFQTs7Q0FFQzs7QUFFRDs7Ozs7O0VBTUUsa0JBQWtCO0VBQ2xCLG9CQUFvQjtBQUN0Qjs7QUFFQTs7Q0FFQzs7QUFFRDtFQUNFLGNBQWM7RUFDZCx3QkFBd0I7QUFDMUI7O0FBRUE7O0NBRUM7O0FBRUQ7O0VBRUUsbUJBQW1CO0FBQ3JCOztBQUVBOzs7Q0FHQzs7QUFFRDs7OztFQUlFLCtHQUErRztFQUMvRyxNQUFNO0VBQ04sY0FBYztFQUNkLE1BQU07QUFDUjs7QUFFQTs7Q0FFQzs7QUFFRDtFQUNFLGNBQWM7QUFDaEI7O0FBRUE7O0NBRUM7O0FBRUQ7O0VBRUUsY0FBYztFQUNkLGNBQWM7RUFDZCxrQkFBa0I7RUFDbEIsd0JBQXdCO0FBQzFCOztBQUVBO0VBQ0UsZUFBZTtBQUNqQjs7QUFFQTtFQUNFLFdBQVc7QUFDYjs7QUFFQTs7OztDQUlDOztBQUVEO0VBQ0UsY0FBYztFQUNkLE1BQU07RUFDTixxQkFBcUI7RUFDckIsTUFBTTtFQUNOLHlCQUF5QjtFQUN6QixNQUFNO0FBQ1I7O0FBRUE7Ozs7Q0FJQzs7QUFFRDs7Ozs7RUFLRSxvQkFBb0I7RUFDcEIsTUFBTTtFQUNOLDhCQUE4QjtFQUM5QixNQUFNO0VBQ04sZ0NBQWdDO0VBQ2hDLE1BQU07RUFDTixlQUFlO0VBQ2YsTUFBTTtFQUNOLG9CQUFvQjtFQUNwQixNQUFNO0VBQ04sb0JBQW9CO0VBQ3BCLE1BQU07RUFDTixjQUFjO0VBQ2QsTUFBTTtFQUNOLFNBQVM7RUFDVCxNQUFNO0VBQ04sVUFBVTtFQUNWLE1BQU07QUFDUjs7QUFFQTs7Q0FFQzs7QUFFRDs7RUFFRSxvQkFBb0I7QUFDdEI7O0FBRUE7OztDQUdDOztBQUVEOzs7O0VBSUUsMEJBQTBCO0VBQzFCLE1BQU07RUFDTiw2QkFBNkI7RUFDN0IsTUFBTTtFQUNOLHNCQUFzQjtFQUN0QixNQUFNO0FBQ1I7O0FBRUE7O0NBRUM7O0FBRUQ7RUFDRSxhQUFhO0FBQ2Y7O0FBRUE7O0NBRUM7O0FBRUQ7RUFDRSxnQkFBZ0I7QUFDbEI7O0FBRUE7O0NBRUM7O0FBRUQ7RUFDRSx3QkFBd0I7QUFDMUI7O0FBRUE7O0NBRUM7O0FBRUQ7O0VBRUUsWUFBWTtBQUNkOztBQUVBOzs7Q0FHQzs7QUFFRDtFQUNFLDZCQUE2QjtFQUM3QixNQUFNO0VBQ04sb0JBQW9CO0VBQ3BCLE1BQU07QUFDUjs7QUFFQTs7Q0FFQzs7QUFFRDtFQUNFLHdCQUF3QjtBQUMxQjs7QUFFQTs7O0NBR0M7O0FBRUQ7RUFDRSwwQkFBMEI7RUFDMUIsTUFBTTtFQUNOLGFBQWE7RUFDYixNQUFNO0FBQ1I7O0FBRUE7O0NBRUM7O0FBRUQ7RUFDRSxrQkFBa0I7QUFDcEI7O0FBRUE7O0NBRUM7O0FBRUQ7Ozs7Ozs7Ozs7Ozs7RUFhRSxTQUFTO0FBQ1g7O0FBRUE7RUFDRSxTQUFTO0VBQ1QsVUFBVTtBQUNaOztBQUVBO0VBQ0UsVUFBVTtBQUNaOztBQUVBOzs7RUFHRSxnQkFBZ0I7RUFDaEIsU0FBUztFQUNULFVBQVU7QUFDWjs7QUFFQTs7Q0FFQzs7QUFFRDtFQUNFLFVBQVU7QUFDWjs7QUFFQTs7Q0FFQzs7QUFFRDtFQUNFLGdCQUFnQjtBQUNsQjs7QUFFQTs7O0NBR0M7O0FBRUQ7RUFFRSxVQUFVO0VBQ1YsTUFBTTtFQUNOLGNBQWM7RUFDZCxNQUFNO0FBQ1I7O0FBTkE7O0VBRUUsVUFBVTtFQUNWLE1BQU07RUFDTixjQUFjO0VBQ2QsTUFBTTtBQUNSOztBQUVBOztDQUVDOztBQUVEOztFQUVFLGVBQWU7QUFDakI7O0FBRUE7O0NBRUM7O0FBRUQ7RUFDRSxlQUFlO0FBQ2pCOztBQUVBOzs7O0NBSUM7O0FBRUQ7Ozs7Ozs7O0VBUUUsY0FBYztFQUNkLE1BQU07RUFDTixzQkFBc0I7RUFDdEIsTUFBTTtBQUNSOztBQUVBOztDQUVDOztBQUVEOztFQUVFLGVBQWU7RUFDZixZQUFZO0FBQ2Q7O0FBRUEsd0VBQXdFOztBQUV4RTtFQUNFLGFBQWE7QUFDZjs7QUFFQTtFQUNFLHdCQUF3QjtFQUN4Qix3QkFBd0I7RUFDeEIsbUJBQW1CO0VBQ25CLG1CQUFtQjtFQUNuQixjQUFjO0VBQ2QsY0FBYztFQUNkLGNBQWM7RUFDZCxlQUFlO0VBQ2YsZUFBZTtFQUNmLGFBQWE7RUFDYixhQUFhO0VBQ2Isa0JBQWtCO0VBQ2xCLHNDQUFzQztFQUN0Qyw4QkFBOEI7RUFDOUIsNkJBQTZCO0VBQzdCLDRCQUE0QjtFQUM1QixlQUFlO0VBQ2Ysb0JBQW9CO0VBQ3BCLHNCQUFzQjtFQUN0Qix1QkFBdUI7RUFDdkIsd0JBQXdCO0VBQ3hCLGtCQUFrQjtFQUNsQiwyQkFBMkI7RUFDM0IsNEJBQTRCO0VBQzVCLHNDQUFzQztFQUN0QyxrQ0FBa0M7RUFDbEMsMkJBQTJCO0VBQzNCLHNCQUFzQjtFQUN0Qiw4QkFBOEI7RUFDOUIsWUFBWTtFQUNaLGtCQUFrQjtFQUNsQixnQkFBZ0I7RUFDaEIsaUJBQWlCO0VBQ2pCLGtCQUFrQjtFQUNsQixjQUFjO0VBQ2QsZ0JBQWdCO0VBQ2hCLGFBQWE7RUFDYixtQkFBbUI7RUFDbkIscUJBQXFCO0VBQ3JCLDJCQUEyQjtFQUMzQix5QkFBeUI7RUFDekIsMEJBQTBCO0VBQzFCLDJCQUEyQjtFQUMzQix1QkFBdUI7RUFDdkIsd0JBQXdCO0VBQ3hCLHlCQUF5QjtFQUN6QjtBQUNGOztBQUVBO0VBQ0Usd0JBQXdCO0VBQ3hCLHdCQUF3QjtFQUN4QixtQkFBbUI7RUFDbkIsbUJBQW1CO0VBQ25CLGNBQWM7RUFDZCxjQUFjO0VBQ2QsY0FBYztFQUNkLGVBQWU7RUFDZixlQUFlO0VBQ2YsYUFBYTtFQUNiLGFBQWE7RUFDYixrQkFBa0I7RUFDbEIsc0NBQXNDO0VBQ3RDLDhCQUE4QjtFQUM5Qiw2QkFBNkI7RUFDN0IsNEJBQTRCO0VBQzVCLGVBQWU7RUFDZixvQkFBb0I7RUFDcEIsc0JBQXNCO0VBQ3RCLHVCQUF1QjtFQUN2Qix3QkFBd0I7RUFDeEIsa0JBQWtCO0VBQ2xCLDJCQUEyQjtFQUMzQiw0QkFBNEI7RUFDNUIsc0NBQXNDO0VBQ3RDLGtDQUFrQztFQUNsQywyQkFBMkI7RUFDM0Isc0JBQXNCO0VBQ3RCLDhCQUE4QjtFQUM5QixZQUFZO0VBQ1osa0JBQWtCO0VBQ2xCLGdCQUFnQjtFQUNoQixpQkFBaUI7RUFDakIsa0JBQWtCO0VBQ2xCLGNBQWM7RUFDZCxnQkFBZ0I7RUFDaEIsYUFBYTtFQUNiLG1CQUFtQjtFQUNuQixxQkFBcUI7RUFDckIsMkJBQTJCO0VBQzNCLHlCQUF5QjtFQUN6QiwwQkFBMEI7RUFDMUIsMkJBQTJCO0VBQzNCLHVCQUF1QjtFQUN2Qix3QkFBd0I7RUFDeEIseUJBQXlCO0VBQ3pCO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRSx3QkFBd0I7RUFDeEIsMERBQTBEO0VBQzFEO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRSxzQkFBc0I7RUFDdEI7QUFDRjs7QUFFQTtFQUNFLGtCQUFrQjtFQUNsQjtBQUNGOztBQUVBO0VBQ0Usa0JBQWtCO0VBQ2xCO0FBQ0Y7O0FBRUE7RUFDRSxrQkFBa0I7RUFDbEI7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0UscUJBQXFCO0VBQ3JCO0FBQ0Y7O0FBRUE7RUFDRSxrQkFBa0I7RUFDbEI7QUFDRjs7QUFFQTtFQUNFLG1CQUFtQjtFQUNuQjtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRSxpQkFBaUI7RUFDakI7QUFDRjs7QUFFQTtFQUNFLG1CQUFtQjtFQUNuQjtBQUNGOztBQUVBO0VBQ0UsbUJBQW1CO0VBQ25CO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFO0FBQ0Y7O0FBRUE7RUFDRTtBQUNGOztBQUVBO0VBQ0U7QUFDRjs7QUFFQTtFQUNFLG9CQUFvQjtFQUNwQjtBQUNGOztBQUVBO0VBQ0Usb0JBQW9CO0VBQ3BCO0FBQ0Y7O0FBRUE7RUFDRSxvQkFBb0I7RUFDcEI7QUFDRjs7QUFFQTtFQUNFLG9CQUFvQjtFQUNwQjtBQUNGOztBQUVBO0VBQ0UsMEVBQTBFO0VBQzFFLDhGQUE4RjtFQUM5RjtBQUNGOztBQUVBO0VBQ0Usa0JBQWtCO0VBQ2xCO0FBQ0Y7O0FBRUE7RUFDRSw4QkFBOEI7RUFDOUI7QUFDRjs7QUFFQTtFQUNFLDJHQUEyRztFQUMzRyx5R0FBeUc7RUFDekc7QUFDRjs7QUFFQTtFQUNFLG9CQUFvQjtFQUNwQjtBQUNGOztBQUVBO0VBQ0U7SUFDRTtFQUNGO0FBQ0YiLCJmaWxlIjoibmV3LWRhc2hib2FyZC5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiEgdGFpbHdpbmRjc3MgdjMuMy4zIHwgTUlUIExpY2Vuc2UgfCBodHRwczovL3RhaWx3aW5kY3NzLmNvbVxuKi9cblxuLypcbjEuIFByZXZlbnQgcGFkZGluZyBhbmQgYm9yZGVyIGZyb20gYWZmZWN0aW5nIGVsZW1lbnQgd2lkdGguIChodHRwczovL2dpdGh1Yi5jb20vbW96ZGV2cy9jc3NyZW1lZHkvaXNzdWVzLzQpXG4yLiBBbGxvdyBhZGRpbmcgYSBib3JkZXIgdG8gYW4gZWxlbWVudCBieSBqdXN0IGFkZGluZyBhIGJvcmRlci13aWR0aC4gKGh0dHBzOi8vZ2l0aHViLmNvbS90YWlsd2luZGNzcy90YWlsd2luZGNzcy9wdWxsLzExNilcbiovXG5cbiosXG46OmJlZm9yZSxcbjo6YWZ0ZXIge1xuICBib3gtc2l6aW5nOiBib3JkZXItYm94O1xuICAvKiAxICovXG4gIGJvcmRlci13aWR0aDogMDtcbiAgLyogMiAqL1xuICBib3JkZXItc3R5bGU6IHNvbGlkO1xuICAvKiAyICovXG4gIGJvcmRlci1jb2xvcjogI2U1ZTdlYjtcbiAgLyogMiAqL1xufVxuXG46OmJlZm9yZSxcbjo6YWZ0ZXIge1xuICAtLXR3LWNvbnRlbnQ6ICcnO1xufVxuXG4vKlxuMS4gVXNlIGEgY29uc2lzdGVudCBzZW5zaWJsZSBsaW5lLWhlaWdodCBpbiBhbGwgYnJvd3NlcnMuXG4yLiBQcmV2ZW50IGFkanVzdG1lbnRzIG9mIGZvbnQgc2l6ZSBhZnRlciBvcmllbnRhdGlvbiBjaGFuZ2VzIGluIGlPUy5cbjMuIFVzZSBhIG1vcmUgcmVhZGFibGUgdGFiIHNpemUuXG40LiBVc2UgdGhlIHVzZXIncyBjb25maWd1cmVkIGBzYW5zYCBmb250LWZhbWlseSBieSBkZWZhdWx0LlxuNS4gVXNlIHRoZSB1c2VyJ3MgY29uZmlndXJlZCBgc2Fuc2AgZm9udC1mZWF0dXJlLXNldHRpbmdzIGJ5IGRlZmF1bHQuXG42LiBVc2UgdGhlIHVzZXIncyBjb25maWd1cmVkIGBzYW5zYCBmb250LXZhcmlhdGlvbi1zZXR0aW5ncyBieSBkZWZhdWx0LlxuKi9cblxuaHRtbCB7XG4gIGxpbmUtaGVpZ2h0OiAxLjU7XG4gIC8qIDEgKi9cbiAgLXdlYmtpdC10ZXh0LXNpemUtYWRqdXN0OiAxMDAlO1xuICAvKiAyICovXG4gIC1tb3otdGFiLXNpemU6IDQ7XG4gIC8qIDMgKi9cbiAgdGFiLXNpemU6IDQ7XG4gIC8qIDMgKi9cbiAgZm9udC1mYW1pbHk6IHVpLXNhbnMtc2VyaWYsIHN5c3RlbS11aSwgLWFwcGxlLXN5c3RlbSwgQmxpbmtNYWNTeXN0ZW1Gb250LCBcIlNlZ29lIFVJXCIsIFJvYm90bywgXCJIZWx2ZXRpY2EgTmV1ZVwiLCBBcmlhbCwgXCJOb3RvIFNhbnNcIiwgc2Fucy1zZXJpZiwgXCJBcHBsZSBDb2xvciBFbW9qaVwiLCBcIlNlZ29lIFVJIEVtb2ppXCIsIFwiU2Vnb2UgVUkgU3ltYm9sXCIsIFwiTm90byBDb2xvciBFbW9qaVwiO1xuICAvKiA0ICovXG4gIGZvbnQtZmVhdHVyZS1zZXR0aW5nczogbm9ybWFsO1xuICAvKiA1ICovXG4gIGZvbnQtdmFyaWF0aW9uLXNldHRpbmdzOiBub3JtYWw7XG4gIC8qIDYgKi9cbn1cblxuLypcbjEuIFJlbW92ZSB0aGUgbWFyZ2luIGluIGFsbCBicm93c2Vycy5cbjIuIEluaGVyaXQgbGluZS1oZWlnaHQgZnJvbSBgaHRtbGAgc28gdXNlcnMgY2FuIHNldCB0aGVtIGFzIGEgY2xhc3MgZGlyZWN0bHkgb24gdGhlIGBodG1sYCBlbGVtZW50LlxuKi9cblxuYm9keSB7XG4gIG1hcmdpbjogMDtcbiAgLyogMSAqL1xuICBsaW5lLWhlaWdodDogaW5oZXJpdDtcbiAgLyogMiAqL1xufVxuXG4vKlxuMS4gQWRkIHRoZSBjb3JyZWN0IGhlaWdodCBpbiBGaXJlZm94LlxuMi4gQ29ycmVjdCB0aGUgaW5oZXJpdGFuY2Ugb2YgYm9yZGVyIGNvbG9yIGluIEZpcmVmb3guIChodHRwczovL2J1Z3ppbGxhLm1vemlsbGEub3JnL3Nob3dfYnVnLmNnaT9pZD0xOTA2NTUpXG4zLiBFbnN1cmUgaG9yaXpvbnRhbCBydWxlcyBhcmUgdmlzaWJsZSBieSBkZWZhdWx0LlxuKi9cblxuaHIge1xuICBoZWlnaHQ6IDA7XG4gIC8qIDEgKi9cbiAgY29sb3I6IGluaGVyaXQ7XG4gIC8qIDIgKi9cbiAgYm9yZGVyLXRvcC13aWR0aDogMXB4O1xuICAvKiAzICovXG59XG5cbi8qXG5BZGQgdGhlIGNvcnJlY3QgdGV4dCBkZWNvcmF0aW9uIGluIENocm9tZSwgRWRnZSwgYW5kIFNhZmFyaS5cbiovXG5cbmFiYnI6d2hlcmUoW3RpdGxlXSkge1xuICAtd2Via2l0LXRleHQtZGVjb3JhdGlvbjogdW5kZXJsaW5lIGRvdHRlZDtcbiAgICAgICAgICB0ZXh0LWRlY29yYXRpb246IHVuZGVybGluZSBkb3R0ZWQ7XG59XG5cbi8qXG5SZW1vdmUgdGhlIGRlZmF1bHQgZm9udCBzaXplIGFuZCB3ZWlnaHQgZm9yIGhlYWRpbmdzLlxuKi9cblxuaDEsXG5oMixcbmgzLFxuaDQsXG5oNSxcbmg2IHtcbiAgZm9udC1zaXplOiBpbmhlcml0O1xuICBmb250LXdlaWdodDogaW5oZXJpdDtcbn1cblxuLypcblJlc2V0IGxpbmtzIHRvIG9wdGltaXplIGZvciBvcHQtaW4gc3R5bGluZyBpbnN0ZWFkIG9mIG9wdC1vdXQuXG4qL1xuXG5hIHtcbiAgY29sb3I6IGluaGVyaXQ7XG4gIHRleHQtZGVjb3JhdGlvbjogaW5oZXJpdDtcbn1cblxuLypcbkFkZCB0aGUgY29ycmVjdCBmb250IHdlaWdodCBpbiBFZGdlIGFuZCBTYWZhcmkuXG4qL1xuXG5iLFxuc3Ryb25nIHtcbiAgZm9udC13ZWlnaHQ6IGJvbGRlcjtcbn1cblxuLypcbjEuIFVzZSB0aGUgdXNlcidzIGNvbmZpZ3VyZWQgYG1vbm9gIGZvbnQgZmFtaWx5IGJ5IGRlZmF1bHQuXG4yLiBDb3JyZWN0IHRoZSBvZGQgYGVtYCBmb250IHNpemluZyBpbiBhbGwgYnJvd3NlcnMuXG4qL1xuXG5jb2RlLFxua2JkLFxuc2FtcCxcbnByZSB7XG4gIGZvbnQtZmFtaWx5OiB1aS1tb25vc3BhY2UsIFNGTW9uby1SZWd1bGFyLCBNZW5sbywgTW9uYWNvLCBDb25zb2xhcywgXCJMaWJlcmF0aW9uIE1vbm9cIiwgXCJDb3VyaWVyIE5ld1wiLCBtb25vc3BhY2U7XG4gIC8qIDEgKi9cbiAgZm9udC1zaXplOiAxZW07XG4gIC8qIDIgKi9cbn1cblxuLypcbkFkZCB0aGUgY29ycmVjdCBmb250IHNpemUgaW4gYWxsIGJyb3dzZXJzLlxuKi9cblxuc21hbGwge1xuICBmb250LXNpemU6IDgwJTtcbn1cblxuLypcblByZXZlbnQgYHN1YmAgYW5kIGBzdXBgIGVsZW1lbnRzIGZyb20gYWZmZWN0aW5nIHRoZSBsaW5lIGhlaWdodCBpbiBhbGwgYnJvd3NlcnMuXG4qL1xuXG5zdWIsXG5zdXAge1xuICBmb250LXNpemU6IDc1JTtcbiAgbGluZS1oZWlnaHQ6IDA7XG4gIHBvc2l0aW9uOiByZWxhdGl2ZTtcbiAgdmVydGljYWwtYWxpZ246IGJhc2VsaW5lO1xufVxuXG5zdWIge1xuICBib3R0b206IC0wLjI1ZW07XG59XG5cbnN1cCB7XG4gIHRvcDogLTAuNWVtO1xufVxuXG4vKlxuMS4gUmVtb3ZlIHRleHQgaW5kZW50YXRpb24gZnJvbSB0YWJsZSBjb250ZW50cyBpbiBDaHJvbWUgYW5kIFNhZmFyaS4gKGh0dHBzOi8vYnVncy5jaHJvbWl1bS5vcmcvcC9jaHJvbWl1bS9pc3N1ZXMvZGV0YWlsP2lkPTk5OTA4OCwgaHR0cHM6Ly9idWdzLndlYmtpdC5vcmcvc2hvd19idWcuY2dpP2lkPTIwMTI5NylcbjIuIENvcnJlY3QgdGFibGUgYm9yZGVyIGNvbG9yIGluaGVyaXRhbmNlIGluIGFsbCBDaHJvbWUgYW5kIFNhZmFyaS4gKGh0dHBzOi8vYnVncy5jaHJvbWl1bS5vcmcvcC9jaHJvbWl1bS9pc3N1ZXMvZGV0YWlsP2lkPTkzNTcyOSwgaHR0cHM6Ly9idWdzLndlYmtpdC5vcmcvc2hvd19idWcuY2dpP2lkPTE5NTAxNilcbjMuIFJlbW92ZSBnYXBzIGJldHdlZW4gdGFibGUgYm9yZGVycyBieSBkZWZhdWx0LlxuKi9cblxudGFibGUge1xuICB0ZXh0LWluZGVudDogMDtcbiAgLyogMSAqL1xuICBib3JkZXItY29sb3I6IGluaGVyaXQ7XG4gIC8qIDIgKi9cbiAgYm9yZGVyLWNvbGxhcHNlOiBjb2xsYXBzZTtcbiAgLyogMyAqL1xufVxuXG4vKlxuMS4gQ2hhbmdlIHRoZSBmb250IHN0eWxlcyBpbiBhbGwgYnJvd3NlcnMuXG4yLiBSZW1vdmUgdGhlIG1hcmdpbiBpbiBGaXJlZm94IGFuZCBTYWZhcmkuXG4zLiBSZW1vdmUgZGVmYXVsdCBwYWRkaW5nIGluIGFsbCBicm93c2Vycy5cbiovXG5cbmJ1dHRvbixcbmlucHV0LFxub3B0Z3JvdXAsXG5zZWxlY3QsXG50ZXh0YXJlYSB7XG4gIGZvbnQtZmFtaWx5OiBpbmhlcml0O1xuICAvKiAxICovXG4gIGZvbnQtZmVhdHVyZS1zZXR0aW5nczogaW5oZXJpdDtcbiAgLyogMSAqL1xuICBmb250LXZhcmlhdGlvbi1zZXR0aW5nczogaW5oZXJpdDtcbiAgLyogMSAqL1xuICBmb250LXNpemU6IDEwMCU7XG4gIC8qIDEgKi9cbiAgZm9udC13ZWlnaHQ6IGluaGVyaXQ7XG4gIC8qIDEgKi9cbiAgbGluZS1oZWlnaHQ6IGluaGVyaXQ7XG4gIC8qIDEgKi9cbiAgY29sb3I6IGluaGVyaXQ7XG4gIC8qIDEgKi9cbiAgbWFyZ2luOiAwO1xuICAvKiAyICovXG4gIHBhZGRpbmc6IDA7XG4gIC8qIDMgKi9cbn1cblxuLypcblJlbW92ZSB0aGUgaW5oZXJpdGFuY2Ugb2YgdGV4dCB0cmFuc2Zvcm0gaW4gRWRnZSBhbmQgRmlyZWZveC5cbiovXG5cbmJ1dHRvbixcbnNlbGVjdCB7XG4gIHRleHQtdHJhbnNmb3JtOiBub25lO1xufVxuXG4vKlxuMS4gQ29ycmVjdCB0aGUgaW5hYmlsaXR5IHRvIHN0eWxlIGNsaWNrYWJsZSB0eXBlcyBpbiBpT1MgYW5kIFNhZmFyaS5cbjIuIFJlbW92ZSBkZWZhdWx0IGJ1dHRvbiBzdHlsZXMuXG4qL1xuXG5idXR0b24sXG5bdHlwZT0nYnV0dG9uJ10sXG5bdHlwZT0ncmVzZXQnXSxcblt0eXBlPSdzdWJtaXQnXSB7XG4gIC13ZWJraXQtYXBwZWFyYW5jZTogYnV0dG9uO1xuICAvKiAxICovXG4gIGJhY2tncm91bmQtY29sb3I6IHRyYW5zcGFyZW50O1xuICAvKiAyICovXG4gIGJhY2tncm91bmQtaW1hZ2U6IG5vbmU7XG4gIC8qIDIgKi9cbn1cblxuLypcblVzZSB0aGUgbW9kZXJuIEZpcmVmb3ggZm9jdXMgc3R5bGUgZm9yIGFsbCBmb2N1c2FibGUgZWxlbWVudHMuXG4qL1xuXG46LW1vei1mb2N1c3Jpbmcge1xuICBvdXRsaW5lOiBhdXRvO1xufVxuXG4vKlxuUmVtb3ZlIHRoZSBhZGRpdGlvbmFsIGA6aW52YWxpZGAgc3R5bGVzIGluIEZpcmVmb3guIChodHRwczovL2dpdGh1Yi5jb20vbW96aWxsYS9nZWNrby1kZXYvYmxvYi8yZjllYWNkOWQzZDk5NWM5MzdiNDI1MWE1NTU3ZDk1ZDQ5NGM5YmUxL2xheW91dC9zdHlsZS9yZXMvZm9ybXMuY3NzI0w3MjgtTDczNylcbiovXG5cbjotbW96LXVpLWludmFsaWQge1xuICBib3gtc2hhZG93OiBub25lO1xufVxuXG4vKlxuQWRkIHRoZSBjb3JyZWN0IHZlcnRpY2FsIGFsaWdubWVudCBpbiBDaHJvbWUgYW5kIEZpcmVmb3guXG4qL1xuXG5wcm9ncmVzcyB7XG4gIHZlcnRpY2FsLWFsaWduOiBiYXNlbGluZTtcbn1cblxuLypcbkNvcnJlY3QgdGhlIGN1cnNvciBzdHlsZSBvZiBpbmNyZW1lbnQgYW5kIGRlY3JlbWVudCBidXR0b25zIGluIFNhZmFyaS5cbiovXG5cbjo6LXdlYmtpdC1pbm5lci1zcGluLWJ1dHRvbixcbjo6LXdlYmtpdC1vdXRlci1zcGluLWJ1dHRvbiB7XG4gIGhlaWdodDogYXV0bztcbn1cblxuLypcbjEuIENvcnJlY3QgdGhlIG9kZCBhcHBlYXJhbmNlIGluIENocm9tZSBhbmQgU2FmYXJpLlxuMi4gQ29ycmVjdCB0aGUgb3V0bGluZSBzdHlsZSBpbiBTYWZhcmkuXG4qL1xuXG5bdHlwZT0nc2VhcmNoJ10ge1xuICAtd2Via2l0LWFwcGVhcmFuY2U6IHRleHRmaWVsZDtcbiAgLyogMSAqL1xuICBvdXRsaW5lLW9mZnNldDogLTJweDtcbiAgLyogMiAqL1xufVxuXG4vKlxuUmVtb3ZlIHRoZSBpbm5lciBwYWRkaW5nIGluIENocm9tZSBhbmQgU2FmYXJpIG9uIG1hY09TLlxuKi9cblxuOjotd2Via2l0LXNlYXJjaC1kZWNvcmF0aW9uIHtcbiAgLXdlYmtpdC1hcHBlYXJhbmNlOiBub25lO1xufVxuXG4vKlxuMS4gQ29ycmVjdCB0aGUgaW5hYmlsaXR5IHRvIHN0eWxlIGNsaWNrYWJsZSB0eXBlcyBpbiBpT1MgYW5kIFNhZmFyaS5cbjIuIENoYW5nZSBmb250IHByb3BlcnRpZXMgdG8gYGluaGVyaXRgIGluIFNhZmFyaS5cbiovXG5cbjo6LXdlYmtpdC1maWxlLXVwbG9hZC1idXR0b24ge1xuICAtd2Via2l0LWFwcGVhcmFuY2U6IGJ1dHRvbjtcbiAgLyogMSAqL1xuICBmb250OiBpbmhlcml0O1xuICAvKiAyICovXG59XG5cbi8qXG5BZGQgdGhlIGNvcnJlY3QgZGlzcGxheSBpbiBDaHJvbWUgYW5kIFNhZmFyaS5cbiovXG5cbnN1bW1hcnkge1xuICBkaXNwbGF5OiBsaXN0LWl0ZW07XG59XG5cbi8qXG5SZW1vdmVzIHRoZSBkZWZhdWx0IHNwYWNpbmcgYW5kIGJvcmRlciBmb3IgYXBwcm9wcmlhdGUgZWxlbWVudHMuXG4qL1xuXG5ibG9ja3F1b3RlLFxuZGwsXG5kZCxcbmgxLFxuaDIsXG5oMyxcbmg0LFxuaDUsXG5oNixcbmhyLFxuZmlndXJlLFxucCxcbnByZSB7XG4gIG1hcmdpbjogMDtcbn1cblxuZmllbGRzZXQge1xuICBtYXJnaW46IDA7XG4gIHBhZGRpbmc6IDA7XG59XG5cbmxlZ2VuZCB7XG4gIHBhZGRpbmc6IDA7XG59XG5cbm9sLFxudWwsXG5tZW51IHtcbiAgbGlzdC1zdHlsZTogbm9uZTtcbiAgbWFyZ2luOiAwO1xuICBwYWRkaW5nOiAwO1xufVxuXG4vKlxuUmVzZXQgZGVmYXVsdCBzdHlsaW5nIGZvciBkaWFsb2dzLlxuKi9cblxuZGlhbG9nIHtcbiAgcGFkZGluZzogMDtcbn1cblxuLypcblByZXZlbnQgcmVzaXppbmcgdGV4dGFyZWFzIGhvcml6b250YWxseSBieSBkZWZhdWx0LlxuKi9cblxudGV4dGFyZWEge1xuICByZXNpemU6IHZlcnRpY2FsO1xufVxuXG4vKlxuMS4gUmVzZXQgdGhlIGRlZmF1bHQgcGxhY2Vob2xkZXIgb3BhY2l0eSBpbiBGaXJlZm94LiAoaHR0cHM6Ly9naXRodWIuY29tL3RhaWx3aW5kbGFicy90YWlsd2luZGNzcy9pc3N1ZXMvMzMwMClcbjIuIFNldCB0aGUgZGVmYXVsdCBwbGFjZWhvbGRlciBjb2xvciB0byB0aGUgdXNlcidzIGNvbmZpZ3VyZWQgZ3JheSA0MDAgY29sb3IuXG4qL1xuXG5pbnB1dDo6cGxhY2Vob2xkZXIsXG50ZXh0YXJlYTo6cGxhY2Vob2xkZXIge1xuICBvcGFjaXR5OiAxO1xuICAvKiAxICovXG4gIGNvbG9yOiAjOWNhM2FmO1xuICAvKiAyICovXG59XG5cbi8qXG5TZXQgdGhlIGRlZmF1bHQgY3Vyc29yIGZvciBidXR0b25zLlxuKi9cblxuYnV0dG9uLFxuW3JvbGU9XCJidXR0b25cIl0ge1xuICBjdXJzb3I6IHBvaW50ZXI7XG59XG5cbi8qXG5NYWtlIHN1cmUgZGlzYWJsZWQgYnV0dG9ucyBkb24ndCBnZXQgdGhlIHBvaW50ZXIgY3Vyc29yLlxuKi9cblxuOmRpc2FibGVkIHtcbiAgY3Vyc29yOiBkZWZhdWx0O1xufVxuXG4vKlxuMS4gTWFrZSByZXBsYWNlZCBlbGVtZW50cyBgZGlzcGxheTogYmxvY2tgIGJ5IGRlZmF1bHQuIChodHRwczovL2dpdGh1Yi5jb20vbW96ZGV2cy9jc3NyZW1lZHkvaXNzdWVzLzE0KVxuMi4gQWRkIGB2ZXJ0aWNhbC1hbGlnbjogbWlkZGxlYCB0byBhbGlnbiByZXBsYWNlZCBlbGVtZW50cyBtb3JlIHNlbnNpYmx5IGJ5IGRlZmF1bHQuIChodHRwczovL2dpdGh1Yi5jb20vamVuc2ltbW9ucy9jc3NyZW1lZHkvaXNzdWVzLzE0I2lzc3VlY29tbWVudC02MzQ5MzQyMTApXG4gICBUaGlzIGNhbiB0cmlnZ2VyIGEgcG9vcmx5IGNvbnNpZGVyZWQgbGludCBlcnJvciBpbiBzb21lIHRvb2xzIGJ1dCBpcyBpbmNsdWRlZCBieSBkZXNpZ24uXG4qL1xuXG5pbWcsXG5zdmcsXG52aWRlbyxcbmNhbnZhcyxcbmF1ZGlvLFxuaWZyYW1lLFxuZW1iZWQsXG5vYmplY3Qge1xuICBkaXNwbGF5OiBibG9jaztcbiAgLyogMSAqL1xuICB2ZXJ0aWNhbC1hbGlnbjogbWlkZGxlO1xuICAvKiAyICovXG59XG5cbi8qXG5Db25zdHJhaW4gaW1hZ2VzIGFuZCB2aWRlb3MgdG8gdGhlIHBhcmVudCB3aWR0aCBhbmQgcHJlc2VydmUgdGhlaXIgaW50cmluc2ljIGFzcGVjdCByYXRpby4gKGh0dHBzOi8vZ2l0aHViLmNvbS9tb3pkZXZzL2Nzc3JlbWVkeS9pc3N1ZXMvMTQpXG4qL1xuXG5pbWcsXG52aWRlbyB7XG4gIG1heC13aWR0aDogMTAwJTtcbiAgaGVpZ2h0OiBhdXRvO1xufVxuXG4vKiBNYWtlIGVsZW1lbnRzIHdpdGggdGhlIEhUTUwgaGlkZGVuIGF0dHJpYnV0ZSBzdGF5IGhpZGRlbiBieSBkZWZhdWx0ICovXG5cbltoaWRkZW5dIHtcbiAgZGlzcGxheTogbm9uZTtcbn1cblxuKiwgOjpiZWZvcmUsIDo6YWZ0ZXJ7XG4gIC0tdHctYm9yZGVyLXNwYWNpbmcteDogMDtcbiAgLS10dy1ib3JkZXItc3BhY2luZy15OiAwO1xuICAtLXR3LXRyYW5zbGF0ZS14OiAwO1xuICAtLXR3LXRyYW5zbGF0ZS15OiAwO1xuICAtLXR3LXJvdGF0ZTogMDtcbiAgLS10dy1za2V3LXg6IDA7XG4gIC0tdHctc2tldy15OiAwO1xuICAtLXR3LXNjYWxlLXg6IDE7XG4gIC0tdHctc2NhbGUteTogMTtcbiAgLS10dy1wYW4teDogIDtcbiAgLS10dy1wYW4teTogIDtcbiAgLS10dy1waW5jaC16b29tOiAgO1xuICAtLXR3LXNjcm9sbC1zbmFwLXN0cmljdG5lc3M6IHByb3hpbWl0eTtcbiAgLS10dy1ncmFkaWVudC1mcm9tLXBvc2l0aW9uOiAgO1xuICAtLXR3LWdyYWRpZW50LXZpYS1wb3NpdGlvbjogIDtcbiAgLS10dy1ncmFkaWVudC10by1wb3NpdGlvbjogIDtcbiAgLS10dy1vcmRpbmFsOiAgO1xuICAtLXR3LXNsYXNoZWQtemVybzogIDtcbiAgLS10dy1udW1lcmljLWZpZ3VyZTogIDtcbiAgLS10dy1udW1lcmljLXNwYWNpbmc6ICA7XG4gIC0tdHctbnVtZXJpYy1mcmFjdGlvbjogIDtcbiAgLS10dy1yaW5nLWluc2V0OiAgO1xuICAtLXR3LXJpbmctb2Zmc2V0LXdpZHRoOiAwcHg7XG4gIC0tdHctcmluZy1vZmZzZXQtY29sb3I6ICNmZmY7XG4gIC0tdHctcmluZy1jb2xvcjogcmdiKDU5IDEzMCAyNDYgLyAwLjUpO1xuICAtLXR3LXJpbmctb2Zmc2V0LXNoYWRvdzogMCAwICMwMDAwO1xuICAtLXR3LXJpbmctc2hhZG93OiAwIDAgIzAwMDA7XG4gIC0tdHctc2hhZG93OiAwIDAgIzAwMDA7XG4gIC0tdHctc2hhZG93LWNvbG9yZWQ6IDAgMCAjMDAwMDtcbiAgLS10dy1ibHVyOiAgO1xuICAtLXR3LWJyaWdodG5lc3M6ICA7XG4gIC0tdHctY29udHJhc3Q6ICA7XG4gIC0tdHctZ3JheXNjYWxlOiAgO1xuICAtLXR3LWh1ZS1yb3RhdGU6ICA7XG4gIC0tdHctaW52ZXJ0OiAgO1xuICAtLXR3LXNhdHVyYXRlOiAgO1xuICAtLXR3LXNlcGlhOiAgO1xuICAtLXR3LWRyb3Atc2hhZG93OiAgO1xuICAtLXR3LWJhY2tkcm9wLWJsdXI6ICA7XG4gIC0tdHctYmFja2Ryb3AtYnJpZ2h0bmVzczogIDtcbiAgLS10dy1iYWNrZHJvcC1jb250cmFzdDogIDtcbiAgLS10dy1iYWNrZHJvcC1ncmF5c2NhbGU6ICA7XG4gIC0tdHctYmFja2Ryb3AtaHVlLXJvdGF0ZTogIDtcbiAgLS10dy1iYWNrZHJvcC1pbnZlcnQ6ICA7XG4gIC0tdHctYmFja2Ryb3Atb3BhY2l0eTogIDtcbiAgLS10dy1iYWNrZHJvcC1zYXR1cmF0ZTogIDtcbiAgLS10dy1iYWNrZHJvcC1zZXBpYTogIFxufVxuXG46OmJhY2tkcm9we1xuICAtLXR3LWJvcmRlci1zcGFjaW5nLXg6IDA7XG4gIC0tdHctYm9yZGVyLXNwYWNpbmcteTogMDtcbiAgLS10dy10cmFuc2xhdGUteDogMDtcbiAgLS10dy10cmFuc2xhdGUteTogMDtcbiAgLS10dy1yb3RhdGU6IDA7XG4gIC0tdHctc2tldy14OiAwO1xuICAtLXR3LXNrZXcteTogMDtcbiAgLS10dy1zY2FsZS14OiAxO1xuICAtLXR3LXNjYWxlLXk6IDE7XG4gIC0tdHctcGFuLXg6ICA7XG4gIC0tdHctcGFuLXk6ICA7XG4gIC0tdHctcGluY2gtem9vbTogIDtcbiAgLS10dy1zY3JvbGwtc25hcC1zdHJpY3RuZXNzOiBwcm94aW1pdHk7XG4gIC0tdHctZ3JhZGllbnQtZnJvbS1wb3NpdGlvbjogIDtcbiAgLS10dy1ncmFkaWVudC12aWEtcG9zaXRpb246ICA7XG4gIC0tdHctZ3JhZGllbnQtdG8tcG9zaXRpb246ICA7XG4gIC0tdHctb3JkaW5hbDogIDtcbiAgLS10dy1zbGFzaGVkLXplcm86ICA7XG4gIC0tdHctbnVtZXJpYy1maWd1cmU6ICA7XG4gIC0tdHctbnVtZXJpYy1zcGFjaW5nOiAgO1xuICAtLXR3LW51bWVyaWMtZnJhY3Rpb246ICA7XG4gIC0tdHctcmluZy1pbnNldDogIDtcbiAgLS10dy1yaW5nLW9mZnNldC13aWR0aDogMHB4O1xuICAtLXR3LXJpbmctb2Zmc2V0LWNvbG9yOiAjZmZmO1xuICAtLXR3LXJpbmctY29sb3I6IHJnYig1OSAxMzAgMjQ2IC8gMC41KTtcbiAgLS10dy1yaW5nLW9mZnNldC1zaGFkb3c6IDAgMCAjMDAwMDtcbiAgLS10dy1yaW5nLXNoYWRvdzogMCAwICMwMDAwO1xuICAtLXR3LXNoYWRvdzogMCAwICMwMDAwO1xuICAtLXR3LXNoYWRvdy1jb2xvcmVkOiAwIDAgIzAwMDA7XG4gIC0tdHctYmx1cjogIDtcbiAgLS10dy1icmlnaHRuZXNzOiAgO1xuICAtLXR3LWNvbnRyYXN0OiAgO1xuICAtLXR3LWdyYXlzY2FsZTogIDtcbiAgLS10dy1odWUtcm90YXRlOiAgO1xuICAtLXR3LWludmVydDogIDtcbiAgLS10dy1zYXR1cmF0ZTogIDtcbiAgLS10dy1zZXBpYTogIDtcbiAgLS10dy1kcm9wLXNoYWRvdzogIDtcbiAgLS10dy1iYWNrZHJvcC1ibHVyOiAgO1xuICAtLXR3LWJhY2tkcm9wLWJyaWdodG5lc3M6ICA7XG4gIC0tdHctYmFja2Ryb3AtY29udHJhc3Q6ICA7XG4gIC0tdHctYmFja2Ryb3AtZ3JheXNjYWxlOiAgO1xuICAtLXR3LWJhY2tkcm9wLWh1ZS1yb3RhdGU6ICA7XG4gIC0tdHctYmFja2Ryb3AtaW52ZXJ0OiAgO1xuICAtLXR3LWJhY2tkcm9wLW9wYWNpdHk6ICA7XG4gIC0tdHctYmFja2Ryb3Atc2F0dXJhdGU6ICA7XG4gIC0tdHctYmFja2Ryb3Atc2VwaWE6ICBcbn1cblxuLm0tNHtcbiAgbWFyZ2luOiAxcmVtXG59XG5cbi5tYi0ye1xuICBtYXJnaW4tYm90dG9tOiAwLjVyZW1cbn1cblxuLm1iLTN7XG4gIG1hcmdpbi1ib3R0b206IDAuNzVyZW1cbn1cblxuLm1iLTZ7XG4gIG1hcmdpbi1ib3R0b206IDEuNXJlbVxufVxuXG4ubWItOHtcbiAgbWFyZ2luLWJvdHRvbTogMnJlbVxufVxuXG4ubWwtMntcbiAgbWFyZ2luLWxlZnQ6IDAuNXJlbVxufVxuXG4uaW5saW5lLWZsZXh7XG4gIGRpc3BsYXk6IGlubGluZS1mbGV4XG59XG5cbi5ncmlke1xuICBkaXNwbGF5OiBncmlkXG59XG5cbi5oLTN7XG4gIGhlaWdodDogMC43NXJlbVxufVxuXG4uaC0zXFwuNXtcbiAgaGVpZ2h0OiAwLjg3NXJlbVxufVxuXG4udy0ze1xuICB3aWR0aDogMC43NXJlbVxufVxuXG4udy0zXFwuNXtcbiAgd2lkdGg6IDAuODc1cmVtXG59XG5cbi5tYXgtdy1zbXtcbiAgbWF4LXdpZHRoOiAyNHJlbVxufVxuXG4uZ3JpZC1jb2xzLTJ7XG4gIGdyaWQtdGVtcGxhdGUtY29sdW1uczogcmVwZWF0KDIsIG1pbm1heCgwLCAxZnIpKVxufVxuXG4uaXRlbXMtY2VudGVye1xuICBhbGlnbi1pdGVtczogY2VudGVyXG59XG5cbi5kaXZpZGUteCA+IDpub3QoW2hpZGRlbl0pIH4gOm5vdChbaGlkZGVuXSl7XG4gIC0tdHctZGl2aWRlLXgtcmV2ZXJzZTogMDtcbiAgYm9yZGVyLXJpZ2h0LXdpZHRoOiBjYWxjKDFweCAqIHZhcigtLXR3LWRpdmlkZS14LXJldmVyc2UpKTtcbiAgYm9yZGVyLWxlZnQtd2lkdGg6IGNhbGMoMXB4ICogY2FsYygxIC0gdmFyKC0tdHctZGl2aWRlLXgtcmV2ZXJzZSkpKVxufVxuXG4ucm91bmRlZC1sZ3tcbiAgYm9yZGVyLXJhZGl1czogMC41cmVtXG59XG5cbi5yb3VuZGVkLW1ke1xuICBib3JkZXItcmFkaXVzOiAwLjM3NXJlbVxufVxuXG4uYm9yZGVye1xuICBib3JkZXItd2lkdGg6IDFweFxufVxuXG4uYm9yZGVyLWdyYXktMjAwe1xuICAtLXR3LWJvcmRlci1vcGFjaXR5OiAxO1xuICBib3JkZXItY29sb3I6IHJnYigyMjkgMjMxIDIzNSAvIHZhcigtLXR3LWJvcmRlci1vcGFjaXR5KSlcbn1cblxuLmJnLWJsdWUtMTAwe1xuICAtLXR3LWJnLW9wYWNpdHk6IDE7XG4gIGJhY2tncm91bmQtY29sb3I6IHJnYigyMTkgMjM0IDI1NCAvIHZhcigtLXR3LWJnLW9wYWNpdHkpKVxufVxuXG4uYmctYmx1ZS03MDB7XG4gIC0tdHctYmctb3BhY2l0eTogMTtcbiAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDI5IDc4IDIxNiAvIHZhcigtLXR3LWJnLW9wYWNpdHkpKVxufVxuXG4uYmctd2hpdGV7XG4gIC0tdHctYmctb3BhY2l0eTogMTtcbiAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDI1NSAyNTUgMjU1IC8gdmFyKC0tdHctYmctb3BhY2l0eSkpXG59XG5cbi5wLTZ7XG4gIHBhZGRpbmc6IDEuNXJlbVxufVxuXG4ucC04e1xuICBwYWRkaW5nOiAycmVtXG59XG5cbi5weC0ze1xuICBwYWRkaW5nLWxlZnQ6IDAuNzVyZW07XG4gIHBhZGRpbmctcmlnaHQ6IDAuNzVyZW1cbn1cblxuLnB4LTR7XG4gIHBhZGRpbmctbGVmdDogMXJlbTtcbiAgcGFkZGluZy1yaWdodDogMXJlbVxufVxuXG4ucHktMntcbiAgcGFkZGluZy10b3A6IDAuNXJlbTtcbiAgcGFkZGluZy1ib3R0b206IDAuNXJlbVxufVxuXG4udGV4dC1jZW50ZXJ7XG4gIHRleHQtYWxpZ246IGNlbnRlclxufVxuXG4udGV4dC1yaWdodHtcbiAgdGV4dC1hbGlnbjogcmlnaHRcbn1cblxuLnRleHQtMnhse1xuICBmb250LXNpemU6IDEuNXJlbTtcbiAgbGluZS1oZWlnaHQ6IDJyZW1cbn1cblxuLnRleHQtM3hse1xuICBmb250LXNpemU6IDEuODc1cmVtO1xuICBsaW5lLWhlaWdodDogMi4yNXJlbVxufVxuXG4udGV4dC1zbXtcbiAgZm9udC1zaXplOiAwLjg3NXJlbTtcbiAgbGluZS1oZWlnaHQ6IDEuMjVyZW1cbn1cblxuLmZvbnQtYm9sZHtcbiAgZm9udC13ZWlnaHQ6IDcwMFxufVxuXG4uZm9udC1leHRyYWJvbGR7XG4gIGZvbnQtd2VpZ2h0OiA4MDBcbn1cblxuLmZvbnQtbm9ybWFse1xuICBmb250LXdlaWdodDogNDAwXG59XG5cbi5mb250LXNlbWlib2xke1xuICBmb250LXdlaWdodDogNjAwXG59XG5cbi50cmFja2luZy10aWdodHtcbiAgbGV0dGVyLXNwYWNpbmc6IC0wLjAyNWVtXG59XG5cbi50ZXh0LWJsdWUtODAwe1xuICAtLXR3LXRleHQtb3BhY2l0eTogMTtcbiAgY29sb3I6IHJnYigzMCA2NCAxNzUgLyB2YXIoLS10dy10ZXh0LW9wYWNpdHkpKVxufVxuXG4udGV4dC1ncmF5LTUwMHtcbiAgLS10dy10ZXh0LW9wYWNpdHk6IDE7XG4gIGNvbG9yOiByZ2IoMTA3IDExNCAxMjggLyB2YXIoLS10dy10ZXh0LW9wYWNpdHkpKVxufVxuXG4udGV4dC1ncmF5LTkwMHtcbiAgLS10dy10ZXh0LW9wYWNpdHk6IDE7XG4gIGNvbG9yOiByZ2IoMTcgMjQgMzkgLyB2YXIoLS10dy10ZXh0LW9wYWNpdHkpKVxufVxuXG4udGV4dC13aGl0ZXtcbiAgLS10dy10ZXh0LW9wYWNpdHk6IDE7XG4gIGNvbG9yOiByZ2IoMjU1IDI1NSAyNTUgLyB2YXIoLS10dy10ZXh0LW9wYWNpdHkpKVxufVxuXG4uc2hhZG93e1xuICAtLXR3LXNoYWRvdzogMCAxcHggM3B4IDAgcmdiKDAgMCAwIC8gMC4xKSwgMCAxcHggMnB4IC0xcHggcmdiKDAgMCAwIC8gMC4xKTtcbiAgLS10dy1zaGFkb3ctY29sb3JlZDogMCAxcHggM3B4IDAgdmFyKC0tdHctc2hhZG93LWNvbG9yKSwgMCAxcHggMnB4IC0xcHggdmFyKC0tdHctc2hhZG93LWNvbG9yKTtcbiAgYm94LXNoYWRvdzogdmFyKC0tdHctcmluZy1vZmZzZXQtc2hhZG93LCAwIDAgIzAwMDApLCB2YXIoLS10dy1yaW5nLXNoYWRvdywgMCAwICMwMDAwKSwgdmFyKC0tdHctc2hhZG93KVxufVxuXG4uaG92ZXJcXDpiZy1ibHVlLTgwMDpob3ZlcntcbiAgLS10dy1iZy1vcGFjaXR5OiAxO1xuICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMzAgNjQgMTc1IC8gdmFyKC0tdHctYmctb3BhY2l0eSkpXG59XG5cbi5mb2N1c1xcOm91dGxpbmUtbm9uZTpmb2N1c3tcbiAgb3V0bGluZTogMnB4IHNvbGlkIHRyYW5zcGFyZW50O1xuICBvdXRsaW5lLW9mZnNldDogMnB4XG59XG5cbi5mb2N1c1xcOnJpbmctNDpmb2N1c3tcbiAgLS10dy1yaW5nLW9mZnNldC1zaGFkb3c6IHZhcigtLXR3LXJpbmctaW5zZXQpIDAgMCAwIHZhcigtLXR3LXJpbmctb2Zmc2V0LXdpZHRoKSB2YXIoLS10dy1yaW5nLW9mZnNldC1jb2xvcik7XG4gIC0tdHctcmluZy1zaGFkb3c6IHZhcigtLXR3LXJpbmctaW5zZXQpIDAgMCAwIGNhbGMoNHB4ICsgdmFyKC0tdHctcmluZy1vZmZzZXQtd2lkdGgpKSB2YXIoLS10dy1yaW5nLWNvbG9yKTtcbiAgYm94LXNoYWRvdzogdmFyKC0tdHctcmluZy1vZmZzZXQtc2hhZG93KSwgdmFyKC0tdHctcmluZy1zaGFkb3cpLCB2YXIoLS10dy1zaGFkb3csIDAgMCAjMDAwMClcbn1cblxuLmZvY3VzXFw6cmluZy1ibHVlLTMwMDpmb2N1c3tcbiAgLS10dy1yaW5nLW9wYWNpdHk6IDE7XG4gIC0tdHctcmluZy1jb2xvcjogcmdiKDE0NyAxOTcgMjUzIC8gdmFyKC0tdHctcmluZy1vcGFjaXR5KSlcbn1cblxuQG1lZGlhIChtaW4td2lkdGg6IDc2OHB4KXtcbiAgLm1kXFw6Z3JpZC1jb2xzLTJ7XG4gICAgZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOiByZXBlYXQoMiwgbWlubWF4KDAsIDFmcikpXG4gIH1cbn1cbiJdfQ== */"] });


/***/ }),

/***/ "5ZbQ":
/*!***************************************************!*\
  !*** ./src/app/common/captcha/captcha.service.ts ***!
  \***************************************************/
/*! exports provided: CaptchaService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CaptchaService", function() { return CaptchaService; });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");


class CaptchaService {
    constructor() {
        this.captchSource = new rxjs__WEBPACK_IMPORTED_MODULE_0__["BehaviorSubject"](null);
        this.captchStatus = this.captchSource.asObservable();
    }
    setCaptchaStatus(code) {
        this.captchSource.next(code);
    }
}
CaptchaService.ɵfac = function CaptchaService_Factory(t) { return new (t || CaptchaService)(); };
CaptchaService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: CaptchaService, factory: CaptchaService.ɵfac, providedIn: 'root' });


/***/ }),

/***/ "9KkW":
/*!***************************************************************************!*\
  !*** ./src/app/main/manage-applications/manage-applications.component.ts ***!
  \***************************************************************************/
/*! exports provided: ManageApplicationsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ManageApplicationsComponent", function() { return ManageApplicationsComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ "tyNb");


class ManageApplicationsComponent {
    constructor() { }
    ngOnInit() {
    }
}
ManageApplicationsComponent.ɵfac = function ManageApplicationsComponent_Factory(t) { return new (t || ManageApplicationsComponent)(); };
ManageApplicationsComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: ManageApplicationsComponent, selectors: [["app-manage-applications"]], decls: 1, vars: 0, template: function ManageApplicationsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "router-outlet");
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterOutlet"]], encapsulation: 2 });


/***/ }),

/***/ "9vUh":
/*!****************************************!*\
  !*** ./src/app/home/home.component.ts ***!
  \****************************************/
/*! exports provided: HomeComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HomeComponent", function() { return HomeComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");
/* harmony import */ var _common_env_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../common/env.service */ "YcfP");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");







function HomeComponent_p_279_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 120);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "ERRORS.emailValidate"), " ");
} }
const _c0 = function () { return ["/faq"]; };
const _c1 = function (a0) { return { border: a0 }; };
const _c2 = function (a0) { return { border: a0, resize: "none" }; };
// import * as $ from 'jquery';
class HomeComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj, translate, renderer, envservice) {
        super(inj);
        this.translate = translate;
        this.renderer = renderer;
        this.envservice = envservice;
        // errorMessage: string = '';
        this.homeInfo = {};
        this.noWrapSlides = true;
        this.showIndicator = true;
        this.images = [
            {
                image: 'assets/img/tourists/1.jpg',
                thumbImage: 'assets/img/tourists/1.jpg'
            },
            {
                image: 'assets/img/tourists/2.jpg',
                thumbImage: 'assets/img/tourists/2.jpg'
            }, {
                image: 'assets/img/tourists/3.jpg',
                thumbImage: 'assets/img/tourists/3.jpg'
            }, {
                image: 'assets/img/tourists/4.jpg',
                thumbImage: 'assets/img/tourists/4.jpg'
            }, {
                image: 'assets/img/tourists/5.jpg',
                thumbImage: 'assets/img/tourists/5.jpg'
            }, {
                image: 'assets/img/tourists/6.jpg',
                thumbImage: 'assets/img/tourists/6.jpg'
            },
            {
                image: 'assets/img/tourists/7.jpg',
                thumbImage: 'assets/img/tourists/7.jpg'
            },
        ];
        this.windowObjectReference = null;
        this.sendMessage = {};
        this.submitted = false;
        const browserLang = translate.getBrowserLang();
        this.homeInfo.lang = browserLang;
        translate.use(browserLang.match(/en|fr/) ? browserLang : 'en');
        localStorage.setItem("Language", browserLang.match(/fr|fr-FR/) ? 'fr' : 'en');
        this.setToken("Language", browserLang.match(/fr|fr-FR/) ? 'fr' : 'en');
        this.translate.get('DEFAULT_TITLE').subscribe((translatedTitle) => {
            this.titleService.setTitle(translatedTitle);
        });
    }
    ngOnInit() {
        this.renderer.removeClass(document.body, 'login');
        this.buildVersion = this.envservice.build_Version;
        console.log(this.buildVersion);
        this.buildDate = this.envservice.build_Date;
        this.loadScript('assets/home/js/theme-core.js');
    }
    launchApplication(type) {
        if (type == 'L') {
            localStorage.setItem("getPage", 'loginTrue');
            if (localStorage.getItem("isguilty") == "YES") {
                alert("You have been caught!! close all the windows and clear the browser cache to proceed");
                return 0;
            }
            this.routerUrl = window.location.href.split('#')[0];
            let endUrl = this.routerUrl + '#/login';
            this.evisaCount = localStorage.getItem("evisaCount");
            if (this.evisaCount != null) {
                this.evisaCount = Number(this.evisaCount) + 1;
            }
            else {
                this.evisaCount = 1;
            }
            // this.setToken("evisaCount", this.evisaCount);
            localStorage.setItem("evisaCount", this.evisaCount);
            if ((this.windowObjectReference == null || this.windowObjectReference.closed) && this.evisaCount == 1) {
                this.windowObjectReference = window.open(endUrl, "myWindow", "width=" + screen.width + ",height=" + screen.height + ",left=0,top=0,resizable=no,scrollbars=yes,toolbar=no,menubar=no,titlebar=no");
            }
            else if (this.windowObjectReference != null && !this.windowObjectReference.closed) {
                this.windowObjectReference.focus();
            }
            else if (this.evisaCount > 0) {
                alert('Application is already opened in another browser or tab. If not opened, clear the browser cache and try again.');
            }
        }
        else {
            localStorage.setItem("getPage", 'signupTrue');
            this.routerUrl = window.location.href.split('#')[0];
            let endUrl = this.routerUrl + '#/login';
            this.windowObjectReference = window.open(endUrl, "myWindow", "width=" + screen.width + ",height=" + screen.height + ",left=0,top=0,resizable=no,scrollbars=yes,toolbar=no,menubar=no,titlebar=no");
        }
    }
    translateLanguage(language) {
        this.setToken("Language", language);
        localStorage.setItem("Language", language);
    }
    // loadJS(){
    //    $.getScript('src/assets/home/js/theme-core.js');
    // }
    loadScript(url) {
        const body = document.body;
        const script = document.createElement('script');
        script.innerHTML = '';
        script.src = url;
        script.async = false;
        script.defer = true;
        body.appendChild(script);
    }
    submitForm(form, sendMessage) {
        if (form.valid) {
            console.log(sendMessage);
            this.commonService.callApi('contactus', sendMessage, 'post', false, true, 'REG').then(success => {
                let successData = success;
                if (successData.apiStatusCode === "SUCCESS") {
                    this.toastr.success(successData.apiStatusDesc, 'Success');
                    this.sendMessage = {};
                    this.submitted = false;
                }
                else {
                    this.toastr.error(successData.apiStatusDesc, 'Error');
                }
            });
        }
        else {
            this.submitted = true;
        }
    }
    validateInput(event, type) {
        // Vérifier si l'élément cible est un input ou une textarea
        const inputElement = event.target;
        const input = inputElement.value; // Obtenir la valeur de l'élément
        // Définir une expression régulière selon le type
        let regex;
        switch (type) {
            case 'string': // Autoriser uniquement les lettres
                regex = /^[a-zA-Z\s-]*$/;
                break;
            case 'number': // Autoriser uniquement les chiffres
                regex = /^[0-9]*$/;
                break;
            case 'address': // Autoriser lettres, chiffres et quelques caractères spéciaux
                regex = /^[a-zA-Z0-9\s,.'-/]*$/;
                break;
            case 'passport': // Numéro de passeport
                regex = /^[A-Z0-9-]{6,12}$/;
                break;
            default:
                regex = /.*/; // Autoriser tout (fallback)
        }
        // Remplacer les caractères invalides
        if (!regex.test(input)) {
            inputElement.value = input.replace(type === 'string'
                ? /[^a-zA-Z\s-]/g // Pour les lettres, autoriser les espaces et les tirets
                : type === 'number'
                    ? /[^0-9]/g // Pour les chiffres, supprimer les caractères non numériques
                    : /[^a-zA-Z0-9\s,.'-/]/g, // Pour les adresses, supprimer les caractères non autorisés
            '');
        }
    }
}
HomeComponent.ɵfac = function HomeComponent_Factory(t) { return new (t || HomeComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__["TranslateService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Renderer2"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_common_env_service__WEBPACK_IMPORTED_MODULE_3__["EnvService"])); };
HomeComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: HomeComponent, selectors: [["app-home"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 348, vars: 152, consts: [[1, "no-page-top"], ["data-bg-color", "rgba(9, 103, 139, 0.36)", "data-font-color", "#fff", 1, "header1"], [1, ""], ["id", "nav-centrer", 1, "navbar-collapse", "nav-main-collapse", "collapse"], ["id", "nav-wrapper"], [1, "nav-main", "mega-menu", "one-page-menu"], ["href", "index.html"], ["src", "assets/img/evisa.png", "alt", "", "width", "200px", 1, "lo"], ["id", "mainMenu", 1, "nav", "nav-pills", "nav-main", 2, "display", "flex", "align-items", "center", "margin", "auto"], [1, "active", 2, "color", "black !important"], ["data-hash", "", "href", "#home"], ["data-hash", "", "href", "#features"], ["data-hash", "", "href", "#services"], ["data-hash", "", "href", "#screenshots"], ["data-hash", "", "href", "#contact-us"], ["href", "javascript:;", 3, "click"], ["id", "lang", "name", "lang", "required", "", "maxlength", "25", 1, "form-control", 3, "ngModel", "change", "ngModelChange"], ["lang", "ngModel"], ["value", "en"], ["value", "fr"], ["data-toggle", "collapse", "data-target", ".nav-main-collapse", 1, "btn", "btn-responsive-nav", "btn-inverse"], [1, "fa", "fa-bars"], [2, "display", "block", "color", "red", "text-align", "center", "padding-bottom", "10px"], ["href", "mailto://immigration@evisa.dj", "target", "_blank", "rel", "noopener noreferrer"], ["id", "img-container"], ["src", "assets/home/img/touris/_DOM5184.jpg", 1, "image", 2, "font-weight", "600"], [1, "text"], ["id", "img-head"], ["id", "img-p"], ["id", "container"], [1, "v-page-wrap", "no-bottom-spacing"], [1, "container"], [1, "v-spacer", "col-sm-12", "v-height-small"], ["id", "features", 1, "container"], [1, "row", "center"], [1, "col-md-12"], [1, "v-smash-text-large-2x"], [1, "horizontal-break"], [1, "lead", 2, "color", "#999"], [1, "v-spacer", "col-sm-12", "v-height-standard"], [1, "row", "features"], [1, "col-md-4", "col-sm-4"], ["data-animation", "fade-from-left", "data-delay", "300", 1, "feature-box", "left-icon", "v-animation", "pull-top"], [1, "feature-box-icon", "small"], [1, "num"], [1, "feature-box-text"], [1, "feature-box-text-inner"], ["data-animation", "fade-from-left", "data-delay", "600", 1, "feature-box", "left-icon", "v-animation"], ["data-animation", "fade-from-right", "data-delay", "300", 1, "feature-box", "left-icon", "v-animation", "pull-top"], [1, "row"], [1, "col-sm-3", "col-md-3"], [1, "col-md-6", "col-sm-6"], ["data-animation", "fade-from-right", "data-delay", "200", 1, "b", "img-responsive", "v-animation", 3, "click"], [1, "col-sm-12"], ["id", "services", 1, "v-parallax", "v-parallax-video", "v-bg-stylish", 2, "background-image", "url(assets/home/img/air-djibouti-cargo4.jpg)"], [1, "col-sm-4"], ["data-animation", "grow", "data-delay", "0", 1, "feature-box", "feature-box-secundary-one", "v-animation"], [1, "num1"], [1, "feature-box-text", "clearfix"], ["data-animation", "grow", "data-delay", "200", 1, "feature-box", "feature-box-secundary-one", "v-animation"], ["data-animation", "grow", "data-delay", "400", 1, "feature-box", "feature-box-secundary-one", "v-animation"], [1, "v-bg-overlay", "overlay-colored"], [1, "b", 2, "align-content", "center", "align-items", "center", "width", "100%", 3, "routerLink"], ["id", "screenshots", 1, "v-parallax", "v-bg-stylish", "v-bg-stylish-v4", "no-shadow"], [1, "container-fluid"], ["href", "https://guide.visitdjibouti.dj/", 1, "visiblity"], ["id", "myCarousel", "data-ride", "carousel", 1, "carousel", "slide"], ["id", "carousel-center", 1, "carousel-indicators"], ["data-target", "#myCarousel", "data-slide-to", "0", 1, "active"], ["data-target", "#myCarousel", "data-slide-to", "1"], ["data-target", "#myCarousel", "data-slide-to", "2"], ["data-target", "#myCarousel", "data-slide-to", "3"], ["role", "listbox", 1, "carousel-inner"], [1, "item", "active"], ["src", "assets/home/img/touris/touris1.jpg", "alt", "Chania", "width", "100%"], [1, "item"], ["src", "assets/home/img/touris/touris2.jpg", "alt", "Chania", "width", "100%"], ["src", "assets/home/img/touris/touris3.jpg", "alt", "Flower", "width", "100%"], ["src", "assets/home/img/touris/touris4.jpg", "alt", "Flower", "width", "100%"], ["href", "#myCarousel", "role", "button", "data-slide", "prev", 1, "left", "carousel-control"], [1, "sr-only"], ["href", "#myCarousel", "role", "button", "data-slide", "next", 1, "right", "carousel-control"], ["id", "contact-us", 1, "v-parallax", "v-bg-stylish"], [1, "col-sm-8", "col-sm-offset-2"], [1, "form-horizontal", 3, "ngSubmit"], ["sendMessageForm", "ngForm"], [1, "form-group"], [1, "required"], ["name", "subject", "id", "subject", "required", "", 1, "form-control", 3, "ngModel", "ngStyle", "ngModelChange"], ["subject", "ngModel"], ["disabled", "", "selected", "", 3, "ngValue"], ["value", "S"], ["value", "R"], ["type", "text", "maxlength", "100", "name", "contactName", "id", "contactName", "required", "", 1, "form-control", 3, "ngStyle", "ngModel", "ngModelChange", "input"], ["contactName", "ngModel"], ["type", "email", "maxlength", "100", "name", "contactEmail", "id", "contactEmail", "pattern", "^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[a-zA-Z]{2,4}$", "required", "", 1, "form-control", 3, "ngStyle", "ngModel", "ngModelChange"], ["contactEmail", "ngModel"], ["style", "color: #b94a48", 4, "ngIf"], ["maxlength", "5000", "rows", "10", "name", "contactComment", "id", "contactComment", "required", "", 1, "form-control", 3, "ngStyle", "ngModel", "ngModelChange", "input"], ["contactComment", "ngModel"], ["type", "submit", 1, "btn", "v-btn", "no-three-d"], [2, "font-weight", "bold"], ["href", "tel:0025377722124", "target", "_blank", "rel", "noopener noreferrer"], ["href", "tel:0025377722123", "target", "_blank", "rel", "noopener noreferrer"], ["href", "https://wa.me/0025377722124", "target", "_blank", "rel", "noopener noreferrer", 2, "display", "inline-flex", "align-items", "center"], ["xmlns", "http://www.w3.org/2000/svg", "viewBox", "0 0 448 512", "width", "16", "height", "16", "fill", "currentColor"], ["d", "M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"], [1, "footer-wrap"], [1, "widget"], [1, "logo"], ["src", "assets/img/evisa.png", "alt", "", 1, "lo", 2, "width", "200px"], [1, "col-sm-8"], [1, "widget-heading", 2, "text-align", "right"], [1, "footer-contact-info"], ["href", "javascript:;", 3, "routerLink"], [1, "fa", "fa-question"], [1, "copyright"], ["rel", "nofollow", "target", "_parent", "href", "https://www.hypercube.dj/", 1, "tm-text-link"], ["id", "back-to-top", 1, "animate-top"], [1, "fa", "fa-angle-up"], [2, "color", "#b94a48"]], template: function HomeComponent_Template(rf, ctx) { if (rf & 1) {
        const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](0, "` ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "body", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "header", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "nav", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "a", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "img", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "ul", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "li", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "a", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](15, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "a", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](19, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "a", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](23, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "a", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](26);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](27, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "a", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](30);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](31, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "a", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function HomeComponent_Template_a_click_33_listener() { return ctx.launchApplication("L"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](34);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](35, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](36, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](37, "a", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function HomeComponent_Template_a_click_37_listener() { return ctx.launchApplication("S"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](38);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](39, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](41, "select", 16, 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function HomeComponent_Template_select_change_41_listener() { ctx.translate.use(ctx.homeInfo.lang); return ctx.translateLanguage(ctx.homeInfo.lang); })("ngModelChange", function HomeComponent_Template_select_ngModelChange_41_listener($event) { return ctx.homeInfo.lang = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](43, "option", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](44, "English");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "option", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](46, "Fran\u00E7ais");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](47, "button", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](48, "i", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](49, "span", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](50);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](51, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](52, "a", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](54, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](55, "div", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](56, "img", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](57, "div", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](58, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](59, "h1", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](60);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](61, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](62, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](63, "h1");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](64, "p", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](65);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](66, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](67, "p", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](68);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](69, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](70, "div", 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](71, "div", 30);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](72, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](73, "div", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](74, "div", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](75, "div", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](76, "div", 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](77, "p", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](78, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](79);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](80, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](81, "div", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](82, "p", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](83);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](84, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](85, "div", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](86, "div", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](87, "div", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](88, "div", 42);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](89, "div", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](90, "div", 44);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](91, "1");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](92, "div", 45);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](93, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](94);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](95, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](96, "div", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](97);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](98, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](99, "div", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](100, "div", 47);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](101, "div", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](102, "div", 44);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](103, "2");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](104, "div", 45);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](105, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](106);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](107, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](108, "div", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](109);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](110, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](111, "div", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](112, "div", 48);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](113, "div", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](114, "div", 44);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](115, "3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](116, "div", 45);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](117, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](118);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](119, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](120, "div", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](121);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](122, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](123, "div", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](124, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](125, "div", 50);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](126, "div", 51);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](127, "button", 52);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function HomeComponent_Template_button_click_127_listener() { return ctx.launchApplication("S"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](128, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](129);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](130, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](131, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](132, "div", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](133, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](134, "div", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](135, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](136, "p", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](137, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](138);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](139, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](140, "div", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](141, "p", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](142);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](143, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](144, "div", 54);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](145, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](146, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](147, "div", 55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](148, "div", 56);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](149, "div", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](150, "div", 57);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](151, "1");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](152, "div", 58);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](153, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](154);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](155, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](156, "div", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](157, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](158);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](159, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](160, "div", 55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](161, "div", 59);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](162, "div", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](163, "div", 57);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](164, "2");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](165, "div", 45);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](166, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](167);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](168, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](169, "div", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](170, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](171);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](172, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](173, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](174, "div", 55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](175, "div", 60);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](176, "div", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](177, "div", 57);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](178, "3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](179, "div", 45);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](180, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](181);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](182, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](183, "div", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](184, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](185);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](186, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](187, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](188, "div", 61);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](189, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](190, "div", 55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](191, "div", 55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](192, "div", 59);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](193, "button", 62);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](194);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](195, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](196, "div", 63);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](197, "div", 64);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](198, "div", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](199, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](200, "p", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](201, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](202);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](203, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](204, "div", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](205, "p", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](206, "a", 65);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](207);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](208, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](209, "div", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](210, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](211, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](212, "div", 66);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](213, "ol", 67);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](214, "li", 68);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](215, "li", 69);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](216, "li", 70);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](217, "li", 71);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](218, "div", 72);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](219, "div", 73);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](220, "img", 74);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](221, "div", 75);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](222, "img", 76);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](223, "div", 75);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](224, "img", 77);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](225, "div", 75);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](226, "img", 78);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](227, "a", 79);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](228, "span", 80);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](229, "Previous");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](230, "a", 81);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](231, "span", 80);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](232, "Next");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](233, "div", 82);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](234, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](235, "div", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](236, "div", 83);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](237, "p", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](238, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](239);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](240, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](241, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](242, "div", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](243, "div", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](244, "form", 84, 85);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngSubmit", function HomeComponent_Template_form_ngSubmit_244_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r7); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](245); return ctx.submitForm(_r1, ctx.sendMessage); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](246, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](247, "div", 86);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](248, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](249, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](250);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](251, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](252, "span", 87);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](253, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](254, "select", 88, 89);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function HomeComponent_Template_select_ngModelChange_254_listener($event) { return ctx.sendMessage.subject = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](256, "option", 90);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](257);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](258, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](259, "option", 91);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](260, "Support");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](261, "option", 92);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](262, "Renseignement | Information");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](263, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](264, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](265);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](266, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](267, "span", 87);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](268, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](269, "input", 93, 94);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function HomeComponent_Template_input_ngModelChange_269_listener($event) { return ctx.sendMessage.contactName = $event; })("input", function HomeComponent_Template_input_input_269_listener($event) { return ctx.validateInput($event, "string"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](271, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](272, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](273);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](274, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](275, "span", 87);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](276, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](277, "input", 95, 96);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function HomeComponent_Template_input_ngModelChange_277_listener($event) { return ctx.sendMessage.contactEmail = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](279, HomeComponent_p_279_Template, 3, 3, "p", 97);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](280, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](281, "div", 86);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](282, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](283, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](284);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](285, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](286, "span", 87);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](287, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](288, "textarea", 98, 99);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function HomeComponent_Template_textarea_ngModelChange_288_listener($event) { return ctx.sendMessage.contactComment = $event; })("input", function HomeComponent_Template_textarea_input_288_listener($event) { return ctx.validateInput($event, "string"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](290, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](291, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](292, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](293, "button", 100);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](294);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](295, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](296, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](297, "div", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](298, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](299, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](300, "span", 101);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](301);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](302, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](303, "a", 102);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](304, "+253 77 72 21 24");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](305, " | ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](306, "a", 103);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](307, "+253 77 79 88 93");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](308, " \u00A0 \u00A0 ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](309, "span", 101);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](310, "a", 104);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceSVG"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](311, "svg", 105);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](312, "path", 106);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](313);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](314, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnamespaceHTML"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](315, "div", 107);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](316, "footer");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](317, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](318, "div", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](319, "div", 55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](320, "section", 108);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](321, "div", 109);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](322, "img", 110);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](323, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](324, "div", 111);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](325, "section", 108);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](326, "div", 112);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](327, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](328);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](329, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](330, "div", 113);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](331, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](332, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](333, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](334, "strong");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](335, "a", 114);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](336);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](337, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](338, "i", 115);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](339, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](340, "div", 116);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](341, "div", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](342, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](343, " \u00A9 2024 E-visa Djibouti \u00A0 \u2022 \u00A0 ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](344, "a", 117);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](345, "Hypercube");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](346, "div", 118);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](347, "i", 119);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](255);
        const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](270);
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](278);
        const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](289);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](15, 56, "HOME.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](19, 58, "HOME.Apply visa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](23, 60, "HOME.Information"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](27, 62, "HOME.Tourist"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](31, 64, "HOME.Contact us"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](35, 66, "HOME.Login"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](39, 68, "HOME.Signup"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngModel", ctx.homeInfo.lang);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](51, 70, "HEADER.Message"), " \u00A0\u00A0");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](54, 72, "HEADER.oldPlatform"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](61, 74, "HOME.Welcome To"), " DJIBOUTI");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](66, 76, "HOME.THIS IS YOUR EVISA WEBSITE"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](69, 78, "HOME.GET YOUR VISA ELECTRONIC"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](80, 80, "HOME.STEP VISA"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](84, 82, "HOME.steps to electronic visa"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](95, 84, "HOME.SIGN UP"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](98, 86, "HOME.Take a few seconds"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](107, 88, "HOME.application"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](110, 90, "HOME.Make Payment"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](119, 92, "HOME.GetYourVisa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](122, 94, "HOME.Download"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](130, 96, "HOME.Apply visa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](139, 98, "HOME.VISA INFORMATION"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](143, 100, "HOME.Frequently"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](155, 102, "HOME.What is the eVisa"), " ?");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](159, 104, "HOME.evisa document"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](168, 106, "HOME.What do I need to apply"), " ?");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](172, 108, "HOME.need to apply"), ".");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](182, 110, "HOME.advantages of the eVisa"), " ?");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](186, 112, "HOME.You can easily get your eVisa"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](142, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](195, 114, "HOME.Read more"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](203, 116, "HOME.TOURIST"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](208, 118, "HOME.more information"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](32);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](240, 120, "HOME.CONTACT US"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](251, 122, "HOME.Subject"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngModel", ctx.sendMessage.subject)("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](143, _c1, ctx.submitted == true && _r2.invalid ? "1px solid #b94a48" : ""));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngValue", undefined);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" --", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](258, 124, "HOME.Select the subject"), "-- ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](266, 126, "HOME.Your name"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](145, _c1, ctx.submitted == true && _r3.invalid ? "1px solid #b94a48" : ""))("ngModel", ctx.sendMessage.contactName);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](274, 128, "HOME.Your email address"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](147, _c1, ctx.submitted == true && _r4.invalid ? "1px solid #b94a48" : ""))("ngModel", ctx.sendMessage.contactEmail);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", _r4.errors == null ? null : _r4.errors.pattern);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](285, 130, "HOME.Comment"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](149, _c2, ctx.submitted && _r6.invalid ? "1px solid #b94a48" : ""))("ngModel", ctx.sendMessage.contactComment);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](295, 132, "HOME.Send Message"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](302, 134, "HOME.Number support"), "\u00A0\u00A0");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("\u00A0\u00A0", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](314, 136, "HOME.Disponible sur Whatsapp"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](329, 138, "HOME.Frequently"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](151, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](337, 140, "HOME.FAQ"), " ");
    } }, directives: [_angular_forms__WEBPACK_IMPORTED_MODULE_4__["SelectControlValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["RequiredValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["MaxLengthValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgModel"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgSelectOption"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["ɵangular_packages_forms_forms_z"], _angular_router__WEBPACK_IMPORTED_MODULE_5__["RouterLink"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgForm"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgStyle"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["PatternValidator"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], _angular_router__WEBPACK_IMPORTED_MODULE_5__["RouterLinkWithHref"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__["TranslatePipe"]], styles: ["@import url('https://fonts.googleapis.com/css2?family=Homemade+Apple&display=swap');\n@import url('https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,232;1,232&display=swap');\n\n.page-content[_ngcontent-%COMP%] {\n  padding: 0;\n}\n#mu-header[_ngcontent-%COMP%] {\n  background-color: #192c54;\n  display: inline;\n  float: left;\n  width: 100%;\n  color: #FFFFFF;\n}\n.ie8[_ngcontent-%COMP%]   .page-content[_ngcontent-%COMP%] {\n  padding: 0 !important;\n}\n.mu-abtus-counter-single[_ngcontent-%COMP%] {\n  border-right: none !important;\n}\n.promo-page[_ngcontent-%COMP%] {\n  padding-left: 0;\n  padding-right: 0;\n  \n}\n.promo-page[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .promo-page[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 50px;\n  line-height: 60px;\n}\n.promo-page[_ngcontent-%COMP%]   .btn.xlarge[_ngcontent-%COMP%] {\n  font-size: 22px;\n  padding: 7px 25px;\n  margin: 5px 0;\n}\n.promo-page[_ngcontent-%COMP%]   input.form-control[_ngcontent-%COMP%] {\n  background: #fff;\n}\n\n.promo-page[_ngcontent-%COMP%]   .block-transparent[_ngcontent-%COMP%] {\n  min-height: 350px;\n  padding: 50px 20px 30px 20px;\n}\n.promo-page[_ngcontent-%COMP%]   .block-grey[_ngcontent-%COMP%] {\n  min-height: 350px;\n  padding: 50px 20px 30px 20px;\n  background: #eeedf2;\n}\n.promo-page[_ngcontent-%COMP%]   .block-yellow[_ngcontent-%COMP%] {\n  min-height: 350px;\n  padding: 50px 20px 30px 20px;\n  background: #ffd800;\n}\n.promo-page[_ngcontent-%COMP%]   .block-footer[_ngcontent-%COMP%] {\n  padding: 30px 20px 30px 20px;\n  background: #eeedf2;\n}\n\n.block-carousel[_ngcontent-%COMP%]   .carousel-inner[_ngcontent-%COMP%] {\n  padding-top: 10px;\n  padding-bottom: 30px;\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  display: none;\n  position: absolute;\n  top: 40%;\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-control.left[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  right: 30%;\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-control.right[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  left: 30%;\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel[_ngcontent-%COMP%]:hover   .carousel-control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  display: inline-block;\n}\n.carousel-indicators[_ngcontent-%COMP%] {\n  margin-left: -386px;\n}\n.nav-tabs[_ngcontent-%COMP%], .nav-pills[_ngcontent-%COMP%] {\n  margin-bottom: 10px;\n  margin-right: -99px;\n}\nheader[_ngcontent-%COMP%]   div.logo[_ngcontent-%COMP%] {\n  display: table;\n  position: absolute;\n  height: 90px;\n  \n  margin-top: 15px;\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-indicators[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  background-color: #666;\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-indicators[_ngcontent-%COMP%]   li.active[_ngcontent-%COMP%] {\n  background-color: #333;\n}\n.login[_ngcontent-%COMP%] {\n  background-color: none;\n  background-image: none;\n  background-size: none;\n}\n#mu-abtus-counter[_ngcontent-%COMP%] {\n  background: #6ab2e7;\n  \n  background-size: 100%;\n  display: inline;\n  float: left;\n  padding: 20px 0;\n  width: 100%;\n}\n#mu-service[_ngcontent-%COMP%] {\n  display: inline;\n  float: left;\n  margin-top: 0px;\n  width: 100%;\n}\n#mu-latest-courses[_ngcontent-%COMP%] {\n  background-color: #333;\n  display: inline;\n  float: left !important;\n  padding: 10px 0;\n  margin-top: 20px;\n  width: 100%;\n}\n#mu-footer[_ngcontent-%COMP%]   .mu-footer-bottom[_ngcontent-%COMP%] {\n  background-color: #192c54;\n  display: inline;\n  float: left;\n  padding: 25px 0;\n  width: 100%;\n}\n.ng-image-slider[_ngcontent-%COMP%] {\n  width: 81% !important;\n}\n.mu-latest-course-single[_ngcontent-%COMP%] {\n  width: 74% !important\n}\n\n.row.fw-row[_ngcontent-%COMP%]   .v-box-wrap[_ngcontent-%COMP%]   .v-box-inner[_ngcontent-%COMP%] {\n  padding: 12%;\n}\n.row.fw-row[_ngcontent-%COMP%]   .v-box-wrap[_ngcontent-%COMP%]   .v-box-inner.no-padding[_ngcontent-%COMP%] {\n  padding: 0%;\n}\n.row.fw-row[_ngcontent-%COMP%]   .v-box-wrap[_ngcontent-%COMP%]   .col-sm-6[_ngcontent-%COMP%] {\n  padding-left: 0px;\n  padding-right: 0px;\n}\n\n.ui-widget-content[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #333333;\n}\n.ui-widget-content[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  color: #1dc6df;\n}\n\n@media (min-width: 1200px) {\n  .container[_ngcontent-%COMP%] {\n    width: 1100px;\n  }\n}\n@media only screen and (min-width: 1250px) {\n  body.boxed-layout[_ngcontent-%COMP%] {\n    width: 1140px;\n  }\n\n  body.boxed-layout[_ngcontent-%COMP%]   header[_ngcontent-%COMP%] {\n    max-width: 1140px;\n  }\n}\n.v-container[_ngcontent-%COMP%] {\n  padding-top: 70px !important;\n  padding-bottom: 70px !important;\n}\n.v-container-2x[_ngcontent-%COMP%] {\n  padding-top: 100px !important;\n  padding-bottom: 100px !important;\n}\n\n\n\n@font-face {\n  font-family: 'source_sans_probold';\n  src: url('sourcesanspro-bold-webfont.eot');\n  src: url('sourcesanspro-bold-webfont.eot?#iefix') format('embedded-opentype'), url('sourcesanspro-bold-webfont.woff') format('woff'), url('sourcesanspro-bold-webfont.ttf') format('truetype'), url('sourcesanspro-bold-webfont.svg#source_sans_probold') format('svg');\n  font-weight: normal;\n  font-style: normal;\n}\n@font-face {\n  font-family: 'Museo500Regular';\n  src: url('Museo500-Regular-webfont.eot');\n  src: url('Museo500-Regular-webfont.eot?#iefix') format('embedded-opentype'), url('Museo500-Regular-webfont.woff') format('woff'), url('Museo500-Regular-webfont.ttf') format('truetype'), url('Museo500-Regular-webfont.svg#Museo300Regular') format('svg');\n  font-weight: normal;\n  font-style: normal;\n}\n@font-face {\n  font-family: 'MuseoSlab500Regular';\n  src: url('Museo_Slab_300-webfont.eot');\n  src: url('Museo_Slab_300-webfont.eot?#iefix') format('embedded-opentype'), url('Museo_Slab_300-webfont.woff') format('woff'), url('Museo_Slab_300-webfont.ttf') format('truetype'), url('Museo_Slab_300-webfont.svg#Museo300Regular') format('svg');\n  font-weight: normal;\n  font-style: normal;\n}\n@font-face {\n  font-family: entypo-fontello;\n  src: url('entypo-fontello.eot'), url('entypo-fontello.woff');\n}\nbody[_ngcontent-%COMP%] {\n  color: #555;\n  font-size: 13px;\n  line-height: 22px;\n  font-family: 'Open Sans';\n}\nh1[_ngcontent-%COMP%], h2[_ngcontent-%COMP%], h3[_ngcontent-%COMP%], h4[_ngcontent-%COMP%], h5[_ngcontent-%COMP%], .custom-caption[_ngcontent-%COMP%]   p[_ngcontent-%COMP%], span.dropcap1[_ngcontent-%COMP%], span.dropcap2[_ngcontent-%COMP%], span.dropcap3[_ngcontent-%COMP%], span.dropcap4[_ngcontent-%COMP%], .v-call-text[_ngcontent-%COMP%], .smash-text[_ngcontent-%COMP%], .v-smash-text-large[_ngcontent-%COMP%], .testimonial-text[_ngcontent-%COMP%], .header-advert[_ngcontent-%COMP%], .v-icon-character[_ngcontent-%COMP%], .v-fancy-heading[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-family: \"Museo500Regular\", Arial, Helvetica, Tahoma, sans-serif;\n}\nh6[_ngcontent-%COMP%], .v-counter[_ngcontent-%COMP%]   h6.v-counter-text[_ngcontent-%COMP%], .progress-bar-wrap[_ngcontent-%COMP%]   .bar-text[_ngcontent-%COMP%] > span.progress-value[_ngcontent-%COMP%], table.v-table[_ngcontent-%COMP%]   th[_ngcontent-%COMP%], .team-member[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], .read-more-button[_ngcontent-%COMP%], .v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   span.current[_ngcontent-%COMP%], .twitter-link[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .comment-meta[_ngcontent-%COMP%]   .comment-author[_ngcontent-%COMP%] {\n  font-family: \"source_sans_probold\", Arial, Helvetica, Tahoma, sans-serif;\n  letter-spacing: 1.5px;\n  font-weight: normal !important;\n}\n.lo[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  color: #ff0157;\n  font-size: 2em;\n  font-family: 'Homemade Apple', cursive;\n}\nspan#gou[_ngcontent-%COMP%] {\n  color: #2ecc71;\n  font-size: 15px;\n}\n.lo[_ngcontent-%COMP%] {\n  color: #557cc4;\n  font-size: 2.876em;\n  font-family: Arial, Helvetica, sans-serif;\n  font-weight: 400;\n}\n\n.padding-100[_ngcontent-%COMP%] {\n  padding-bottom: 100px !important;\n  padding-top: 100px !important;\n}\n.padding-90[_ngcontent-%COMP%] {\n  padding-bottom: 90px !important;\n  padding-top: 90px !important;\n}\n.padding-80[_ngcontent-%COMP%] {\n  padding-bottom: 80px !important;\n  padding-top: 80px !important;\n}\n.padding-70[_ngcontent-%COMP%] {\n  padding-bottom: 70px !important;\n  padding-top: 70px !important;\n}\n.padding-60[_ngcontent-%COMP%] {\n  padding-bottom: 60px !important;\n  padding-top: 60px !important;\n}\n.padding-50[_ngcontent-%COMP%] {\n  padding-bottom: 50px !important;\n  padding-top: 50px !important;\n}\n.padding-40[_ngcontent-%COMP%] {\n  padding-bottom: 40px !important;\n  padding-top: 40px !important;\n}\n.padding-30[_ngcontent-%COMP%] {\n  padding-bottom: 30px !important;\n  padding-top: 30px !important;\n}\n.no-bottom-padding[_ngcontent-%COMP%] {\n  padding-bottom: 0px !important;\n}\n.no-top-padding[_ngcontent-%COMP%] {\n  padding-top: 0 !important;\n}\n.no-margin[_ngcontent-%COMP%] {\n  margin: 0 !important;\n}\n.no-margin-bottom[_ngcontent-%COMP%] {\n  margin-bottom: 0 !important;\n}\n.no-margin-top[_ngcontent-%COMP%] {\n  margin-top: 0 !important;\n}\n.no-margin-left[_ngcontent-%COMP%] {\n  margin-left: 0 !important;\n}\n.no-margin-right[_ngcontent-%COMP%] {\n  margin-right: 0 !important;\n}\n.pull-bottom[_ngcontent-%COMP%] {\n  margin-bottom: 35px;\n}\n.pull-bottom-small[_ngcontent-%COMP%] {\n  margin-bottom: 20px;\n}\n.pull-bottom-big[_ngcontent-%COMP%] {\n  margin-bottom: 45px;\n}\n.pull-top-small[_ngcontent-%COMP%] {\n  margin-top: 20px;\n}\n.pull-top[_ngcontent-%COMP%] {\n  margin-top: 35px;\n}\n.pull-top-big[_ngcontent-%COMP%] {\n  margin-top: 50px;\n}\n.v-height-mini[_ngcontent-%COMP%] {\n  height: 15px !important;\n}\n.v-height-small[_ngcontent-%COMP%] {\n  height: 30px !important;\n}\n.v-height-standard[_ngcontent-%COMP%] {\n  height: 50px !important;\n}\n.v-height-big[_ngcontent-%COMP%] {\n  height: 75px !important;\n}\n.v-lead[_ngcontent-%COMP%] {\n  font-size: 14px;\n  line-height: 24px;\n}\ndiv.center[_ngcontent-%COMP%] {\n  text-align: center !important;\n}\n[_ngcontent-%COMP%]::-moz-selection {\n  background-color: #25CBF5;\n  color: #fff;\n}\n[_ngcontent-%COMP%]::selection, [_ngcontent-%COMP%]::-moz-selection {\n  background-color: #25CBF5;\n  color: #fff;\n}\nbody.modal-open[_ngcontent-%COMP%] {\n  margin-right: 0;\n}\nlabel[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-size: 13px;\n  line-height: 22px;\n  font-family: 'Open Sans';\n}\n.img[_ngcontent-%COMP%] {\n  border-radius: 10px;\n  float: right;\n}\na[_ngcontent-%COMP%] {\n  outline: none !important;\n  transition: all 0.2s ease-in-out;\n  text-decoration: none !important;\n  color: #333333;\n}\na[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n  color: #25CBF5;\n}\na[_ngcontent-%COMP%]:active {\n  outline: none;\n}\na[_ngcontent-%COMP%]:focus {\n  -moz-outline-style: none;\n  outline-style: none;\n  outline: none;\n  text-decoration: none;\n}\nh1[_ngcontent-%COMP%] {\n  font-size: 24px;\n  line-height: 34px;\n  color: #333333;\n}\nh2[_ngcontent-%COMP%] {\n  font-size: 20px;\n  line-height: 30px;\n}\nh3[_ngcontent-%COMP%] {\n  font-size: 18px;\n  line-height: 24px;\n  font-weight: normal;\n  margin-bottom: 15px;\n}\nh4[_ngcontent-%COMP%] {\n  font-size: 16px;\n  line-height: 20px;\n  font-weight: normal;\n  margin-bottom: 15px;\n}\nh5[_ngcontent-%COMP%] {\n  font-size: 14px;\n  line-height: 18px;\n  font-weight: normal;\n  margin-bottom: 15px;\n}\nh6[_ngcontent-%COMP%] {\n  font-size: 12px;\n  font-weight: bold;\n  line-height: 16px;\n  margin-bottom: 10px;\n  text-transform: uppercase;\n}\nh6.special[_ngcontent-%COMP%] {\n  font-family: source_sans_probold, Arial, Helvetica, Tahoma, sans-serif;\n  font-weight: 400 !important;\n  font-size: 14px;\n  letter-spacing: 1px;\n  text-transform: uppercase;\n  color: #323436;\n  margin-bottom: 15px;\n}\nh1[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #333333;\n}\nh2[_ngcontent-%COMP%], h2[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #333333;\n}\nh3[_ngcontent-%COMP%], h3[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #333333;\n}\nh4[_ngcontent-%COMP%], h4[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #333333;\n}\nh5[_ngcontent-%COMP%], h5[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #333333;\n}\nh6[_ngcontent-%COMP%], h6[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #333333;\n}\np[_ngcontent-%COMP%] {\n  margin: 0 0 15px;\n  font-size: 13px;\n  line-height: 22px;\n  font-family: 'Open Sans';\n}\nul[_ngcontent-%COMP%] {\n  list-style: none;\n  margin: 0 0 20px;\n  padding: 0;\n}\nol[_ngcontent-%COMP%] {\n  margin: 0 0 20px;\n  padding: 0 0 0 20px;\n}\nul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > ul[_ngcontent-%COMP%], ol[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > ol[_ngcontent-%COMP%] {\n  margin-left: 20px;\n  padding-left: 0;\n}\ndl[_ngcontent-%COMP%]   dt[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\ndl[_ngcontent-%COMP%]   dd[_ngcontent-%COMP%] {\n  margin-bottom: 20px;\n}\ndl[_ngcontent-%COMP%]   dt[_ngcontent-%COMP%], dl[_ngcontent-%COMP%]   dd[_ngcontent-%COMP%] {\n  line-height: 180%;\n}\nul[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], ul[_ngcontent-%COMP%]   ol[_ngcontent-%COMP%], ol[_ngcontent-%COMP%]   ol[_ngcontent-%COMP%], ol[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  margin-left: 0;\n}\na.text-link[_ngcontent-%COMP%] {\n  border-bottom: 1px dotted #e3e3e3;\n  border-color: #25CBF5;\n}\n.no-js-alert[_ngcontent-%COMP%] {\n  background: none repeat scroll 0 0 #222222;\n  color: #FFFFFF;\n  font-size: 24px;\n  height: 100%;\n  left: 0;\n  -moz-opacity: 0.9;\n  opacity: 0.9;\n  filter: alpha(opacity=90);\n  padding: 20% 5% 0;\n  position: fixed;\n  text-align: center;\n  top: 0;\n  width: 90%;\n  z-index: 9999;\n  backface-visibility: hidden;\n  transform: translate3d(0, 0, 0);\n}\n.clearfix[_ngcontent-%COMP%] {\n  clear: none !important;\n}\n#container[_ngcontent-%COMP%] {\n  position: relative;\n  background: white;\n  width: 100%;\n  \n}\n.img-container[_ngcontent-%COMP%] {\n  position: relative;\n  white-space: nowrap;\n\n}\n.image[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 720px;\n  display: block;\n  -o-object-fit: cover;\n     object-fit: cover;\n}\n.text[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 40%;\n  left: 40%;\n\n}\n#img-head[_ngcontent-%COMP%] {\n  font-size: 42px;\n  line-height: 44px;\n  opacity: 1;\n  color: rgb(255, 255, 255);\n  letter-spacing: 1px;\n  text-shadow: rgba(0, 0, 0, 0.15) 2px;\n  background-color: transparent;\n  font-family: 'Raleway' sans-serif;\n\n\n\n}\n#img-p[_ngcontent-%COMP%]{\n  font-size: 22px;\n  line-height: 30px;\n  opacity: 1;\n  color: rgb(255, 255, 255);\n  font-weight: 400;\n  letter-spacing: 1px;\n  text-shadow: rgba(0, 0, 0, 0.15) 2px;\n  background-color: transparent;\n  font-family: 'Raleway';\n\n}\n.no-csstransforms3d[_ngcontent-%COMP%]   #container[_ngcontent-%COMP%] {\n  transition: all 0.3s ease-in-out;\n  transform-style: flat;\n  position: inherit;\n}\niframe[_ngcontent-%COMP%] {\n  border: 0;\n}\nvideo.wp-video-shortcode[_ngcontent-%COMP%] {\n  max-width: 100%;\n}\ntable[_ngcontent-%COMP%] {\n  border-collapse: collapse;\n  border-spacing: 0;\n  font-size: 14px;\n  line-height: 2;\n}\ntable[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\ntable[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  text-transform: uppercase;\n}\ntable[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%] > th[_ngcontent-%COMP%] {\n  padding-right: 20px;\n}\ntable[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n  padding: 5px 10px 5px 0;\n}\naddress[_ngcontent-%COMP%] {\n  font-style: italic;\n  margin: 0 0 24px;\n}\nimg[_ngcontent-%COMP%] {\n  max-width: 100%;\n  height: auto;\n}\nins[_ngcontent-%COMP%] {\n  background: #fff9c0;\n  text-decoration: none;\n}\n.g[_ngcontent-%COMP%] {\n  height: 250px;\n}\npre[_ngcontent-%COMP%] {\n  background: #f5f5f5;\n  color: #666;\n  font-family: monospace;\n  font-size: 14px;\n  margin: 20px 0;\n  overflow: auto;\n  padding: 20px;\n  white-space: pre;\n  white-space: pre-wrap;\n  -ms-word-wrap: break-word;\n  word-wrap: break-word;\n  border: 1px solid #E4E4E4;\n  border-radius: 2px;\n}\naudio[_ngcontent-%COMP%] {\n  margin: 20px 0;\n}\n.v-spacer[_ngcontent-%COMP%] {\n  min-height: 0;\n}\n.chat-transcript[_ngcontent-%COMP%]   .chat-author[_ngcontent-%COMP%] {\n  font-weight: bold;\n}\n.nicescroll-rails[_ngcontent-%COMP%] {\n  background: #fff;\n  width: 5px !important;\n}\n.nicescroll-rails[_ngcontent-%COMP%] > div[_ngcontent-%COMP%] {\n  width: 5px !important;\n  border: 0 !important;\n  background: #666 !important;\n  border-radius: 6px !important;\n}\n.fw-row[_ngcontent-%COMP%] {\n  margin-left: 0;\n  margin-right: 0;\n}\n.row.fw-row[_ngcontent-%COMP%]   .coloured-box-wrap[_ngcontent-%COMP%]   .col-sm-2[_ngcontent-%COMP%], .row.fw-row[_ngcontent-%COMP%]   .coloured-box-wrap[_ngcontent-%COMP%]   .col-sm-3[_ngcontent-%COMP%], .row.fw-row[_ngcontent-%COMP%]   .coloured-box-wrap[_ngcontent-%COMP%]   .col-sm-4[_ngcontent-%COMP%] {\n  padding-left: 0px;\n  padding-right: 0px;\n}\n.row.fw-row[_ngcontent-%COMP%]   .coloured-box-wrap[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  margin-top: 10px;\n}\n.row.fw-row[_ngcontent-%COMP%]   .coloured-box-wrap[_ngcontent-%COMP%]   .coloured-box-inner[_ngcontent-%COMP%] {\n  padding: 12%;\n  color: #ffffff;\n}\n.single[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]   .body-text[_ngcontent-%COMP%] > .container[_ngcontent-%COMP%] {\n  margin-left: -15px;\n  max-width: 100%;\n}\n.modal-body[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%] {\n  max-width: 100%;\n}\n.white-color[_ngcontent-%COMP%] {\n  color: white !important;\n}\ndiv.white-color[_ngcontent-%COMP%] {\n  color: white !important;\n}\n.v-color[_ngcontent-%COMP%], div.v-color[_ngcontent-%COMP%] {\n  color: #25CBF5;\n}\n.v-link[_ngcontent-%COMP%] {\n  color: #25CBF5;\n}\n.v-link[_ngcontent-%COMP%]:hover {\n  border-bottom: 1px dotted #25CBF5;\n}\n.v-bg-color[_ngcontent-%COMP%] {\n  background-color: #f7f7f7 !important;\n}\n\nfigure[_ngcontent-%COMP%] {\n  margin: 0;\n}\nfigure[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n  height: auto;\n}\nfigure[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  display: block;\n}\nfigure[_ngcontent-%COMP%]   .overlay[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  display: block;\n  z-index: 3;\n  -moz-opacity: 0;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  transition: all 0.3s ease-in-out;\n  margin-left: -0.6px;\n  padding-right: 0.6px;\n}\nfigure[_ngcontent-%COMP%]:hover > a[_ngcontent-%COMP%] > .overlay[_ngcontent-%COMP%] {\n  -moz-opacity: 0.9;\n  opacity: 0.9;\n  filter: alpha(opacity=90);\n  margin-top: -1.6px;\n  padding-bottom: 1.6px;\n}\nfigure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%] {\n  background-color: rgba(29, 198, 223, 0.90);\n}\nfigure.animated-overlay.transparent[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%] {\n  background-color: transparent;\n}\nfigure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%], figure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%], figcaption[_ngcontent-%COMP%]   .thumb-info-excerpt[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: #ffffff;\n}\nfigure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  background: #222222;\n  color: #ffffff;\n  cursor: pointer !important;\n  transform: scale(0.5) rotate(-90deg);\n  transition-duration: 0.3s;\n}\nfigure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   i.fa-angle-right[_ngcontent-%COMP%]:before {\n  content: '\\E832';\n  font-family: 'entypo-fontello';\n}\n@keyframes rotate {\n  0% {\n    transform: rotate(0deg);\n  }\n\n  100% {\n    transform: rotate(-360deg);\n  }\n}\nfigure[_ngcontent-%COMP%]:hover   .overlay[_ngcontent-%COMP%] {\n  box-shadow: inset 0 0 0 500px #25CBF5;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%] {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  backface-visibility: hidden;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  line-height: 20px;\n  padding: 0 5%;\n  width: 100%;\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  overflow: hidden;\n  text-align: center;\n  -moz-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  -webkit-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  position: absolute;\n  bottom: 25px;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info-extended[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  margin-top: -60px;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info-extended[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%] {\n  padding: 0 5%;\n  width: 100%;\n  position: absolute;\n  bottom: 5px;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  -moz-opacity: 1;\n  opacity: 1;\n  filter: alpha(opacity=100);\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 18px;\n  line-height: 24px;\n  padding: 14px;\n  border-radius: 50%;\n  height: 24px;\n  width: 24px;\n  display: block;\n  -moz-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  -webkit-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  text-align: center;\n  -ms-box-sizing: content-box;\n  box-sizing: content-box;\n  position: absolute;\n  left: 50%;\n  top: 47%;\n  margin: -24px 0 0 -24px;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info-v2[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 18px;\n  line-height: 30px;\n  padding: 10px;\n  border-radius: 50%;\n  height: 30px;\n  width: 30px;\n  top: 50%;\n  margin-top: -25px;\n  margin-left: -25px;\n  left: 50%;\n  position: absolute;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info-excerpt[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  line-height: 20px;\n  margin-bottom: 0;\n  padding: 0 5%;\n  width: 100%;\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  overflow: hidden;\n  text-align: center;\n  -moz-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  -webkit-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  position: absolute;\n  top: 40%;\n  margin-top: -40px;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info-excerpt[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  line-height: 22px;\n  margin-bottom: 0;\n  padding: 0 5%;\n  width: 100%;\n  text-align: center;\n  -moz-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  -webkit-text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  text-shadow: 0 0 5px rgba(0, 0, 0, .2);\n  position: absolute;\n  top: 40%;\n  margin-top: 0;\n}\nfigcaption[_ngcontent-%COMP%]   .thumb-info-excerpt[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  display: none;\n}\nfigure.animated-overlay[_ngcontent-%COMP%] {\n  position: relative;\n  overflow: visible;\n  z-index: 2;\n}\nfigure.animated-overlay[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 4;\n}\nfigure.animated-overlay[_ngcontent-%COMP%]   .thumb-slider[_ngcontent-%COMP%]   ul.slides[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 2;\n}\nfigure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  display: block;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  text-align: center;\n  position: absolute;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  background-image: url('crease.svg');\n  background-size: cover;\n  background-position: center center;\n  backface-visibility: hidden;\n  transition: transform 0.3s, opacity 0.3s;\n}\n.browser-ie[_ngcontent-%COMP%]   figure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%], .browser-ie10[_ngcontent-%COMP%]   figure.animated-overlay[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%] {\n  background-image: none;\n}\nfigure.animated-overlay[_ngcontent-%COMP%]:hover   figcaption[_ngcontent-%COMP%] {\n  opacity: 1;\n  filter: alpha(opacity=100);\n  \n}\nfigure.animated-overlay.overlay-alt[_ngcontent-%COMP%]:hover   figcaption[_ngcontent-%COMP%] {\n  transform: translate(0, 0);\n}\n.curved-bar-styling[_ngcontent-%COMP%] {\n  border: 1px solid #e4e4e4;\n  border-radius: 4px;\n  -moz-background-clip: padding;\n  -webkit-background-clip: padding-box;\n  background-clip: padding-box;\n}\nul.bar-styling[_ngcontent-%COMP%] {\n  height: auto;\n  overflow: hidden;\n}\nul.page-numbers[_ngcontent-%COMP%] {\n  float: right;\n}\nul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  float: left;\n  display: block;\n}\nul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > div[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > span[_ngcontent-%COMP%] {\n  padding: 8px 15px;\n  border: 1px solid transparent;\n  display: block;\n  margin-right: -1px;\n  text-decoration: none;\n  height: auto;\n  overflow: hidden;\n}\nul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  border: 1px solid transparent;\n  display: block;\n  margin-right: -1px;\n  overflow: hidden;\n  padding: 10px 14px;\n  height: 40px;\n  font-size: 14px;\n  border-radius: 0;\n}\nul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child   a[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child   div[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child   a[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child   span[_ngcontent-%COMP%] {\n  -moz-border-radius-topleft: 4px;\n  -moz-border-radius-bottomleft: 4px;\n  -webkit-border-top-left-radius: 4px;\n  -webkit-border-bottom-left-radius: 4px;\n  border-top-left-radius: 4px;\n  border-bottom-left-radius: 4px;\n  -moz-background-clip: padding;\n  -webkit-background-clip: padding-box;\n  background-clip: padding-box;\n}\nul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:last-child   a[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:last-child   div[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:last-child   a[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:last-child   span[_ngcontent-%COMP%] {\n  -moz-border-radius-topright: 4px;\n  -moz-border-radius-bottomright: 4px;\n  -webkit-border-top-right-radius: 4px;\n  -webkit-border-bottom-right-radius: 4px;\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\nul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a.prev[_ngcontent-%COMP%]   i[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a.next[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  height: 10px;\n  display: inline-block;\n  vertical-align: -3px;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:not(.selected) > a[_ngcontent-%COMP%]:hover, ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > .comments-likes[_ngcontent-%COMP%]:hover, ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover, ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > span.current[_ngcontent-%COMP%] {\n  color: #ffffff !important;\n  background: #25CBF5;\n  border-color: #25CBF5;\n}\nul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > .comments-likes[_ngcontent-%COMP%]:hover   *[_ngcontent-%COMP%] {\n  color: #ffffff !important;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], .v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   span.expand[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > div[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], ul.page-numbers[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > span[_ngcontent-%COMP%], .curved-bar-styling[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  border-color: #e4e4e4;\n}\nul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > span[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > div[_ngcontent-%COMP%], ul.bar-styling[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  background-color: #ffffff;\n}\nul.bar-styling[_ngcontent-%COMP%]   li.facebook[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  color: #fff !important;\n  background: #3b5998;\n  border-color: #3b5998;\n}\nul.bar-styling[_ngcontent-%COMP%]   li.twitter[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  color: #fff !important;\n  background: #4099FF;\n  border-color: #4099FF;\n}\nul.bar-styling[_ngcontent-%COMP%]   li.google-plus[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  color: #fff !important;\n  background: #d34836;\n  border-color: #d34836;\n}\nul.bar-styling[_ngcontent-%COMP%]   li.pinterest[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  color: #fff !important;\n  background: #cb2027;\n  border-color: #cb2027;\n}\n.modal-header[_ngcontent-%COMP%] {\n  padding: 22px 30px;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  background: #f7f7f7;\n}\n.modal-header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%], .modal-header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  margin: 0;\n}\n.modal-header[_ngcontent-%COMP%]   .close[_ngcontent-%COMP%] {\n  margin-top: 2px;\n  outline: none !important;\n}\n.modal-body[_ngcontent-%COMP%] {\n  padding: 20px 30px;\n}\n.viewer[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  transition: width 500ms cubic-bezier(0.075, 0.820, 0.165, 1.000);\n}\n.viewer[_ngcontent-%COMP%]   .caption[_ngcontent-%COMP%] {\n  visibility: hidden;\n  opacity: 0;\n  transition: opacity 1.5s ease-in-out;\n}\n.viewer[_ngcontent-%COMP%]   .current[_ngcontent-%COMP%]   .caption[_ngcontent-%COMP%] {\n  opacity: 100;\n  visibility: visible;\n}\n.viewer[_ngcontent-%COMP%]   .close[_ngcontent-%COMP%]:hover {\n  color: #fff;\n}\n\n.grid[_ngcontent-%COMP%] {\n  list-style: none;\n}\n.grid[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  display: block;\n  float: left;\n  opacity: 0;\n}\n.grid[_ngcontent-%COMP%] > li.shown[_ngcontent-%COMP%], .no-js[_ngcontent-%COMP%]   .grid[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .no-cssanimations[_ngcontent-%COMP%]   .grid[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .grid.no-effect[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n\n.grid.effect-1[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  animation: fadeIn 0.65s ease forwards;\n}\n\n.grid.effect-2[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  transform: translateY(200px);\n  animation: moveUp 0.65s ease forwards;\n}\n\n.grid.effect-3[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  transform: scale(0.6);\n  animation: scaleUp 0.65s ease-in-out forwards;\n}\n\n.grid.effect-4[_ngcontent-%COMP%] {\n  -ms-perspective: 1300px;\n  perspective: 1300px;\n}\n.grid.effect-4[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  transform-style: preserve-3d;\n  transform: translateY(300px) rotateX(-90deg);\n  animation: fallPerspective .8s ease-in-out forwards;\n}\n\n.grid.effect-5[_ngcontent-%COMP%] {\n  -ms-perspective: 1300px;\n  perspective: 1300px;\n}\n.grid.effect-5[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  transform-style: preserve-3d;\n  transform-origin: 50% 50%;\n  transform: rotateX(-180deg);\n  animation: fly .8s ease-in-out forwards;\n}\n\n.grid.effect-6[_ngcontent-%COMP%] {\n  -ms-perspective: 1300px;\n  perspective: 1300px;\n}\n.grid.effect-6[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  transform-style: preserve-3d;\n  transform-origin: 0% 0%;\n  transform: rotateX(-80deg);\n  animation: flip .8s ease-in-out forwards;\n}\n\n.grid.effect-7[_ngcontent-%COMP%] {\n  -ms-perspective: 1300px;\n  perspective: 1300px;\n}\n.grid.effect-7[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  transform-style: preserve-3d;\n  transform: rotateY(-180deg);\n  animation: helix .8s ease-in-out forwards;\n}\n\n.grid.effect-8[_ngcontent-%COMP%] {\n  -ms-perspective: 1300px;\n  perspective: 1300px;\n}\n.grid.effect-8[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\n  transform-style: preserve-3d;\n  transform: scale(0.4);\n  animation: popUp .8s ease-in forwards;\n}\n\n.flexslider[_ngcontent-%COMP%] {\n  background: transparent;\n  border: 0;\n  width: 100%;\n  z-index: 2;\n  display: block;\n  position: relative;\n  overflow: hidden;\n}\n.flexslider[_ngcontent-%COMP%]   ul.slides[_ngcontent-%COMP%] {\n  background: transparent;\n  margin: 0;\n  height: auto;\n  overflow: hidden;\n  list-style: none !important;\n}\n.flexslider[_ngcontent-%COMP%]   .slides[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  position: relative;\n  text-align: center;\n  overflow: hidden;\n  margin: 0;\n  display: none;\n  backface-visibility: hidden;\n}\n.flexslider[_ngcontent-%COMP%]   .slides[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  max-width: 100%;\n  width: 100%;\n  height: auto;\n  display: block !important;\n}\n.flex-direction-nav[_ngcontent-%COMP%], .flex-direction-nav[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  margin: 0;\n  padding: 0;\n  list-style: none;\n}\n.flex-direction-nav[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .carousel-wrap[_ngcontent-%COMP%]   a.next[_ngcontent-%COMP%], .carousel-wrap[_ngcontent-%COMP%]   a.prev[_ngcontent-%COMP%] {\n  width: 38px;\n  height: 38px;\n  margin: -19px 0 0;\n  display: block;\n  background: transparent url('showcase-nav.png') no-repeat center left;\n  position: absolute;\n  top: 50%;\n  cursor: pointer;\n  text-indent: -9999px;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  transition: all 0.3s ease-in-out;\n  z-index: 3;\n}\n.flex-direction-nav[_ngcontent-%COMP%]   .flex-next[_ngcontent-%COMP%] {\n  background-position: center right;\n  right: -36px;\n}\n.flex-direction-nav[_ngcontent-%COMP%]   .flex-prev[_ngcontent-%COMP%] {\n  left: -36px;\n}\n\n.carousel-wrap[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\n  color: #333333;\n}\n.carousel-wrap[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  color: #25CBF5 !important;\n}\n.carousel-wrap[_ngcontent-%COMP%]   a.prev[_ngcontent-%COMP%] {\n  left: -10px;\n  transition: all 0.3s ease-in-out;\n  -moz-opacity: 0;\n  opacity: 0;\n  filter: alpha(opacity=0);\n}\n.carousel-wrap[_ngcontent-%COMP%]   a.next[_ngcontent-%COMP%] {\n  right: -10px;\n  transition: all 0.3s ease-in-out;\n  -moz-opacity: 0;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  background-position: center right;\n}\n.carousel-wrap[_ngcontent-%COMP%]:hover   a.next[_ngcontent-%COMP%], .carousel-wrap[_ngcontent-%COMP%]:hover   a.prev[_ngcontent-%COMP%] {\n  -moz-opacity: 1;\n  opacity: 1;\n  filter: alpha(opacity=100);\n}\n.flex-direction-nav[_ngcontent-%COMP%]   .flex-disabled[_ngcontent-%COMP%] {\n  opacity: 0 !important;\n  filter: alpha(opacity=0) !important;\n  pointer-events: none;\n}\n.carousel-wrap[_ngcontent-%COMP%] {\n  position: relative;\n  margin-right: -11px;\n  margin-left: -11px;\n}\n.content-slider[_ngcontent-%COMP%] {\n  position: static;\n}\n.content-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   .flex-next[_ngcontent-%COMP%] {\n  right: 20px !important;\n}\n.content-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   .flex-prev[_ngcontent-%COMP%] {\n  left: 20px !important;\n}\n.flexslider[_ngcontent-%COMP%]:hover   .flex-next[_ngcontent-%COMP%] {\n  opacity: 1;\n  filter: alpha(opacity=100);\n  right: 20px !important;\n}\n.flexslider[_ngcontent-%COMP%]:hover   .flex-prev[_ngcontent-%COMP%] {\n  opacity: 1;\n  filter: alpha(opacity=100);\n  left: 20px !important;\n}\n.tp-caption[_ngcontent-%COMP%]   a.btn.v-btn[_ngcontent-%COMP%] {\n  \n  margin-right: 0;\n}\n.flex-direction-nav[_ngcontent-%COMP%]   .disabled[_ngcontent-%COMP%] {\n  opacity: .3 !important;\n  filter: alpha(opacity=30);\n  cursor: default;\n}\n.thumb-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%] {\n  height: 100%;\n  position: absolute;\n  top: 0;\n  width: 100%;\n}\n.thumb-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  position: relative !important;\n  left: auto !important;\n  top: 50% !important;\n}\n.thumb-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  height: 38px;\n  width: 36px;\n  background: transparent url('slider-nav.png') no-repeat center left;\n}\n.thumb-slider[_ngcontent-%COMP%]   .flex-prev[_ngcontent-%COMP%], .thumb-slider[_ngcontent-%COMP%]:hover   .flex-prev[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]   .flex-prev[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]:hover   .flex-prev[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]   .flex-prev[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]:hover   .flex-prev[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]   .flex-prev[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]:hover   .flex-prev[_ngcontent-%COMP%] {\n  left: 0 !important;\n}\n.thumb-slider[_ngcontent-%COMP%]   .flex-next[_ngcontent-%COMP%], .thumb-slider[_ngcontent-%COMP%]:hover   .flex-next[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]   .flex-next[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]:hover   .flex-next[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]   .flex-next[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]:hover   .flex-next[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]   .flex-next[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]:hover   .flex-next[_ngcontent-%COMP%] {\n  right: 0 !important;\n}\n.thumb-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%] {\n  background-position: center right;\n}\n.thumb-slider[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-prev[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-prev[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-prev[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-prev[_ngcontent-%COMP%] {\n  -moz-opacity: 0.8;\n  opacity: 0.8;\n  filter: alpha(opacity=80);\n}\n.thumb-slider[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%], .gallery-slider[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%], .gallery-nav[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%], .item-slider[_ngcontent-%COMP%]:hover   .flex-direction-nav[_ngcontent-%COMP%]   a.flex-next[_ngcontent-%COMP%] {\n  -moz-opacity: 0.8;\n  opacity: 0.8;\n  filter: alpha(opacity=80);\n}\n.flex-control-nav[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 20px;\n  margin: 0;\n  z-index: 4;\n  list-style: none !important;\n  text-align: center;\n  width: 100%;\n}\n.flex-control-nav[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  display: inline-block;\n  margin-right: 5px;\n  margin-bottom: 0;\n}\n.flexslider[_ngcontent-%COMP%]   .flexslider-caption[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 0px;\n  z-index: 10;\n  padding-top: 12px;\n  padding-bottom: 12px;\n  color: #fff;\n  text-align: center;\n  text-shadow: 0 1px 2px rgba(0, 0, 0, .6);\n  background: rgba(0, 0, 0, 0.6);\n  left: 0%;\n  right: 0%;\n}\n.flex-control-nav[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #FFF;\n}\n.flex-control-nav[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  cursor: pointer;\n}\n.flex-control-nav[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a.flex-active[_ngcontent-%COMP%] {\n  -moz-opacity: 1;\n  opacity: 1;\n  filter: alpha(opacity=100);\n}\n.flex-pauseplay[_ngcontent-%COMP%] {\n  position: absolute;\n  color: #fff;\n  bottom: 18px;\n  left: 20px;\n  font-size: 13px;\n  height: 13px;\n}\n.flex-pauseplay[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before {\n  font-family: FontAwesome;\n  font-weight: normal;\n  font-style: normal;\n  display: inline-block;\n  text-decoration: inherit;\n}\n.flex-pauseplay[_ngcontent-%COMP%]   .pause[_ngcontent-%COMP%]:before {\n  content: \"\\f04c\";\n}\n.flex-pauseplay[_ngcontent-%COMP%]   .play[_ngcontent-%COMP%]:before {\n  content: \"\\f04b\";\n}\n.blog-slider[_ngcontent-%COMP%]   .flex-pauseplay[_ngcontent-%COMP%], .thumb-slider[_ngcontent-%COMP%]   .flex-pauseplay[_ngcontent-%COMP%] {\n  bottom: 16px;\n  font-size: 11px;\n  height: 13px;\n}\n.flex-pauseplay[_ngcontent-%COMP%]:hover {\n  cursor: pointer;\n}\n.flex-pauseplay[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  height: 11px;\n  display: block;\n  line-height: 13px;\n}\n.thumb-slider[_ngcontent-%COMP%]   .flex-control-nav[_ngcontent-%COMP%], .thumb-slider[_ngcontent-%COMP%]   .flex-pauseplay[_ngcontent-%COMP%] {\n  display: none;\n}\np.flex-caption[_ngcontent-%COMP%] {\n  text-shadow: none;\n  background: rgba(0, 0, 0, .4);\n}\n.item-slider[_ngcontent-%COMP%]   p.flex-caption[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 0;\n  padding: 15px 25px;\n  color: #fff;\n  margin: 0;\n  font-size: 16px;\n  right: 0;\n}\n.custom-caption[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 2;\n  top: 60px;\n  left: 60px;\n  width: auto;\n  max-width: 500px;\n}\n.custom-caption[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  text-align: left;\n  width: auto;\n  font-size: 24px;\n  padding: 0px 4px 2px;\n  line-height: 28px;\n  margin-bottom: 0;\n  text-decoration: underline;\n  text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.4);\n}\n.ls-wp-fullwidth-container[_ngcontent-%COMP%] {\n  min-height: 100px;\n}\n.ls-container[_ngcontent-%COMP%]   .ls-nav-prev[_ngcontent-%COMP%], .ls-container[_ngcontent-%COMP%]   .ls-nav-next[_ngcontent-%COMP%] {\n  background-image: url('slider-nav.png') !important;\n  background-position: center left !important;\n  width: 36px !important;\n  height: 38px !important;\n  transition: all 0.3s ease-in-out !important;\n  opacity: 0;\n  filter: alpha(opacity=0);\n}\n.ls-container[_ngcontent-%COMP%]   .ls-nav-prev[_ngcontent-%COMP%] {\n  left: 0px !important;\n}\n.ls-container[_ngcontent-%COMP%]   .ls-nav-next[_ngcontent-%COMP%] {\n  background-position: center right !important;\n  right: 0px !important;\n}\n.ls-container[_ngcontent-%COMP%]:hover   .ls-nav-prev[_ngcontent-%COMP%], .ls-container[_ngcontent-%COMP%]:hover   .ls-nav-next[_ngcontent-%COMP%] {\n  opacity: 1;\n  filter: alpha(opacity=100);\n}\n.v-rev-slider[_ngcontent-%COMP%] {\n  height: 450px;\n}\n.v-rev-slider[_ngcontent-%COMP%]   .v-slider-overlay[_ngcontent-%COMP%] {\n  background-repeat: repeat;\n  background-position: center center;\n  position: absolute;\n  left: 0;\n  top: 0;\n  width: 100%;\n  height: 100%;\n  opacity: 0.8;\n  background-image: url('video-overlay-1.png');\n}\n.v-rev-slider[_ngcontent-%COMP%]   .v-slider-overlay.overlay-colored[_ngcontent-%COMP%] {\n  background-color: #6DBFEC;\n  opacity: 0.4;\n}\n.v-overlay-colored[_ngcontent-%COMP%] {\n  background-repeat: repeat;\n  background-position: center center;\n  position: absolute;\n  left: 0;\n  top: 0;\n  width: 100%;\n  height: 100%;\n  opacity: 0.8;\n}\nimg.size-full[_ngcontent-%COMP%] {\n  max-width: 100%;\n  height: auto;\n}\n.aligncenter[_ngcontent-%COMP%], div.aligncenter[_ngcontent-%COMP%] {\n  display: block;\n  margin: 5px auto 5px auto;\n}\n.alignright[_ngcontent-%COMP%] {\n  float: right;\n  margin: 5px 0 20px 20px;\n}\n.alignleft[_ngcontent-%COMP%] {\n  float: left;\n  margin: 5px 20px 20px 0;\n}\n.aligncenter[_ngcontent-%COMP%] {\n  display: block;\n  margin: 5px auto 5px auto;\n}\na[_ngcontent-%COMP%]   img.alignright[_ngcontent-%COMP%] {\n  float: right;\n  margin: 5px 0 20px 20px;\n}\na[_ngcontent-%COMP%]   img.alignleft[_ngcontent-%COMP%] {\n  float: left;\n  margin: 5px 20px 20px 0;\n}\na[_ngcontent-%COMP%]   img.aligncenter[_ngcontent-%COMP%] {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\nimg.aligncenter[_ngcontent-%COMP%], img.alignleft[_ngcontent-%COMP%], img.alignright[_ngcontent-%COMP%], img.alignnone[_ngcontent-%COMP%] {\n  max-width: 100%;\n}\n.align-left[_ngcontent-%COMP%] {\n  text-align: left;\n}\n.align-right[_ngcontent-%COMP%] {\n  text-align: right;\n}\n.no-margin[_ngcontent-%COMP%] {\n  margin: 0;\n}\n.img-link[_ngcontent-%COMP%] {\n  display: block;\n}\n\n.isotope-item[_ngcontent-%COMP%] {\n  z-index: 2;\n}\n.isotope-hidden.isotope-item[_ngcontent-%COMP%] {\n  pointer-events: none;\n  z-index: 1;\n}\n.isotope[_ngcontent-%COMP%], .isotope[_ngcontent-%COMP%]   .isotope-item[_ngcontent-%COMP%] {\n  \n  transition-duration: 0.6s;\n}\n.isotope[_ngcontent-%COMP%] {\n  transition-property: height, width;\n}\n.isotope[_ngcontent-%COMP%]   .isotope-item[_ngcontent-%COMP%] {\n  transition-property: transform, opacity;\n}\n\n.isotope.no-transition[_ngcontent-%COMP%], .isotope.no-transition[_ngcontent-%COMP%]   .isotope-item[_ngcontent-%COMP%], .isotope[_ngcontent-%COMP%]   .isotope-item.no-transition[_ngcontent-%COMP%] {\n  transition-duration: 0s;\n}\n\nbody.boxed-layout[_ngcontent-%COMP%] {\n  width: 1000px;\n  margin: 0px auto;\n  background: #F1F1F1;\n}\nbody.boxed-layout[_ngcontent-%COMP%]   #container[_ngcontent-%COMP%] {\n  box-shadow: 0 0 7px rgba(0, 0, 0, 0.15);\n}\n.bg-special[_ngcontent-%COMP%] {\n  background: none;\n  background-image: url('irongrip.png') !important;\n  background-attachment: scroll;\n  background-size: initial;\n  background-position: 50% 50%;\n  background-repeat: repeat;\n}\n#back-to-top[_ngcontent-%COMP%] {\n  border-radius: 0px;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n  -moz-background-clip: padding;\n  -webkit-background-clip: padding-box;\n  background-clip: padding-box;\n  background-color: rgba(0, 0, 0, .4);\n  box-shadow: inset 0 0 5px rgba(0, 0, 0, .1);\n  position: fixed;\n  bottom: -40px;\n  right: 20px;\n  z-index: 1000;\n  padding: 10px 15px 10px;\n  cursor: pointer;\n  transform: translate3d(0, 0, 0);\n  opacity: 0;\n  color: #fff;\n}\n#back-to-top[_ngcontent-%COMP%]:hover {\n  color: #25CBF5;\n}\n#back-to-top[_ngcontent-%COMP%]   i.fa[_ngcontent-%COMP%] {\n  font-size: 19px;\n}\n.v-page-wrap[_ngcontent-%COMP%] {\n  margin-top: 50px;\n  margin-bottom: 50px;\n  min-height: 500px;\n}\n.v-page-wrap.no-bottom-spacing[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n}\n.v-page-wrap.no-top-spacing[_ngcontent-%COMP%] {\n  margin-top: 0;\n}\naside.left-sidebar.sticky[_ngcontent-%COMP%] {\n  float: none;\n  position: fixed;\n  z-index: 6;\n  left: auto;\n  padding-top: 100px !important;\n}\naside.right-sidebar.sticky[_ngcontent-%COMP%] {\n  float: none;\n  position: fixed;\n  z-index: 6;\n  right: auto;\n  padding-top: 100px !important;\n}\n.has-left-sidebar[_ngcontent-%COMP%]   aside.sidebar[_ngcontent-%COMP%] {\n  float: left;\n}\n.has-left-sidebar[_ngcontent-%COMP%] > article[_ngcontent-%COMP%], .has-left-sidebar[_ngcontent-%COMP%]   .type-page[_ngcontent-%COMP%], .has-left-sidebar[_ngcontent-%COMP%]   .archive-page[_ngcontent-%COMP%], .has-left-sidebar[_ngcontent-%COMP%]   .push-right[_ngcontent-%COMP%] {\n  float: right !important;\n}\n.has-both-sidebars[_ngcontent-%COMP%]   aside.left-sidebar[_ngcontent-%COMP%] {\n  float: left;\n}\n.has-both-sidebars[_ngcontent-%COMP%]   aside.right-sidebar[_ngcontent-%COMP%] {\n  float: right;\n}\n.has-both-sidebars[_ngcontent-%COMP%] > article[_ngcontent-%COMP%], .has-both-sidebars[_ngcontent-%COMP%]   .type-page[_ngcontent-%COMP%], .has-both-sidebars[_ngcontent-%COMP%]   .archive-page[_ngcontent-%COMP%] {\n  float: left;\n}\n.has-both-sidebars[_ngcontent-%COMP%]   .page-content[_ngcontent-%COMP%] {\n  float: right !important;\n}\n.page-content[_ngcontent-%COMP%] {\n  border-bottom: 0 solid transparent;\n}\n.page-content[_ngcontent-%COMP%] > ul[_ngcontent-%COMP%] {\n  list-style: disc inside none;\n}\n.search-no-results[_ngcontent-%COMP%]   .page-content[_ngcontent-%COMP%] > h3[_ngcontent-%COMP%] {\n  margin-top: 0;\n}\n.has-both-sidebars[_ngcontent-%COMP%]   aside.sidebar[_ngcontent-%COMP%] {\n  padding-top: 0;\n}\n.v-bg-stylish[_ngcontent-%COMP%] {\n  margin: 0;\n  padding: 30px 0px;\n  border-top: 1px solid transparent;\n  border-bottom: 1px solid transparent;\n  box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.07);\n  -ms-box-sizing: content-box;\n  box-sizing: content-box;\n}\n.fw-row[_ngcontent-%COMP%]   .v-bg-stylish[_ngcontent-%COMP%] {\n  padding-bottom: 0px;\n}\n.v-heading[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 20px;\n  margin-right: 10px;\n  display: inline-block;\n  vertical-align: -1px;\n}\n.heading-wrap[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 2;\n}\nh4.v-heading[_ngcontent-%COMP%], h3.v-heading[_ngcontent-%COMP%], h4.v-line-heading[_ngcontent-%COMP%] {\n  line-height: 0 !important;\n  text-align: left;\n  padding: 10px 0;\n  margin-top: 0;\n  max-width: 100%;\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  overflow: hidden;\n}\nh3.v-heading[_ngcontent-%COMP%] {\n  margin-bottom: 28px;\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  display: inline-block;\n  position: relative;\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\n  content: \"\";\n  position: absolute;\n  height: 7px !important;\n  border-top: 1px solid #E9E9E9;\n  border-bottom: 1px solid #E9E9E9;\n  top: -2px;\n  width: 1200px;\n}\naside[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, aside[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\n  display: none;\n}\nh3.spb-icon-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.spb-icon-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\n  top: 11px;\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before {\n  right: 100%;\n  margin-right: 15px;\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\n  left: 100%;\n  margin-left: 15px;\n}\nh4.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\n  max-width: 30px;\n  margin: 0 -10px;\n}\nh3.v-center-heading[_ngcontent-%COMP%], h4.v-center-heading[_ngcontent-%COMP%] {\n  display: block !important;\n  max-width: 100%;\n  margin: 20px auto 45px;\n  text-align: center;\n}\nh3.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], h4.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  padding: 0 20px;\n  position: relative;\n  z-index: 5;\n}\n.slider-wrap[_ngcontent-%COMP%]   .heading-wrap[_ngcontent-%COMP%] {\n  text-align: center;\n  margin-bottom: 10px;\n}\n.v-full-width-text[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]:before, .v-bg-stylish[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]:before {\n  border: 0;\n}\n.v-full-width-text[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], .v-bg-stylish[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  background: transparent !important;\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\n  border-color: #e4e4e4;\n}\nh4.v-heading[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]:before {\n  border-top-color: #e4e4e4;\n}\n.no-shadow[_ngcontent-%COMP%] {\n  box-shadow: none !important;\n}\n.v-bg-stylish[_ngcontent-%COMP%]   .carousel-wrap[_ngcontent-%COMP%]   .heading-wrap[_ngcontent-%COMP%] {\n  text-align: center;\n}\n.v-bg-stylish[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%] {\n  display: inline-block;\n}\n.v-heading-v2[_ngcontent-%COMP%] {\n  display: block;\n  margin-bottom: 25px;\n  border-bottom: 1px dotted #e4e4e4;\n}\n.v-heading-v2[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%], .v-heading-v2[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%], .v-heading-v2[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  margin: 0 0 -2px 0;\n  padding-bottom: 7px;\n  display: inline-block;\n  border-bottom: 2px solid #25CBF5;\n}\n.v-heading-v2[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  font-size: 10px;\n  background-color: #25CBF5;\n  padding: 2px 4px;\n  border-radius: 50%;\n  font-weight: 600;\n  color: white;\n  padding-top: 1px;\n}\n.help-text[_ngcontent-%COMP%] {\n  font-size: 18px;\n  line-height: 26px;\n  margin-bottom: 60px;\n}\n.help-text[_ngcontent-%COMP%]   .search-form[_ngcontent-%COMP%] {\n  margin-bottom: 40px;\n}\n.help-text[_ngcontent-%COMP%]   .search-form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  font-size: 14px;\n}\n.help-text[_ngcontent-%COMP%]   a.btn.v-btn[_ngcontent-%COMP%] {\n  margin: 0;\n  text-transform: uppercase;\n}\n.no-results-text[_ngcontent-%COMP%] {\n  margin-top: 20px;\n}\n.no-results-text[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-bottom: 15px;\n}\n.no-results-text[_ngcontent-%COMP%]   .search-form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  margin-top: 0;\n  margin-bottom: 60px;\n}\n\n.v-page-heading[_ngcontent-%COMP%] {\n  padding-top: 26px;\n  padding-bottom: 22px;\n  margin-top: 0;\n  margin-bottom: 0 !important;\n  position: relative;\n  text-align: left;\n  border-bottom: 1px solid transparent;\n  border-top: 0 !important;\n  box-shadow: none;\n}\n.header-overlay[_ngcontent-%COMP%]   .v-page-heading[_ngcontent-%COMP%] {\n  padding-top: 125px;\n}\n.v-page-heading[_ngcontent-%COMP%]   .heading-text[_ngcontent-%COMP%] {\n  float: left;\n  margin-left: 15px;\n}\n.v-page-heading[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  margin-top: 0;\n  margin-bottom: 0;\n  white-space: nowrap;\n  font-size: 22px;\n}\n.v-page-heading[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n}\n.v-page-heading.v-fancy-heading[_ngcontent-%COMP%] {\n  background-attachment: local;\n  background-size: cover;\n  background-repeat: repeat;\n  background-position: 50% 0;\n  text-align: center;\n  padding-top: 120px;\n  padding-bottom: 120px;\n  display: none;\n}\n.v-page-heading[_ngcontent-%COMP%] {\n  background-color: #f7f7f7;\n  border-bottom-color: #e4e4e4;\n}\n.v-page-heading[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .v-page-heading[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: #222222;\n}\n.v-fancy-heading[_ngcontent-%COMP%]   .heading-text[_ngcontent-%COMP%] {\n  float: none;\n  margin-left: 0;\n}\n.v-fancy-heading[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 38px;\n  line-height: 48px;\n  letter-spacing: inherit;\n  font-family: MuseoSlab500Regular;\n}\n.v-fancy-heading.v-fancy-image.light-style[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .v-fancy-heading.v-fancy-image.light-style[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: #fff !important;\n}\n.v-fancy-heading.v-fancy-image.dark-style[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .v-fancy-heading.v-fancy-image.dark-style[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: #222 !important;\n}\n.v-page-heading.v-fancy-heading.v-fancy-top-header[_ngcontent-%COMP%] {\n  padding-top: 180px;\n  padding-bottom: 120px;\n}\n.v-fancy-heading.v-fancy-top-header[_ngcontent-%COMP%]   .heading-text[_ngcontent-%COMP%] {\n  float: left;\n}\n.v-fancy-heading.v-fancy-top-header.v-fancy-image.light-style[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  margin-top: 0px;\n  margin-left: 0px;\n  float: left;\n  opacity: 0.7;\n}\n\n.v-pagination[_ngcontent-%COMP%] {\n  margin-top: 30px;\n  clear: both;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   span.current[_ngcontent-%COMP%] {\n  box-shadow: inset 0 0 9px rgba(0, 0, 0, .1);\n  border-color: #e4e4e4;\n}\n.paged[_ngcontent-%COMP%]   .v-pagination[_ngcontent-%COMP%] {\n  display: block !important;\n  visibility: visible !important;\n}\n.v-pagination[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  height: auto;\n  overflow: hidden;\n  margin: 15px 0;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  float: left;\n  display: inline-block;\n  margin-bottom: 0;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child {\n  border-left: 0;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  padding: 10px 16px;\n  border: 1px solid transparent;\n  display: block;\n  margin-right: -1px;\n  text-decoration: none;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  padding: 8px 16px;\n  border: 1px solid transparent;\n  display: block;\n  margin-right: -1px;\n  text-decoration: none;\n}\n.v-pagination[_ngcontent-%COMP%]   li.next[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  margin-left: -1px;\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  margin-left: 3px;\n  margin-right: 4px;\n}\n.v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n}\n.v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  color: #25CBF5;\n}\n.v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .search-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #444444;\n}\n.v-pagination[_ngcontent-%COMP%]   .nav-previous[_ngcontent-%COMP%] {\n  text-align: left;\n  float: left;\n  max-width: 45%;\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n.pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > span[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover, .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > span[_ngcontent-%COMP%]:hover, .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:focus, .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > span[_ngcontent-%COMP%]:focus {\n  background-color: #25CBF5;\n  border-color: #25CBF5;\n}\n.pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > span[_ngcontent-%COMP%] {\n  border: 1px solid #e4e4e4;\n  color: #444444;\n  font-size: 13px;\n}\n.pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:not(.active) > a[_ngcontent-%COMP%]:hover, .pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:not(.active) > span[_ngcontent-%COMP%]:hover {\n  color: #ffffff !important;\n  background: #25CBF5;\n  border-color: #25CBF5;\n}\n.pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  box-shadow: inset 0 0 9px rgba(0, 0, 0, .1);\n  background-color: #FFFFFF;\n  border-color: #e4e4e4;\n  color: #444444;\n  font-weight: bold;\n}\n.pagination-lg[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child > a[_ngcontent-%COMP%] {\n  border-top-left-radius: 2px;\n  border-bottom-left-radius: 2px;\n}\n.pagination-lg[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:last-child > a[_ngcontent-%COMP%] {\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n\n#container[_ngcontent-%COMP%]   aside.right-sidebar[_ngcontent-%COMP%] {\n  margin-top: -50px;\n  padding-top: 50px;\n  padding-bottom: 70px;\n  border-left: solid 1px #EBEBEB;\n  margin-bottom: -50px !important;\n  width: 25% !important;\n  padding-left: 26px;\n}\n#container[_ngcontent-%COMP%]   .has-right-sidebar[_ngcontent-%COMP%]   .col-sm-9[_ngcontent-%COMP%] {\n  border-right: solid 1px #EBEBEB;\n  margin-right: -1px;\n  padding-right: 30px !important;\n  width: 75% !important;\n  padding-left: 20px !important;\n}\n#container[_ngcontent-%COMP%]   .has-left-sidebar[_ngcontent-%COMP%]   .col-sm-9[_ngcontent-%COMP%] {\n  border-left: solid 1px #EBEBEB;\n  margin-left: -1px;\n  padding-left: 30px !important;\n  width: 75% !important;\n  padding-right: 20px !important;\n}\n#container[_ngcontent-%COMP%]   aside.left-sidebar[_ngcontent-%COMP%] {\n  margin-top: -50px;\n  padding-top: 50px;\n  padding-bottom: 70px;\n  border-right: solid 1px #EBEBEB;\n  margin-bottom: -50px !important;\n  width: 25% !important;\n  padding-right: 26px;\n}\n.sidebar[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   hr[_ngcontent-%COMP%] {\n  border-color: #e4e4e4;\n}\n.sidebar[_ngcontent-%COMP%]   .widget-heading[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-family: source_sans_probold, Arial, Helvetica, Tahoma, sans-serif;\n  letter-spacing: 1.1px;\n  font-weight: 400 !important;\n  font-size: 13px;\n  line-height: 23px;\n  text-transform: uppercase;\n  color: #333;\n}\n.sidebar[_ngcontent-%COMP%] {\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.sidebar.left-sidebar[_ngcontent-%COMP%] {\n  padding-right: 20px;\n}\n.sidebar.right-sidebar[_ngcontent-%COMP%] {\n  padding-left: 20px;\n}\n.sidebar[_ngcontent-%COMP%]   .widget_heading[_ngcontent-%COMP%] {\n  margin-top: -6px;\n}\n.sidebar[_ngcontent-%COMP%]   .widget-heading[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  margin-bottom: 15px;\n}\n.sidebar[_ngcontent-%COMP%]   object[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   object[_ngcontent-%COMP%] > img[_ngcontent-%COMP%]   .sidebar[_ngcontent-%COMP%]   embed[_ngcontent-%COMP%] {\n  width: 100%;\n  max-width: 100%;\n}\n.sidebar[_ngcontent-%COMP%]   object[_ngcontent-%COMP%] > img[_ngcontent-%COMP%] {\n  height: auto;\n}\n.sidebar[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n}\n.sidebar[_ngcontent-%COMP%]   .v-heading-v2[_ngcontent-%COMP%] {\n  margin-bottom: 20px !important;\n}\n.sidebar[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin: 0 0 20px;\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%] {\n  margin-left: -26px;\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  padding: 9px 15px;\n  border-bottom: 0px solid #EBEBEB !important;\n  padding-left: 30px;\n}\n.sidebar[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  color: #25CBF5;\n  font-family: 'Open Sans';\n  border-bottom: 1px solid #EBEBEB;\n  font-size: 13px;\n}\n.sidebar[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  font-size: 14px;\n}\n.sidebar[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .sidebar[_ngcontent-%COMP%]   .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li.current-menu-item[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  color: #25CBF5;\n}\n.list-toggle[_ngcontent-%COMP%]:after {\n  top: 9px;\n  right: 10px;\n  color: #25CBF5;\n  font-size: 14px;\n  content: \"\\f105\";\n  position: absolute;\n  font-weight: normal;\n  display: inline-block;\n  font-family: FontAwesome;\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%]   span.badge[_ngcontent-%COMP%] {\n  margin-top: 9px;\n  margin-right: 10px;\n}\n.list-group-item.active[_ngcontent-%COMP%], .list-group-item.active[_ngcontent-%COMP%]:hover, .list-group-item.active[_ngcontent-%COMP%]:focus {\n  border-left-color: #25CBF5;\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]   i.fa[_ngcontent-%COMP%] {\n  width: 20px;\n  font-size: 14px;\n  opacity: .9;\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%]   .accordion-toggle[_ngcontent-%COMP%] {\n  background-color: transparent;\n  box-shadow: none;\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%]   .list-group-item[_ngcontent-%COMP%] {\n  padding: 0px;\n  border-left: 0px !important;\n  border-bottom: 1px solid #F7F7F7;\n  border-right: 0px !important;\n}\n.sidebar.left-sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%] {\n  margin-left: 0px;\n  margin-right: -26px;\n}\n.sidebar.left-sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  padding-left: 5px;\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]   i[class*=\"icon-\"][_ngcontent-%COMP%] {\n  width: 20px;\n  font-size: 13px;\n  margin-right: 2px;\n  display: inline-block;\n  vertical-align: -1px;\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li.active[_ngcontent-%COMP%] {\n  border-bottom: 1px solid rgb(241, 241, 241);\n  border-top: 1px solid rgb(241, 241, 241);\n  background: #FAFAFA;\n  border-left: 1px solid #25CBF5 !important;\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before {\n  content: ' ';\n}\n\n.v-sidebar-content-wrap[_ngcontent-%COMP%] {\n  padding-top: 40px;\n  padding-bottom: 26px;\n}\n.v-right-sidebar-wrap[_ngcontent-%COMP%] {\n  padding-top: 40px;\n  padding-bottom: 60px;\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-sidebar-content-wrap[_ngcontent-%COMP%] {\n  padding-right: 15px;\n  padding-left: 30px;\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-sidebar-content-wrap[_ngcontent-%COMP%]   .tab-content[_ngcontent-%COMP%] {\n  padding: 0px;\n  box-shadow: none;\n  border: 0px solid #fff;\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-wrap[_ngcontent-%COMP%] {\n  padding-right: 30px;\n  padding-left: 15px;\n  border-right: 1px solid #ccc;\n  box-shadow: inset -8px 0 15px -10px rgba(0, 0, 0, 0.2);\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 101;\n  margin: 0 0 2em;\n  border-top: 1px solid #e5e5e5;\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  padding: 0;\n  margin: 0;\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\n  padding: 11px 10px !important;\n  color: #666;\n  border-bottom: 1px solid #e5e5e5;\n  outline: none;\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]   .fa[_ngcontent-%COMP%] {\n  width: 1em;\n  margin-right: 9px;\n  font-size: 1.15em;\n  text-align: center;\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  background-color: #f4f4f4;\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:focus, .v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  color: #25CBF5;\n  background-color: #fff;\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] + li[_ngcontent-%COMP%] {\n  margin-top: 0;\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-inner[_ngcontent-%COMP%] {\n  margin-left: 0;\n  margin-right: -31px;\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  margin: 0 1px 0 0;\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] {\n  margin-right: 0;\n}\n\n.widget[_ngcontent-%COMP%] {\n  padding-bottom: 50px;\n}\n.widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  margin: 0;\n  list-style: none;\n}\n.widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n  line-height: 19px;\n}\n.widget[_ngcontent-%COMP%]   ul.v-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  line-height: 180%;\n}\n.v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  padding: 10px 0;\n}\n.widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\n  padding: 10px 0;\n  display: block;\n}\n.widget[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  text-decoration: none;\n}\n.widget[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  text-decoration: underline;\n}\n.v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  border-top: 1px solid transparent;\n}\n.v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child {\n  border-top: 0;\n}\n.v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n}\n.v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before, .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before {\n  content: \"\\f105\";\n  font-family: FontAwesome;\n  font-weight: normal;\n  font-style: normal;\n  display: block;\n  float: right;\n  text-decoration: inherit;\n  font-size: 14px;\n}\n.v-nav-menu-widget[_ngcontent-%COMP%]   ul.sub-menu[_ngcontent-%COMP%] {\n  border-radius: 0;\n  \n  border-left: 0;\n  border-right: 0;\n  border-bottom: 0;\n}\n.v-nav-menu-widget[_ngcontent-%COMP%]   ul.sub-menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  padding-left: 15px;\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%] {\n  margin: 0;\n  padding: 0;\n  list-style: none;\n  height: auto;\n  overflow: hidden;\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  background: #f7f7f7;\n  border-color: #e4e4e4;\n}\n.widget[_ngcontent-%COMP%]   .tagcloud[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:hover > a[_ngcontent-%COMP%] {\n  background-color: #25CBF5;\n  color: #ffffff;\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  float: left;\n  margin-bottom: 4px;\n}\n.widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\n  margin-right: 4px;\n  padding: 5px 8px;\n  text-decoration: none;\n  border-radius: 2px;\n  border: 1px solid #333333;\n  font-size: 11px !important;\n  background-size: 100% 100%;\n  background-position: center center;\n  background-color: #333333;\n  color: white;\n  font-family: 'Open Sans';\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  border-color: transparent;\n  background-image: url('crease.svg');\n}\n.browser-ie[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover, .browser-ie10[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  background-image: none;\n}\n.sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   span.post-date[_ngcontent-%COMP%] {\n  display: block;\n  line-height: 13px;\n  font-size: 11px;\n  color: #999;\n  margin-bottom: 15px;\n  margin-top: -5px;\n}\n.sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #25CBF5;\n  font-size: 14px;\n}\n.widget-video[_ngcontent-%COMP%]   iframe[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.widget.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  height: 72px;\n  width: 72px;\n  padding: 0;\n  border: 0;\n  overflow: hidden;\n  float: left;\n  display: inline-block;\n  position: relative;\n  margin: 0 5px 5px 0;\n  background-image: url('crease.svg');\n  background-size: 100% 100%;\n  background-position: center center;\n  \n  transition: transform 0.3s, opacity 0.3s;\n  border-radius: 2px;\n  background-color: #25CBF5 !important;\n  color: #ffffff;\n}\n.browser-ie[_ngcontent-%COMP%]   .widget.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], .browser-ie10[_ngcontent-%COMP%]   .widget.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  background-image: none;\n}\n.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 72px;\n  width: auto;\n  min-height: 72px;\n  min-width: 72px;\n  display: block;\n  transition: all 0.3s ease-in-out;\n}\n.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:hover   img[_ngcontent-%COMP%] {\n  -moz-opacity: 0;\n  opacity: 0;\n  filter: alpha(opacity=0);\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  padding: 0;\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after {\n  content: \"\\f064\";\n  font-family: \"FontAwesome\";\n  font-weight: normal;\n  font-style: normal;\n  display: inline-block;\n  text-decoration: inherit;\n  font-size: 17px;\n  position: absolute;\n  right: 50%;\n  top: 50%;\n  margin-top: -8px;\n  margin-right: -10px;\n  color: #999;\n  opacity: 0;\n  transition: all 0.3s ease-in-out;\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:hover   a[_ngcontent-%COMP%]:after {\n  opacity: 1;\n}\n.browser-ie[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after {\n  display: none;\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after, .portfolio-grid[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after {\n  color: #ffffff;\n}\n.widget.v-search-widget[_ngcontent-%COMP%] {\n  padding-bottom: 35px;\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%] {\n  position: relative;\n  margin-bottom: 0;\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  margin: 0;\n  border: 1px solid #e3e3e3;\n  width: 100%;\n  height: 42px;\n  font-size: 14px;\n  line-height: 19px;\n  padding-left: 15px;\n  border-radius: 0;\n  -moz-background-clip: padding;\n  -webkit-background-clip: padding-box;\n  background-clip: padding-box;\n  background: #ffffff;\n  border-color: #e4e4e4;\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   input[type=\"submit\"][_ngcontent-%COMP%] {\n  visibility: hidden;\n  height: 0;\n  padding: 0;\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]:after {\n  font-weight: normal;\n  font-style: normal;\n  display: inline-block;\n  text-decoration: inherit;\n  font-size: 15px;\n  padding-right: 15px;\n  position: absolute;\n  float: right;\n  top: 11px;\n  right: 0;\n  color: #A8A8A8;\n  content: \"\\f002\";\n  font-family: \"FontAwesome\";\n}\n\nfooter[_ngcontent-%COMP%] {\n  padding: 55px 0 0;\n  border-top: 0 solid transparent;\n  padding-bottom: 44px;\n  border-top-width: 1px;\n  background: #f4f4f5;\n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%] {\n  background: #f7f7f7;\n  border-top: 3px solid #eee;\n  padding: 45px 0;\n  padding-bottom: 30px;\n}\nfooter[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  color: #25CBF5;\n}\nfooter[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: #000000;\n  line-height: 21px;\n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%], .footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: #666;\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  border-color: #333333;\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   hr[_ngcontent-%COMP%] {\n  border-color: #333333;\n}\nfooter[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-family: source_sans_probold, Arial, Helvetica, Tahoma, sans-serif;\n  letter-spacing: 1.8px;\n  font-weight: 400 !important;\n  margin-top: 0;\n  margin-bottom: 20px;\n  padding-bottom: 0;\n  font-size: 13px;\n  line-height: 23px;\n  text-transform: uppercase;\n  display: inline-block;\n  width: auto;\n  color: #000000 !important;\n\n}\nfooter[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #000000;\n  \n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #444;\n}\nfooter[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  text-decoration: none !important;\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%] {\n  padding-bottom: 10px;\n}\nfooter[_ngcontent-%COMP%]   ul.social-icons[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  border: 1px solid rgba(247, 247, 247, 0.17);\n  border-radius: 0 100px 100px;\n  margin-right: 8px;\n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%]   ul.social-icons[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  border: 1px solid rgba(61, 61, 61, 0.52);\n}\n.copyright[_ngcontent-%COMP%] {\n  padding: 16px 0;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  height: auto;\n  overflow: hidden;\n  font-size: 12px;\n  border-top: 0 solid transparent;\n  border-top-width: 1px;\n  background-color: #32bddd;\n  border-top-color: #f4f4f5;\n}\n.footer-v2[_ngcontent-%COMP%]   .copyright[_ngcontent-%COMP%] {\n  background-color: #EBEBEB;\n  border-top-color: #E0E0E0;\n}\n.copyright[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 12px;\n  float: left;\n  margin-bottom: 0;\n  line-height: 24px;\n  color: #000000;\n  padding-bottom: 2px;\n}\n.footer-v2[_ngcontent-%COMP%]   .copyright[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: #555;\n}\n.copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%] {\n  float: right;\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  font-size: 13px;\n  margin: 0 !important;\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child {\n  border-left: 0;\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  display: none;\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\n  border: 1px solid #3F3E3E;\n  padding: 5px 8px;\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  background: #f7f7f8;\n  border-color: #5E5E5E;\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\n  color: #fff;\n}\nfooter[_ngcontent-%COMP%]   .footer-contact-info[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-bottom: 6px;\n}\nfooter[_ngcontent-%COMP%]   .footer-contact-info[_ngcontent-%COMP%]   p[_ngcontent-%COMP%]:hover{\n  color: #25CBF5;\n}\nfooter[_ngcontent-%COMP%]   .footer-contact-info[_ngcontent-%COMP%]   .fa[_ngcontent-%COMP%] {\n  margin-right: 10px;\n  font-size: 14px;\n  width: 12px;\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\n  padding-bottom: 4px;\n  padding-top: 10px;\n}\nfooter[_ngcontent-%COMP%]   .v-recent-entry-widget.widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child   a[_ngcontent-%COMP%] {\n  padding-top: 0px;\n}\nfooter[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   .post-date[_ngcontent-%COMP%] {\n  margin-bottom: 10px;\n  display: block;\n  margin-top: -2px;\n  font-size: 12px;\n}\n.copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #000000;\n  border-bottom: solid 1px rgba(255, 255, 255, .07);\n  padding-bottom: 2px;\n  font-size: 12px;\n}\n.footer-v2[_ngcontent-%COMP%]   .copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: #555;\n  border-bottom: solid 1px rgba(206, 206, 206, 0.6);\n}\n.copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  color: #25CBF5;\n}\n\n.search-form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  border: 1px solid #ccc;\n  border-radius: 3px;\n  -moz-background-clip: padding;\n  -webkit-background-clip: padding-box;\n  background-clip: padding-box;\n  background: transparent;\n  width: 85%;\n  padding: 10px;\n  margin-top: 40px;\n}\n\na[rel=\"tooltip\"][_ngcontent-%COMP%] {\n  border-bottom: 1px dotted #e3e3e3;\n  border-color: #25CBF5;\n}\nspan.tooltip[_ngcontent-%COMP%] {\n  display: block;\n  background: #5F5F5F;\n  color: #f7f7f7;\n  position: absolute;\n  left: 50%;\n  bottom: 25px;\n  padding: 3px 10px;\n  width: auto;\n  line-height: 20px;\n  white-space: nowrap;\n  z-index: 8;\n  -moz-opacity: 0;\n  opacity: 0;\n  filter: alpha(opacity=0);\n  display: none;\n}\nspan.tooltip[_ngcontent-%COMP%]   .arrow[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  bottom: -4px;\n  margin-left: -6px;\n  width: 0;\n  height: 0;\n  border-left: 6px solid transparent;\n  border-right: 6px solid transparent;\n  border-top: 5px solid #5F5F5F;\n}\n.grid-img-wrap[_ngcontent-%COMP%]   span.tooltip[_ngcontent-%COMP%] {\n  bottom: 65px;\n}\n.read-more[_ngcontent-%COMP%] {\n  text-decoration: none;\n  display: inline-block;\n  border-bottom: 1px dotted #e3e3e3;\n  border-color: #25CBF5;\n}\n.read-more[_ngcontent-%COMP%]   i[_ngcontent-%COMP%], .read-more[_ngcontent-%COMP%]   em[_ngcontent-%COMP%] {\n  color: transparent;\n}\n.read-more[_ngcontent-%COMP%]   i[_ngcontent-%COMP%]:before, .read-more[_ngcontent-%COMP%]   em[_ngcontent-%COMP%]:before {\n  color: #25CBF5;\n}\n.read-more-button[_ngcontent-%COMP%] {\n  font-size: 12px;\n  height: auto;\n  padding: 10px 16px;\n  border: 1px solid #e4e4e4;\n  border-radius: 2px;\n  text-transform: uppercase;\n  font-weight: bold;\n  display: inline-block;\n  border-color: #e4e4e4;\n}\n.read-more-link[_ngcontent-%COMP%] {\n  text-decoration: none;\n  margin-top: 5px;\n  font-weight: bold;\n  display: block;\n}\n.item-link[_ngcontent-%COMP%] {\n  text-decoration: none;\n}\n.item-link[_ngcontent-%COMP%]:hover {\n  color: #25CBF5;\n}\n.portfolio[_ngcontent-%COMP%]   .item-link[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  margin-right: 5px;\n  vertical-align: -2px;\n}\n.v-smash-text[_ngcontent-%COMP%] {\n  background: transparent;\n  clear: both;\n  height: auto;\n  overflow: hidden;\n  border-color: #e4e4e4;\n}\n.v-smash-text[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%], .smash-text[_ngcontent-%COMP%], .v-smash-text-large[_ngcontent-%COMP%] {\n  color: #333333;\n}\n.v-smash-text.v-bg-stylish[_ngcontent-%COMP%] {\n  padding-top: 30px;\n  padding-bottom: 30px;\n}\n.v-smash-text-wrap[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 30px 35px;\n  border: 1px solid #e4e4e4;\n  border-radius: 4px;\n  border-color: #e4e4e4;\n}\n.v-bg-stylish[_ngcontent-%COMP%]   .v-smash-text-wrap[_ngcontent-%COMP%] {\n  border: 0;\n  border-radius: 0;\n  padding: 0;\n  margin: 0 15px;\n}\n.v-smash-text-wrap[_ngcontent-%COMP%]   .v-smash-text-arrow[_ngcontent-%COMP%] {\n  font-size: 42px;\n}\n.v-smash-text-wrap[_ngcontent-%COMP%]   .v-smash-text-arrow[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  line-height: 50px;\n}\n.v-smash-text.v-control-right[_ngcontent-%COMP%]   a.btn.v-btn[_ngcontent-%COMP%] {\n  margin-right: 0;\n}\n.v-smash-text[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%], .smash-text[_ngcontent-%COMP%] {\n  font-size: 24px;\n  line-height: 32px;\n  font-weight: 300;\n  margin-bottom: 0;\n}\np.v-smash-text-large[_ngcontent-%COMP%] {\n  font-size: 30px !important;\n  line-height: 40px;\n  margin-bottom: 0;\n  font-family: MuseoSlab500Regular;\n}\np.v-smash-text-large-2x[_ngcontent-%COMP%] {\n  font-size: 36px !important;\n  line-height: 48px;\n  font-family: MuseoSlab500Regular;\n}\n.v-smash-text[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n}\n.v-bg-stylish.v-smash-text[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%] {\n  border-left: 0;\n  padding-left: 0;\n}\n.v-smash-text[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n}\n.v-call-to-action[_ngcontent-%COMP%] {\n  position: relative;\n  background: #f4f4f4;\n  padding: 20px;\n  padding: 3%;\n}\n.v-call-to-action[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  margin: 0;\n  margin-top: 5px;\n}\n.v-call-to-action[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  margin-top: 10px;\n  margin-bottom: 0px;\n  font-size: 25px;\n}\n.v-call-to-action[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 20px;\n  font-weight: 400 !important;\n  color: #8c8c8c !important;\n  margin-top: 0px;\n  font-family: MuseoSlab500Regular;\n}\n.v-call-to-action.v-bg-stylish[_ngcontent-%COMP%] {\n  padding-top: 40px;\n  padding-bottom: 40px;\n}\n.v-control-left[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  float: left;\n  margin-right: 2.5641%;\n}\n.v-control-right[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  float: right;\n  margin-left: 2.5641%;\n}\n.v-control-left[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%], .v-control-right[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  max-width: 31.6239%;\n}\n.v-control-left[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%], .v-control-right[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%] {\n  width: 65.812%;\n  float: left;\n  clear: none;\n}\n.v-control-right[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-family: MuseoSlab500Regular;\n  font-size: 26px;\n  margin-top: 10px;\n}\n.v-control-right[_ngcontent-%COMP%]   .v-smash-text-wrap[_ngcontent-%COMP%] {\n  border-left: 2px solid #25CBF5;\n  border-top-left-radius: 1px;\n  border-bottom-left-radius: 1px;\n}\n.v-control-left[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%] {\n  float: right;\n}\n.v-call-to-action[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%], #content[_ngcontent-%COMP%]   .v-call-to-action[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%] {\n  margin: 0;\n}\n.cta_align_bottom[_ngcontent-%COMP%] {\n  text-align: center;\n}\n.cta_align_bottom[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  position: static;\n  margin-top: 2%;\n  display: inline-block;\n}\n.v-control-left[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%], .v-control-right[_ngcontent-%COMP%]   .v-call-text[_ngcontent-%COMP%] {\n  width: 80%;\n}\n.v-control-left[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%], .v-control-left[_ngcontent-%COMP%]   .v-smash-text-arrow[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 30px;\n  top: 50%;\n  margin-top: -20px;\n  max-width: 20%;\n}\n.v-bg-stylish[_ngcontent-%COMP%]   .v-control-left[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%], .v-bg-stylish[_ngcontent-%COMP%]   .v-control-left[_ngcontent-%COMP%]   .v-smash-text-arrow[_ngcontent-%COMP%] {\n  left: 0;\n}\n.v-control-right[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%], .v-control-right[_ngcontent-%COMP%]   .v-smash-text-arrow[_ngcontent-%COMP%] {\n  position: absolute;\n  right: 30px;\n  top: 50%;\n  margin-top: -23px;\n  max-width: 20%;\n}\n.v-bg-stylish[_ngcontent-%COMP%]   .v-control-right[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%], .v-bg-stylish[_ngcontent-%COMP%]   .v-control-right[_ngcontent-%COMP%]   .v-smash-text-arrow[_ngcontent-%COMP%] {\n  right: 0;\n}\n.cta_align_bottom[_ngcontent-%COMP%]   .btn.v-btn[_ngcontent-%COMP%] {\n  margin: 15px 0 0 0;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%] {\n  padding: 25px 0;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   .twitter-bird[_ngcontent-%COMP%] {\n  font-size: 14px;\n  line-height: 26px;\n  float: left;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  margin-left: 25px;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  margin-top: 15px;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   .tweet-text[_ngcontent-%COMP%] {\n  line-height: 24px;\n  display: block;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   .tweet-text[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  font-weight: bold;\n  text-decoration: none;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   .twitter_intents[_ngcontent-%COMP%] {\n  display: block;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   .twitter_intents[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  margin-right: 5px;\n}\n.v-latest-tweets-widget[_ngcontent-%COMP%]   a.twitter-timestamp[_ngcontent-%COMP%] {\n  display: inline-block;\n  line-height: 24px;\n  margin-left: 10px;\n  font-size: 12px;\n}\n.v-video-widget[_ngcontent-%COMP%]   .v-wrapper.shadow[_ngcontent-%COMP%] {\n  margin-bottom: 20px;\n  box-shadow: 2px 2px 0 rgba(0, 0, 0, .25);\n}\nfigure.lightbox[_ngcontent-%COMP%] {\n  position: relative;\n}\n.widget[_ngcontent-%COMP%]   .recent-posts-list[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  height: auto;\n  overflow: hidden;\n  margin-bottom: 0;\n  padding-bottom: 10px;\n}\n.recent-posts-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .recent-post-image[_ngcontent-%COMP%] {\n  padding: 0;\n  float: left;\n  width: 90px;\n  height: auto;\n  min-height: 70px;\n  background: #222;\n}\n.recent-posts-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .recent-post-image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  height: auto;\n}\n.recent-posts-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .recent-post-details[_ngcontent-%COMP%] {\n  padding: 0 10px;\n  margin-left: 98px;\n}\n.recent-posts-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .recent-post-title[_ngcontent-%COMP%] {\n  display: block;\n  margin-bottom: 5px;\n  overflow: hidden;\n  white-space: nowrap;\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n}\n.recent-posts-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .recent-post-details[_ngcontent-%COMP%] > span[_ngcontent-%COMP%] {\n  font-size: 12px;\n  font-style: italic;\n}\n.recent-posts-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   .recent-post-details[_ngcontent-%COMP%]   .like-info[_ngcontent-%COMP%] {\n  float: none;\n  margin-top: 5px;\n  font-size: 12px !important;\n}\n.recent-comments-list[_ngcontent-%COMP%]   .comment[_ngcontent-%COMP%]   .comment-wrap[_ngcontent-%COMP%] {\n  border-bottom: 1px solid #E6E6E6;\n  padding: 10px 0;\n  padding-bottom: 5px;\n  padding-top: 15px;\n}\n.recent-comments-list[_ngcontent-%COMP%]   .comment[_ngcontent-%COMP%]   .comment-meta-actions[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  font-size: 12px;\n  text-transform: uppercase;\n}\n.recentcomments[_ngcontent-%COMP%] {\n  overflow: hidden;\n  white-space: nowrap;\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n}\n.sidebar-ad-grid[_ngcontent-%COMP%] {\n  padding: 15px;\n  box-shadow: inset 0 0 10px rgba(0, 0, 0, .15);\n}\n.sidebar-ad-grid[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\n  float: left;\n  margin: 5px;\n  max-width: 125px;\n}\n.sidebar-ad-grid[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  display: block;\n}\n.widget[_ngcontent-%COMP%]   input[type=\"email\"][_ngcontent-%COMP%] {\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  padding: 5px 20px 5px 10px;\n  line-height: 21px;\n  height: 32px;\n  display: block;\n  border: 0;\n  background: #f7f7f7;\n  color: #999;\n}\n.widget[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n  width: 100%;\n  padding: 5px 20px 5px 10px;\n  line-height: 21px;\n  height: 32px;\n  display: block;\n  border: 0;\n  background: #f7f7f7;\n  color: #999;\n}\n.infocus-title[_ngcontent-%COMP%]   .like-info-wrap[_ngcontent-%COMP%] {\n  display: block;\n  float: right;\n  margin: 10px 16px 10px 0;\n}\n.widget[_ngcontent-%COMP%]   hr[_ngcontent-%COMP%] {\n  border-bottom: 0;\n}\n\n.type-page[_ngcontent-%COMP%]   #comment-area[_ngcontent-%COMP%] {\n  padding-top: 20px;\n}\n#comment-area[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  text-decoration: none;\n}\n.logged-in-as[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  border-bottom: 1px dotted #e3e3e3;\n  border-color: #25CBF5;\n}\n#comments-list[_ngcontent-%COMP%] {\n  margin-bottom: 50px;\n}\n#comments-list[_ngcontent-%COMP%]   ol[_ngcontent-%COMP%] {\n  list-style: none;\n  margin: 0 0 -10px;\n  padding: 0;\n}\n#comments-list[_ngcontent-%COMP%]   ol[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  margin-bottom: 0;\n}\n.comment[_ngcontent-%COMP%]   .comment-wrap[_ngcontent-%COMP%] {\n  position: relative;\n  height: auto;\n}\n.comment-wrap[_ngcontent-%COMP%]   .comment-avatar[_ngcontent-%COMP%] {\n  float: left;\n  position: relative;\n}\n.comment-wrap[_ngcontent-%COMP%]   .comment-avatar[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 50px;\n  width: 50px;\n  display: block;\n}\n#comments-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  list-style: none;\n  margin: 0 0 0 30px;\n  font-size: 100%;\n}\n.comment-content[_ngcontent-%COMP%] {\n  margin-left: 65px;\n  padding: 0px;\n  \n  border-radius: 5px;\n  -moz-background-clip: padding;\n  -webkit-background-clip: padding-box;\n  background-clip: padding-box;\n  margin-bottom: 14px;\n}\n.comment-content[_ngcontent-%COMP%]   .comment-body[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-bottom: 10px;\n  font-family: 'Open Sans';\n  color: #25CBF5;\n  font-size: 14px;\n}\n.comment-meta[_ngcontent-%COMP%] {\n  position: relative;\n  margin-top: -8px;\n}\n.comment-meta[_ngcontent-%COMP%]   .comment-date[_ngcontent-%COMP%] {\n  margin-left: 2px;\n  font-size: 12px;\n  color: #999;\n}\n.comment-meta-actions[_ngcontent-%COMP%] {\n  display: inline-block;\n  font-size: 12px;\n}\n.comment-meta-actions[_ngcontent-%COMP%]   .edit-link[_ngcontent-%COMP%] {\n  margin-left: 5px;\n  border-bottom: 1px dotted #e3e3e3;\n}\n.comment-meta-actions[_ngcontent-%COMP%]   .meta-sep[_ngcontent-%COMP%] {\n  margin: 0 0 0 1px;\n  color: rgba(0, 0, 0, 0.1);\n}\n.comment-meta-actions[_ngcontent-%COMP%]   .comment-reply[_ngcontent-%COMP%] {\n  border-bottom: 1px dotted #e3e3e3;\n}\n.comment-meta-actions[_ngcontent-%COMP%]   .edit-link[_ngcontent-%COMP%], .comment-meta-actions[_ngcontent-%COMP%]   .comment-reply[_ngcontent-%COMP%] {\n  border-color: #25CBF5;\n}\n#comment-area[_ngcontent-%COMP%]   .edit-link[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, #comment-area[_ngcontent-%COMP%]   .comment-reply[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n}\n.comment-avatar[_ngcontent-%COMP%]   .is-author[_ngcontent-%COMP%] {\n  text-align: center;\n  font-size: 10px;\n  text-transform: uppercase;\n  color: #ccc;\n}\n.comment-meta[_ngcontent-%COMP%]   cite[_ngcontent-%COMP%] {\n  font-style: normal;\n}\n.comment-meta-actions[_ngcontent-%COMP%]   a.comment-reply-link[_ngcontent-%COMP%] {\n  font-weight: normal;\n}\n.comment-meta[_ngcontent-%COMP%]   .comment-author[_ngcontent-%COMP%] {\n  letter-spacing: normal;\n}\n#commentform[_ngcontent-%COMP%]   p.comment-notes[_ngcontent-%COMP%]   span.required[_ngcontent-%COMP%] {\n  float: none;\n}\n.required[_ngcontent-%COMP%] {\n  color: #ee3c59;\n}\n\n.home-intro[_ngcontent-%COMP%] {\n  background-color: #f8f8f8;\n  margin-bottom: 60px;\n  overflow: hidden;\n  padding: 30px 0 21px 0;\n  position: relative;\n  text-align: left;\n  border-top: 1px solid #e5e4e4;\n  border-bottom: 1px solid #e5e4e4;\n}\n.home-intro[_ngcontent-%COMP%]   .btn-buy[_ngcontent-%COMP%] {\n  margin-top: 30px;\n}\n.home-intro[_ngcontent-%COMP%]   .v-smash-text-large[_ngcontent-%COMP%] {\n  margin-bottom: 10px;\n  font-size: 30px !important;\n}\n\n.special-contact-form[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%], .special-contact-form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  margin-bottom: 10px !important;\n}\n.fw-map[_ngcontent-%COMP%] {\n  background: #292929;\n  width: 100%;\n  height: 100%;\n  left: 0;\n  right: 0;\n  position: absolute;\n}\n.map-info-section[_ngcontent-%COMP%] {\n  width: 440px;\n  padding: 20px 30px;\n  background: #FFF;\n  background: rgba(255, 255, 255, .94);\n  position: relative;\n  z-index: 91;\n  float: right;\n  margin: 60px 0;\n  border: solid 1px #f5f8ff;\n  border-radius: 2px;\n  overflow: hidden;\n  box-shadow: 0 2px 12px rgba(0, 0, 0, .1);\n}\n.fw-map-wrapper[_ngcontent-%COMP%] {\n  position: relative;\n  min-height: 600px;\n  display: block;\n  overflow: hidden;\n}\n.map-info-section[_ngcontent-%COMP%]   .minimize-section[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 30px;\n  height: 30px;\n  text-align: center;\n  line-height: 30px;\n  font-size: 13px;\n  color: #ccc;\n}\n.map-info-section.minimized[_ngcontent-%COMP%] {\n  height: 60px !important;\n}\n\n.panel-default[_ngcontent-%COMP%] > .panel-heading[_ngcontent-%COMP%] {\n  background-color: #fff;\n  box-shadow: none;\n  border-color: #e4e4e4;\n}\n.panel-default[_ngcontent-%COMP%] {\n  border-color: #e4e4e4;\n}\n.panel[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n.panel-title[_ngcontent-%COMP%] {\n  font-size: 14px;\n  font-family: 'Open Sans', Arial, Helvetica, sans-serif !important;\n  color: #555 !important;\n}\n.panel-title[_ngcontent-%COMP%]   i.fa[_ngcontent-%COMP%] {\n  width: 20px;\n  margin-right: 3px;\n}\n.panel-group[_ngcontent-%COMP%]   .panel[_ngcontent-%COMP%] {\n  border-radius: 2px;\n}\n.panel-group[_ngcontent-%COMP%]   .panel[_ngcontent-%COMP%] + .panel[_ngcontent-%COMP%] {\n  margin-top: 6px;\n}\n.panel-body[_ngcontent-%COMP%] {\n  padding: 20px;\n}\n.panel-blue[_ngcontent-%COMP%] {\n  border-color: #3498db;\n}\n.panel-blue[_ngcontent-%COMP%] > .panel-heading[_ngcontent-%COMP%] {\n  background: #3498db;\n}\n.panel-green[_ngcontent-%COMP%] {\n  border-color: #2ecc71;\n}\n.panel-green[_ngcontent-%COMP%] > .panel-heading[_ngcontent-%COMP%] {\n  background: #2ecc71;\n}\n.panel-grey[_ngcontent-%COMP%] {\n  border-color: #95a5a6;\n}\n.panel-grey[_ngcontent-%COMP%] > .panel-heading[_ngcontent-%COMP%] {\n  background: #95a5a6;\n}\n.panel-red[_ngcontent-%COMP%] {\n  border-color: #e74c3c;\n}\n.panel-red[_ngcontent-%COMP%] > .panel-heading[_ngcontent-%COMP%] {\n  background: #e74c3c;\n}\n\n.bs-glyphicons[_ngcontent-%COMP%] {\n  margin-right: 0;\n  margin-left: 0;\n  margin: 0 -10px 20px;\n  overflow: hidden;\n}\n.bs-glyphicons[_ngcontent-%COMP%]   .glyphicon[_ngcontent-%COMP%] {\n  margin-top: 5px;\n  margin-bottom: 10px;\n  font-size: 24px;\n}\n.bs-glyphicons[_ngcontent-%COMP%]   .glyphicon-class[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  -ms-word-wrap: break-word;\n  word-wrap: break-word;\n}\n.bs-glyphicons[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  width: 12.5%;\n  float: left;\n  width: 16.5%;\n  height: 100px;\n  padding: 10px;\n  font-size: 11px;\n  line-height: 1.4;\n  text-align: center;\n  background-color: #f9f9f9;\n  border: 1px solid #fff;\n}\n.glyphs.css-mapping[_ngcontent-%COMP%] {\n  padding: 0px 0 20px 30px;\n}\n.glyphs.css-mapping[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  margin: 0 30px 5px 0;\n  padding: 0;\n  display: inline-block;\n  overflow: hidden;\n}\n.glyphs.css-mapping[_ngcontent-%COMP%]   .icon[_ngcontent-%COMP%] {\n  margin: 0;\n  margin-right: 10px;\n  padding: 13px;\n  height: 50px;\n  width: 50px;\n  color: #162a36 !important;\n  overflow: hidden;\n  float: left;\n  font-size: 24px;\n}\n.glyphs.css-mapping[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  margin: 0;\n  margin-top: 5px;\n  padding: 8px;\n  line-height: 16px;\n  font-size: 16px;\n  display: block;\n  width: 270px;\n  height: 40px;\n  border: 1px solid #F0F0F0;\n  border-radius: 2px;\n  background: #fff;\n  outline: 0;\n  float: right;\n}\n\n.v-page-not-found-wrap[_ngcontent-%COMP%]   h1.v-404[_ngcontent-%COMP%] {\n  font-size: 160px;\n  font-weight: 500;\n  letter-spacing: -5px;\n  line-height: 160px;\n  font-family: 'Open Sans' !important;\n}\n.v-page-not-found-wrap[_ngcontent-%COMP%]   h1.v-error[_ngcontent-%COMP%] {\n  margin-top: 15px;\n  margin-bottom: -35px;\n  font-size: 50px;\n  margin-left: 48px;\n}\n.v-page-not-found-wrap[_ngcontent-%COMP%]   .v-search-widget[_ngcontent-%COMP%] {\n  width: 50%;\n  margin-left: auto;\n  margin-right: auto;\n}\n\n.features[_ngcontent-%COMP%]   .phone-image[_ngcontent-%COMP%] {\n  max-width: 250px;\n  margin: auto;\n  margin-bottom: 80px;\n}\n.app-brief[_ngcontent-%COMP%]   .phone-image[_ngcontent-%COMP%] {\n  max-width: 350px;\n  margin: auto;\n}\n.subscription-form[_ngcontent-%COMP%]   .subscriber-button[_ngcontent-%COMP%] {\n  margin-bottom: 0px;\n  padding: 15px 20px 14px;\n}\n.subscription-form[_ngcontent-%COMP%]   .subscriber-email[_ngcontent-%COMP%] {\n  width: 300px;\n  height: 45px;\n  margin-bottom: 0px;\n  background-color: #fff !important;\n}\n.subscription-form[_ngcontent-%COMP%]   .subscriber-email[_ngcontent-%COMP%]:active, .subscription-form[_ngcontent-%COMP%]   .subscriber-email[_ngcontent-%COMP%]:focus {\n  background-color: #fff !important;\n}\n\n.v-page-heading[_ngcontent-%COMP%]   .breadcrumb[_ngcontent-%COMP%] {\n  float: right;\n  background-color: transparent;\n  margin-bottom: 0px;\n  padding: 8px 0 6px;\n  font-size: 12px;\n}\n.v-page-heading[_ngcontent-%COMP%]   .breadcrumb[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] + li[_ngcontent-%COMP%]:before {\n  padding: 0 3px;\n}\n\n\n.v-yellow[_ngcontent-%COMP%], .v-yellow[_ngcontent-%COMP%]:hover, .v-third-dark[_ngcontent-%COMP%], .v-third-dark[_ngcontent-%COMP%]:hover, .v-second-dark[_ngcontent-%COMP%]:hover, .v-second-dark[_ngcontent-%COMP%] {\n  box-shadow: none;\n}\n\n.post-block-wrap[_ngcontent-%COMP%] {\n  padding-top: 20px;\n}\nimg.media-object[_ngcontent-%COMP%] {\n  width: 60px;\n  height: auto;\n  border-radius: 50%;\n}\n.media-heading[_ngcontent-%COMP%] {\n  font-family: \"source_sans_probold\", Arial, Helvetica, Tahoma, sans-serif;\n  font-weight: normal !important;\n  font-size: 13px;\n  color: #555;\n  margin-top: 5px;\n  margin-bottom: 2px;\n}\n.media-body[_ngcontent-%COMP%]   .date[_ngcontent-%COMP%] {\n  margin-left: 5px;\n  margin-right: 5px;\n  font-size: 12px;\n  color: #999;\n  font-family: 'Open Sans';\n}\n.media-body[_ngcontent-%COMP%]   .reply-link[_ngcontent-%COMP%] {\n  font-family: 'Open Sans';\n  font-size: 12px;\n  font-weight: normal;\n  color: #333333;\n  border-bottom: 1px dotted #e3e3e3;\n  border-color: #25CBF5;\n}\n.media[_ngcontent-%COMP%] {\n  margin-top: 0px;\n}\n.comments-wrap[_ngcontent-%COMP%] {\n  margin-bottom: 65px;\n}\n\n#newsletterForm[_ngcontent-%COMP%]   .btn.btn-default[_ngcontent-%COMP%] {\n  margin-right: 0px;\n  box-shadow: none;\n  padding: 9px 12px;\n  padding-bottom: 10px;\n  font-family: 'Open Sans';\n  text-transform: none;\n  border-top-right-radius: 3px;\n  border-bottom-right-radius: 3px;\n}\n#newsletterForm[_ngcontent-%COMP%]   .btn[_ngcontent-%COMP%]:active {\n  top: 0px !important;\n}\n#newsletterForm[_ngcontent-%COMP%]   .input-group-btn[_ngcontent-%COMP%]:last-child > .btn[_ngcontent-%COMP%] {\n  margin-left: -1px;\n}\n#newsletterForm[_ngcontent-%COMP%]   .input-group[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%] {\n  background-color: #fff !important;\n}\n.input-group-btn[_ngcontent-%COMP%]:last-child > .btn[_ngcontent-%COMP%] {\n  margin-left: 0px;\n}\n.sep-double[_ngcontent-%COMP%] {\n  height: 8px;\n  border-top: 1px solid #e7e6e6;\n  border-bottom: 1px solid #e7e6e6;\n}\n.demo-sep[_ngcontent-%COMP%] {\n  clear: both;\n}\n.sep-double[_ngcontent-%COMP%], .sep-dashed[_ngcontent-%COMP%], .sep-dotted[_ngcontent-%COMP%], .search-page-search-form[_ngcontent-%COMP%] {\n  border-color: #e0dede !important;\n}\n\ninput[_ngcontent-%COMP%], input[type=\"text\"][_ngcontent-%COMP%], input[type=\"password\"][_ngcontent-%COMP%], input[type=\"datetime\"][_ngcontent-%COMP%], input[type=\"datetime-local\"][_ngcontent-%COMP%], input[type=\"date\"][_ngcontent-%COMP%], input[type=\"month\"][_ngcontent-%COMP%], input[type=\"time\"][_ngcontent-%COMP%], input[type=\"week\"][_ngcontent-%COMP%], input[type=\"number\"][_ngcontent-%COMP%], input[type=\"email\"][_ngcontent-%COMP%], input[type=\"url\"][_ngcontent-%COMP%], input[type=\"search\"][_ngcontent-%COMP%], input[type=\"tel\"][_ngcontent-%COMP%], input[type=\"color\"][_ngcontent-%COMP%] {\n  outline: 0;\n  border-radius: 0;\n  box-shadow: none;\n}\ninput[type=email][_ngcontent-%COMP%], input[type=password][_ngcontent-%COMP%], input[type=tel][_ngcontent-%COMP%], input[type=text][_ngcontent-%COMP%], textarea[_ngcontent-%COMP%] {\n  width: 100%;\n  border: solid 1px #e3e3e3;\n  border-bottom-color: #F0F0F0;\n  border-top-color: #e0e0e0;\n  color: #777;\n  background-color: rgba(0, 0, 0, .03) !important;\n  border-radius: 1px;\n  transition: all .2s linear;\n  outline: none !important;\n  -o-box-shadow: 0 1px 2px rgba(10, 10, 10, .1)inset;\n  box-shadow: 0 1px 2px rgba(10, 10, 10, .1)inset;\n  backface-visibility: hidden;\n}\ninput[type=email][_ngcontent-%COMP%]:focus, input[type=text][_ngcontent-%COMP%]:focus, textarea[_ngcontent-%COMP%]:focus {\n  color: #323436;\n  background-color: rgba(150, 150, 150, .01) !important;\n  outline: none !important;\n  transition: all .2s linear;\n}\n.form-control[_ngcontent-%COMP%] {\n  font-size: 13px;\n  height: 40px;\n  border: 1px solid #e3e3e3;\n  border-radius: 2px;\n}\n.form-control[_ngcontent-%COMP%]:focus {\n  box-shadow: none;\n  color: #323436;\n  background-color: rgba(250, 250, 250);\n  outline: none !important;\n  border: solid 1px #e3e3e3;\n  border-bottom-color: #F0F0F0;\n  border-top-color: #e0e0e0;\n  -o-box-shadow: 0 1px 2px rgba(10, 10, 10, .1)inset;\n  box-shadow: 0 1px 2px rgba(10, 10, 10, .1)inset;\n  transition: all .2s linear;\n}\n.button[_ngcontent-%COMP%], button[_ngcontent-%COMP%], input[type=\"submit\"][_ngcontent-%COMP%], input[type=\"reset\"][_ngcontent-%COMP%], input[type=\"button\"][_ngcontent-%COMP%] {\n  transition: all 0.3s ease-in-out;\n}\n.form-control[_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"text\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"password\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"datetime\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"datetime-local\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"date\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"month\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"time\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"week\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"number\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"email\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"url\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"search\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"tel\"][_ngcontent-%COMP%]::-webkit-input-placeholder, input[type=\"color\"][_ngcontent-%COMP%]::-webkit-input-placeholder, select[_ngcontent-%COMP%]::-webkit-input-placeholder, textarea[_ngcontent-%COMP%]::-webkit-input-placeholder {\n  color: #999;\n}\n.form-control[_ngcontent-%COMP%]::-moz-placeholder, input[type=\"text\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"password\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"datetime\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"datetime-local\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"date\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"month\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"time\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"week\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"number\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"email\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"url\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"search\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"tel\"][_ngcontent-%COMP%]::-moz-placeholder, input[type=\"color\"][_ngcontent-%COMP%]::-moz-placeholder, select[_ngcontent-%COMP%]::-webkit-input-placeholder, textarea[_ngcontent-%COMP%]::-moz-placeholder {\n  color: #999;\n}\nbutton[_ngcontent-%COMP%]::-moz-focus-inner {\n  border: 0;\n}\n.form-group[_ngcontent-%COMP%]:after {\n  content: \".\";\n  display: block;\n  clear: both;\n  visibility: hidden;\n  line-height: 0;\n  height: 0;\n}\n\n\n.signup[_ngcontent-%COMP%] {\n  width: 430px;\n  background: #fff;\n  padding: 40px;\n  padding-bottom: 30px;\n  border-radius: 2px;\n  box-shadow: 0 2px 15px 5px rgba(0, 0, 0, .1);\n  border-top: 4px solid #25CBF5;\n}\n.body-sign[_ngcontent-%COMP%]   .checkbox-custom[_ngcontent-%COMP%] {\n  margin-top: 8px;\n}\n.body-sign[_ngcontent-%COMP%]   .line-thru[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 12px;\n  font-size: 1.2rem;\n  position: relative;\n}\n.body-sign[_ngcontent-%COMP%]   .line-thru[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  color: #CCC;\n  position: relative;\n  z-index: 3;\n}\n.body-sign[_ngcontent-%COMP%]   .line-thru[_ngcontent-%COMP%]:before {\n  background-color: #FFF;\n  content: '';\n  height: 10px;\n  left: 50%;\n  position: absolute;\n  margin: -5px 0 0 -20px;\n  top: 50%;\n  width: 40px;\n  z-index: 2;\n}\n.body-sign[_ngcontent-%COMP%]   .line-thru[_ngcontent-%COMP%]:after {\n  border-bottom: 1px solid #DADADA;\n  content: '';\n  display: block;\n  left: 10%;\n  position: absolute;\n  top: 47%;\n  width: 81%;\n  z-index: 1;\n}\nbody[_ngcontent-%COMP%]   .btn-facebook[_ngcontent-%COMP%], body[_ngcontent-%COMP%]   .btn-facebook[_ngcontent-%COMP%]:focus {\n  background: #3B5998;\n  border: 1px solid #37538D;\n}\nbody[_ngcontent-%COMP%]   .btn-twitter[_ngcontent-%COMP%], body[_ngcontent-%COMP%]   .btn-twitter[_ngcontent-%COMP%]:focus {\n  background: #55ACEE;\n  border: 1px solid #47A5ED;\n}\nbody[_ngcontent-%COMP%]   .btn-facebook[_ngcontent-%COMP%], body[_ngcontent-%COMP%]   .btn-facebook[_ngcontent-%COMP%]:active, body[_ngcontent-%COMP%]   .btn-facebook[_ngcontent-%COMP%]:hover, body[_ngcontent-%COMP%]   .btn-facebook[_ngcontent-%COMP%]:focus, body[_ngcontent-%COMP%]   .btn-twitter[_ngcontent-%COMP%], body[_ngcontent-%COMP%]   .btn-twitter[_ngcontent-%COMP%]:active, body[_ngcontent-%COMP%]   .btn-twitter[_ngcontent-%COMP%]:hover, body[_ngcontent-%COMP%]   .btn-twitter[_ngcontent-%COMP%]:focus, body[_ngcontent-%COMP%]   .btn-gplus[_ngcontent-%COMP%], body[_ngcontent-%COMP%]   .btn-gplus[_ngcontent-%COMP%]:active, body[_ngcontent-%COMP%]   .btn-gplus[_ngcontent-%COMP%]:hover, body[_ngcontent-%COMP%]   .btn-gplus[_ngcontent-%COMP%]:focus {\n  color: #FFF;\n  font-weight: 300;\n  padding-left: 30px;\n  padding-right: 30px;\n  text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.2);\n  border-radius: 2px;\n  margin-left: 5px;\n  margin-right: 5px;\n}\n.btn-facebook[_ngcontent-%COMP%]:hover {\n  background: #4162a7;\n  border-color: #3d5c9c;\n}\n.btn-twitter[_ngcontent-%COMP%]:hover {\n  background: #63b3ef;\n  border-color: #55acee;\n}\n\n.portfolio-grid[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  float: left;\n  height: 70px;\n  position: relative;\n  margin: 0 6px 6px 0 !important;\n  background-image: url('crease.svg');\n  background-size: 100% 100%;\n  background-position: center center;\n  backface-visibility: hidden;\n  border-radius: 2px;\n  -moz-background-clip: padding;\n  -webkit-background-clip: padding-box;\n  background-clip: padding-box;\n  \n}\n.browser-ie[_ngcontent-%COMP%]   .portfolio-grid[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], .browser-ie10[_ngcontent-%COMP%]   .portfolio-grid[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\n  background-image: none;\n}\n.portfolio-grid[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  padding: 0 !important;\n}\n.portfolio-grid[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 70px;\n  height: 70px;\n  transition: all 0.3s ease-in-out;\n}\n\n.v-portfolio-items.no-padding[_ngcontent-%COMP%]   li.v-portfolio-item[_ngcontent-%COMP%] {\n  padding: 1px;\n}\n.full-width-area.v-portfolio-items[_ngcontent-%COMP%] {\n  padding: 0 2%;\n}\n.full-width-area.v-portfolio-items[_ngcontent-%COMP%]   .v-portfolio-item[_ngcontent-%COMP%] {\n  width: 24%;\n  padding: 0 1%;\n}\n.v-portfolio-item.standard[_ngcontent-%COMP%]   figcaption[_ngcontent-%COMP%]   .thumb-info[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  top: 50%;\n  position: absolute;\n  margin-top: -25px;\n  margin-left: -25px;\n}\n.v-portfolio-filter-wrap[_ngcontent-%COMP%] {\n  display: block;\n  margin-bottom: 20px;\n}\n.v-portfolio-filter-wrap[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%] {\n  line-height: 30px;\n  margin-bottom: 10px;\n  display: block;\n  position: relative;\n  outline: none;\n}\n.has-no-sidebar[_ngcontent-%COMP%]   .v-portfolio-filter-wrap[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%] {\n  text-align: center;\n  padding-left: 20px;\n}\n.v-portfolio-filter-wrap[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%]:hover {\n  text-decoration: none;\n}\n.v-portfolio-filter-wrap[_ngcontent-%COMP%]   .select[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  margin-right: 10px;\n}\n.b[_ngcontent-%COMP%] {\n  border-radius: 4px;\n  background-color: #25CBF5;\n  border: none;\n  color: #FFFFFF;\n  text-align: center;\n  font-size: 28px;\n  padding: 20px;\n  width: 500px;\n  transition: all 0.5s;\n  cursor: pointer;\n  align-items: center;\n}\n.num[_ngcontent-%COMP%] {\n  color: #25CBF5;\n  font-size: 30px;\n  font-weight: 300;\n}\n.num[_ngcontent-%COMP%]:hover {\n  color: white;\n  font-size: 30px;\n  font-weight: 300;\n}\n.num1[_ngcontent-%COMP%] {\n  color: white;\n  font-size: 30px;\n  font-weight: 300;\n}\n.b[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: inline-block;\n  position: relative;\n  transition: 0.5s;\n}\n.b[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\n  content: '\\00bb';\n  position: absolute;\n  opacity: 0;\n  top: 0;\n  right: -20px;\n  transition: 0.5s;\n}\n.b[_ngcontent-%COMP%]:hover   span[_ngcontent-%COMP%] {\n  padding-right: 25px;\n}\n.b[_ngcontent-%COMP%]:hover   span[_ngcontent-%COMP%]:after {\n  opacity: 1;\n  right: 0;\n}\n.is-invalid[_ngcontent-%COMP%] {\n  border: 1px solid #b94a48 !important;\n}\n.visiblity[_ngcontent-%COMP%] {\n  text-decoration: underline !important;\n  font-size: 14px;\n}\n#nav-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  text-align: center;\n}\n.whatsapp[_ngcontent-%COMP%]{\n  aspect-ratio: 3/2;\n  mix-blend-mode: darken;\n}\n@media only screen and (max-width: 994px) {\n  #mainMenu[_ngcontent-%COMP%] {\n    display: flex;\n    text-align: center;\n    flex-direction: column;\n    flex-wrap: nowrap;\n  }\n\n  header[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%] {\n    background-color: white;\n  }\n\n  nav[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n    color: rgba(0, 0, 0, .6) !important;\n  }\n\n  li.active[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n    color: rgba(0, 0, 0, .6) !important;\n\n  }\n  .img-container[_ngcontent-%COMP%] {\n    position: relative;\n    width: 100%;\n    max-width: 700px;\n\n  }\n  \n  .image[_ngcontent-%COMP%] {\n    width: 100%;\n    height: 720px;\n    display: block;\n    -o-object-fit: cover;\n       object-fit: cover;\n    text-align: center;\n\n  }\n  \n  .text[_ngcontent-%COMP%] {\n    top: 45%;\n    left: 70%;\n    text-align: center;\n    transform: translate(-70%, -10%);\n    width: 100%;\n\n  }\n  \n  #img-head[_ngcontent-%COMP%] {\n    font-size: 20px;\n    line-height: 20px;\n    opacity: 1;\n    color: rgb(255, 255, 255);\n    font-weight: 300;\n    letter-spacing: 1px;\n    text-shadow: rgba(0, 0, 0, 0.15) 2px;\n    background-color: transparent;\n    font-family: 'Raleway' sans-serif;\n  }\n  \n  #img-p[_ngcontent-%COMP%]{\n    font-size: 18px;\n    line-height: 18px;\n    color: rgb(255, 255, 255);\n    font-weight: 300;\n    letter-spacing: 1px;\n    text-shadow: rgba(0, 0, 0, 0.15) 2px;\n    background-color: transparent;\n    font-family: 'Raleway';\n  }\n\n  #carousel-center[_ngcontent-%COMP%]{\n    margin-left: -29%;\n  \n  }\n  ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n    color: #25CBF5 !important;\n    \n}\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "AA6N":
/*!**************************************************************!*\
  !*** ./src/app/update-password/update-password.component.ts ***!
  \**************************************************************/
/*! exports provided: UpdatePasswordComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdatePasswordComponent", function() { return UpdatePasswordComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _common_block_copy_paste_directive__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/block-copy-paste.directive */ "cRXe");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");






function UpdatePasswordComponent_i_34_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 25);
} }
function UpdatePasswordComponent_i_35_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 26);
} }
function UpdatePasswordComponent_div_36_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PASSWORD.ERRORMESSAGE.Required"), " ");
} }
function UpdatePasswordComponent_i_48_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 25);
} }
function UpdatePasswordComponent_i_49_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 26);
} }
function UpdatePasswordComponent_div_50_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PASSWORD.ERRORMESSAGE.Required"), " ");
} }
function UpdatePasswordComponent_div_51_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PASSWORD.ERRORMESSAGE.PasswordValidation"), " ");
} }
function UpdatePasswordComponent_div_52_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PASSWORD.ERRORMESSAGE.newPassword"), " ");
} }
function UpdatePasswordComponent_i_64_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 25);
} }
function UpdatePasswordComponent_i_65_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "i", 26);
} }
function UpdatePasswordComponent_div_66_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PASSWORD.ERRORMESSAGE.Required"), " ");
} }
function UpdatePasswordComponent_div_67_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PASSWORD.ERRORMESSAGE.PasswordValidation"), " ");
} }
function UpdatePasswordComponent_div_68_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "PASSWORD.ERRORMESSAGE.confirmPassword"), " ");
} }
class UpdatePasswordComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj) {
        super(inj);
        this.submitted = false;
        this.passwordData = {};
        this.show = false;
        this.isValue = false;
        this.isShow = false;
    }
    ngOnInit() {
        if (window.opener == null) {
            localStorage.removeItem("evisaCount");
            this.router.navigate(["/home"]);
        }
    }
    updatePassword(form, passwordData) {
        if (form.valid && (this.passwordData.newsecretkey === this.passwordData.confirmNewsecretkey)) {
            setTimeout(() => {
                passwordData.username = this.getToken('username');
                this.commonService.callApi('applicant/updatecredentials', passwordData, 'post', false, false, 'REG').then(success => {
                    this.successData = success;
                    if (this.successData.status === "SUCCESS") {
                        this.router.navigate(["/login"]);
                        this.toastr.success(this.successData.statusDescription, 'Success');
                    }
                    else {
                        this.toastr.error(this.successData.statusDescription, 'Error');
                    }
                }).catch(e => {
                    this.toastr.error(e.error.statusDescription, 'Oops!');
                });
            }, 500);
        }
        else {
            this.submitted = true;
        }
    }
    onClick(type) {
        console.log(type);
        if (type === 'secret') {
            if (this.password === 'password') {
                this.password = 'text';
                this.isValue = true;
            }
            else {
                this.password = 'password';
                this.isValue = false;
            }
        }
        if (type === 'newsecret') {
            if (this.password === 'password') {
                this.password = 'text';
                this.show = true;
            }
            else {
                this.password = 'password';
                this.show = false;
            }
        }
        if (type === 'cnfrmnew') {
            if (this.password === 'password') {
                this.password = 'text';
                this.isShow = true;
            }
            else {
                this.password = 'password';
                this.isShow = false;
            }
        }
    }
}
UpdatePasswordComponent.ɵfac = function UpdatePasswordComponent_Factory(t) { return new (t || UpdatePasswordComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"])); };
UpdatePasswordComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: UpdatePasswordComponent, selectors: [["app-update-password"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 73, vars: 52, consts: [[1, "content"], [1, "logo", "center-block"], ["href", "landing.html"], ["src", "assets/img/evisa.png", "alt", "", 2, "width", "300px"], [2, "text-align", "center"], ["action", "#", 1, "form-horizontal", 3, "ngSubmit"], ["passwordDetails", "ngForm"], [2, "color", "mediumseagreen", "font-size", "13px"], [1, "form-group"], [1, "col-md-5", "control-label"], [1, "required"], [1, "col-md-7"], ["name", "secretKey", "autocomplete", "off", "id", "secretKey", "required", "", 1, "form-control", 3, "placeholder", "type", "ngModel", "ngModelChange"], ["secretKey", "ngModel"], [2, "position", "absolute", "right", "28px", "top", "8px", "cursor", "pointer", 3, "click"], ["class", "fa fa-eye", 4, "ngIf"], ["class", "fa fa-eye-slash", "aria-hidden", "true", 4, "ngIf"], ["class", "error-block ", 4, "ngIf"], ["name", "newsecretkey", "autocomplete", "off", "id", "newsecretkey", "required", "", "pattern", "(?=.*\\d)(?=.*[a-z])(?=.*[@!$*]).{8,20}", "maxlength", "20", "appBlockCopyPaste", "", 1, "form-control", 3, "placeholder", "type", "ngModel", "ngModelChange"], ["newsecretkey", "ngModel"], ["class", "error-block", 4, "ngIf"], ["name", "condirmNewsecretkey", "autocomplete", "off", "id", "confirmNewsecretkey", "pattern", "(?=.*\\d)(?=.*[a-z])(?=.*[@!$*]).{8,20}", "maxlength", "20", "required", "", "appBlockCopyPaste", "", 1, "form-control", 3, "placeholder", "type", "ngModel", "ngModelChange"], ["confirmNewsecretkey", "ngModel"], [1, "form-group", "text-center"], ["type", "submit", 1, "btn", "btn-primary"], [1, "fa", "fa-eye"], ["aria-hidden", "true", 1, "fa", "fa-eye-slash"], [1, "error-block"]], template: function UpdatePasswordComponent_Template(rf, ctx) { if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](0, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "a", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](4, "img", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "h3", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](7, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "form", 5, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngSubmit", function UpdatePasswordComponent_Template_form_ngSubmit_8_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r17); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](9); return ctx.updatePassword(_r0, ctx.passwordData); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "span", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15, "8-20");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](19, "(!, @, $, *)");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](21, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](22, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "label", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](25);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](26, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](27, "span", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](28, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "input", 12, 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function UpdatePasswordComponent_Template_input_ngModelChange_30_listener($event) { return ctx.passwordData.secretKey = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](32, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "span", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function UpdatePasswordComponent_Template_span_click_33_listener() { return ctx.onClick("secret"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](34, UpdatePasswordComponent_i_34_Template, 1, 0, "i", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](35, UpdatePasswordComponent_i_35_Template, 1, 0, "i", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](36, UpdatePasswordComponent_div_36_Template, 3, 3, "div", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](37, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](38, "label", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](39);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](40, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](41, "span", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](42, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](43, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](44, "input", 18, 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function UpdatePasswordComponent_Template_input_ngModelChange_44_listener($event) { return ctx.passwordData.newsecretkey = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](46, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](47, "span", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function UpdatePasswordComponent_Template_span_click_47_listener() { return ctx.onClick("newsecret"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](48, UpdatePasswordComponent_i_48_Template, 1, 0, "i", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](49, UpdatePasswordComponent_i_49_Template, 1, 0, "i", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](50, UpdatePasswordComponent_div_50_Template, 3, 3, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](51, UpdatePasswordComponent_div_51_Template, 3, 3, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](52, UpdatePasswordComponent_div_52_Template, 3, 3, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](53, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](54, "label", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](56, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](57, "span", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](58, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](59, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](60, "input", 21, 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function UpdatePasswordComponent_Template_input_ngModelChange_60_listener($event) { return ctx.passwordData.confirmNewsecretkey = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](62, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](63, "span", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function UpdatePasswordComponent_Template_span_click_63_listener() { return ctx.onClick("cnfrmnew"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](64, UpdatePasswordComponent_i_64_Template, 1, 0, "i", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](65, UpdatePasswordComponent_i_65_Template, 1, 0, "i", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](66, UpdatePasswordComponent_div_66_Template, 3, 3, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](67, UpdatePasswordComponent_div_67_Template, 3, 3, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](68, UpdatePasswordComponent_div_68_Template, 3, 3, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](69, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](70, "button", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](71);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](72, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](31);
        const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](45);
        const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](61);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](7, 30, "PASSWORD.Update Password"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](13, 32, "PASSWORD.Your password"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](17, 34, "PASSWORD.characters"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](", ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](21, 36, "PASSWORD.and must not contain"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](26, 38, "PASSWORD.CurrentPassword"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](32, 40, "PASSWORD.PLACEHOLDER.currentPassword"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("type", ctx.isValue ? "text" : "password")("ngModel", ctx.passwordData.secretKey);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.isValue);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.isValue);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.submitted || _r1.touched) && _r1.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](40, 42, "PASSWORD.New Password"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](46, 44, "PASSWORD.PLACEHOLDER.newPassword"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("type", ctx.show ? "text" : "password")("ngModel", ctx.passwordData.newsecretkey);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.show);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.show);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.submitted || _r5.touched) && _r5.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.submitted || _r5.touched || _r5.dirty) && _r5.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.submitted || _r5.touched || _r5.dirty) && _r5.valid && ctx.passwordData.secretKey == ctx.passwordData.newsecretkey);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](56, 46, "PASSWORD.Confirm New Password"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](62, 48, "PASSWORD.PLACEHOLDER.confirmPassword"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("type", ctx.isShow ? "text" : "password")("ngModel", ctx.passwordData.confirmNewsecretkey);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.isShow);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.isShow);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.submitted || _r11.touched) && _r11.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.submitted || _r11.touched || _r11.dirty) && _r11.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.submitted || _r11.touched || _r11.dirty) && _r11.valid && ctx.passwordData.confirmNewsecretkey != ctx.passwordData.newsecretkey);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](72, 50, "LOGIN.Submit"));
    } }, directives: [_angular_forms__WEBPACK_IMPORTED_MODULE_2__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["NgForm"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["RequiredValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["NgModel"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["PatternValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_2__["MaxLengthValidator"], _common_block_copy_paste_directive__WEBPACK_IMPORTED_MODULE_4__["BlockCopyPasteDirective"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslatePipe"]], styles: [".content[_ngcontent-%COMP%]{   \n    background-color: #fff;\n    width: 50%;\n    margin:auto;\n    margin-bottom: 0px;\n    margin-right: 330px;\n    margin-top: 40px;\n    padding: 30px;\n    padding-top: 0px;\n    padding-bottom: 15px;\n    border-radius: 30px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInVwZGF0ZS1wYXNzd29yZC5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0lBQ0ksc0JBQXNCO0lBQ3RCLFVBQVU7SUFDVixXQUFXO0lBQ1gsa0JBQWtCO0lBQ2xCLG1CQUFtQjtJQUNuQixnQkFBZ0I7SUFDaEIsYUFBYTtJQUNiLGdCQUFnQjtJQUNoQixvQkFBb0I7SUFDcEIsbUJBQW1CO0FBQ3ZCIiwiZmlsZSI6InVwZGF0ZS1wYXNzd29yZC5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmNvbnRlbnR7ICAgXG4gICAgYmFja2dyb3VuZC1jb2xvcjogI2ZmZjtcbiAgICB3aWR0aDogNTAlO1xuICAgIG1hcmdpbjphdXRvO1xuICAgIG1hcmdpbi1ib3R0b206IDBweDtcbiAgICBtYXJnaW4tcmlnaHQ6IDMzMHB4O1xuICAgIG1hcmdpbi10b3A6IDQwcHg7XG4gICAgcGFkZGluZzogMzBweDtcbiAgICBwYWRkaW5nLXRvcDogMHB4O1xuICAgIHBhZGRpbmctYm90dG9tOiAxNXB4O1xuICAgIGJvcmRlci1yYWRpdXM6IDMwcHg7XG59Il19 */"] });


/***/ }),

/***/ "AytR":
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/*! exports provided: environment */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "environment", function() { return environment; });
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
// export const environment = {
//   production: false,
//   stripe: 'pk_test_51IS2RDErV2ejINDYYLbdrNrP7MtaU3XYSlDl2U5FbZKCnMe3mmjF0jeRIJmW8WDM9my7o5gaXavu3eYelp3VFjzi00nd696K5Q',
//   serverUrl: 'http://localhost:8081/applicant-api/v1/api/payment/charge',
// };
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/dist/zone-error';  // Included with Angular CLI.
const environment = {
    production: true,
    /* stripe_key: 'pk_test_51IS2RDErV2ejINDYYLbdrNrP7MtaU3XYSlDl2U5FbZKCnMe3mmjF0jeRIJmW8WDM9my7o5gaXavu3eYelp3VFjzi00nd696K5Q', */
    stripe_key: 'pk_live_51LcpdGIn53euoVYlqrPY2pkiwWinFKx5oKwrPBT3SUcP0uPge2ND0WGDSG17MD7gqnB2pDLrSlPS1u9ur7T0sabO00n3n2dsdl',
    //stripe_key: 'pk_test_51MzbEFHhAOKhLI4yrvoddWpsZY8eEIKL28XZ3kXUtggxjdvLnkEW1MnCjUiMzc9l2LTuOZHMpbwbqMad7YjM5abQ00cKAVXu1V',
    //Strip EvisaDGPN Prod Mode
    // stripe_key: 'pk_live_51PKbmaCk3phQxdKylkJZlUl13H6rTr9aEIWmmF1frQn2lcKBzp3fsar0JCZMs7UWZ58wWN6NExtumqAhzgSObG6H00gTCtdXVI',
    //Strip Evisa version 2 PROD
    // stripe_key:'pk_live_51QclGMDkTELGuZ01fSak3yGnFbkDeRKuq7zolp3OAsWZHmGBpkN4pWCiSGnYyVZCN62PgjRtLspjtIZCML0qdjHF00PPQdIzK1',
    // serverUrl: 'http://localhost:8081/applicant-api/v1/api/payment/checkout' //localhost
    serverUrl: 'https://www.evisa.gouv.dj/applicant-api/v1/api/payment/checkout' //localhost
    // serverUrl: window.location.href.split('#')[0]+'v1/api/payment/checkout' // server
    // urlpayementPenality: 'http://localhost:8081/applicant-api/v1/api/applyoverstay'
};


/***/ }),

/***/ "CTGF":
/*!****************************************************************************************!*\
  !*** ./src/app/main/apply-visa-extension/apply-visa-edit/apply-visa-edit.component.ts ***!
  \****************************************************************************************/
/*! exports provided: ApplyVisaEditComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApplyVisaEditComponent", function() { return ApplyVisaEditComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @stripe/stripe-js */ "v4r+");
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var ngx_bootstrap_datepicker__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ngx-bootstrap/datepicker */ "hzby");
/* harmony import */ var _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ng-select/ng-select */ "ZOsW");
/* harmony import */ var ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ngx-bootstrap/tooltip */ "Mfq2");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");













const _c0 = ["takeInput"];
function ApplyVisaEditComponent_div_72_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "ERRORS.requiredField"), " ");
} }
function ApplyVisaEditComponent_div_82_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "ERRORS.requiredField"), " ");
} }
function ApplyVisaEditComponent_div_93_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "ERRORS.requiredField"), " ");
} }
function ApplyVisaEditComponent_div_94_div_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](2, 1, "ERRORS.requiredField"), " ");
} }
function ApplyVisaEditComponent_div_94_Template(rf, ctx) { if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "label", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "*");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "textarea", 47, 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_div_94_Template_textarea_ngModelChange_7_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r15); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](); return ctx_r14.extensionVisa.otherRemarks = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10, "                                ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](11, ApplyVisaEditComponent_div_94_div_11_Template, 3, 3, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](8);
    const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](3, 4, "EXTENSIONVISA.MotivatesRemarks"));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 6, "EXTENSIONVISA.MotivatesRemarks"));
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngModel", ctx_r8.extensionVisa.otherRemarks);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (ctx_r8.submitted || _r12.touched) && _r12.invalid);
} }
function ApplyVisaEditComponent_div_115_tr_11_Template(rf, ctx) { if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](5, "number");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "a", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ApplyVisaEditComponent_div_115_tr_11_Template_a_click_7_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20); const i_r18 = ctx.index; const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"](2); return ctx_r19.deleteDoc(i_r18); });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](8, "i", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](9, "\u00A0 ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r17 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](data_r17 == null ? null : data_r17.name);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind2"](5, 2, (data_r17 == null ? null : data_r17.size) / 1024, "1.0-0"));
} }
function ApplyVisaEditComponent_div_115_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 49);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "table", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "thead");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "Name");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](7, "Size (KB)");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](8, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](9, "Action");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](10, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](11, ApplyVisaEditComponent_div_115_tr_11_Template, 10, 5, "tr", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx_r11.AttachedFiles);
} }
const _c1 = function () { return ["/main/dashboard"]; };
const _c2 = function () { return ["/main/evisa-extension/apply-visa-list"]; };
class ApplyVisaEditComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__["BaseComponent"] {
    constructor(inj, datepipe, ngxLoader) {
        super(inj);
        this.datepipe = datepipe;
        this.ngxLoader = ngxLoader;
        this.attachmentCount = 0;
        this.extensionVisa = {};
        this.attachedFileSize = false;
        this.AttachedFiles = [];
        this.fileInfo = {};
        this.submitted = false;
        this.colorTheme = 'theme-blue';
        this.datePickerConfig = {
            dateInputFormat: 'DD-MM-YYYY',
            containerClass: this.colorTheme,
            showWeekNumbers: false,
        };
        this.applyVisaTypes = [];
        this.applicantNo = this.getToken('applicantNo');
        this.passport = this.getToken('passport');
        this.givenName = this.getToken('givenName');
        this.fileNumber = this.getToken('fileNumber');
        this.emailId = this.getToken('emailId');
        this.VisaDate = this.getToken('VisaDate');
        this.isOther = false;
        this.selectedFiles = [];
    }
    ngOnInit() {
        this.VisaDate = new Date(this.VisaDate);
        this.extensionVisa.totalAmount = 0;
        this.extensionVisa.penalityAmount = 0;
        this.getVisaExtensionType();
        this.getExtension('EXTRS');
    }
    submitForm(form, extensionVisa) {
        extensionVisa = {
            "applicationNumber": this.applicantNo,
            "daysOfExtension": this.duration,
            "penalityAmount": 0,
            "reasonsForExtension": extensionVisa.reasonsForExtension,
            "status": "PP",
            "totalAmount": extensionVisa.totalAmount,
            "username": this.getToken('username'),
            "visaType": this.extensionVisa.daysOfExtension,
            "previousExpiryDate": this.VisaDate
        };
        if (form.valid) {
            this.loading = true;
            this.ngxLoader.start();
            const uploadData = new FormData();
            const sendData = {
                "applicationNumber": this.applicantNo,
                "daysOfExtension": this.duration,
                "penalityAmount": 0,
                "reasonsForExtension": extensionVisa.reasonsForExtension,
                "totalAmount": extensionVisa.totalAmount,
                "username": this.getToken('username'),
                "visaType": this.extensionVisa.daysOfExtension,
                "previousExpiryDate": this.VisaDate,
            };
            if (extensionVisa.reasonsForExtension === 'OTH') {
                sendData['otherRemarks'] = extensionVisa.otherRemarks;
            }
            const resdata = new Blob([JSON.stringify(sendData)], {
                type: 'application/json',
            });
            uploadData.append("file", this.AttachedFiles[0]);
            uploadData.append('ApplicantVisaExtension', resdata);
            setTimeout(() => {
                this.commonService.callApi('applyvisaextension', uploadData, 'post', false, false, 'REG').then((success) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
                    let successData = success;
                    this.loading = false;
                    this.ngxLoader.stop();
                    if (successData.statusCode === "SUCCESS") {
                        this.toastr.success('Success');
                        let stripePromise = Object(_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__["loadStripe"])(src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].stripe_key);
                        // Call your backend to create the Checkout session.
                        // When the customer clicks on the button, redirect them to Checkout.
                        const stripe = yield stripePromise;
                        const result = stripe.redirectToCheckout({
                            sessionId: successData.refId,
                        });
                    }
                    else {
                        this.toastr.error(successData.statusDesc, 'Oops!');
                    }
                })).catch(e => {
                    this.toastr.error(e.message, 'Oops!');
                });
            }, 1500);
        }
        else {
            this.submitted = true;
            console.log("else block ");
        }
    }
    selectVisa(e) {
        console.log(e);
        this.extensionVisa.totalAmount = e.visaFee;
        this.duration = e.visaDuration;
    }
    getVisaExtensionType() {
        this.commonService.callApi('visadetails/extension', '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.applyVisaTypes = successData.masterCodeResultDTOs;
            console.log(this.applyVisaTypes);
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    selectReason(e) {
        if (e.code === 'OTH') {
            this.isOther = true;
        }
        else {
            this.isOther = false;
        }
    }
    payloadUpload(event) {
        let reader = new FileReader();
        // when the load event is fired and the file not empty
        if (event.target.files && event.target.files.length > 0) {
            // Fill file variable with the file content
            if (!this.validateFile(event.target.files[0].name)) {
                this.toastr.error("error", "selected file format is not supported");
                return false;
            }
            if (this.validateSize(event.target.files[0].size)) {
                this.toastr.error("error", "file size exceeds limit");
                return false;
            }
            for (let i = 0; i < event.target.files.length; i++) {
                this.AttachedFiles.push(event.target.files[i]);
            }
        }
    }
    validateFile(name) {
        var ext = name.substring(name.lastIndexOf('.') + 1);
        if ((ext.toLowerCase() == 'jpeg') || (ext.toLowerCase() == 'png') || (ext.toLowerCase() == 'pdf') || (ext.toLowerCase() == 'jpg')) {
            return true;
        }
        else {
            return false;
        }
    }
    validateSize(size) {
        this.attachmentCount = 0;
        this.attachmentCount = this.attachmentCount + size;
        console.log(this.attachmentCount);
        if (this.attachmentCount > 2000000) {
            return true;
        }
        else {
            return false;
        }
    }
    deleteDoc(index) {
        //this.payloadCount = 0;
        this.AttachVar.nativeElement.value = "";
        this.fileInfo.fileattach = '';
        // this.payLoadFileSize=false;
        this.AttachedFiles.splice(index, 1);
    }
}
ApplyVisaEditComponent.ɵfac = function ApplyVisaEditComponent_Factory(t) { return new (t || ApplyVisaEditComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_5__["DatePipe"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](ngx_ui_loader__WEBPACK_IMPORTED_MODULE_6__["NgxUiLoaderService"])); };
ApplyVisaEditComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: ApplyVisaEditComponent, selectors: [["app-apply-visa-edit"]], viewQuery: function ApplyVisaEditComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_c0, 1);
    } if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.AttachVar = _t.first);
    } }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 126, vars: 90, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], ["href", "javascript:;", 3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "portlet-body", "form"], [1, "form-horizontal", 3, "ngSubmit"], ["visaExtensionForm", "ngForm"], [1, "form-body"], [1, "form-group"], [1, "col-md-3", "control-label"], [1, "col-md-4"], ["type", "text", "name", "applicantNo", 1, "form-control", 3, "ngModel", "disabled", "ngModelChange"], ["type", "text", "name", "givenName", 1, "form-control", 3, "ngModel", "disabled", "ngModelChange"], ["type", "text", "name", "fileNumber", 1, "form-control", 3, "ngModel", "disabled", "ngModelChange"], ["type", "text", "name", "passport", 1, "form-control", 3, "ngModel", "disabled", "ngModelChange"], ["type", "text", "name", "emailId", 1, "form-control", 3, "ngModel", "disabled", "ngModelChange"], ["type", "text", "bsDatepicker", "", "id", "previousApproval", "name", "previousApproval", 1, "form-control", 3, "disabled", "ngModel", "bsConfig", "ngModelChange"], ["previousApproval", "ngModel"], [1, "required"], ["bindLabel", "description", "bindValue", "code", "name", "daysOfExtension", "id", "daysOfExtension", "required", "", 1, "chosen-select", 3, "items", "placeholder", "clearable", "searchable", "ngModel", "dropdownPosition", "change", "ngModelChange"], ["daysOfExtension", "ngModel"], ["class", "error-block", 4, "ngIf"], ["type", "text", "disabled", "", "id", "totalAmount", "name", "totalAmount", "required", "", 1, "form-control", 3, "ngModel", "ngModelChange"], ["totalAmount", "ngModel"], ["bindLabel", "description", "bindValue", "code", "name", "reasonsForExtension", "id", "reasonsForExtension", "required", "", 1, "chosen-select", 3, "items", "placeholder", "clearable", "searchable", "ngModel", "dropdownPosition", "change", "ngModelChange"], ["reasonsForExtension", "ngModel"], ["class", "form-group", 4, "ngIf"], [1, "btn", "btn-info", 2, "cursor", "pointer", 3, "click"], [1, "fa", "fa-plus"], ["hidden", "", "type", "File", "name", "fileattach", "placeholder", "File", "accept", ".pdf,.png,.jpg,.jpeg", "id", "fileattach", 2, "display", "none", 3, "disabled", "ngModel", "ngModelChange", "change"], ["takeInput", "", "fileattach", "ngModel"], [1, "item", "form-group"], [1, "col-form-label", "col-md-3", "col-sm-3", "label-align"], [1, "col-md-5", "col-sm-5"], ["class", "table-responsive", 4, "ngIf"], [1, "form-actions", "fluid"], [1, "text-center"], ["type", "submit", 1, "btn", "blue"], ["type", "button", 1, "btn", "default", 3, "routerLink"], ["hasProgressBar", "true", "fgsType", "three-strings"], [1, "error-block"], ["id", "otherRemarks", "name", "otherRemarks", "rows", "3", "required", "", 1, "form-control", 3, "placeholder", "ngModel", "ngModelChange"], ["otherRemarks", "ngModel"], [1, "table-responsive"], ["id", "sample_editable_1", 1, "styled-table"], [4, "ngFor", "ngForOf"], ["href", "javascript:;", "tooltip", "Delete", 3, "click"], [1, "fa", "fa-trash-o", "delete"]], template: function ApplyVisaEditComponent_Template(rf, ctx) { if (rf & 1) {
        const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](16, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](17, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](21, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](22, "form", 11, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngSubmit", function ApplyVisaEditComponent_Template_form_ngSubmit_22_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r21); const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](23); return ctx.submitForm(_r0, ctx.extensionVisa); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](24, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](25, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](26, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](29, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](30, "input", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_30_listener($event) { return ctx.applicantNo = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](31, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](32, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](35, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](36, "input", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_36_listener($event) { return ctx.givenName = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](37, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](38, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](39);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](40, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](41, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](42, "input", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_42_listener($event) { return ctx.fileNumber = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](43, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](44, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](45);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](46, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](47, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](48, "input", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_48_listener($event) { return ctx.passport = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](49, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](50, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](51);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](52, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](53, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](54, "input", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_54_listener($event) { return ctx.emailId = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](55, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](56, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](57);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](58, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](59, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](60, "input", 22, 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_60_listener($event) { return ctx.VisaDate = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](62, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](63, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](64);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](65, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](66, "span", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](67, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](68, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](69, "ng-select", 25, 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("change", function ApplyVisaEditComponent_Template_ng_select_change_69_listener($event) { return ctx.selectVisa($event); })("ngModelChange", function ApplyVisaEditComponent_Template_ng_select_ngModelChange_69_listener($event) { return ctx.extensionVisa.daysOfExtension = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](71, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](72, ApplyVisaEditComponent_div_72_Template, 3, 3, "div", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](73, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](74, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](75);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](76, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](77, "span", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](78, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](79, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](80, "input", 28, 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_80_listener($event) { return ctx.extensionVisa.totalAmount = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](82, ApplyVisaEditComponent_div_82_Template, 3, 3, "div", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](83, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](84, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](85);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](86, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](87, "span", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](88, "*");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](89, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](90, "ng-select", 30, 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("change", function ApplyVisaEditComponent_Template_ng_select_change_90_listener($event) { return ctx.selectReason($event); })("ngModelChange", function ApplyVisaEditComponent_Template_ng_select_ngModelChange_90_listener($event) { return ctx.extensionVisa.reasonsForExtension = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](92, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](93, ApplyVisaEditComponent_div_93_Template, 3, 3, "div", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](94, ApplyVisaEditComponent_div_94_Template, 12, 8, "div", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](95, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](96, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](97);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](98, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](99, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](100, "span", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function ApplyVisaEditComponent_Template_span_click_100_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r21); const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](105); return _r9.click(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](101, "i", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](102, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](103, "\u00A0Add");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](104, "input", 35, 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngModelChange", function ApplyVisaEditComponent_Template_input_ngModelChange_104_listener($event) { return ctx.fileInfo.fileattach = $event; })("change", function ApplyVisaEditComponent_Template_input_change_104_listener($event) { return ctx.payloadUpload($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](107, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](108, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](109, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](110, "Note :");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](111);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](112, "div", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](113, "label", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](114, "div", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](115, ApplyVisaEditComponent_div_115_Template, 12, 1, "div", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](116, "div", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](117, "div", 42);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](118, "button", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](119);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](120, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](121, "\u00A0\u00A0 ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](122, "button", 44);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](123);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](124, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](125, "ngx-ui-loader", 45);
    } if (rf & 2) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](70);
        const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](81);
        const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](91);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 52, "EXTENSIONVISA.Apply Visa Extension"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](88, _c1));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 54, "APPLICATIONSPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](13, 56, "EXTENSIONVISA.Apply Visa Extension"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](20, 58, "EXTENSIONVISA.Renewal Of Visa"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](28, 60, "EXTENSIONVISA.Applicant Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngModel", ctx.applicantNo)("disabled", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](34, 62, "EXTENSIONVISA.Given Name"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngModel", ctx.givenName)("disabled", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](40, 64, "EXTENSIONVISA.File Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngModel", ctx.fileNumber)("disabled", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](46, 66, "EXTENSIONVISA.Passport"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngModel", ctx.passport)("disabled", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](52, 68, "EXTENSIONVISA.Email Id"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngModel", ctx.emailId)("disabled", true);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](58, 70, "EXTENSIONVISA.Previous Approval Date Visa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("disabled", true)("ngModel", ctx.VisaDate)("bsConfig", ctx.datePickerConfig);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](65, 72, "EXTENSIONVISA.Period Visa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](71, 74, "EXTENSIONVISA.Period Visa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("items", ctx.applyVisaTypes)("clearable", true)("searchable", false)("ngModel", ctx.extensionVisa.daysOfExtension)("dropdownPosition", "auto");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (ctx.submitted || _r2.touched) && _r2.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](76, 76, "EXTENSIONVISA.Total Amount"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngModel", ctx.extensionVisa.totalAmount);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (ctx.submitted || _r4.touched) && _r4.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](86, 78, "EXTENSIONVISA.Motivates"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpropertyInterpolate"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](92, 80, "EXTENSIONVISA.Motivates"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("items", ctx.extensionDetails)("clearable", true)("searchable", false)("ngModel", ctx.extensionVisa.reasonsForExtension)("dropdownPosition", "auto");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (ctx.submitted || _r6.touched) && _r6.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.isOther);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](98, 82, "EXTENSIONVISA.Attachment"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("disabled", ctx.AttachedFiles.length)("ngModel", ctx.fileInfo.fileattach);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", "Max File Size = 2MB, Accepted File Type = jpg/jpeg/png/pdf", " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.AttachedFiles.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](120, 84, "EXTENSIONVISA.Submit"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](89, _c2));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](124, 86, "ManageApplication.Cancel"));
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_7__["RouterLinkWithHref"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgForm"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgModel"], ngx_bootstrap_datepicker__WEBPACK_IMPORTED_MODULE_9__["BsDatepickerInputDirective"], ngx_bootstrap_datepicker__WEBPACK_IMPORTED_MODULE_9__["BsDatepickerDirective"], _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_10__["NgSelectComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["RequiredValidator"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgIf"], _angular_router__WEBPACK_IMPORTED_MODULE_7__["RouterLink"], ngx_ui_loader__WEBPACK_IMPORTED_MODULE_6__["ɵb"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgForOf"], ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_11__["TooltipDirective"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__["TranslatePipe"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["DecimalPipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJhcHBseS12aXNhLWVkaXQuY29tcG9uZW50LmNzcyJ9 */"] });


/***/ }),

/***/ "NJ78":
/*!***************************************************!*\
  !*** ./src/app/main/payment/payment.component.ts ***!
  \***************************************************/
/*! exports provided: PaymentComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PaymentComponent", function() { return PaymentComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @stripe/stripe-js */ "v4r+");
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");







const _c0 = function () { return ["/main/dashboard"]; };
class PaymentComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__["BaseComponent"] {
    constructor(inj) {
        super(inj);
        this.stripePromise = Object(_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__["loadStripe"])(src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].stripe_key);
    }
    checkout(e) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            // Call your backend to create the Checkout session.
            // When the customer clicks on the button, redirect them to Checkout.
            const stripe = yield this.stripePromise;
            let tmpamt = this.getToken('charge').split(" ")[0];
            console.log(this.getToken("visaType"));
            console.log(this.getToken("expressVisa"));
            const payment = {
                amount: tmpamt * 100,
                // ici d'après stripe product il y a une variable quantité pour mle nom de visa demander
                referenceNumber: this.getToken('fileNumber'),
                // cancelUrl: 'http://87.106.107.227/applicant-api/#/main/dashboard',
                // successUrl: 'http://87.106.107.227/applicant-api/#/main/success-payment',
                //cancelUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/dashboard',
                //successUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/success-payment',
                // cancelUrl: 'http://localhost:4200/#/main/dashboard',
                // successUrl: 'http://localhost:4200/#/main/success-payment',
                cancelUrl: 'https://eastbleu.org/#/main/dashboard',
                successUrl: 'https://eastbleu.org/#/main/success-payment',
                // cancelUrl: 'http://217.160.99.180/applicant-api/cancel',
                // successUrl: 'http://217.160.99.180/applicant-api/#/main/success-payment',
                // cancelUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/dashboard',
                // successUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/success-payment',
                instrType: 'EVISA_PAY'
            };
            // this is a normal http calls for a backend api
            this.http
                .post(`${src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].serverUrl}`, payment)
                .subscribe((data) => {
                // I use stripe to redirect To Checkout page of Stripe platform
                // stripe.redirectToCheckout({
                //   sessionId: data.refId,
                // }); 
                const result = stripe.redirectToCheckout({
                    sessionId: data.refId,
                });
                //console.log(result);
            });
        });
    }
    ngOnInit() {
        //this.invokeStripe();
        if (this.getToken("visaType") == "CS30") {
            if (this.getToken("expressVisa")) {
                this.setToken("expressTva", (173 * 0.10).toFixed(1));
            }
            else {
                this.setToken("tva", (23 * 0.10).toFixed(1));
            }
        }
        else {
            if (this.getToken("expressVisa")) {
                this.setToken("expressTva", (164 * 0.10).toFixed(1));
            }
            else {
                this.setToken("tva", (14 * 0.10).toFixed(1));
            }
        }
    }
    invokeStripe() {
        if (!window.document.getElementById('checkout-button')) {
            const script = window.document.createElement('script');
            script.id = 'checkout-button';
            script.type = 'text/javascript';
            script.src = 'https://js.stripe.com/v3/';
            window.document.body.appendChild(script);
        }
    }
    makePayment(amount) {
        // const paymentHandler = (<any>window).StripeCheckout.configure({
        //   key:
        //     'pk_test_51IS2RDErV2ejINDYYLbdrNrP7MtaU3XYSlDl2U5FbZKCnMe3mmjF0jeRIJmW8WDM9my7o5gaXavu3eYelp3VFjzi00nd696K5Q',
        //   locale: 'auto',
        //   token: function (stripeToken: any) {
        //     //console.log(stripeToken.card);
        //     //console.log(stripeToken)
        //     this.tokenData = stripeToken.card
        //     const url = 'http://localhost:8081/applicant-api/v1/api/payment/charge';
        //      let amt:any=sessionStorage.getItem("charge").split(" ")[0]
        //      let senddata = {
        //         "amount":amt*100,
        //         "currency": "USD",
        //         "referenceNumber":sessionStorage.getItem("fileNumber"),
        //         "recieptMail":stripeToken.card.name,
        //         "stripeEmail":stripeToken.card.name,
        //         "stripeToken":stripeToken.id
        //     }
        //     var request = new Request(url,{
        //       method: 'POST',
        //       body: JSON.stringify(senddata),
        //       headers: new Headers({'content-type': 'application/json'}),
        //     });
        //     fetch(request)
        //       .then(function (res) {
        //         // Handle response we get from the AP
        //         //console.log(res);
        //       })
        //   },
        // });
        // paymentHandler.open({
        //   name: 'Evisa Payment',
        //   description: '',
        //   amount: amount * 100,
        // });
        // //console.log(this.tokenData)
    }
}
PaymentComponent.ɵfac = function PaymentComponent_Factory(t) { return new (t || PaymentComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["Injector"])); };
PaymentComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: PaymentComponent, selectors: [["app-payment"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 71, vars: 27, consts: [["id", "portlet-config", "tabindex", "-1", "role", "dialog", "aria-labelledby", "myModalLabel", "aria-hidden", "true", 1, "modal", "fade"], [1, "modal-dialog"], [1, "modal-content"], [1, "modal-header"], ["type", "button", "data-dismiss", "modal", "aria-hidden", "true", 1, "close"], [1, "modal-title"], [1, "modal-body"], [1, "modal-footer"], ["type", "button", 1, "btn", "blue"], ["type", "button", "data-dismiss", "modal", 1, "btn", "default"], [1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [1, "fa", "fa-home"], ["href", "applicationsListAPP.html"], [1, "fa", "fa-angle-right"], ["href", "#"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], [1, "portlet-body"], [1, "alert", "alert-block", "alert-info", "fade", "in"], ["type", "button", "data-dismiss", "alert", 1, "close"], ["href", "javascript:;", 1, "btn", "green", 3, "click"], ["href", "javacript:;", 1, "btn", "btn-link", 3, "routerLink"]], template: function PaymentComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](4, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "h4", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](6, "Modal title");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8, " Widget settings form goes here ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](10, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](11, "Save changes");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](13, "Close");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](16, "h3", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](17, " eVisa Application ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "ul", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](19, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](20, "i", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](21, "a", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](22, "Home");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](23, "i", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](24, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](25, "eVisa");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](26, "i", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](27, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](28, "a", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](29, "Apply");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](30, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](31, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](32, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](33, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](34, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](35, "Notification");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](36, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](37, "div", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](38, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](39, "button", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](40, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](41, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](42);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](43, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](44);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](45, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](46, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](47, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](48);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](49, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](50, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](51, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](52, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](53);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](54, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](55, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](56, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](57);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](58, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](59, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](60, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](61);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](62, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](63, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](64, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](65, "a", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PaymentComponent_Template_a_click_65_listener($event) { return ctx.checkout($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](66);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](67, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](68, "a", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](69);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](70, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](42);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](43, 10, "PAYMENT.fileref"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](ctx.getToken("appNo"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate2"]("", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](49, 12, "PAYMENT.visaCharge").replace(":amount", ctx.getToken("charge")), "", ctx.getToken("expressVisa") == "true" ? " " + _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](50, 14, "PAYMENT.expressCharges") : "", "");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](54, 16, "PAYMENT.information2"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](58, 18, "PAYMENT.information3"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](62, 20, "PAYMENT.information4"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](67, 22, "PAYMENT.makepayement"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](26, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](70, 24, "PAYMENT.later"));
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_5__["RouterLinkWithHref"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__["TranslatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJwYXltZW50LmNvbXBvbmVudC5jc3MifQ== */"] });


/***/ }),

/***/ "QSRU":
/*!*******************************************!*\
  !*** ./src/app/common/commonComponent.ts ***!
  \*******************************************/
/*! exports provided: BaseComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BaseComponent", function() { return BaseComponent; });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/platform-browser */ "jhN1");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var ngx_toastr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-toastr */ "5eHb");
/* harmony import */ var _common_BroadCaster__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/BroadCaster */ "oKSk");
/* harmony import */ var _common_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./common.service */ "mPL+");
/* harmony import */ var _errorMessages__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./errorMessages */ "WP+w");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");











class BaseComponent {
    constructor(injector) {
        this.Environments = [];
        this.Categories = [];
        this.Status = [];
        this.projects = [];
        this.AlertGroups = [];
        this.Fprojects = [];
        this.FCategories = [];
        this.FEnvironments = [];
        this.FStatus = [];
        this.router = injector.get(_angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]);
        this.platformId = injector.get(_angular_core__WEBPACK_IMPORTED_MODULE_2__["PLATFORM_ID"]);
        this.appId = injector.get(_angular_core__WEBPACK_IMPORTED_MODULE_2__["APP_ID"]);
        this.commonService = injector.get(_common_service__WEBPACK_IMPORTED_MODULE_7__["CommonService"]);
        this.errorMessage = injector.get(_errorMessages__WEBPACK_IMPORTED_MODULE_8__["ErrorMessages"]);
        this.http = injector.get(_angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpClient"]);
        this.titleService = injector.get(_angular_platform_browser__WEBPACK_IMPORTED_MODULE_3__["Title"]);
        this.metaService = injector.get(_angular_platform_browser__WEBPACK_IMPORTED_MODULE_3__["Meta"]);
        this.activatedRoute = injector.get(_angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"]);
        this.translate = injector.get(_ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__["TranslateService"]);
        this.translate.use(localStorage.getItem('Language'));
        this.brodcaster = injector.get(_common_BroadCaster__WEBPACK_IMPORTED_MODULE_6__["Broadcaster"]);
        this.toastr = injector.get(ngx_toastr__WEBPACK_IMPORTED_MODULE_5__["ToastrService"]);
        // this.brodcaster = injector.get(Broadcaster)
        this.baseUrl = this.commonService._apiUrl;
        //console.log('Your current Environment is :', environment)
        //this.getMasterDetails();
    }
    // *************************************************************//
    //@Purpose : We can use following function to use localstorage
    //*************************************************************//
    setToken(key, value) {
        if (Object(_angular_common__WEBPACK_IMPORTED_MODULE_0__["isPlatformBrowser"])(this.platformId)) {
            window.sessionStorage.setItem(key, value);
        }
    }
    getToken(key) {
        if (Object(_angular_common__WEBPACK_IMPORTED_MODULE_0__["isPlatformBrowser"])(this.platformId)) {
            return window.sessionStorage.getItem(key);
        }
    }
    removeToken(key) {
        if (Object(_angular_common__WEBPACK_IMPORTED_MODULE_0__["isPlatformBrowser"])(this.platformId)) {
            window.sessionStorage.removeItem(key);
        }
    }
    clearToken() {
        if (Object(_angular_common__WEBPACK_IMPORTED_MODULE_0__["isPlatformBrowser"])(this.platformId)) {
            window.sessionStorage.clear();
        }
    }
    //*************************************************************//
    //*************************************************************//
    //@Purpose : We can use following function to use Toaster Service.
    //*************************************************************//
    popToast(type, title, refer) {
        if (refer) {
            // swal.fire({
            //   position: 'center',
            //   type: type,
            //   text: title,
            //   showConfirmButton: false,
            //   timer: 4000,
            //   customClass :'custom-toaster'
            // })
        }
        else {
            // swal.fire({
            //   position:'center',
            //   type: type,
            //   text: title,
            //   showConfirmButton: false,
            //   timer: 1800,
            //   customClass :'custom-toaster'
            // })
        }
    }
    /****************************************************************************
    @PURPOSE      : To restrict or allow some values in input.
    @PARAMETERS   : $event
    @RETURN       : Boolen
    ****************************************************************************/
    RestrictSpace(e) {
        if (e.keyCode == 32) {
            return false;
        }
        else {
            return true;
        }
    }
    AllowNumbers(e) {
        var input;
        if (e.metaKey || e.ctrlKey) {
            return true;
        }
        if (e.which === 32) {
            return false;
        }
        if (e.which === 0) {
            return true;
        }
        if (e.which < 33) {
            return true;
        }
        if (e.which === 43 || e.which === 45) {
            return true;
        }
        input = String.fromCharCode(e.which);
        return !!/[\d\s]/.test(input);
    }
    AllowChar(e) {
        if ((e.keyCode > 64 && e.keyCode < 91) || (e.keyCode > 96 && e.keyCode < 123) || e.keyCode == 8) {
            return true;
        }
        else {
            return false;
        }
    }
    omit_special_char(event) {
        var k;
        k = event.charCode; //         k = event.keyCode;  (Both can be used)
        return ((k > 64 && k < 91) || (k > 96 && k < 123) || k == 8 || k == 32 || (k >= 48 && k <= 57));
    }
    /****************************************************************************/
    logout() {
        this.clearToken();
        localStorage.removeItem("accessToken");
        localStorage.removeItem("getPage");
        console.log('logout called ');
        this.router.navigate(["/login"]);
    }
    /****************************************************************************
    @PURPOSE      : To show validation message
    @PARAMETERS   : <field_name, errorObj?>
    @RETURN       : error message.
    ****************************************************************************/
    showError(field, errorObj) {
        return this.errorMessage.getError(field, errorObj);
    }
    /****************************************************************************/
    getProfile() {
        var url = this.getToken('profilePic');
        if (url == null || url == ' ' || url == 'null') {
            return 'assets/images/no-image-user.png';
        }
        else {
            return url;
        }
    }
    /****************************************************************************
  //For Date Format (YYYY-MM-DD)
  /****************************************************************************/
    convertDateFormat(date) {
        try {
            var day = date.getUTCDate() + 1;
            var month = date.getMonth() + 1;
            var year = date.getFullYear();
            var displayDay;
            var displayMonth;
            if (day < 10) {
                displayDay = '0' + '' + day.toString();
            }
            else {
                displayDay = day;
            }
            if (month < 10) {
                displayMonth = '0' + '' + month.toString();
            }
            else {
                displayMonth = month;
            }
            return year + '-' + displayMonth + '-' + displayDay;
        }
        catch (e) {
            return date;
        }
    }
    getVisaDescription(code) {
        this.commonService.callApi('visadetailsbyvisatype/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.visaDescription = successData.description;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getCountrys(code) {
        this.commonService.callApi('mastercode/active/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.countryDetails = successData.masterCodeResultDTOs;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getNationalities(code) {
        this.commonService.callApi('mastercode/active/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.nationalityDetails = successData.masterCodeResultDTOs;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getLanguages(code) {
        this.commonService.callApi('mastercode/active/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.languageDetails = successData.masterCodeResultDTOs;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getTraveldetails(code) {
        this.commonService.callApi('mastercode/active/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.travelDetails = successData.masterCodeResultDTOs;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getLocationdetails(code) {
        this.commonService.callApi('mastercode/active/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.locationDetails = successData.masterCodeResultDTOs;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getMarital(code) {
        this.commonService.callApi('mastercode/active/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.maritalDetails = successData.masterCodeResultDTOs;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getExtension(code) {
        this.commonService.callApi('mastercode/active/' + code, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.extensionDetails = successData.masterCodeResultDTOs;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
}
BaseComponent.ɵfac = function BaseComponent_Factory(t) { return new (t || BaseComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["Injector"])); };
BaseComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: BaseComponent, selectors: [["parent-comp"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵProvidersFeature"]([])], decls: 0, vars: 0, template: function BaseComponent_Template(rf, ctx) { }, encapsulation: 2 });


/***/ }),

/***/ "RnhZ":
/*!**************************************************!*\
  !*** ./node_modules/moment/locale sync ^\.\/.*$ ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./af": "K/tc",
	"./af.js": "K/tc",
	"./ar": "jnO4",
	"./ar-dz": "o1bE",
	"./ar-dz.js": "o1bE",
	"./ar-kw": "Qj4J",
	"./ar-kw.js": "Qj4J",
	"./ar-ly": "HP3h",
	"./ar-ly.js": "HP3h",
	"./ar-ma": "CoRJ",
	"./ar-ma.js": "CoRJ",
	"./ar-ps": "TJgH",
	"./ar-ps.js": "TJgH",
	"./ar-sa": "gjCT",
	"./ar-sa.js": "gjCT",
	"./ar-tn": "bYM6",
	"./ar-tn.js": "bYM6",
	"./ar.js": "jnO4",
	"./az": "SFxW",
	"./az.js": "SFxW",
	"./be": "H8ED",
	"./be.js": "H8ED",
	"./bg": "hKrs",
	"./bg.js": "hKrs",
	"./bm": "p/rL",
	"./bm.js": "p/rL",
	"./bn": "kEOa",
	"./bn-bd": "loYQ",
	"./bn-bd.js": "loYQ",
	"./bn.js": "kEOa",
	"./bo": "0mo+",
	"./bo.js": "0mo+",
	"./br": "aIdf",
	"./br.js": "aIdf",
	"./bs": "JVSJ",
	"./bs.js": "JVSJ",
	"./ca": "1xZ4",
	"./ca.js": "1xZ4",
	"./cs": "PA2r",
	"./cs.js": "PA2r",
	"./cv": "A+xa",
	"./cv.js": "A+xa",
	"./cy": "l5ep",
	"./cy.js": "l5ep",
	"./da": "DxQv",
	"./da.js": "DxQv",
	"./de": "tGlX",
	"./de-at": "s+uk",
	"./de-at.js": "s+uk",
	"./de-ch": "u3GI",
	"./de-ch.js": "u3GI",
	"./de.js": "tGlX",
	"./dv": "WYrj",
	"./dv.js": "WYrj",
	"./el": "jUeY",
	"./el.js": "jUeY",
	"./en-au": "Dmvi",
	"./en-au.js": "Dmvi",
	"./en-ca": "OIYi",
	"./en-ca.js": "OIYi",
	"./en-gb": "Oaa7",
	"./en-gb.js": "Oaa7",
	"./en-ie": "4dOw",
	"./en-ie.js": "4dOw",
	"./en-il": "czMo",
	"./en-il.js": "czMo",
	"./en-in": "7C5Q",
	"./en-in.js": "7C5Q",
	"./en-nz": "b1Dy",
	"./en-nz.js": "b1Dy",
	"./en-sg": "t+mt",
	"./en-sg.js": "t+mt",
	"./eo": "Zduo",
	"./eo.js": "Zduo",
	"./es": "iYuL",
	"./es-do": "CjzT",
	"./es-do.js": "CjzT",
	"./es-mx": "tbfe",
	"./es-mx.js": "tbfe",
	"./es-us": "Vclq",
	"./es-us.js": "Vclq",
	"./es.js": "iYuL",
	"./et": "7BjC",
	"./et.js": "7BjC",
	"./eu": "D/JM",
	"./eu.js": "D/JM",
	"./fa": "jfSC",
	"./fa.js": "jfSC",
	"./fi": "gekB",
	"./fi.js": "gekB",
	"./fil": "1ppg",
	"./fil.js": "1ppg",
	"./fo": "ByF4",
	"./fo.js": "ByF4",
	"./fr": "nyYc",
	"./fr-ca": "2fjn",
	"./fr-ca.js": "2fjn",
	"./fr-ch": "Dkky",
	"./fr-ch.js": "Dkky",
	"./fr.js": "nyYc",
	"./fy": "cRix",
	"./fy.js": "cRix",
	"./ga": "USCx",
	"./ga.js": "USCx",
	"./gd": "9rRi",
	"./gd.js": "9rRi",
	"./gl": "iEDd",
	"./gl.js": "iEDd",
	"./gom-deva": "qvJo",
	"./gom-deva.js": "qvJo",
	"./gom-latn": "DKr+",
	"./gom-latn.js": "DKr+",
	"./gu": "4MV3",
	"./gu.js": "4MV3",
	"./he": "x6pH",
	"./he.js": "x6pH",
	"./hi": "3E1r",
	"./hi.js": "3E1r",
	"./hr": "S6ln",
	"./hr.js": "S6ln",
	"./hu": "WxRl",
	"./hu.js": "WxRl",
	"./hy-am": "1rYy",
	"./hy-am.js": "1rYy",
	"./id": "UDhR",
	"./id.js": "UDhR",
	"./is": "BVg3",
	"./is.js": "BVg3",
	"./it": "bpih",
	"./it-ch": "bxKX",
	"./it-ch.js": "bxKX",
	"./it.js": "bpih",
	"./ja": "B55N",
	"./ja.js": "B55N",
	"./jv": "tUCv",
	"./jv.js": "tUCv",
	"./ka": "IBtZ",
	"./ka.js": "IBtZ",
	"./kk": "bXm7",
	"./kk.js": "bXm7",
	"./km": "6B0Y",
	"./km.js": "6B0Y",
	"./kn": "PpIw",
	"./kn.js": "PpIw",
	"./ko": "Ivi+",
	"./ko.js": "Ivi+",
	"./ku": "JCF/",
	"./ku-kmr": "dVgr",
	"./ku-kmr.js": "dVgr",
	"./ku.js": "JCF/",
	"./ky": "lgnt",
	"./ky.js": "lgnt",
	"./lb": "RAwQ",
	"./lb.js": "RAwQ",
	"./lo": "sp3z",
	"./lo.js": "sp3z",
	"./lt": "JvlW",
	"./lt.js": "JvlW",
	"./lv": "uXwI",
	"./lv.js": "uXwI",
	"./me": "KTz0",
	"./me.js": "KTz0",
	"./mi": "aIsn",
	"./mi.js": "aIsn",
	"./mk": "aQkU",
	"./mk.js": "aQkU",
	"./ml": "AvvY",
	"./ml.js": "AvvY",
	"./mn": "lYtQ",
	"./mn.js": "lYtQ",
	"./mr": "Ob0Z",
	"./mr.js": "Ob0Z",
	"./ms": "6+QB",
	"./ms-my": "ZAMP",
	"./ms-my.js": "ZAMP",
	"./ms.js": "6+QB",
	"./mt": "G0Uy",
	"./mt.js": "G0Uy",
	"./my": "honF",
	"./my.js": "honF",
	"./nb": "bOMt",
	"./nb.js": "bOMt",
	"./ne": "OjkT",
	"./ne.js": "OjkT",
	"./nl": "+s0g",
	"./nl-be": "2ykv",
	"./nl-be.js": "2ykv",
	"./nl.js": "+s0g",
	"./nn": "uEye",
	"./nn.js": "uEye",
	"./oc-lnc": "Fnuy",
	"./oc-lnc.js": "Fnuy",
	"./pa-in": "8/+R",
	"./pa-in.js": "8/+R",
	"./pl": "jVdC",
	"./pl.js": "jVdC",
	"./pt": "8mBD",
	"./pt-br": "0tRk",
	"./pt-br.js": "0tRk",
	"./pt.js": "8mBD",
	"./ro": "lyxo",
	"./ro.js": "lyxo",
	"./ru": "lXzo",
	"./ru.js": "lXzo",
	"./sd": "Z4QM",
	"./sd.js": "Z4QM",
	"./se": "//9w",
	"./se.js": "//9w",
	"./si": "7aV9",
	"./si.js": "7aV9",
	"./sk": "e+ae",
	"./sk.js": "e+ae",
	"./sl": "gVVK",
	"./sl.js": "gVVK",
	"./sq": "yPMs",
	"./sq.js": "yPMs",
	"./sr": "zx6S",
	"./sr-cyrl": "E+lV",
	"./sr-cyrl.js": "E+lV",
	"./sr.js": "zx6S",
	"./ss": "Ur1D",
	"./ss.js": "Ur1D",
	"./sv": "X709",
	"./sv.js": "X709",
	"./sw": "dNwA",
	"./sw.js": "dNwA",
	"./ta": "PeUW",
	"./ta.js": "PeUW",
	"./te": "XLvN",
	"./te.js": "XLvN",
	"./tet": "V2x9",
	"./tet.js": "V2x9",
	"./tg": "Oxv6",
	"./tg.js": "Oxv6",
	"./th": "EOgW",
	"./th.js": "EOgW",
	"./tk": "Wv91",
	"./tk.js": "Wv91",
	"./tl-ph": "Dzi0",
	"./tl-ph.js": "Dzi0",
	"./tlh": "z3Vd",
	"./tlh.js": "z3Vd",
	"./tr": "DoHr",
	"./tr.js": "DoHr",
	"./tzl": "z1FC",
	"./tzl.js": "z1FC",
	"./tzm": "wQk9",
	"./tzm-latn": "tT3J",
	"./tzm-latn.js": "tT3J",
	"./tzm.js": "wQk9",
	"./ug-cn": "YRex",
	"./ug-cn.js": "YRex",
	"./uk": "raLr",
	"./uk.js": "raLr",
	"./ur": "UpQW",
	"./ur.js": "UpQW",
	"./uz": "Loxo",
	"./uz-latn": "AQ68",
	"./uz-latn.js": "AQ68",
	"./uz.js": "Loxo",
	"./vi": "KSF8",
	"./vi.js": "KSF8",
	"./x-pseudo": "/X5v",
	"./x-pseudo.js": "/X5v",
	"./yo": "fzPg",
	"./yo.js": "fzPg",
	"./zh-cn": "XDpg",
	"./zh-cn.js": "XDpg",
	"./zh-hk": "SatO",
	"./zh-hk.js": "SatO",
	"./zh-mo": "OmwH",
	"./zh-mo.js": "OmwH",
	"./zh-tw": "kOpN",
	"./zh-tw.js": "kOpN"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "RnhZ";

/***/ }),

/***/ "SWzA":
/*!***********************************************************!*\
  !*** ./src/app/main/add-payment/add-payment.component.ts ***!
  \***********************************************************/
/*! exports provided: AddPaymentComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AddPaymentComponent", function() { return AddPaymentComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");

class AddPaymentComponent {
    constructor() { }
    ngOnInit() {
    }
}
AddPaymentComponent.ɵfac = function AddPaymentComponent_Factory(t) { return new (t || AddPaymentComponent)(); };
AddPaymentComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AddPaymentComponent, selectors: [["app-add-payment"]], decls: 0, vars: 0, template: function AddPaymentComponent_Template(rf, ctx) { }, styles: ["@import url('https://fonts.googleapis.com/css?family=Raleway&display=swap');\n\n[_ngcontent-%COMP%]:root {\n  --light-grey: #F6F9FC;\n  --dark-terminal-color: #0A2540;\n  --accent-color: #635BFF;\n  --radius: 3px;\n}\n\nbody[_ngcontent-%COMP%] {\n  padding: 20px;\n  font-family: 'Raleway';\n  display: flex;\n  justify-content: center;\n  font-size: 1.2em;\n  color: var(--dark-terminal-color);\n}\n\nmain[_ngcontent-%COMP%] {\n  width: 480px;\n}\n\nform[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n  margin: 10px 0;\n}\n\nbutton[_ngcontent-%COMP%] {\n  background-color: var(--accent-color);\n}\n\nbutton[_ngcontent-%COMP%] {\n  background: var(--accent-color);\n  border-radius: var(--radius);\n  color: white;\n  border: 0;\n  padding: 12px 16px;\n  margin-top: 16px;\n  font-weight: 600;\n  cursor: pointer;\n  transition: all 0.2s ease;\n  display: block;\n}\n\nbutton[_ngcontent-%COMP%]:hover {\n  filter: contrast(115%);\n}\n\nbutton[_ngcontent-%COMP%]:active {\n  transform: translateY(0px) scale(0.98);\n  filter: brightness(0.9);\n}\n\nbutton[_ngcontent-%COMP%]:disabled {\n  opacity: 0.5;\n  cursor: none;\n}\n\ninput[_ngcontent-%COMP%], select[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.1em;\n  width: 100%;\n  margin-bottom: 10px;\n}\n\nlabel[_ngcontent-%COMP%] {\n  display: block;\n}\n\na[_ngcontent-%COMP%] {\n  color: var(--accent-color);\n  font-weight: 900;\n}\n\nsmall[_ngcontent-%COMP%] {\n  font-size: .6em;\n}\n\nfieldset[_ngcontent-%COMP%], input[_ngcontent-%COMP%], select[_ngcontent-%COMP%] {\n  border: 1px solid #efefef;\n}\n\n#payment-form[_ngcontent-%COMP%] {\n  border: #F6F9FC solid 1px;\n  border-radius: var(--radius);\n  padding: 20px;\n  margin: 20px 0;\n  box-shadow: 0 30px 50px -20px rgb(50 50 93 / 25%), 0 30px 60px -30px rgb(0 0 0 / 30%);\n}\n\n#messages[_ngcontent-%COMP%] {\n  font-family: source-code-pro, Menlo, Monaco, Consolas, 'Courier New';\n  display: none; \n  background-color: #0A253C;\n  color: #00D924;\n  padding: 20px;\n  margin: 20px 0;\n  border-radius: var(--radius);\n  font-size:0.7em;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "Sy1n":
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/*! exports provided: AppComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppComponent", function() { return AppComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ "tyNb");


class AppComponent {
    constructor() {
        this.title = 'dJibouti E Visa';
    }
}
AppComponent.ɵfac = function AppComponent_Factory(t) { return new (t || AppComponent)(); };
AppComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AppComponent, selectors: [["app-root"]], decls: 1, vars: 0, template: function AppComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "router-outlet");
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterOutlet"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJhcHAuY29tcG9uZW50LmNzcyJ9 */"] });


/***/ }),

/***/ "TWRy":
/*!***************************************************************!*\
  !*** ./src/app/main/visa-overstay/visa-overstay.component.ts ***!
  \***************************************************************/
/*! exports provided: VisaOverstayComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VisaOverstayComponent", function() { return VisaOverstayComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @stripe/stripe-js */ "v4r+");
/* harmony import */ var src_environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/environments/environment */ "AytR");
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var ng_popups__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-popups */ "iQtR");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");










const _c0 = function (a1, a2) { return ["/main/visaoverstay-view", a1, a2]; };
function VisaOverstayComponent_tr_45_a_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "a", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, "Action");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction2"](1, _c0, data_r2 == null ? null : data_r2.applicationNumber, data_r2 == null ? null : data_r2.penalityAmount));
} }
function VisaOverstayComponent_tr_45_span_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "span", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, "Pay\u00E9e");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} }
function VisaOverstayComponent_tr_45_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "tr", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](12, "\u00A0\u00A0 ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, VisaOverstayComponent_tr_45_a_13_Template, 2, 4, "a", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](14, VisaOverstayComponent_tr_45_span_14_Template, 2, 0, "span", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r2 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](data_r2 == null ? null : data_r2.applicationNumber);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](data_r2 == null ? null : data_r2.fileNumber);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](data_r2 == null ? null : data_r2.surname);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](data_r2 == null ? null : data_r2.visa_expiry);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", data_r2 == null ? null : data_r2.penalityAmount, " $");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r2 == null ? null : data_r2.penalityAmount) != 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", (data_r2 == null ? null : data_r2.penalityAmount) === 0);
} }
function VisaOverstayComponent_tr_46_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "tr", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "td", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 1, "VISAPENALITY.noVisaEligible"));
} }
const _c1 = function () { return ["/main/visaoverstay-view"]; };
class VisaOverstayComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_3__["BaseComponent"] {
    constructor(inj, ngxLoader, ngPopups) {
        super(inj);
        this.ngxLoader = ngxLoader;
        this.ngPopups = ngPopups;
        this.pagesize = 10;
        this.data = {
            pageNumber: 1,
            pageSize: this.pagesize,
            loggedUser: this.getToken('username')
        };
        this.dataa = {
            ReferenceNumber: 1,
            Amount: this.pagesize,
        };
        this.stripePromise = Object(_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__["loadStripe"])(src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].stripe_key);
    }
    ngOnInit() {
        this.getVisaExtension();
    }
    getVisaExtension() {
        console.log(this.data);
        setTimeout(() => {
            this.commonService.callApi('searchavailableoverstay', this.data, 'post', false, false, 'REG').then(success => {
                let successData = success;
                this.totalItem = successData.totalElements;
                this.number = successData.number;
                this.size = successData.size;
                this.noofelements = successData.numberOfElements;
                this.totalElements = successData.totalElements;
                console.log(successData);
                if (successData.content.length) {
                    this.visaCheckOverstayDetails = successData.content;
                }
            }).catch(e => {
                this.toastr.error(e.message, 'Oops!');
            });
        });
    }
    checkout(file, amount) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            console.log(file);
            console.log(amount);
            this.dataa.applicationNumber = file;
            this.dataa.penalityAmount = amount;
            const stripe = yield this.stripePromise;
            this.ngPopups.confirm(this.moneyRefund, { title: this.message }).subscribe(res => {
                if (res) {
                    let tmpamt = this.dataa.penalityAmount;
                    const payment = {
                        amount: tmpamt * 100,
                        referenceNumber: this.dataa.applicationNumber,
                        username: 'Hamda',
                        // cancelUrl: 'http://87.106.107.227/applicant-api/#/main/dashboard',
                        // successUrl: 'http://87.106.107.227/applicant-api/#/main/success-payment',
                        cancelUrl: 'https://evisav2.gouv.dj/applicant-api/#/main/dashboard',
                        successUrl: 'https://evisav2.gouv.dj/applicant-api/#/main/success-payment',
                        // cancelUrl: 'http://localhost:4200/applicant-api/cancel',
                        // successUrl: 'http://localhost:4200/applicant-api/#/main/success-payment', 
                        // cancelUrl: 'http://217.160.99.180/applicant-api/cancel',
                        // successUrl: 'http://217.160.99.180/applicant-api/#/main/success-payment', 
                        // cancelUrl: 'https://www.evisa.gouv.dj/applicant-api/cancel',
                        // successUrl: 'https://www.evisa.gouv.dj/applicant-api/#/main/success-payment',
                        instrType: 'EVISA_PEN'
                    };
                    // this is a normal http calls for a backend api
                    console.log('environment.serverUrl', src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].serverUrl);
                    this.http
                        .post(`${src_environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].serverUrl}`, payment)
                        .subscribe((data) => {
                        // I use stripe to redirect To Checkout page of Stripe platform
                        // stripe.redirectToCheckout({
                        //   sessionId: data.refId,
                        // });
                        const result = stripe.redirectToCheckout({
                            sessionId: data.refId,
                        });
                        console.log(result);
                    });
                }
            });
            console.log("dehors");
        });
    }
}
VisaOverstayComponent.ɵfac = function VisaOverstayComponent_Factory(t) { return new (t || VisaOverstayComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](ngx_ui_loader__WEBPACK_IMPORTED_MODULE_5__["NgxUiLoaderService"]), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](ng_popups__WEBPACK_IMPORTED_MODULE_6__["NgPopupsService"])); };
VisaOverstayComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({ type: VisaOverstayComponent, selectors: [["app-visa-overstay"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵInheritDefinitionFeature"]], decls: 47, vars: 30, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], ["href", "javascript:;", 3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], [1, "portlet-body"], [1, "table-scrollable"], ["id", "sample_editable_1", 1, "styled-table"], ["class", "odd gradeX", 4, "ngFor", "ngForOf"], ["class", "odd", 4, "ngIf"], [1, "odd", "gradeX"], ["href", "javascript:;", 3, "routerLink", 4, "ngIf"], ["style", "color: green", 4, "ngIf"], [2, "color", "green"], [1, "odd"], ["colspan", "10", 1, "dataTables_empty", 2, "text-align", "center"]], template: function VisaOverstayComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](16, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](17, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](20, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](21, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](22, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](23, "div", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](24, "table", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](25, "thead");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](26, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](27, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](28);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](29, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](30, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](31);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](32, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](33, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](34);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](35, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](36, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](38, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](39, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](40);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipe"](41, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](42, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](43, "Action");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](44, "tbody");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](45, VisaOverstayComponent_tr_45_Template, 15, 7, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](46, VisaOverstayComponent_tr_46_Template, 5, 3, "tr", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](4, 11, "VISAPENALITY.VisaPenality"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](29, _c1));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](9, 13, "APPLICATIONSPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](13, 15, "VISAPENALITY.VisaPenality"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](20, 17, "VISAPENALITY.visa overstay"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](29, 19, "VISAPENALITY.applicationnumber"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](32, 21, "VISAPENALITY.File Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](35, 23, "VISAPENALITY.surname"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](38, 25, "VISAPENALITY.visa expirateDate"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpipeBind1"](41, 27, "VISAPENALITY.AmountPenality"));
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngForOf", ctx.visaCheckOverstayDetails);
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_7__["RouterLinkWithHref"], _angular_common__WEBPACK_IMPORTED_MODULE_8__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_8__["NgIf"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__["TranslatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJ2aXNhLW92ZXJzdGF5LmNvbXBvbmVudC5jc3MifQ== */"] });


/***/ }),

/***/ "URam":
/*!*********************************************!*\
  !*** ./src/app/common/errorMessagesdata.ts ***!
  \*********************************************/
/*! exports provided: MessagesData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MessagesData", function() { return MessagesData; });
const MessagesData = {
    "ERROR": {
        "REQUIRED": {
            "Password": "Enter password",
            "Username": "Enter username",
            "oldPassword": "Enter current password",
            "newPassword": "Enter new password",
            "confirmPassword": "Enter confirm password",
            "Email": "Enter email address",
            "firstname": "Enter first Name",
            "lastname": "Enter last Name",
            "username": "Enter user name",
            "mobile": "Enter mobile number",
            "Title": "Enter title ",
            "content": "Enter Content",
            "metaTitle": "Enter metaTitle",
            "metaKeyword": "Enter metaKeyword",
            "metaDescription": "Enter metaDescription",
            "pageId": "Enter pageId",
            "pageName": "Enter pageName",
            "pageUrl": "Enter PageURL",
            "publishgroup": "Enter Publishgroup",
            "Field": "Field is Required"
        },
        "PATTERN": {
            "Age": "Please enter proper Age",
            "Mobile": "Phone number can not be less than 4 characters",
            "Email": "Please enter a valid email address",
            "Password": "Password must contain at least one letter and one digit",
            "Username": "Invalid Username",
            "Contactno": "Invalid Contact Number"
        },
        "MINLENGTH": {
            "mobile": "Mobile number should be 10 digits",
            "Password": "Password must be atleast 6 characters",
            "Distance": "Distance should be minimum 1 characters",
            "PinNo": "Please enter minimum 6 pin number",
            "FirstName": "FirstName should not be more than 5 chartacters",
            "LastName": "LastName should not be more than 5 chartacters",
            "Username": "Username must be atleast 5 characters"
        },
        "CUSTOM": {
            "ConfirmPassword": "Confirm password does not match!",
            "Location": "Please enter valid location",
            "Subject": "Please select subject from available list"
        }
    }
};


/***/ }),

/***/ "WP+w":
/*!*****************************************!*\
  !*** ./src/app/common/errorMessages.ts ***!
  \*****************************************/
/*! exports provided: ErrorMessages */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ErrorMessages", function() { return ErrorMessages; });
/* harmony import */ var _errorMessagesdata__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./errorMessagesdata */ "URam");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
// import * as messages from './errorMessagesdata.ts/index.js';


class ErrorMessages {
    constructor() {
        this.MSG = _errorMessagesdata__WEBPACK_IMPORTED_MODULE_0__["MessagesData"];
    }
    getError(field, error) {
        var message;
        if (error) {
            console.log("error", error, field);
            if (error.required) {
                var required = this.MSG.ERROR.REQUIRED;
                switch (field) {
                    case 'email':
                        {
                            message = required.Email;
                        }
                        break;
                    case 'field':
                        {
                            message = required.Field;
                        }
                        break;
                    case 'mobile':
                        {
                            message = required.mobile;
                        }
                        break;
                    case 'password':
                        {
                            message = required.Password;
                        }
                        break;
                    case 'oldPassword':
                        {
                            message = required.oldPassword;
                        }
                        break;
                    case 'newPassword':
                        {
                            message = required.newPassword;
                        }
                        break;
                    case 'confirmPassword':
                        {
                            message = required.confirmPassword;
                        }
                        break;
                    case 'firstname':
                        {
                            message = required.firstname;
                        }
                        break;
                    case 'lastname':
                        {
                            message = required.lastname;
                        }
                        break;
                    case 'username':
                        {
                            message = required.username;
                        }
                        break;
                    case 'Title':
                        {
                            message = required.Title;
                        }
                        break;
                    case 'content':
                        {
                            message = required.content;
                        }
                        break;
                    case 'metaTitle':
                        {
                            message = required.metaTitle;
                        }
                        break;
                    case 'metaKeyword':
                        {
                            message = required.metaKeyword;
                        }
                        break;
                    case 'metaDescription':
                        {
                            message = required.metaDescription;
                        }
                        break;
                    case 'pageId':
                        {
                            message = required.Pageid;
                        }
                        break;
                    case 'pageName':
                        {
                            message = required.pageName;
                        }
                        break;
                    case 'pageUrl':
                        {
                            message = required.pageUrl;
                        }
                        break;
                }
            }
            else if (error.pattern) {
                var pattern = this.MSG.ERROR.PATTERN;
                switch (field) {
                    case 'email':
                        {
                            message = pattern.Email;
                        }
                        break;
                }
            }
            else if (error.minlength) {
                var minlength = this.MSG.ERROR.MINLENGTH;
                switch (field) {
                    case 'mobile':
                        {
                            message = minlength.mobile;
                        }
                        break;
                }
            }
            return message;
        }
    }
}
ErrorMessages.ɵfac = function ErrorMessages_Factory(t) { return new (t || ErrorMessages)(); };
ErrorMessages.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({ token: ErrorMessages, factory: ErrorMessages.ɵfac, providedIn: 'root' });


/***/ }),

/***/ "YFE/":
/*!****************************************************************************************!*\
  !*** ./src/app/main/apply-visa-extension/apply-visa-list/apply-visa-list.component.ts ***!
  \****************************************************************************************/
/*! exports provided: ApplyVisaListComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApplyVisaListComponent", function() { return ApplyVisaListComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var ngx_bootstrap_modal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ngx-bootstrap/modal */ "K3ix");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ngx-bootstrap/tooltip */ "Mfq2");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ng-select/ng-select */ "ZOsW");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ngx-bootstrap/pagination */ "Lm2G");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");











function ApplyVisaListComponent_tr_53_td_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Result.UnderProcessing"));
} }
function ApplyVisaListComponent_tr_53_td_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Result.Granted"));
} }
function ApplyVisaListComponent_tr_53_td_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "span", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 1, "Result.Rejected"));
} }
function ApplyVisaListComponent_tr_53_a_16_Template(rf, ctx) { if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "a", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ApplyVisaListComponent_tr_53_a_16_Template_a_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r12); const data_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]().$implicit; const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r10.downloadApplication(data_r5 == null ? null : data_r5.applicationNumber, data_r5 == null ? null : data_r5.visaExtensionId); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "Content.download"), " ");
} }
const _c0 = function (a1) { return ["/main/evisa-extension/apply-visa-view/", a1]; };
function ApplyVisaListComponent_tr_53_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](9, ApplyVisaListComponent_tr_53_td_9_Template, 4, 3, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](10, ApplyVisaListComponent_tr_53_td_10_Template, 4, 3, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](11, ApplyVisaListComponent_tr_53_td_11_Template, 4, 3, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "a", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](14, "i", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](15, " \u00A0\u00A0 ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](16, ApplyVisaListComponent_tr_53_a_16_Template, 3, 3, "a", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r5 == null ? null : data_r5.visaExtensionId);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r5 == null ? null : data_r5.applicationNumber);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r5 == null ? null : data_r5.daysOfExtension);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r5 == null ? null : data_r5.totalAmount);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r5 == null ? null : data_r5.extensionStatus) == "UP");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r5 == null ? null : data_r5.extensionStatus) === "APR");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r5 == null ? null : data_r5.extensionStatus) === "REJ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](9, _c0, data_r5 == null ? null : data_r5.visaExtensionId));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (data_r5 == null ? null : data_r5.extensionStatus) === "APR");
} }
function ApplyVisaListComponent_tr_54_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "tr", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "td", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 1, "EXTENSIONVISA.noVisaEligible"));
} }
const _c1 = function () { return { standalone: true }; };
function ApplyVisaListComponent_div_55_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "ng-select", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ApplyVisaListComponent_div_55_Template_ng_select_change_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r13.rangeChanged(ctx_r13.pagesize); })("ngModelChange", function ApplyVisaListComponent_div_55_Template_ng_select_ngModelChange_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r14); const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r15.pagesize = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "pagination", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function ApplyVisaListComponent_div_55_Template_pagination_ngModelChange_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r14); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r16.currentPage = $event; })("pageChanged", function ApplyVisaListComponent_div_55_Template_pagination_pageChanged_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r14); const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r17.pageChanged($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("items", ctx_r2.rangeList)("ngModel", ctx_r2.pagesize)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](28, _c1))("clearable", false)("searchable", false)("dropdownPosition", "top");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate7"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](7, 20, "PAGINATION.Showing"), " ", ctx_r2.number * ctx_r2.size + 1, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](8, 22, "PAGINATION.to"), " ", ctx_r2.number * ctx_r2.size + ctx_r2.noofelements, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 24, "PAGINATION.of"), " ", ctx_r2.totalElements, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](10, 26, "PAGINATION.entries"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("boundaryLinks", ctx_r2.showBoundaryLinks)("rotate", "true")("itemsPerPage", ctx_r2.pagesize)("totalItems", ctx_r2.totalItem)("maxSize", 5)("ngModel", ctx_r2.currentPage)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](29, _c1));
} }
const _c2 = function (a1) { return ["/main/evisa-extension/apply-visa-edit", a1]; };
function ApplyVisaListComponent_ng_template_57_tr_39_Template(rf, ctx) { if (rf & 1) {
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](11, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "a", 55);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ApplyVisaListComponent_ng_template_57_tr_39_Template_a_click_13_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r23); const data_r21 = ctx.$implicit; const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r22.onClose(data_r21 == null ? null : data_r21.applicationNumber, data_r21 == null ? null : data_r21.fileNumber, data_r21 == null ? null : data_r21.givenName, data_r21 == null ? null : data_r21.emailAddress, data_r21 == null ? null : data_r21.passportNo, data_r21 == null ? null : data_r21.visaExpiry); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](14, " Apply");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r21 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", data_r21 == null ? null : data_r21.applicationNumber, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r21 == null ? null : data_r21.fileNumber);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r21 == null ? null : data_r21.passportNo);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](data_r21 == null ? null : data_r21.givenName);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](11, 6, data_r21 == null ? null : data_r21.visaExpiry, "dd/MM/yyyy"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction1"](9, _c2, data_r21.applicationNumber));
} }
function ApplyVisaListComponent_ng_template_57_div_42_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](3, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](6, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "b");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](3, 4, "Content.applNum"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("* ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](6, 6, "Content.territory"), "");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("* ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 8, "Content.remaining validity"), "");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](12, 10, "Content.contact"));
} }
function ApplyVisaListComponent_ng_template_57_div_43_Template(rf, ctx) { if (rf & 1) {
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "ng-select", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("change", function ApplyVisaListComponent_ng_template_57_div_43_Template_ng_select_change_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r25); const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r24.rangeChange(ctx_r24.pagesized); })("ngModelChange", function ApplyVisaListComponent_ng_template_57_div_43_Template_ng_select_ngModelChange_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r25); const ctx_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r26.pagesized = $event; });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "div", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](8, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "div", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](12, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "pagination", 56);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("ngModelChange", function ApplyVisaListComponent_ng_template_57_div_43_Template_pagination_ngModelChange_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r25); const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r27.currentPage = $event; })("pageChanged", function ApplyVisaListComponent_ng_template_57_div_43_Template_pagination_pageChanged_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r25); const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2); return ctx_r28.pageChange($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("items", ctx_r20.rangelists)("ngModel", ctx_r20.pagesized)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](28, _c1))("clearable", false)("searchable", false)("dropdownPosition", "top");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate7"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](7, 20, "PAGINATION.Showing"), " ", ctx_r20.numbers * ctx_r20.sizes + 1, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](8, 22, "PAGINATION.to"), " ", ctx_r20.numbers * ctx_r20.sizes + ctx_r20.numofelements, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 24, "PAGINATION.of"), " ", ctx_r20.totalElements, " ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](10, 26, "PAGINATION.entries"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("boundaryLinks", ctx_r20.showBoundaryLinks)("rotate", "true")("itemsPerPage", ctx_r20.pagesized)("totalItems", ctx_r20.totalitem)("maxSize", 5)("ngModel", ctx_r20.currentPage)("ngModelOptions", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](29, _c1));
} }
function ApplyVisaListComponent_ng_template_57_Template(rf, ctx) { if (rf & 1) {
    const _r30 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "form", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "h3", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](7, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "div", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](9, "div", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](10, "label", 49);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](12, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](13, "input", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("keyup", function ApplyVisaListComponent_ng_template_57_Template_input_keyup_13_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r30); const ctx_r29 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r29.onSearch($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](14, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](15, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "table", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "thead");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](21);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](22, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](24);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](25, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](27);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](28, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](30);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](31, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](33);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](34, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](35, "th");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](36);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](37, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](38, "tbody");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](39, ApplyVisaListComponent_ng_template_57_tr_39_Template, 15, 11, "tr", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "tr", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](41, "td", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](42, ApplyVisaListComponent_ng_template_57_div_42_Template, 13, 12, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](43, ApplyVisaListComponent_ng_template_57_div_43_Template, 14, 30, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](44, "div", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "div", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](46, "div", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](47, "div", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](48, "button", 54);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ApplyVisaListComponent_ng_template_57_Template_button_click_48_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r30); const ctx_r31 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r31.modalRef.hide(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](49, "Close");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](7, 11, "EXTENSIONVISA.SelectExtension"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](12, 13, "EXTENSIONVISA.Search"), ": ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](22, 15, "DASHBOARDPAGE.Application Number"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](25, 17, "EXTENSIONVISA.File Number"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](28, 19, "TRAVELINFO.Passport Number"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](31, 21, "EXTENSIONVISA.Given Name"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](34, 23, "EXTENSIONVISA.Visa Valid Date"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](37, 25, "DASHBOARDPAGE.Action"));
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx_r4.visaExtensionfilters == null ? ctx_r4.modalVisaExtensionDetails : ctx_r4.visaExtensionfilters);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx_r4.visaExtensionfilters == null ? false : !ctx_r4.visaExtensionfilters.length) && !ctx_r4.loading);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx_r4.totalElements > 0);
} }
const _c3 = function () { return ["/main/dashboard"]; };
const FileSaver = __webpack_require__(/*! file-saver */ "Iab2");
class ApplyVisaListComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj, ngxLoader, modalService) {
        super(inj);
        this.ngxLoader = ngxLoader;
        this.modalService = modalService;
        this.pagesize = 10;
        this.data = {
            pageNumber: 1,
            pageSize: this.pagesize,
            loggedUser: this.getToken('username')
        };
        this.visaExtensionDetails = [];
        this.visaExtensionfilters = null;
        this.serchVisa = [];
        /****************************************************************************
            @PURPOSE      : Paginations
            @PARAMETERS   : pageNumber,PageSize,loggedinuse
            @RETURN       : NA
         ****************************************************************************/
        this.currentPage = 1;
        this.showBoundaryLinks = true;
        this.rangeList = [5, 10, 25, 100];
        this.isFilterApplied = false;
        this.filterObj = {};
        /***************************************************************/
        this.modalVisaExtensionDetails = [];
        this.pages = 1;
        this.pagesized = 10;
        /****************************************************************************
            @PURPOSE      : paginations for modal
            @PARAMETERS   : pageNumber,PageSize,loggedinuse
            @RETURN       : NA
         ****************************************************************************/
        this.currentpage = 1;
        this.rangelists = [5, 10, 25, 100];
        this.isFilterapplieed = false;
        this.filterobject = {};
    }
    ngOnInit() {
        this.searchVisaExtension(this.data);
    }
    refreshPage() {
        this.searchVisaExtension(this.data);
    }
    searchVisaExtension(data) {
        data.role = "APPLICANT";
        this.loading = true;
        this.ngxLoader.start();
        setTimeout(() => {
            this.commonService.callApi('searchapplicantvisaextension', data, 'post', false, false, 'REG').then(success => {
                let successData = success;
                this.totalItem = successData.totalElements;
                this.number = successData.number;
                this.size = successData.size;
                this.noofelements = successData.numberOfElements;
                this.totalElements = successData.totalElements;
                this.loading = false;
                console.log(successData.content);
                this.ngxLoader.stop();
                if (successData.content.length) {
                    this.serchVisa = successData.content;
                    console.log(this.serchVisa);
                }
                else {
                    this.serchVisa = [];
                }
            }).catch(e => {
                this.ngxLoader.stop();
                this.toastr.error(e.message, 'Oops!');
            });
        }, 1500);
    }
    getVisaExtension(data, type) {
        this.typeRef = type;
        this.loading = true;
        console.log(data);
        setTimeout(() => {
            this.commonService.callApi('searchavailableextensions', data, 'post', false, false, 'REG').then(success => {
                let successData = success;
                this.totalitem = successData.totalElements;
                this.numbers = successData.number;
                this.sizes = successData.size;
                this.loading = false;
                this.numofelements = successData.numberOfElements;
                this.totalElements = successData.totalElements;
                console.log(this.totalitem);
                let items = [];
                if (successData.content.length) {
                    if (this.typeRef == 'modal') {
                        successData.content.forEach(function (item) {
                            if (item.username === data.loggedUser) {
                                items.push(item);
                            }
                        });
                        this.modalVisaExtensionDetails = items;
                    }
                    else {
                        successData.content.forEach(function (item) {
                            if (item.username === data.loggedUser) {
                                items.push(item);
                            }
                        });
                        this.visaExtensionDetails = items;
                    }
                }
                else {
                    this.visaExtensionDetails = [];
                }
            }).catch(e => {
                this.ngxLoader.stop();
                this.toastr.error(e.message, 'Oops!');
            });
        });
    }
    onClose(applicantNo, fileNumber, givenName, emailId, passport, previousVisaDate) {
        this.modalRef.hide();
        this.setToken('applicantNo', applicantNo);
        this.setToken('givenName', givenName);
        this.setToken('fileNumber', fileNumber);
        this.setToken('passport', passport);
        this.setToken('emailId', emailId);
        this.setToken('VisaDate', previousVisaDate);
    }
    pageChanged(e) {
        if (this.isFilterApplied) {
            this.filterObj.pageNumber = e.page;
            this.filterObj.pageSize = e.itemsPerPage;
            this.searchVisaExtension(this.filterObj);
        }
        else {
            this.data.pageNumber = e.page;
            this.data.pageSize = e.itemsPerPage;
            this.searchVisaExtension(this.data);
        }
    }
    rangeChanged(e) {
        if (this.isFilterApplied) {
            console.log(e);
            this.filterObj.pageSize = e;
            this.searchVisaExtension(this.filterObj);
        }
        else {
            this.data.pageSize = e;
            this.searchVisaExtension(this.data);
        }
    }
    showModal(template) {
        this.pagesized = 10;
        this.visaExtensionfilters = null;
        this.modalVisaExtensionDetails = this.visaExtensionDetails;
        console.log(this.data);
        this.getVisaExtension(this.data, 'modal');
        this.modalRef = this.modalService.show(template);
    }
    onSearch(event) {
        let value = event.target.value;
        const filtersss = this.modalVisaExtensionDetails.filter(o => String(o.applicationNumber).toLowerCase().includes(value.toLowerCase()));
        this.visaExtensionfilters = filtersss;
        if (value == '') {
            this.visaExtensionfilters = null;
        }
    }
    pageChange(e) {
        if (this.isFilterapplieed) {
            this.filterobject.pageNumber = e.page;
            this.filterobject.pageSized = e.itemsPerPage;
            this.getVisaExtension(this.filterobject, 'modal');
        }
        else {
            this.data.pageNumber = e.page;
            this.data.pageSized = e.itemsPerPage;
            this.getVisaExtension(this.data, 'modal');
        }
    }
    rangeChange(e) {
        if (this.isFilterapplieed) {
            console.log(e);
            this.filterobject.pageSized = e;
            this.getVisaExtension(this.filterobject, 'modal');
        }
        else {
            this.data.pageSized = e;
            this.getVisaExtension(this.data, 'modal');
        }
    }
    downloadApplication(data, extension) {
        this.commonService.downloadApproval(data).subscribe((res) => {
            console.log(res);
            this.resource = res;
            let blob = new Blob([this.resource], { type: "application/pdf;charset=UTF-8" });
            FileSaver.saveAs(blob, extension);
        });
    }
}
ApplyVisaListComponent.ɵfac = function ApplyVisaListComponent_Factory(t) { return new (t || ApplyVisaListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ngx_ui_loader__WEBPACK_IMPORTED_MODULE_2__["NgxUiLoaderService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ngx_bootstrap_modal__WEBPACK_IMPORTED_MODULE_3__["BsModalService"])); };
ApplyVisaListComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ApplyVisaListComponent, selectors: [["app-apply-visa-list"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 59, vars: 35, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], ["href", "javascript:;", 3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], ["href", "javascript:;", "tooltip", "Refresh", 2, "position", "relative", "top", "-5px", "color", "#e5e5e5"], [1, "fa", "fa-refresh", 3, "click"], [1, "portlet-body"], [1, "table-toolbar"], [1, "btn-group"], ["id", "sample_editable_1_new", 1, "btn", "green", 3, "click"], [1, "fa", "fa-plus"], [1, "table-scrollable"], ["id", "sample_editable_1", 1, "styled-table"], ["class", "odd gradeX", 4, "ngFor", "ngForOf"], ["class", "odd", 4, "ngIf"], ["class", "row", 4, "ngIf"], ["hasProgressBar", "true", "fgsType", "three-strings"], ["template", ""], [1, "odd", "gradeX"], [4, "ngIf"], ["href", "javascript:;", "tooltip", "View", "routerLinkActive", "active", 3, "routerLink"], [1, "fa", "fa-eye"], ["href", "javascript:;", "style", "cursor: pointer;", "tooltip", "Download", 3, "click", 4, "ngIf"], [1, "label", "label-sm", "label-info"], [1, "label", "label-sm", "label-success"], [1, "label", "label-sm", "label-danger"], ["href", "javascript:;", "tooltip", "Download", 2, "cursor", "pointer", 3, "click"], [1, "odd"], ["colspan", "10", 1, "dataTables_empty", 2, "text-align", "center"], [1, "col-md-4", "col-sm-12"], ["bindLabel", "name", "bindValue", "id", "placeholder", "Select", 3, "items", "ngModel", "ngModelOptions", "clearable", "searchable", "dropdownPosition", "change", "ngModelChange"], ["id", "sample_editable_1_info", 1, "dataTables_info"], [1, "dataTables_paginate", "paging_bootstrap"], ["name", "currentPage", "ngDefaultControl", "", "previousText", "\u2039", "nextText", "\u203A", "firstText", "\u00AB", "lastText", "\u00BB", 1, "page", 3, "boundaryLinks", "rotate", "itemsPerPage", "totalItems", "maxSize", "ngModel", "ngModelOptions", "ngModelChange", "pageChanged"], [1, "modal-body", "view-incident-modal-body"], [1, "portlet", "box"], [1, "portlet-body", "form"], ["role", "form", 1, "form-horizontal"], [1, "form-body"], [1, "form-section", 2, "text-align", "center"], [1, "col-md-12", "col-sm-12"], ["id", "sample_editable_1_filter", 1, "dataTables_filter"], [1, "col-md"], ["type", "text", "id", "search-text", "aria-describedby", "search-text", "placeholder", "Application No", "autofocus", "", 1, "form-control", "input-medium", "pull-right", 3, "keyup"], ["colspan", "10", 1, "dataTables_empty", 2, "text-align", "left"], [1, "form-actions", "fluid"], [1, "col-md-offset-5", "col-md-9"], ["type", "button", 1, "btn", "default", 2, "text-align", "center", 3, "click"], ["href", "javascript:;", 3, "routerLink", "click"], ["name", "currentPage", "ngDefaultControl", "", "previousText", "\u2039", "nextText", "\u203A", "firstText", "\u00AB", "lastText", "\u00BB", 1, "pages", 3, "boundaryLinks", "rotate", "itemsPerPage", "totalItems", "maxSize", "ngModel", "ngModelOptions", "ngModelChange", "pageChanged"]], template: function ApplyVisaListComponent_Template(rf, ctx) { if (rf & 1) {
        const _r32 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](16, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](17, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](19, "Visa Extension");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "a", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "i", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ApplyVisaListComponent_Template_i_click_22_listener() { return ctx.refreshPage(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](23, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](24, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](25, "div", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ApplyVisaListComponent_Template_button_click_26_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r32); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵreference"](58); return ctx.showModal(_r3); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](28, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](29, "i", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "div", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "table", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "thead");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](33, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](34, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](35);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](36, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](37, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](38);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](39, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](41);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](42, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](43, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](44);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](45, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](46, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](47);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](48, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](49, "th");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](50);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](51, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](52, "tbody");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](53, ApplyVisaListComponent_tr_53_Template, 17, 11, "tr", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](54, ApplyVisaListComponent_tr_54_Template, 5, 3, "tr", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](55, ApplyVisaListComponent_div_55_Template, 14, 30, "div", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](56, "ngx-ui-loader", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](57, ApplyVisaListComponent_ng_template_57_Template, 50, 27, "ng-template", null, 24, _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplateRefExtractor"]);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 14, "EXTENSIONVISA.Apply Visa Extension"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](34, _c3));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 16, "APPLICATIONSPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](13, 18, "EXTENSIONVISA.Apply Visa Extension"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](28, 20, "EXTENSIONVISA.Apply for extension"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](36, 22, "EXTENSIONVISA.Visa Extension Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](39, 24, "DASHBOARDPAGE.Application Number"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](42, 26, "EXTENSIONVISA.Daysofextension"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](45, 28, "EXTENSIONVISA.Total Amount"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](48, 30, "EXTENSIONVISA.Extension status"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](51, 32, "DASHBOARDPAGE.Action"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.serchVisa);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", !ctx.serchVisa.length && !ctx.loading);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.totalElements > 0);
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLinkWithHref"], ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_5__["TooltipDirective"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], ngx_ui_loader__WEBPACK_IMPORTED_MODULE_2__["ɵb"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLinkActive"], _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_7__["NgSelectComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgModel"], ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_9__["PaginationComponent"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__["NgForm"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__["TranslatePipe"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["DatePipe"]], styles: [".modal-body[_ngcontent-%COMP%] {\n    position: absolute;\n    width: 140%;\n    padding: 20px;\n    margin-top: 150px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFwcGx5LXZpc2EtbGlzdC5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0lBQ0ksa0JBQWtCO0lBQ2xCLFdBQVc7SUFDWCxhQUFhO0lBQ2IsaUJBQWlCO0FBQ3JCIiwiZmlsZSI6ImFwcGx5LXZpc2EtbGlzdC5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLm1vZGFsLWJvZHkge1xuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICB3aWR0aDogMTQwJTtcbiAgICBwYWRkaW5nOiAyMHB4O1xuICAgIG1hcmdpbi10b3A6IDE1MHB4O1xufVxuXG4iXX0= */"] });


/***/ }),

/***/ "YGF7":
/*!*************************************************************!*\
  !*** ./src/app/main/success-page/success-page.component.ts ***!
  \*************************************************************/
/*! exports provided: SuccessPageComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SuccessPageComponent", function() { return SuccessPageComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");




const _c0 = function () { return ["/main/dashboard"]; };
class SuccessPageComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj) {
        super(inj);
        this.token = this.router.parseUrl(this.router.url).queryParams["session_id"];
    }
    ngOnInit() {
    }
    ngAfterViewInit() {
        console.log('Token ', this.token);
        this.verifyUser();
    }
    verifyUser() {
        this.commonService.callApi('payment/success?session_id=' + this.token, '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            console.log(successData);
        }).catch(e => {
            console.log(e);
            // this.toastr.error(e.message, 'Oops!')
        });
    }
}
SuccessPageComponent.ɵfac = function SuccessPageComponent_Factory(t) { return new (t || SuccessPageComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"])); };
SuccessPageComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: SuccessPageComponent, selectors: [["app-success-page"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 18, vars: 11, consts: [[1, "container"], [1, "centered"], [1, "check"], ["aria-hidden", "true", 1, "fa", "fa-check"], [1, "content"], [1, "modal-body"], [1, "text-center"], [1, "modal-footer"], ["data-dismiss", "modal", 1, "btn", "btn-success", "btn-block", 3, "routerLink"]], template: function SuccessPageComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](3, "i", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](6, "Payment Success !");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](8, "p", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](10, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](11, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](14, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](10, 4, "PAYMENT.information-sucess1"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](13, 6, "PAYMENT.facturation"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](10, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](17, 8, "PAYMENT.gotohome"));
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterLink"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__["TranslatePipe"]], styles: ["body[_ngcontent-%COMP%] {\n    background: #f2f2f2;\n}\n\n.centered[_ngcontent-%COMP%] {\n    position: fixed;\n    top: 50%;\n    left: 60%;\n    width: 500px;\n    transform: translate(-50%, -50%);\n    -webkit-transform: translate(-50%, -50%);\n    -moz-transform: translate(-50%, -50%);\n    -o-transform: translate(-50%, -50%);\n    -ms-transform: translate(-50%, -50%);\n    font-size: 20px;\n    background-color: #ffff;\n    border: #192c54 5px solid;\n    padding: 5px;\n    z-index: 100;\n    border-radius: 20px;\n}\n\n.check[_ngcontent-%COMP%] {\n    color: #fff;\n    position: absolute;\n    margin: 0 auto;\n    left: 0;\n    right: 0;\n    top: -60px;\n    width: 95px;\n    height: 95px;\n    border-radius: 50%;\n    z-index: 9;\n    background: #192c54;\n    padding: 15px;\n    text-align: center;\n    box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.1);\n}\n\n.check[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n    font-size: 58px;\n    position: relative;\n    top: 25px;\n}\n\n.content[_ngcontent-%COMP%] {\n    text-align: center;\n    padding-top: 25px;\n}\n\n.content[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n    width: 200px;\n    height: 35px;\n    color: #fff;\n    border-radius: 30px;\n    padding: 5px 10px;\n    background: #d7141a;\n    transition: all ease-in-out 0.3s;\n}\n\n.content[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\n    text-decoration: none;\n    background: #000;\n}\n\n.content[_ngcontent-%COMP%]   .modal-footer[_ngcontent-%COMP%] {\n    border: none;\n    padding-bottom: 20px;\n}\n\n.btn-success[_ngcontent-%COMP%] {\n    color: #fff;\n    background-color: #192c54;\n    border-color: #192c54;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });


/***/ }),

/***/ "YcfP":
/*!***************************************!*\
  !*** ./src/app/common/env.service.ts ***!
  \***************************************/
/*! exports provided: EnvService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EnvService", function() { return EnvService; });
class EnvService {
    constructor() {
        // The values that are defined here are the default values that can
        // be overridden by env.js
        // API url
        this.apiUrl = window.location.href.split('#')[0];
        this.build_Version = '';
        this.build_Date = '';
        // Whether or not to enable debug mode
        this.enableDebug = true;
    }
}


/***/ }),

/***/ "ZAI4":
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/*! exports provided: HttpLoaderFactory, AppModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HttpLoaderFactory", function() { return HttpLoaderFactory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppModule", function() { return AppModule; });
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/platform-browser */ "jhN1");
/* harmony import */ var _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/platform-browser/animations */ "R1ws");
/* harmony import */ var _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ng-select/ng-select */ "ZOsW");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var ng_image_slider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-image-slider */ "yf9x");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");
/* harmony import */ var _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/http-loader */ "mqiu");
/* harmony import */ var ng_popups__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ng-popups */ "iQtR");
/* harmony import */ var ngx_image_cropper__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ngx-image-cropper */ "rIor");
/* harmony import */ var ngx_toastr__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ngx-toastr */ "5eHb");
/* harmony import */ var _common_auth_gaurd__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./common/auth.gaurd */ "jZVv");
/* harmony import */ var _common_BroadCaster__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./common/BroadCaster */ "oKSk");
/* harmony import */ var _common_env_service_provider__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./common/env.service.provider */ "k8eo");
/* harmony import */ var ngx_bootstrap_modal__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ngx-bootstrap/modal */ "K3ix");
/* harmony import */ var ngx_bootstrap_tabs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ngx-bootstrap/tabs */ "44PX");
/* harmony import */ var _syncfusion_ej2_angular_navigations__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @syncfusion/ej2-angular-navigations */ "hXFv");
/* harmony import */ var ngx_bootstrap_accordion__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ngx-bootstrap/accordion */ "S8xs");
/* harmony import */ var ngx_bootstrap_datepicker__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ngx-bootstrap/datepicker */ "hzby");
/* harmony import */ var ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ngx-bootstrap/pagination */ "Lm2G");
/* harmony import */ var ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ngx-bootstrap/tooltip */ "Mfq2");
/* harmony import */ var ngx_spinner__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ngx-spinner */ "JqCM");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var ngx_bootstrap_chronos__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ngx-bootstrap/chronos */ "U9ZV");
/* harmony import */ var ngx_bootstrap_locale__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ngx-bootstrap/locale */ "RWcO");
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./app-routing.module */ "vY5A");
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./app.component */ "Sy1n");
/* harmony import */ var _common_block_copy_paste_directive__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./common/block-copy-paste.directive */ "cRXe");
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./common/commonComponent */ "QSRU");
/* harmony import */ var _faq_faq_component__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./faq/faq.component */ "gN+M");
/* harmony import */ var _home_home_component__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./home/home.component */ "9vUh");
/* harmony import */ var _login_login_component__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./login/login.component */ "vtpD");
/* harmony import */ var _main_add_payment_add_payment_component__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./main/add-payment/add-payment.component */ "SWzA");
/* harmony import */ var _main_application_preview_application_preview_component__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./main/application-preview/application-preview.component */ "3WXT");
/* harmony import */ var _main_apply_visa_extension_apply_visa_extension_component__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./main/apply-visa-extension/apply-visa-extension.component */ "pa3U");
/* harmony import */ var _main_dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./main/dashboard/dashboard.component */ "kaTA");
/* harmony import */ var _main_errorpage_errorpage_component__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./main/errorpage/errorpage.component */ "q+11");
/* harmony import */ var _main_footer_footer_component__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./main/footer/footer.component */ "cWX7");
/* harmony import */ var _main_header_header_component__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./main/header/header.component */ "l//K");
/* harmony import */ var _main_main_component__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./main/main.component */ "wlho");
/* harmony import */ var _main_manage_applications_applications_details_applications_details_component__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./main/manage-applications/applications-details/applications-details.component */ "m6lr");
/* harmony import */ var _main_manage_applications_applications_list_applications_list_component__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./main/manage-applications/applications-list/applications-list.component */ "qVzU");
/* harmony import */ var _main_manage_applications_manage_applications_component__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./main/manage-applications/manage-applications.component */ "9KkW");
/* harmony import */ var _main_manage_applications_visa_details_visa_details_component__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./main/manage-applications/visa-details/visa-details.component */ "rwP4");
/* harmony import */ var _main_my_profile_my_profile_component__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./main/my-profile/my-profile.component */ "oAfG");
/* harmony import */ var _main_new_dashboard_new_dashboard_component__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./main/new-dashboard/new-dashboard.component */ "3pyi");
/* harmony import */ var _main_payment_completed_payment_completed_edit_payment_completed_edit_component__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./main/payment-completed/payment-completed-edit/payment-completed-edit.component */ "gL2n");
/* harmony import */ var _main_payment_completed_payment_completed_list_payment_completed_list_component__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./main/payment-completed/payment-completed-list/payment-completed-list.component */ "oD2D");
/* harmony import */ var _main_payment_completed_payment_completed_component__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./main/payment-completed/payment-completed.component */ "31uo");
/* harmony import */ var _main_payment_payment_component__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./main/payment/payment.component */ "NJ78");
/* harmony import */ var _main_pending_payment_pending_payment_edit_pending_payment_edit_component__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./main/pending-payment/pending-payment-edit/pending-payment-edit.component */ "1CsG");
/* harmony import */ var _main_pending_payment_pending_payment_list_pending_payment_list_component__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./main/pending-payment/pending-payment-list/pending-payment-list.component */ "2hPh");
/* harmony import */ var _main_pending_payment_pending_payment_component__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./main/pending-payment/pending-payment.component */ "lghm");
/* harmony import */ var _main_sidebar_sidebar_component__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./main/sidebar/sidebar.component */ "k69r");
/* harmony import */ var _main_success_page_success_page_component__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./main/success-page/success-page.component */ "YGF7");
/* harmony import */ var _update_password_update_password_component__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./update-password/update-password.component */ "AA6N");
/* harmony import */ var _common_captcha_captcha_service__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./common/captcha/captcha.service */ "5ZbQ");
/* harmony import */ var _main_apply_visa_extension_apply_visa_edit_apply_visa_edit_component__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./main/apply-visa-extension/apply-visa-edit/apply-visa-edit.component */ "CTGF");
/* harmony import */ var _main_apply_visa_extension_apply_visa_list_apply_visa_list_component__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./main/apply-visa-extension/apply-visa-list/apply-visa-list.component */ "YFE/");
/* harmony import */ var _main_apply_visa_extension_apply_visa_view_apply_visa_view_component__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./main/apply-visa-extension/apply-visa-view/apply-visa-view.component */ "fc9i");
/* harmony import */ var _main_dashboard_dashboard_view_dashboard_view_component__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./main/dashboard/dashboard-view/dashboard-view.component */ "qUBP");
/* harmony import */ var _main_visa_overstay_visa_overstay_component__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./main/visa-overstay/visa-overstay.component */ "TWRy");
/* harmony import */ var _visaoverstay_view_visaoverstay_view_component__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./visaoverstay-view/visaoverstay-view.component */ "vWw0");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! @angular/core */ "fXoL");






// import { NgxCaptchaModule } from '@binssoft/ngx-captcha';











// import { ToastrModule } from 'ng6-toastr-notifications';

























































Object(ngx_bootstrap_chronos__WEBPACK_IMPORTED_MODULE_24__["defineLocale"])('fr', ngx_bootstrap_locale__WEBPACK_IMPORTED_MODULE_25__["frLocale"]);
// AoT requires an exported function for factories
function HttpLoaderFactory(httpClient) {
    // return new TranslateHttpLoader(httpClient);
    return new _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_8__["TranslateHttpLoader"](httpClient, "./assets/i18n/", ".json");
}
class AppModule {
}
AppModule.ɵfac = function AppModule_Factory(t) { return new (t || AppModule)(); };
AppModule.ɵmod = _angular_core__WEBPACK_IMPORTED_MODULE_64__["ɵɵdefineNgModule"]({ type: AppModule, bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_27__["AppComponent"]] });
AppModule.ɵinj = _angular_core__WEBPACK_IMPORTED_MODULE_64__["ɵɵdefineInjector"]({ providers: [_common_auth_gaurd__WEBPACK_IMPORTED_MODULE_12__["CanLoginActivate"], _common_auth_gaurd__WEBPACK_IMPORTED_MODULE_12__["CanAuthActivate"], _common_env_service_provider__WEBPACK_IMPORTED_MODULE_14__["EnvServiceProvider"], _common_BroadCaster__WEBPACK_IMPORTED_MODULE_13__["Broadcaster"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["DatePipe"],
        _common_captcha_captcha_service__WEBPACK_IMPORTED_MODULE_57__["CaptchaService"]
    ], imports: [[
            _angular_platform_browser__WEBPACK_IMPORTED_MODULE_2__["BrowserModule"],
            _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_4__["NgSelectModule"],
            _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormsModule"],
            _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClientModule"],
            _app_routing_module__WEBPACK_IMPORTED_MODULE_26__["AppRoutingModule"],
            ngx_spinner__WEBPACK_IMPORTED_MODULE_22__["NgxSpinnerModule"],
            _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_3__["BrowserAnimationsModule"],
            _syncfusion_ej2_angular_navigations__WEBPACK_IMPORTED_MODULE_17__["TabAllModule"],
            ngx_bootstrap_modal__WEBPACK_IMPORTED_MODULE_15__["ModalModule"].forRoot(),
            ngx_toastr__WEBPACK_IMPORTED_MODULE_11__["ToastrModule"].forRoot(),
            ngx_bootstrap_tabs__WEBPACK_IMPORTED_MODULE_16__["TabsModule"].forRoot(),
            ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_20__["PaginationModule"].forRoot(),
            ngx_bootstrap_datepicker__WEBPACK_IMPORTED_MODULE_19__["BsDatepickerModule"].forRoot(),
            ng_popups__WEBPACK_IMPORTED_MODULE_9__["NgPopupsModule"].forRoot(),
            ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_21__["TooltipModule"].forRoot(),
            ngx_bootstrap_accordion__WEBPACK_IMPORTED_MODULE_18__["AccordionModule"].forRoot(),
            // NgxCaptchaModule,
            ngx_ui_loader__WEBPACK_IMPORTED_MODULE_23__["NgxUiLoaderModule"],
            ng_image_slider__WEBPACK_IMPORTED_MODULE_6__["NgImageSliderModule"],
            ngx_image_cropper__WEBPACK_IMPORTED_MODULE_10__["ImageCropperModule"],
            _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__["TranslateModule"].forRoot({
                loader: {
                    provide: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__["TranslateLoader"],
                    useFactory: HttpLoaderFactory,
                    deps: [_angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClient"]]
                }
            })
        ]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_64__["ɵɵsetNgModuleScope"](AppModule, { declarations: [_app_component__WEBPACK_IMPORTED_MODULE_27__["AppComponent"],
        _common_commonComponent__WEBPACK_IMPORTED_MODULE_29__["BaseComponent"],
        _login_login_component__WEBPACK_IMPORTED_MODULE_32__["LoginComponent"],
        _main_main_component__WEBPACK_IMPORTED_MODULE_40__["MainComponent"],
        _main_header_header_component__WEBPACK_IMPORTED_MODULE_39__["HeaderComponent"],
        _main_sidebar_sidebar_component__WEBPACK_IMPORTED_MODULE_54__["SidebarComponent"],
        _main_footer_footer_component__WEBPACK_IMPORTED_MODULE_38__["FooterComponent"],
        _main_dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_36__["DashboardComponent"],
        _main_new_dashboard_new_dashboard_component__WEBPACK_IMPORTED_MODULE_46__["NewDashboardComponent"],
        _home_home_component__WEBPACK_IMPORTED_MODULE_31__["HomeComponent"],
        _main_manage_applications_manage_applications_component__WEBPACK_IMPORTED_MODULE_43__["ManageApplicationsComponent"],
        _main_manage_applications_applications_list_applications_list_component__WEBPACK_IMPORTED_MODULE_42__["ApplicationsListComponent"],
        _main_manage_applications_applications_details_applications_details_component__WEBPACK_IMPORTED_MODULE_41__["ApplicationsDetailsComponent"],
        _main_manage_applications_visa_details_visa_details_component__WEBPACK_IMPORTED_MODULE_44__["VisaDetailsComponent"],
        _main_payment_payment_component__WEBPACK_IMPORTED_MODULE_50__["PaymentComponent"],
        _main_my_profile_my_profile_component__WEBPACK_IMPORTED_MODULE_45__["MyProfileComponent"],
        _common_block_copy_paste_directive__WEBPACK_IMPORTED_MODULE_28__["BlockCopyPasteDirective"],
        _main_application_preview_application_preview_component__WEBPACK_IMPORTED_MODULE_34__["ApplicationPreviewComponent"],
        _faq_faq_component__WEBPACK_IMPORTED_MODULE_30__["FaqComponent"],
        _main_add_payment_add_payment_component__WEBPACK_IMPORTED_MODULE_33__["AddPaymentComponent"],
        _main_success_page_success_page_component__WEBPACK_IMPORTED_MODULE_55__["SuccessPageComponent"],
        _main_payment_completed_payment_completed_component__WEBPACK_IMPORTED_MODULE_49__["PaymentCompletedComponent"],
        _main_pending_payment_pending_payment_component__WEBPACK_IMPORTED_MODULE_53__["PendingPaymentComponent"],
        _main_pending_payment_pending_payment_list_pending_payment_list_component__WEBPACK_IMPORTED_MODULE_52__["PendingPaymentListComponent"],
        _main_pending_payment_pending_payment_edit_pending_payment_edit_component__WEBPACK_IMPORTED_MODULE_51__["PendingPaymentEditComponent"],
        _main_payment_completed_payment_completed_list_payment_completed_list_component__WEBPACK_IMPORTED_MODULE_48__["PaymentCompletedListComponent"],
        _main_payment_completed_payment_completed_edit_payment_completed_edit_component__WEBPACK_IMPORTED_MODULE_47__["PaymentCompletedEditComponent"],
        _main_apply_visa_extension_apply_visa_extension_component__WEBPACK_IMPORTED_MODULE_35__["ApplyVisaExtensionComponent"],
        _main_errorpage_errorpage_component__WEBPACK_IMPORTED_MODULE_37__["ErrorpageComponent"],
        _update_password_update_password_component__WEBPACK_IMPORTED_MODULE_56__["UpdatePasswordComponent"],
        _main_apply_visa_extension_apply_visa_list_apply_visa_list_component__WEBPACK_IMPORTED_MODULE_59__["ApplyVisaListComponent"],
        _main_apply_visa_extension_apply_visa_edit_apply_visa_edit_component__WEBPACK_IMPORTED_MODULE_58__["ApplyVisaEditComponent"],
        _main_apply_visa_extension_apply_visa_view_apply_visa_view_component__WEBPACK_IMPORTED_MODULE_60__["ApplyVisaViewComponent"],
        _main_dashboard_dashboard_view_dashboard_view_component__WEBPACK_IMPORTED_MODULE_61__["DashboardViewComponent"],
        _main_visa_overstay_visa_overstay_component__WEBPACK_IMPORTED_MODULE_62__["VisaOverstayComponent"],
        _visaoverstay_view_visaoverstay_view_component__WEBPACK_IMPORTED_MODULE_63__["VisaoverstayViewComponent"]], imports: [_angular_platform_browser__WEBPACK_IMPORTED_MODULE_2__["BrowserModule"],
        _ng_select_ng_select__WEBPACK_IMPORTED_MODULE_4__["NgSelectModule"],
        _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormsModule"],
        _angular_common_http__WEBPACK_IMPORTED_MODULE_0__["HttpClientModule"],
        _app_routing_module__WEBPACK_IMPORTED_MODULE_26__["AppRoutingModule"],
        ngx_spinner__WEBPACK_IMPORTED_MODULE_22__["NgxSpinnerModule"],
        _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_3__["BrowserAnimationsModule"],
        _syncfusion_ej2_angular_navigations__WEBPACK_IMPORTED_MODULE_17__["TabAllModule"], ngx_bootstrap_modal__WEBPACK_IMPORTED_MODULE_15__["ModalModule"], ngx_toastr__WEBPACK_IMPORTED_MODULE_11__["ToastrModule"], ngx_bootstrap_tabs__WEBPACK_IMPORTED_MODULE_16__["TabsModule"], ngx_bootstrap_pagination__WEBPACK_IMPORTED_MODULE_20__["PaginationModule"], ngx_bootstrap_datepicker__WEBPACK_IMPORTED_MODULE_19__["BsDatepickerModule"], ng_popups__WEBPACK_IMPORTED_MODULE_9__["NgPopupsModule"], ngx_bootstrap_tooltip__WEBPACK_IMPORTED_MODULE_21__["TooltipModule"], ngx_bootstrap_accordion__WEBPACK_IMPORTED_MODULE_18__["AccordionModule"], 
        // NgxCaptchaModule,
        ngx_ui_loader__WEBPACK_IMPORTED_MODULE_23__["NgxUiLoaderModule"],
        ng_image_slider__WEBPACK_IMPORTED_MODULE_6__["NgImageSliderModule"],
        ngx_image_cropper__WEBPACK_IMPORTED_MODULE_10__["ImageCropperModule"], _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__["TranslateModule"]] }); })();


/***/ }),

/***/ "cRXe":
/*!******************************************************!*\
  !*** ./src/app/common/block-copy-paste.directive.ts ***!
  \******************************************************/
/*! exports provided: BlockCopyPasteDirective */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BlockCopyPasteDirective", function() { return BlockCopyPasteDirective; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");

class BlockCopyPasteDirective {
    constructor() { }
    blockPaste(e) {
        e.preventDefault();
    }
    blockCopy(e) {
        e.preventDefault();
    }
    blockCut(e) {
        e.preventDefault();
    }
}
BlockCopyPasteDirective.ɵfac = function BlockCopyPasteDirective_Factory(t) { return new (t || BlockCopyPasteDirective)(); };
BlockCopyPasteDirective.ɵdir = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({ type: BlockCopyPasteDirective, selectors: [["", "appBlockCopyPaste", ""]], hostBindings: function BlockCopyPasteDirective_HostBindings(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("paste", function BlockCopyPasteDirective_paste_HostBindingHandler($event) { return ctx.blockPaste($event); })("copy", function BlockCopyPasteDirective_copy_HostBindingHandler($event) { return ctx.blockCopy($event); })("cut", function BlockCopyPasteDirective_cut_HostBindingHandler($event) { return ctx.blockCut($event); });
    } } });


/***/ }),

/***/ "cWX7":
/*!*************************************************!*\
  !*** ./src/app/main/footer/footer.component.ts ***!
  \*************************************************/
/*! exports provided: FooterComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FooterComponent", function() { return FooterComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");

class FooterComponent {
    constructor() { }
    ngOnInit() {
    }
    gotoTop() {
        window.scroll({
            top: 0,
            left: 0,
            behavior: 'smooth'
        });
    }
}
FooterComponent.ɵfac = function FooterComponent_Factory(t) { return new (t || FooterComponent)(); };
FooterComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: FooterComponent, selectors: [["app-footer"]], decls: 7, vars: 0, consts: [[1, "footer-inner"], ["rel", "nofollow", "target", "_parent", "href", "#", 1, "tm-text-link"], [1, "footer-tools"], [1, "go-top"], [1, "fa", "fa-angle-up", 3, "click"]], template: function FooterComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " \u00A9 2024 Propuls\u00E9 par ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "a", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "Hypercube");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "span", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "i", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function FooterComponent_Template_i_click_6_listener() { return ctx.gotoTop(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } }, styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJmb290ZXIuY29tcG9uZW50LmNzcyJ9 */"] });


/***/ }),

/***/ "fc9i":
/*!****************************************************************************************!*\
  !*** ./src/app/main/apply-visa-extension/apply-visa-view/apply-visa-view.component.ts ***!
  \****************************************************************************************/
/*! exports provided: ApplyVisaViewComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApplyVisaViewComponent", function() { return ApplyVisaViewComponent; });
/* harmony import */ var src_app_common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");






function ApplyVisaViewComponent_p_101_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "Result.UnderProcessing"), "");
} }
function ApplyVisaViewComponent_p_102_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "Result.Granted"), "");
} }
function ApplyVisaViewComponent_p_103_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "Result.Rejected"), " ");
} }
function ApplyVisaViewComponent_p_121_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", data_r5 == null ? null : data_r5.description, "");
} }
function ApplyVisaViewComponent_div_122_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "label", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](5, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](5, 2, "EXTENSIONVISA.New Expiry Date"), " :");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](9, 4, ctx_r4.visaExtension == null ? null : ctx_r4.visaExtension.newExpiryDate, "dd/MM/yyyy"), "");
} }
const _c0 = function () { return ["/main/dashboard"]; };
const _c1 = function () { return ["/main/evisa-extension"]; };
class ApplyVisaViewComponent extends src_app_common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj) {
        super(inj);
        this.inj = inj;
        this.visaExtension = {};
        this.applyVisaTypes = [];
        this.activatedRoute.params.subscribe((params) => {
            this.extensionId = params['id'];
            this.getVisaExtensionType();
            this.getVisaExtensionById(this.extensionId);
        });
    }
    ngOnInit() {
    }
    getVisaExtensionById(id) {
        this.commonService.callApi('visaextension/' + id, '', 'get', false, false, 'REG').then(success => {
            this.visaExtension = success;
            console.log(this.visaExtension.visaType);
            this.visaType = this.applyVisaTypes.filter(x => x.code == this.visaExtension.visaType);
            console.log(this.visaType);
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
    getVisaExtensionType() {
        this.commonService.callApi('visadetails/extension', '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            this.applyVisaTypes = successData.masterCodeResultDTOs;
            console.log(this.applyVisaTypes);
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
}
ApplyVisaViewComponent.ɵfac = function ApplyVisaViewComponent_Factory(t) { return new (t || ApplyVisaViewComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"])); };
ApplyVisaViewComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ApplyVisaViewComponent, selectors: [["app-apply-visa-view"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 128, vars: 74, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], [3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], [1, "portlet-body", "form"], ["role", "form", 1, "form-horizontal"], [1, "form-body"], [1, "form-group"], [1, "col-md-3", "control-label"], [1, "col-md-6"], [1, "form-control-static"], ["class", "form-control-static", 4, "ngIf"], ["class", "form-control-static", 4, "ngFor", "ngForOf"], ["class", "row", 4, "ngI"], [1, "form-actions", "fluid"], [1, "text-center"], ["routerLinkActive", "active", "type", "button", 1, "btn", "default", 3, "routerLink"]], template: function ApplyVisaViewComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](14, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](24, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](25, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](27, "form", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](35, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](36, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](38, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](39, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](41, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](42);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](43, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](44, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](47, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](48, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](49, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](50, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](51);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](52, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](53, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](54, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](55);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](56, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](57, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](58, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](59, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](60);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](61, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](62, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](63, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](64);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](65, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](66, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](67, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](68, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](69);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](70, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](71, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](72, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](73);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](74, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](75, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](76, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](77, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](78);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](79, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](80, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](81, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](82);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](83, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](84, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](85, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](86, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](87, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](88);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](89, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](90, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](91, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](92);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](93, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](94, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](95, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](96, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](97, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](98);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](99, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](100, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](101, ApplyVisaViewComponent_p_101_Template, 3, 3, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](102, ApplyVisaViewComponent_p_102_Template, 3, 3, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](103, ApplyVisaViewComponent_p_103_Template, 3, 3, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](104, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](105, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](106, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](107, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](108);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](109, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](110, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](111, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](112);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](113, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](114, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](115, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](116, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](117, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](118);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](119, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](120, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](121, ApplyVisaViewComponent_p_121_Template, 2, 1, "p", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](122, ApplyVisaViewComponent_div_122_Template, 10, 7, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](123, "div", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](124, "div", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](125, "button", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](126);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](127, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 31, "EXTENSIONVISA.Apply Visa Extension"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](72, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 33, "APPLICATIONSPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](13, 35, "EXTENSIONVISA.Apply Visa Extension"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](17, 37, "PAYMENT.View"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](24, 39, "PAYMENT.View"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](34, 41, "EXTENSIONVISA.Visa Extension Number"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.visaExtension == null ? null : ctx.visaExtension.visaExtensionId);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](43, 43, "DASHBOARDPAGE.Application Number"), " : ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.visaExtension == null ? null : ctx.visaExtension.applicationNumber);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](52, 45, "EXTENSIONVISA.Daysofextension"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.visaExtension == null ? null : ctx.visaExtension.daysOfExtension, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](61, 47, "EXTENSIONVISA.Total Amount"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.visaExtension == null ? null : ctx.visaExtension.totalAmount, " USD");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](70, 49, "EXTENSIONVISA.Reasons For Extension"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.visaExtension == null ? null : ctx.visaExtension.reasonsForExtension, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](79, 51, "EXTENSIONVISA.Previous Approval DateVisa"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](83, 53, ctx.visaExtension == null ? null : ctx.visaExtension.previousExpiryDate, "dd/MM/yyyy"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](89, 56, "EXTENSIONVISA.Requested Date"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](93, 58, ctx.visaExtension == null ? null : ctx.visaExtension.requestedDate, "dd/MM/yyyy"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](99, 61, "EXTENSIONVISA.Extension status"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.visaExtension == null ? null : ctx.visaExtension.extensionStatus) == "UP");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.visaExtension == null ? null : ctx.visaExtension.extensionStatus) === "APR");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.visaExtension == null ? null : ctx.visaExtension.extensionStatus) === "REJ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](109, 63, "EXTENSIONVISA.Approval Date"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind2"](113, 65, ctx.visaExtension == null ? null : ctx.visaExtension.allocatedDate, "dd/MM/yyyy"), "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](119, 68, "APPLICATIONSPAGE.Visa Type"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngForOf", ctx.visaType);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngI", ctx.visaExtension == null ? null : ctx.visaExtension.newExpiryDate);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](73, _c1));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](127, 70, "PAYMENT.Cancel"));
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterLinkWithHref"], _angular_forms__WEBPACK_IMPORTED_MODULE_3__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_3__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_3__["NgForm"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgIf"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgForOf"], _angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterLinkActive"], _angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterLink"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslatePipe"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["DatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJhcHBseS12aXNhLXZpZXcuY29tcG9uZW50LmNzcyJ9 */"] });


/***/ }),

/***/ "gL2n":
/*!***************************************************************************************************!*\
  !*** ./src/app/main/payment-completed/payment-completed-edit/payment-completed-edit.component.ts ***!
  \***************************************************************************************************/
/*! exports provided: PaymentCompletedEditComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PaymentCompletedEditComponent", function() { return PaymentCompletedEditComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/commonComponent */ "QSRU");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_ui_loader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-ui-loader */ "gren");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");







function PaymentCompletedEditComponent_p_54_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "SIDEBAR.Manage Applications"), "");
} }
function PaymentCompletedEditComponent_p_55_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "p", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](2, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](2, 1, "EXTENSIONVISA.Apply Visa Extension"));
} }
const _c0 = function () { return ["/main/dashboard"]; };
const _c1 = function () { return ["/main/payment-completed"]; };
class PaymentCompletedEditComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    // datePipe: any;
    constructor(inj, ngxLoader, datepipe) {
        super(inj);
        this.ngxLoader = ngxLoader;
        this.datepipe = datepipe;
        this.paymentDetails = {};
        this.activatedRoute.params.subscribe((params) => {
            this.paymentDetails = params['id'];
            this.fetchPaymentDetails(this.paymentDetails);
        });
    }
    ngOnInit() {
    }
    fetchPaymentDetails(id) {
        this.commonService.callApi('payment/' + id, '', 'get', false, false, 'REG').then(success => {
            this.paymentDetails = success;
            if (this.paymentDetails.status === 'PC') {
                this.paymentDetails.status = "Payment Completed";
            }
            this.paymentDetails.createdDate = this.datepipe.transform(this.paymentDetails.createdDate, "dd-MM-yyyy HH:mm:ss");
            this.paymentDetails.updatedDate = this.datepipe.transform(this.paymentDetails.updatedDate, "dd-MM-yyyy HH:mm:ss");
        });
    }
}
PaymentCompletedEditComponent.ɵfac = function PaymentCompletedEditComponent_Factory(t) { return new (t || PaymentCompletedEditComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ngx_ui_loader__WEBPACK_IMPORTED_MODULE_2__["NgxUiLoaderService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_3__["DatePipe"])); };
PaymentCompletedEditComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: PaymentCompletedEditComponent, selectors: [["app-payment-completed-edit"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], decls: 97, vars: 52, consts: [[1, "row"], [1, "col-md-12"], [1, "page-title"], [1, "page-breadcrumb", "breadcrumb"], [2, "margin-left", "0.5rem", "margin-right", "0.5rem"], [3, "routerLink"], [1, "fa", "fa-angle-right", 2, "padding", "0 1rem"], [1, "portlet", "box", "blue"], [1, "portlet-title"], [1, "caption"], [1, "tools"], [1, "portlet-body", "form"], ["role", "form", 1, "form-horizontal"], [1, "form-body"], [1, "form-group"], [1, "col-md-3", "control-label"], [1, "col-md-6"], [1, "form-control-static"], ["class", "form-control-static", 4, "ngIf"], [1, "form-actions", "fluid"], [1, "text-center"], ["routerLinkActive", "active", "type", "button", 1, "btn", "default", 3, "routerLink"]], template: function PaymentCompletedEditComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "h3", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](5, "ul", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](6, "li", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](7, "a", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](9, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](10, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](11, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](13, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](14, "i", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](15, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](17, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](18, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](19, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](20, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](21, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](22, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](24, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelement"](25, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](26, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](27, "form", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](28, "div", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](29, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](30, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](31, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](32, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](35, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](36, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](38, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](39, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](40, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](41, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](42);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](43, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](44, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](45, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](46);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](47, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](48, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](49, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](50, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](51);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](52, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](53, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](54, PaymentCompletedEditComponent_p_54_Template, 3, 3, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](55, PaymentCompletedEditComponent_p_55_Template, 3, 3, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](56, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](57, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](58, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](59, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](60);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](61, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](62, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](63, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](64);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](65, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](66, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](67, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](68, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](69);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](70, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](71, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](72, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](73);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](74, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](75, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](76, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](77, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](78);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](79, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](80, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](81, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](82);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](83, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](84, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](85, "div", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](86, "label", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](87);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](88, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](89, "div", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](90, "p", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](91);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](92, "div", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](93, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](94, "button", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](95);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipe"](96, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](4, 24, "SIDEBAR.PaymentCompleted"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](50, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](9, 26, "APPLICATIONSPAGE.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](13, 28, "SIDEBAR.PaymentCompleted"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](17, 30, "PAYMENT.View"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](24, 32, "PAYMENT.View"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](34, 34, "PAYMENT.File Number"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.paymentDetails == null ? null : ctx.paymentDetails.fileNumber);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](43, 36, "PAYMENT.Paid Amount"), " : ");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate2"]("", ctx.paymentDetails == null ? null : ctx.paymentDetails.amountPaid, "\u00A0", ctx.paymentDetails == null ? null : ctx.paymentDetails.paymentCurrency, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](52, 38, "PAYMENT.Instruction Type"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.paymentDetails == null ? null : ctx.paymentDetails.instrType) === "EVISA_PAY");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", (ctx.paymentDetails == null ? null : ctx.paymentDetails.instrType) === "EVISA_EXT");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](61, 40, "PAYMENT.PaymentMethod"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.paymentDetails == null ? null : ctx.paymentDetails.paymentMethod, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](70, 42, "PAYMENT.Status"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.paymentDetails == null ? null : ctx.paymentDetails.status, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](79, 44, "PAYMENT.Invoiced Date"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.paymentDetails == null ? null : ctx.paymentDetails.createdDate, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"]("", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](88, 46, "PAYMENT.PaidDate"), " :");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate1"](" ", ctx.paymentDetails == null ? null : ctx.paymentDetails.updatedDate, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpureFunction0"](51, _c1));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵpipeBind1"](96, 48, "PAYMENT.Cancel"));
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLinkWithHref"], _angular_forms__WEBPACK_IMPORTED_MODULE_5__["ɵangular_packages_forms_forms_ba"], _angular_forms__WEBPACK_IMPORTED_MODULE_5__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_5__["NgForm"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLinkActive"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterLink"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__["TranslatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJwYXltZW50LWNvbXBsZXRlZC1lZGl0LmNvbXBvbmVudC5jc3MifQ== */"] });


/***/ }),

/***/ "gN+M":
/*!**************************************!*\
  !*** ./src/app/faq/faq.component.ts ***!
  \**************************************/
/*! exports provided: FaqComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FaqComponent", function() { return FaqComponent; });
/* harmony import */ var _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../common/commonComponent */ "QSRU");
/* harmony import */ var _assets_json_faq_en__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../assets/json/faq_en */ "+4dD");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngx-translate/core */ "sYmb");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ "tyNb");







function FaqComponent_div_66_p_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"]("Q: ", data_r2 == null ? null : data_r2.faqQuestion, "");
} }
function FaqComponent_div_66_p_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"]("Q: ", data_r2 == null ? null : data_r2.faqQuestionOther, "");
} }
function FaqComponent_div_66_p_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", data_r2 == null ? null : data_r2.faqAnswer, "");
} }
function FaqComponent_div_66_p_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "p", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const data_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", data_r2 == null ? null : data_r2.faqAnswerOther, "");
} }
function FaqComponent_div_66_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "div", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "h4", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, FaqComponent_div_66_p_3_Template, 2, 1, "p", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, FaqComponent_div_66_p_4_Template, 2, 1, "p", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "div", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](6, "div", 49);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](8, "label", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](10, "translate");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](11, FaqComponent_div_66_p_11_Template, 2, 1, "p", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](12, FaqComponent_div_66_p_12_Template, 2, 1, "p", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
} if (rf & 2) {
    const i_r3 = ctx.index;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵattributeInterpolate1"]("data-target", "#question", i_r3, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r1.getToken("Language") === "en");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r1.getToken("Language") === "fr");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpropertyInterpolate1"]("id", "question", i_r3, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](10, 7, "FAQ.Answer"));
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r1.getToken("Language") === "en");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngIf", ctx_r1.getToken("Language") === "fr");
} }
const _c0 = function () { return ["/faq"]; };
class FaqComponent extends _common_commonComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"] {
    constructor(inj, translate) {
        super(inj);
        this.translate = translate;
        this.oneAtATime = true;
        this.FaqList = [];
        this.homeInfo = {};
        this.windowObjectReference = null;
        // const browserLang = translate.getBrowserLang();
        // this.homeInfo.lang = browserLang;
        // translate.use(browserLang.match(/en|fr/) ? browserLang : 'en');
        // localStorage.setItem("Language", browserLang.match(/fr|fr-FR/) ? 'fr' : 'en')
        // this.setToken("Language", browserLang.match(/fr|fr-FR/) ? 'fr' : 'en')
        this.homeInfo.lang = this.getToken('Language');
        this.translate.get('DEFAULT_TITLE').subscribe((translatedTitle) => {
            this.titleService.setTitle(translatedTitle);
        });
    }
    ngOnInit() {
        console.log(_assets_json_faq_en__WEBPACK_IMPORTED_MODULE_1__["faqData"]);
        this.getFaqList();
        //this.FaqList = faqData.data;
        console.log(this.FaqList);
    }
    translateLanguage(language) {
        this.setToken("Language", language);
        localStorage.setItem("Language", language);
    }
    launchApplication(type) {
        if (type == 'L') {
            console.log("test");
            localStorage.setItem("getPage", 'loginTrue');
            this.routerUrl = window.location.href.split('#')[0];
            let endUrl = this.routerUrl + '#/login';
            this.evisaCount = localStorage.getItem("evisaCount");
            if (this.evisaCount != null) {
                this.evisaCount = Number(this.evisaCount) + 1;
            }
            else {
                this.evisaCount = 1;
            }
            // this.setToken("evisaCount", this.evisaCount);
            localStorage.setItem("evisaCount", this.evisaCount);
            if ((this.windowObjectReference == null || this.windowObjectReference.closed) && this.evisaCount == 1) {
                this.windowObjectReference = window.open(endUrl, "myWindow", "width=" + screen.width + ",height=" + screen.height + ",left=0,top=0,resizable=no,scrollbars=yes,toolbar=no,menubar=no,titlebar=no");
            }
            else if (this.windowObjectReference != null && !this.windowObjectReference.closed) {
                this.windowObjectReference.focus();
            }
            else if (this.evisaCount > 0) {
                alert('Application is already opened in another browser or tab. If not opened, clear the browser cache and try again.');
            }
        }
        else {
            localStorage.setItem("getPage", 'signupTrue');
            // this.routerUrl = window.location.href.split('#')[0];
            let endUrl = this.routerUrl + '#/login';
            this.windowObjectReference = window.open(endUrl, "myWindow", "width=" + screen.width + ",height=" + screen.height + ",left=0,top=0,resizable=no,scrollbars=yes,toolbar=no,menubar=no,titlebar=no");
        }
    }
    getFaqList() {
        this.commonService.callApi('applicant/getFaqdetails', '', 'get', false, false, 'REG').then(success => {
            let successData = success;
            console.log(successData);
            this.FaqList = successData;
        }).catch(e => {
            this.toastr.error(e.message, 'Oops!');
        });
    }
}
FaqComponent.ɵfac = function FaqComponent_Factory(t) { return new (t || FaqComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["Injector"]), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__["TranslateService"])); };
FaqComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({ type: FaqComponent, selectors: [["app-faq"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵInheritDefinitionFeature"]], decls: 106, vars: 34, consts: [[1, "no-page-top"], ["data-bg-color", "rgba(9, 103, 139, 0.36)", "data-font-color", "#fff", 1, "header1"], [1, ""], ["id", "nav-centrer", 1, "navbar-collapse", "nav-main-collapse", "collapse"], ["id", "nav-wrapper"], [1, "nav-main", "mega-menu", "one-page-menu", 2, "font-family", "Open Sans"], ["href", "index.html"], ["src", "assets/img/evisa.png", "alt", "", "width", "200px", 1, "lo"], ["id", "mainMenu", 1, "nav", "nav-pills", "nav-main", 2, "display", "flex", "align-items", "center", "margin", "auto"], [1, "active"], ["data-hash", "", "href", "#home"], ["data-hash", "", "href", "#features"], ["data-hash", "", "href", "#services"], ["data-hash", "", "href", "#screenshots"], ["data-hash", "", "href", "#contact-us"], ["href", "javascript:;", 3, "click"], ["id", "lang", "name", "lang", "required", "", "maxlength", "25", 1, "form-control", 3, "ngModel", "change", "ngModelChange"], ["lang", "ngModel"], ["value", "en"], ["value", "fr"], ["data-toggle", "collapse", "data-target", ".nav-main-collapse", 1, "btn", "btn-responsive-nav", "btn-inverse"], [1, "fa", "fa-bars"], ["id", "mu-slider"], [1, "container"], [1, "row", "col-lg-12", "col-md-12", "col-sm-12", "col-xs-12", "faqTitle"], [1, "text-center", "col-lg-12", "col-md-12", "col-sm-12", "col-xs-12"], ["id", "faqAccordion", 1, "panel-group"], ["class", "panel panel-default ", 4, "ngFor", "ngForOf"], [1, "footer-wrap"], [1, "row"], [1, "col-sm-4"], [1, "widget"], [1, "logo"], ["src", "assets/img/evisa.png", "alt", "", 1, "lo", 2, "width", "200px"], [1, "col-sm-8"], [1, "widget-heading", 2, "text-align", "right"], [1, "footer-contact-info"], [2, "padding", "0 !important"], [1, "fa", "fa-question"], ["href", "javascript:;", 3, "routerLink"], [1, "copyright"], ["rel", "nofollow", "target", "_parent", "href", "https://www.hypercube.dj", 1, "tm-text-link"], ["id", "back-to-top", 1, "animate-top"], [1, "fa", "fa-angle-up"], [1, "panel", "panel-default"], ["data-toggle", "collapse", "data-parent", "#faqAccordion", 1, "panel-heading", "accordion-toggle", "question-toggle", "collapsed"], [1, "panel-title"], ["class", "ing", "style", "cursor: pointer;", 4, "ngIf"], [1, "panel-collapse", "collapse", 2, "height", "0px", 3, "id"], [1, "panel-body"], [1, "label", "label-primary"], ["style", "font-family: Verdana, sans-serif;", 4, "ngIf"], [1, "ing", 2, "cursor", "pointer"], [2, "font-family", "Verdana, sans-serif"]], template: function FaqComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "body", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](1, "header", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](5, "nav", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](6, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](7, "a", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](8, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](9, "img", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](10, "ul", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](11, "li", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](12, "a", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](14, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](15, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](16, "a", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](17);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](18, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](19, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](20, "a", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](22, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](23, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](24, "a", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](25);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](26, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](27, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](28, "a", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](29);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](30, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](31, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](32, "a", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function FaqComponent_Template_a_click_32_listener() { return ctx.launchApplication("L"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](33);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](34, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](35, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](36, "a", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function FaqComponent_Template_a_click_36_listener() { return ctx.launchApplication("S"); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](38, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](39, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](40, "select", 16, 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("change", function FaqComponent_Template_select_change_40_listener() { ctx.translate.use(ctx.homeInfo.lang); return ctx.translateLanguage(ctx.homeInfo.lang); })("ngModelChange", function FaqComponent_Template_select_ngModelChange_40_listener($event) { return ctx.homeInfo.lang = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](42, "option", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](43, "English");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](44, "option", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](45, "Fran\u00E7ais");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](46, "button", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](47, "i", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](48, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](49, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](50, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](51, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](52, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](53, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](54, " \u00A0\u00A0 ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](55, "section", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](56, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](57, "div", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](58, "div", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](59, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](60);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](61, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](62, " \u00A0\u00A0\u00A0 ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](63, "section", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](64, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](65, "div", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](66, FaqComponent_div_66_Template, 13, 9, "div", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](67, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](68, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](69, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](70, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](71, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](72, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](73, "div", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](74, "footer");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](75, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](76, "div", 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](77, "div", 30);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](78, "section", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](79, "div", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](80, "img", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](81, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](82, "div", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](83, "section", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](84, "div", 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](85, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](86);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](87, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](88, "div", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](89, "ul", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](90, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](91, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](92, "strong");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](93, "i", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](94, "a", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](95);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipe"](96, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](97, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](98, "div", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](99, "div", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](100, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](101, "\u00A9 2024 E-visa Djibouti \u00A0 \u2022 \u00A0 ");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](102, "a", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](103, "Hypercube");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](104, "div", 42);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](105, "i", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](14, 13, "HOME.Home"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](18, 15, "HOME.Apply visa"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](22, 17, "HOME.Information"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](26, 19, "HOME.Tourist"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](30, 21, "HOME.Contact us"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](34, 23, "HOME.Login"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](38, 25, "HOME.Signup"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngModel", ctx.homeInfo.lang);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](61, 27, "FAQ.Frequently"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx.FaqList);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](87, 29, "HOME.Frequently"));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("routerLink", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction0"](33, _c0));
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate"](_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpipeBind1"](96, 31, "HOME.FAQ"));
    } }, directives: [_angular_forms__WEBPACK_IMPORTED_MODULE_4__["SelectControlValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["RequiredValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["MaxLengthValidator"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgModel"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["NgSelectOption"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__["ɵangular_packages_forms_forms_z"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgForOf"], _angular_router__WEBPACK_IMPORTED_MODULE_6__["RouterLinkWithHref"], _angular_common__WEBPACK_IMPORTED_MODULE_5__["NgIf"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__["TranslatePipe"]], styles: ["@import url('https://fonts.googleapis.com/css2?family=Homemade+Apple&display=swap');\n\n.page-content[_ngcontent-%COMP%] {\r\n  padding: 0;\r\n}\n.ie8[_ngcontent-%COMP%]   .page-content[_ngcontent-%COMP%] {\r\n  padding: 0 !important;\r\n}\n.promo-page[_ngcontent-%COMP%] {\r\n  padding-left: 0;\r\n  padding-right: 0;\r\n  \r\n}\n.promo-page[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .promo-page[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\r\n  font-size: 50px;\r\n  line-height: 60px;\r\n}\n.promo-page[_ngcontent-%COMP%]   .btn.xlarge[_ngcontent-%COMP%] {\r\n  font-size: 22px;\r\n  padding: 7px 25px;\r\n  margin: 5px 0;\r\n}\n.promo-page[_ngcontent-%COMP%]   input.form-control[_ngcontent-%COMP%] {\r\n  background: #fff;\r\n}\n\n.promo-page[_ngcontent-%COMP%]   .block-transparent[_ngcontent-%COMP%] {\r\n  min-height: 350px;\r\n  padding: 50px 20px 30px 20px;\r\n}\n.promo-page[_ngcontent-%COMP%]   .block-grey[_ngcontent-%COMP%] {\r\n  min-height: 350px;\r\n  padding: 50px 20px 30px 20px;\r\n  background: #eeedf2;\r\n}\n.promo-page[_ngcontent-%COMP%]   .block-yellow[_ngcontent-%COMP%] {\r\n  min-height: 350px;\r\n  padding: 50px 20px 30px 20px;\r\n  background: #ffd800;\r\n}\n\n.block-carousel[_ngcontent-%COMP%]   .carousel-inner[_ngcontent-%COMP%] {\r\n  padding-top: 10px;\r\n  padding-bottom: 30px;\r\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\r\n  display: none;\r\n  position: absolute;\r\n  top: 40%;\r\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-control.left[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\r\n  right: 30%;\r\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-control.right[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\r\n  left: 30%;\r\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel[_ngcontent-%COMP%]:hover   .carousel-control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\r\n  display: inline-block;\r\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-indicators[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  background-color: #666;\r\n}\n.block-carousel[_ngcontent-%COMP%]   .carousel-indicators[_ngcontent-%COMP%]   li.active[_ngcontent-%COMP%] {\r\n  background-color: #333;\r\n}\n.login[_ngcontent-%COMP%] {\r\n  background-color: none;\r\n  background-image: none;\r\n  background-size: none;\r\n}\n.faqTitle[_ngcontent-%COMP%] {\r\n  background-color: #3f8ead;\r\n  color: #fff;\r\n  margin: 0;\r\n  padding: .2em;\r\n}\nheader[_ngcontent-%COMP%]   div.logo[_ngcontent-%COMP%] {\r\n  display: table;\r\n  position: absolute;\r\n  height: 90px;\r\n  \r\n  margin-top: 15px;\r\n\r\n}\n#mu-header[_ngcontent-%COMP%] {\r\n  background-color: #192c54;\r\n  display: inline;\r\n  float: left;\r\n  width: 100%;\r\n  color: #FFFFFF;\r\n}\n.lo[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\r\n  color: #ff0157;\r\n  font-size: 2em;\r\n  font-family: 'Homemade Apple', cursive;\r\n}\nspan#gou[_ngcontent-%COMP%] {\r\n  color: #2ecc71;\r\n  font-size: 15px;\r\n}\n.lo[_ngcontent-%COMP%] {\r\n  color: #557cc4;\r\n  font-size: 4em;\r\n  font-family: Arial, Helvetica, sans-serif;\r\n  font-weight: 400;\r\n}\n.nav-tabs[_ngcontent-%COMP%], .nav-pills[_ngcontent-%COMP%] {\r\n  margin-bottom: 10px;\r\n  margin-right: -70px;\r\n}\n.copyright[_ngcontent-%COMP%] {\r\n  padding: 16px 0;\r\n  -ms-box-sizing: border-box;\r\n  box-sizing: border-box;\r\n  height: auto;\r\n  overflow: hidden;\r\n  font-size: 12px;\r\n  border-top: 0 solid transparent;\r\n  border-top-width: 1px;\r\n  background-color: #2C2C2C;\r\n  border-top-color: #333333;\r\n}\n.copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  text-decoration: none;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%] {\r\n  float: right;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  font-size: 13px;\r\n  margin: 0 !important;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child {\r\n  border-left: 0;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\r\n  display: none;\r\n}\n.copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  color: #25CBF5;\r\n}\n.widget[_ngcontent-qwu-c165][_ngcontent-%COMP%]   ul[_ngcontent-qwu-c165][_ngcontent-%COMP%] {\r\n  margin: 0;\r\n  list-style: none;\r\n}\n\n.grid[_ngcontent-%COMP%] {\r\n  list-style: none;\r\n}\n.grid[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\r\n  display: block;\r\n  float: left;\r\n  opacity: 0;\r\n}\n.grid[_ngcontent-%COMP%] > li.shown[_ngcontent-%COMP%], .no-js[_ngcontent-%COMP%]   .grid[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .no-cssanimations[_ngcontent-%COMP%]   .grid[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .grid.no-effect[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\r\n  opacity: 1;\r\n}\n\n.grid.effect-1[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  animation: fadeIn 0.65s ease forwards;\r\n}\n\n.grid.effect-2[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  transform: translateY(200px);\r\n  animation: moveUp 0.65s ease forwards;\r\n}\n\n.grid.effect-3[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  transform: scale(0.6);\r\n  animation: scaleUp 0.65s ease-in-out forwards;\r\n}\n\n.grid.effect-4[_ngcontent-%COMP%] {\r\n  -ms-perspective: 1300px;\r\n  perspective: 1300px;\r\n}\n.grid.effect-4[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  transform-style: preserve-3d;\r\n  transform: translateY(300px) rotateX(-90deg);\r\n  animation: fallPerspective .8s ease-in-out forwards;\r\n}\n\n.grid.effect-5[_ngcontent-%COMP%] {\r\n  -ms-perspective: 1300px;\r\n  perspective: 1300px;\r\n}\n.grid.effect-5[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  transform-style: preserve-3d;\r\n  transform-origin: 50% 50%;\r\n  transform: rotateX(-180deg);\r\n  animation: fly .8s ease-in-out forwards;\r\n}\n\n.grid.effect-6[_ngcontent-%COMP%] {\r\n  -ms-perspective: 1300px;\r\n  perspective: 1300px;\r\n}\n.grid.effect-6[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  transform-style: preserve-3d;\r\n  transform-origin: 0% 0%;\r\n  transform: rotateX(-80deg);\r\n  animation: flip .8s ease-in-out forwards;\r\n}\n\n.grid.effect-7[_ngcontent-%COMP%] {\r\n  -ms-perspective: 1300px;\r\n  perspective: 1300px;\r\n}\n.grid.effect-7[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  transform-style: preserve-3d;\r\n  transform: rotateY(-180deg);\r\n  animation: helix .8s ease-in-out forwards;\r\n}\n\n.grid.effect-8[_ngcontent-%COMP%] {\r\n  -ms-perspective: 1300px;\r\n  perspective: 1300px;\r\n}\n.grid.effect-8[_ngcontent-%COMP%]   li.animate[_ngcontent-%COMP%] {\r\n  transform-style: preserve-3d;\r\n  transform: scale(0.4);\r\n  animation: popUp .8s ease-in forwards;\r\n}\n\nbody.boxed-layout[_ngcontent-%COMP%] {\r\n  width: 1000px;\r\n  margin: 0px auto;\r\n  background: #F1F1F1;\r\n}\n\n.bg-special[_ngcontent-%COMP%] {\r\n  background: none;\r\n  background-image: url('irongrip.png') !important;\r\n  background-attachment: scroll;\r\n  background-size: initial;\r\n  background-position: 50% 50%;\r\n  background-repeat: repeat;\r\n}\n#back-to-top[_ngcontent-%COMP%] {\r\n  border-radius: 0px;\r\n  border-top-left-radius: 4px;\r\n  border-top-right-radius: 4px;\r\n  -moz-background-clip: padding;\r\n  -webkit-background-clip: padding-box;\r\n  background-clip: padding-box;\r\n  background-color: rgba(0, 0, 0, .4);\r\n  box-shadow: inset 0 0 5px rgba(0, 0, 0, .1);\r\n  position: fixed;\r\n  bottom: -40px;\r\n  right: 20px;\r\n  z-index: 1000;\r\n  padding: 10px 15px 10px;\r\n  cursor: pointer;\r\n  transform: translate3d(0, 0, 0);\r\n  opacity: 0;\r\n  color: #fff;\r\n}\n#back-to-top[_ngcontent-%COMP%]:hover {\r\n  color: #25CBF5;\r\n}\n#back-to-top[_ngcontent-%COMP%]   i.fa[_ngcontent-%COMP%] {\r\n  font-size: 19px;\r\n}\n.v-page-wrap[_ngcontent-%COMP%] {\r\n  margin-top: 50px;\r\n  margin-bottom: 50px;\r\n  min-height: 500px;\r\n}\n.v-page-wrap.no-bottom-spacing[_ngcontent-%COMP%] {\r\n  margin-bottom: 0;\r\n}\n.v-page-wrap.no-top-spacing[_ngcontent-%COMP%] {\r\n  margin-top: 0;\r\n}\naside.left-sidebar.sticky[_ngcontent-%COMP%] {\r\n  float: none;\r\n  position: fixed;\r\n  z-index: 6;\r\n  left: auto;\r\n  padding-top: 100px!important;\r\n}\naside.right-sidebar.sticky[_ngcontent-%COMP%] {\r\n  float: none;\r\n  position: fixed;\r\n  z-index: 6;\r\n  right: auto;\r\n  padding-top: 100px!important;\r\n}\n.has-left-sidebar[_ngcontent-%COMP%]   aside.sidebar[_ngcontent-%COMP%] {\r\n  float: left;\r\n}\n.has-left-sidebar[_ngcontent-%COMP%] > article[_ngcontent-%COMP%], .has-left-sidebar[_ngcontent-%COMP%]   .type-page[_ngcontent-%COMP%], .has-left-sidebar[_ngcontent-%COMP%]   .archive-page[_ngcontent-%COMP%], .has-left-sidebar[_ngcontent-%COMP%]   .push-right[_ngcontent-%COMP%] {\r\n  float: right!important;\r\n}\n.has-both-sidebars[_ngcontent-%COMP%]   aside.left-sidebar[_ngcontent-%COMP%] {\r\n  float: left;\r\n}\n.has-both-sidebars[_ngcontent-%COMP%]   aside.right-sidebar[_ngcontent-%COMP%] {\r\n  float: right;\r\n}\n.has-both-sidebars[_ngcontent-%COMP%] > article[_ngcontent-%COMP%], .has-both-sidebars[_ngcontent-%COMP%]   .type-page[_ngcontent-%COMP%], .has-both-sidebars[_ngcontent-%COMP%]   .archive-page[_ngcontent-%COMP%] {\r\n  float: left;\r\n}\n.has-both-sidebars[_ngcontent-%COMP%]   .page-content[_ngcontent-%COMP%] {\r\n  float: right!important;\r\n}\n.page-content[_ngcontent-%COMP%] {\r\n  border-bottom: 0 solid transparent;\r\n}\n.page-content[_ngcontent-%COMP%] > ul[_ngcontent-%COMP%] {\r\n  list-style: disc inside none;\r\n}\n.search-no-results[_ngcontent-%COMP%]   .page-content[_ngcontent-%COMP%] > h3[_ngcontent-%COMP%] {\r\n  margin-top: 0;\r\n}\n.has-both-sidebars[_ngcontent-%COMP%]   aside.sidebar[_ngcontent-%COMP%] {\r\n  padding-top: 0;\r\n}\n.v-bg-stylish[_ngcontent-%COMP%] {\r\n  margin: 0;\r\n  padding: 30px 0px;\r\n  border-top: 1px solid transparent;\r\n  border-bottom: 1px solid transparent;\r\n  box-shadow: inset 0 0 3px rgba(0, 0, 0, 0.07);\r\n  -ms-box-sizing: content-box;\r\n  box-sizing: content-box;\r\n}\n.fw-row[_ngcontent-%COMP%]   .v-bg-stylish[_ngcontent-%COMP%] {\r\n  padding-bottom: 0px;\r\n}\n.v-heading[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\r\n  font-size: 20px;\r\n  margin-right: 10px;\r\n  display: inline-block;\r\n  vertical-align: -1px;\r\n}\n.heading-wrap[_ngcontent-%COMP%] {\r\n  position: relative;\r\n  z-index: 2;\r\n}\nh4.v-heading[_ngcontent-%COMP%], h3.v-heading[_ngcontent-%COMP%], h4.v-line-heading[_ngcontent-%COMP%] {\r\n  line-height: 0 !important;\r\n  text-align: left;\r\n  padding: 10px 0;\r\n  margin-top: 0;\r\n  max-width: 100%;\r\n  -ms-text-overflow: ellipsis;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  overflow: hidden;\r\n}\nh3.v-heading[_ngcontent-%COMP%] {\r\n  margin-bottom: 28px;\r\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\r\n  display: inline-block;\r\n  position: relative;\r\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\r\n  content: \"\";\r\n  position: absolute;\r\n  height: 7px !important;\r\n  border-top: 1px solid #E9E9E9;\r\n  border-bottom: 1px solid #E9E9E9;\r\n  top: -2px;\r\n  width: 1200px;\r\n}\naside[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, aside[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\r\n  display: none;\r\n}\nh3.spb-icon-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.spb-icon-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\r\n  top: 11px;\r\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before {\r\n  right: 100%;\r\n  margin-right: 15px;\r\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\r\n  left: 100%;\r\n  margin-left: 15px;\r\n}\nh4.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\r\n  max-width: 30px;\r\n  margin: 0 -10px;\r\n}\nh3.v-center-heading[_ngcontent-%COMP%], h4.v-center-heading[_ngcontent-%COMP%] {\r\n  display: block !important;\r\n  max-width: 100%;\r\n  margin: 20px auto 45px;\r\n  text-align: center;\r\n}\nh3.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], h4.v-center-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\r\n  padding: 0 20px;\r\n  position: relative;\r\n  z-index: 5;\r\n}\n.slider-wrap[_ngcontent-%COMP%]   .heading-wrap[_ngcontent-%COMP%] {\r\n  text-align: center;\r\n  margin-bottom: 10px;\r\n}\n.v-full-width-text[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]:before, .v-bg-stylish[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]:before {\r\n  border: 0;\r\n}\n.v-full-width-text[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%], .v-bg-stylish[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\r\n  background: transparent !important;\r\n}\nh4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]   span[_ngcontent-%COMP%]:after {\r\n  border-color: #e4e4e4;\r\n}\nh4.v-heading[_ngcontent-%COMP%]:before, h3.v-heading[_ngcontent-%COMP%]:before, h4.v-line-heading[_ngcontent-%COMP%]:before {\r\n  border-top-color: #e4e4e4;\r\n}\n.no-shadow[_ngcontent-%COMP%] {\r\n  box-shadow: none !important;\r\n}\n.v-bg-stylish[_ngcontent-%COMP%]   .carousel-wrap[_ngcontent-%COMP%]   .heading-wrap[_ngcontent-%COMP%] {\r\n  text-align: center;\r\n}\n.v-bg-stylish[_ngcontent-%COMP%]   h4.v-heading[_ngcontent-%COMP%] {\r\n  display: inline-block;\r\n}\n.v-heading-v2[_ngcontent-%COMP%] {\r\n  display: block;\r\n  margin-bottom: 25px;\r\n  border-bottom: 1px dotted #e4e4e4;\r\n}\n.v-heading-v2[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%], .v-heading-v2[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%], .v-heading-v2[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\r\n  margin: 0 0 -2px 0;\r\n  padding-bottom: 7px;\r\n  display: inline-block;\r\n  border-bottom: 2px solid #25CBF5;\r\n}\n.v-heading-v2[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\r\n  margin-left: 8px;\r\n  font-size: 10px;\r\n  background-color: #25CBF5;\r\n  padding: 2px 4px;\r\n  border-radius: 50%;\r\n  font-weight: 600;\r\n  color: white;\r\n  padding-top: 1px;\r\n}\n.help-text[_ngcontent-%COMP%] {\r\n  font-size: 18px;\r\n  line-height: 26px;\r\n  margin-bottom: 60px;\r\n}\n.help-text[_ngcontent-%COMP%]   .search-form[_ngcontent-%COMP%] {\r\n  margin-bottom: 40px;\r\n}\n.help-text[_ngcontent-%COMP%]   .search-form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\r\n  font-size: 14px;\r\n}\n.help-text[_ngcontent-%COMP%]   a.btn.v-btn[_ngcontent-%COMP%] {\r\n  margin: 0;\r\n  text-transform: uppercase;\r\n}\n.no-results-text[_ngcontent-%COMP%] {\r\n  margin-top: 20px;\r\n}\n.no-results-text[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\r\n  margin-bottom: 15px;\r\n}\n.no-results-text[_ngcontent-%COMP%]   .search-form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\r\n  margin-top: 0;\r\n  margin-bottom: 60px;\r\n}\n\n.v-page-heading[_ngcontent-%COMP%] {\r\n  padding-top: 26px;\r\n  padding-bottom: 22px;\r\n  margin-top: 0;\r\n  margin-bottom: 0 !important;\r\n  position: relative;\r\n  text-align: left;\r\n  border-bottom: 1px solid transparent;\r\n  border-top: 0 !important;\r\n  box-shadow: none;\r\n}\n.header-overlay[_ngcontent-%COMP%]   .v-page-heading[_ngcontent-%COMP%] {\r\n  padding-top: 125px;\r\n}\n.v-page-heading[_ngcontent-%COMP%]   .heading-text[_ngcontent-%COMP%] {\r\n  float: left;\r\n  margin-left: 15px;\r\n}\n.v-page-heading[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\r\n  margin-top: 0;\r\n  margin-bottom: 0;\r\n  white-space: nowrap;\r\n  font-size: 22px;\r\n}\n.v-page-heading[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\r\n  margin-bottom: 0;\r\n}\n.v-page-heading.v-fancy-heading[_ngcontent-%COMP%] {\r\n  background-attachment: local;\r\n  background-size: cover;\r\n  background-repeat: repeat;\r\n  background-position: 50% 0;\r\n  text-align: center;\r\n  padding-top: 120px;\r\n  padding-bottom: 120px;\r\n  display: none;\r\n}\n.v-page-heading[_ngcontent-%COMP%] {\r\n  background-color: #f7f7f7;\r\n  border-bottom-color: #e4e4e4;\r\n}\n.v-page-heading[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .v-page-heading[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\r\n  color: #222222;\r\n}\n.v-fancy-heading[_ngcontent-%COMP%]   .heading-text[_ngcontent-%COMP%] {\r\n  float: none;\r\n  margin-left: 0;\r\n}\n.v-fancy-heading[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\r\n  font-size: 38px;\r\n  line-height: 48px;\r\n  letter-spacing: inherit;\r\n  font-family: MuseoSlab500Regular;\r\n}\n.v-fancy-heading.v-fancy-image.light-style[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .v-fancy-heading.v-fancy-image.light-style[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\r\n  color: #fff !important;\r\n}\n.v-fancy-heading.v-fancy-image.dark-style[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%], .v-fancy-heading.v-fancy-image.dark-style[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\r\n  color: #222 !important;\r\n}\n.v-page-heading.v-fancy-heading.v-fancy-top-header[_ngcontent-%COMP%] {\r\n  padding-top: 180px;\r\n  padding-bottom: 120px;\r\n}\n.v-fancy-heading.v-fancy-top-header[_ngcontent-%COMP%]   .heading-text[_ngcontent-%COMP%] {\r\n  float: left;\r\n}\n.v-fancy-heading.v-fancy-top-header.v-fancy-image.light-style[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\r\n  margin-top: 0px;\r\n  margin-left: 0px;\r\n  float: left;\r\n  opacity: 0.7;\r\n}\n\n.v-pagination[_ngcontent-%COMP%] {\r\n  margin-top: 30px;\r\n  clear: both;\r\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   span.current[_ngcontent-%COMP%] {\r\n  box-shadow: inset 0 0 9px rgba(0, 0, 0, .1);\r\n  border-color: #e4e4e4;\r\n}\n.paged[_ngcontent-%COMP%]   .v-pagination[_ngcontent-%COMP%] {\r\n  display: block!important;\r\n  visibility: visible!important;\r\n}\n.v-pagination[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\r\n  height: auto;\r\n  overflow: hidden;\r\n  margin: 15px 0;\r\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  float: left;\r\n  display: inline-block;\r\n  margin-bottom: 0;\r\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child {\r\n  border-left: 0;\r\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  padding: 10px 16px;\r\n  border: 1px solid transparent;\r\n  display: block;\r\n  margin-right: -1px;\r\n  text-decoration: none;\r\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   span[_ngcontent-%COMP%] {\r\n  padding: 8px 16px;\r\n  border: 1px solid transparent;\r\n  display: block;\r\n  margin-right: -1px;\r\n  text-decoration: none;\r\n}\n.v-pagination[_ngcontent-%COMP%]   li.next[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  margin-left: -1px;\r\n}\n.v-pagination[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\r\n  margin-left: 3px;\r\n  margin-right: 4px;\r\n}\n.v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  text-decoration: none;\r\n}\n.v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  color: #25CBF5;\r\n}\n.v-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .search-pagination[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  color: #444444;\r\n}\n.v-pagination[_ngcontent-%COMP%]   .nav-previous[_ngcontent-%COMP%] {\r\n  text-align: left;\r\n  float: left;\r\n  max-width: 45%;\r\n  -ms-text-overflow: ellipsis;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n}\n.pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > span[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover, .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > span[_ngcontent-%COMP%]:hover, .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:focus, .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > span[_ngcontent-%COMP%]:focus {\r\n  background-color: #25CBF5;\r\n  border-color: #25CBF5;\r\n}\n.pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > span[_ngcontent-%COMP%] {\r\n  border: 1px solid #e4e4e4;\r\n  color: #444444;\r\n  font-size: 13px;\r\n}\n.pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:not(.active) > a[_ngcontent-%COMP%]:hover, .pagination[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:not(.active) > span[_ngcontent-%COMP%]:hover {\r\n  color: #ffffff!important;\r\n  background: #25CBF5;\r\n  border-color: #25CBF5;\r\n}\n.pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .pagination[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\r\n  box-shadow: inset 0 0 9px rgba(0, 0, 0, .1);\r\n  background-color: #FFFFFF;\r\n  border-color: #e4e4e4;\r\n  color: #444444;\r\n  font-weight: bold;\r\n}\n.pagination-lg[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child > a[_ngcontent-%COMP%] {\r\n  border-top-left-radius: 2px;\r\n  border-bottom-left-radius: 2px;\r\n}\n.pagination-lg[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:last-child > a[_ngcontent-%COMP%] {\r\n  border-top-right-radius: 4px;\r\n  border-bottom-right-radius: 4px;\r\n}\n\n#container[_ngcontent-%COMP%]   aside.right-sidebar[_ngcontent-%COMP%] {\r\n  margin-top: -50px;\r\n  padding-top: 50px;\r\n  padding-bottom: 70px;\r\n  border-left: solid 1px #EBEBEB;\r\n  margin-bottom: -50px!important;\r\n  width: 25%!important;\r\n  padding-left: 26px;\r\n}\n#container[_ngcontent-%COMP%]   .has-right-sidebar[_ngcontent-%COMP%]   .col-sm-9[_ngcontent-%COMP%] {\r\n  border-right: solid 1px #EBEBEB;\r\n  margin-right: -1px;\r\n  padding-right: 30px!important;\r\n  width: 75%!important;\r\n  padding-left: 20px!important;\r\n}\n#container[_ngcontent-%COMP%]   .has-left-sidebar[_ngcontent-%COMP%]   .col-sm-9[_ngcontent-%COMP%] {\r\n  border-left: solid 1px #EBEBEB;\r\n  margin-left: -1px;\r\n  padding-left: 30px!important;\r\n  width: 75%!important;\r\n  padding-right: 20px!important;\r\n}\n#container[_ngcontent-%COMP%]   aside.left-sidebar[_ngcontent-%COMP%] {\r\n  margin-top: -50px;\r\n  padding-top: 50px;\r\n  padding-bottom: 70px;\r\n  border-right: solid 1px #EBEBEB;\r\n  margin-bottom: -50px!important;\r\n  width: 25%!important;\r\n  padding-right: 26px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   hr[_ngcontent-%COMP%] {\r\n  border-color: #e4e4e4;\r\n}\n.sidebar[_ngcontent-%COMP%]   .widget-heading[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\r\n  font-family: source_sans_probold, Arial, Helvetica, Tahoma, sans-serif;\r\n  letter-spacing: 1.1px;\r\n  font-weight: 400!important;\r\n  font-size: 13px;\r\n  line-height: 23px;\r\n  text-transform: uppercase;\r\n  color: #333;\r\n}\n.sidebar[_ngcontent-%COMP%] {\r\n  -ms-box-sizing: border-box;\r\n  box-sizing: border-box;\r\n}\n.sidebar.left-sidebar[_ngcontent-%COMP%] {\r\n  padding-right: 20px;\r\n}\n.sidebar.right-sidebar[_ngcontent-%COMP%] {\r\n  padding-left: 20px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .widget_heading[_ngcontent-%COMP%] {\r\n  margin-top: -6px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .widget-heading[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\r\n  margin-bottom: 15px;\r\n}\n.sidebar[_ngcontent-%COMP%]   object[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   object[_ngcontent-%COMP%] > img[_ngcontent-%COMP%]   .sidebar[_ngcontent-%COMP%]   embed[_ngcontent-%COMP%] {\r\n  width: 100%;\r\n  max-width: 100%;\r\n}\n.sidebar[_ngcontent-%COMP%]   object[_ngcontent-%COMP%] > img[_ngcontent-%COMP%] {\r\n  height: auto;\r\n}\n.sidebar[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  text-decoration: none;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-heading-v2[_ngcontent-%COMP%] {\r\n  margin-bottom: 20px !important;\r\n}\n.sidebar[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\r\n  margin: 0 0 20px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%] {\r\n  margin-left: -26px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  padding: 9px 15px;\r\n  border-bottom: 0px solid #EBEBEB !important;\r\n  padding-left: 30px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\r\n  color: #25CBF5;\r\n  font-family: 'Open Sans';\r\n  border-bottom: 1px solid #EBEBEB;\r\n  font-size: 13px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  font-size: 14px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .sidebar[_ngcontent-%COMP%]   .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li.current-menu-item[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .sidebar[_ngcontent-%COMP%]   .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  color: #25CBF5;\r\n}\n.list-toggle[_ngcontent-%COMP%]:after {\r\n  top: 9px;\r\n  right: 10px;\r\n  color: #25CBF5;\r\n  font-size: 14px;\r\n  content: \"\\f105\";\r\n  position: absolute;\r\n  font-weight: normal;\r\n  display: inline-block;\r\n  font-family: FontAwesome;\r\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%]   span.badge[_ngcontent-%COMP%] {\r\n  margin-top: 9px;\r\n  margin-right: 10px;\r\n}\n.list-group-item.active[_ngcontent-%COMP%], .list-group-item.active[_ngcontent-%COMP%]:hover, .list-group-item.active[_ngcontent-%COMP%]:focus {\r\n  border-left-color: #25CBF5;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]   i.fa[_ngcontent-%COMP%] {\r\n  width: 20px;\r\n  font-size: 14px;\r\n  opacity: .9;\r\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%]   .accordion-toggle[_ngcontent-%COMP%] {\r\n  background-color: transparent;\r\n  box-shadow: none;\r\n}\n.sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%]   .list-group-item[_ngcontent-%COMP%] {\r\n  padding: 0px;\r\n  border-left: 0px !important;\r\n  border-bottom: 1px solid #F7F7F7;\r\n  border-right: 0px !important;\r\n}\n.sidebar.left-sidebar[_ngcontent-%COMP%]   .list-group[_ngcontent-%COMP%] {\r\n  margin-left: 0px;\r\n  margin-right: -26px;\r\n}\n.sidebar.left-sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  padding-left: 5px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]   i[class*=\"icon-\"][_ngcontent-%COMP%] {\r\n  width: 20px;\r\n  font-size: 13px;\r\n  margin-right: 2px;\r\n  display: inline-block;\r\n  vertical-align: -1px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li.active[_ngcontent-%COMP%] {\r\n  border-bottom: 1px solid rgb(241, 241, 241);\r\n  border-top: 1px solid rgb(241, 241, 241);\r\n  background: #FAFAFA;\r\n  border-left: 1px solid #25CBF5 !important;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before {\r\n  content: ' ';\r\n}\n\n.v-sidebar-content-wrap[_ngcontent-%COMP%] {\r\n  padding-top: 40px;\r\n  padding-bottom: 26px;\r\n}\n.v-right-sidebar-wrap[_ngcontent-%COMP%] {\r\n  padding-top: 40px;\r\n  padding-bottom: 60px;\r\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-sidebar-content-wrap[_ngcontent-%COMP%] {\r\n  padding-right: 15px;\r\n  padding-left: 30px;\r\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-sidebar-content-wrap[_ngcontent-%COMP%]   .tab-content[_ngcontent-%COMP%] {\r\n  padding: 0px;\r\n  box-shadow: none;\r\n  border: 0px solid #fff;\r\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-wrap[_ngcontent-%COMP%] {\r\n  padding-right: 30px;\r\n  padding-left: 15px;\r\n  border-right: 1px solid #ccc;\r\n  box-shadow: inset -8px 0 15px -10px rgba(0, 0, 0, 0.2);\r\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] {\r\n  position: relative;\r\n  z-index: 101;\r\n  margin: 0 0 2em;\r\n  border-top: 1px solid #e5e5e5;\r\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\r\n  padding: 0;\r\n  margin: 0;\r\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\r\n  padding: 11px 10px !important;\r\n  color: #666;\r\n  border-bottom: 1px solid #e5e5e5;\r\n  outline: none;\r\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]   .fa[_ngcontent-%COMP%] {\r\n  width: 1em;\r\n  margin-right: 9px;\r\n  font-size: 1.15em;\r\n  text-align: center;\r\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\r\n  background-color: #f4f4f4;\r\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%], .v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:focus, .v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\r\n  color: #25CBF5;\r\n  background-color: #fff;\r\n}\n.v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] + li[_ngcontent-%COMP%] {\r\n  margin-top: 0;\r\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-inner[_ngcontent-%COMP%] {\r\n  margin-left: 0;\r\n  margin-right: -31px;\r\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-inner[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\r\n  margin: 0 1px 0 0;\r\n}\n.v-right-sidebar-nav[_ngcontent-%COMP%]   .v-right-sidebar-inner[_ngcontent-%COMP%] > .active[_ngcontent-%COMP%] {\r\n  margin-right: 0;\r\n}\n\n.widget[_ngcontent-%COMP%] {\r\n  padding-bottom: 50px;\r\n}\n.widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\r\n  margin: 0;\r\n  list-style: none;\r\n}\n.widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  margin-bottom: 0;\r\n  line-height: 19px;\r\n}\n.widget[_ngcontent-%COMP%]   ul.v-list[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  line-height: 180%;\r\n}\n.v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  padding: 10px 0;\r\n}\n.widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\r\n  padding: 10px 0;\r\n  display: block;\r\n}\n.widget[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  text-decoration: none;\r\n}\n.widget[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  text-decoration: underline;\r\n}\n.v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%], .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%] {\r\n  border-top: 1px solid transparent;\r\n}\n.v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child, .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]:first-child {\r\n  border-top: 0;\r\n}\n.v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  text-decoration: none;\r\n}\n.v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before, .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before, .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] > li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:before {\r\n  content: \"\\f105\";\r\n  font-family: FontAwesome;\r\n  font-weight: normal;\r\n  font-style: normal;\r\n  display: block;\r\n  float: right;\r\n  text-decoration: inherit;\r\n  font-size: 14px;\r\n}\n.v-nav-menu-widget[_ngcontent-%COMP%]   ul.sub-menu[_ngcontent-%COMP%] {\r\n  border-radius: 0;\r\n  \r\n  border-left: 0;\r\n  border-right: 0;\r\n  border-bottom: 0;\r\n}\n.v-nav-menu-widget[_ngcontent-%COMP%]   ul.sub-menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  padding-left: 15px;\r\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%] {\r\n  margin: 0;\r\n  padding: 0;\r\n  list-style: none;\r\n  height: auto;\r\n  overflow: hidden;\r\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  background: #f7f7f7;\r\n  border-color: #e4e4e4;\r\n}\n.widget[_ngcontent-%COMP%]   .tagcloud[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover, .widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:hover > a[_ngcontent-%COMP%] {\r\n  background-color: #25CBF5;\r\n  color: #ffffff;\r\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  float: left;\r\n  margin-bottom: 4px;\r\n}\n.widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\r\n  margin-right: 4px;\r\n  padding: 5px 8px;\r\n  text-decoration: none;\r\n  border-radius: 2px;\r\n  border: 1px solid #333333;\r\n  font-size: 11px!important;\r\n  background-size: 100% 100%;\r\n  background-position: center center;\r\n  background-color: #333333;\r\n  color: white;\r\n  font-family: 'Open Sans';\r\n}\n.widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\r\n  border-color: transparent;\r\n  background-image: url('crease.svg');\r\n}\n.browser-ie[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover, .browser-ie10[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\r\n  background-image: none;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   span.post-date[_ngcontent-%COMP%] {\r\n  display: block;\r\n  line-height: 13px;\r\n  font-size: 11px;\r\n  color: #999;\r\n  margin-bottom: 15px;\r\n  margin-top: -5px;\r\n}\n.sidebar[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  color: #25CBF5;\r\n  font-size: 14px;\r\n}\n.widget-video[_ngcontent-%COMP%]   iframe[_ngcontent-%COMP%] {\r\n  width: 100%;\r\n}\n.widget.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  height: 72px;\r\n  width: 72px;\r\n  padding: 0;\r\n  border: 0;\r\n  overflow: hidden;\r\n  float: left;\r\n  display: inline-block;\r\n  position: relative;\r\n  margin: 0 5px 5px 0;\r\n  background-image: url('crease.svg');\r\n  background-size: 100% 100%;\r\n  background-position: center center;\r\n  \r\n  transition: transform 0.3s, opacity 0.3s;\r\n  border-radius: 2px;\r\n  background-color: #25CBF5!important;\r\n  color: #ffffff;\r\n}\n.browser-ie[_ngcontent-%COMP%]   .widget.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], .browser-ie10[_ngcontent-%COMP%]   .widget.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  background-image: none;\r\n}\n.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\r\n  height: 72px;\r\n  width: auto;\r\n  min-height: 72px;\r\n  min-width: 72px;\r\n  display: block;\r\n  transition: all 0.3s ease-in-out;\r\n}\n.v-photo-stream-widget[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:hover   img[_ngcontent-%COMP%] {\r\n  -moz-opacity: 0;\r\n  opacity: 0;\r\n  filter: alpha(opacity=0);\r\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  padding: 0;\r\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after {\r\n  content: \"\\f064\";\r\n  font-family: \"FontAwesome\";\r\n  font-weight: normal;\r\n  font-style: normal;\r\n  display: inline-block;\r\n  text-decoration: inherit;\r\n  font-size: 17px;\r\n  position: absolute;\r\n  right: 50%;\r\n  top: 50%;\r\n  margin-top: -8px;\r\n  margin-right: -10px;\r\n  color: #999;\r\n  opacity: 0;\r\n  transition: all 0.3s ease-in-out;\r\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:hover   a[_ngcontent-%COMP%]:after {\r\n  opacity: 1;\r\n}\n.browser-ie[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after {\r\n  display: none;\r\n}\n.widget[_ngcontent-%COMP%]   ul.v-photo-stream-images[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after, .portfolio-grid[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:after {\r\n  color: #ffffff;\r\n}\n.widget.v-search-widget[_ngcontent-%COMP%] {\r\n  padding-bottom: 35px;\r\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%] {\r\n  position: relative;\r\n  margin-bottom: 0;\r\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\r\n  margin: 0;\r\n  border: 1px solid #e3e3e3;\r\n  width: 100%;\r\n  height: 42px;\r\n  font-size: 14px;\r\n  line-height: 19px;\r\n  padding-left: 15px;\r\n  border-radius: 0;\r\n  -moz-background-clip: padding;\r\n  -webkit-background-clip: padding-box;\r\n  background-clip: padding-box;\r\n  background: #ffffff;\r\n  border-color: #e4e4e4;\r\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   input[type=\"submit\"][_ngcontent-%COMP%] {\r\n  visibility: hidden;\r\n  height: 0;\r\n  padding: 0;\r\n}\n.v-search-widget[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]:after {\r\n  font-weight: normal;\r\n  font-style: normal;\r\n  display: inline-block;\r\n  text-decoration: inherit;\r\n  font-size: 15px;\r\n  padding-right: 15px;\r\n  position: absolute;\r\n  float: right;\r\n  top: 11px;\r\n  right: 0;\r\n  color: #A8A8A8;\r\n  content: \"\\f002\";\r\n  font-family: \"FontAwesome\";\r\n}\n\nfooter[_ngcontent-%COMP%] {\r\n  padding: 55px 0 0;\r\n  border-top: 0 solid transparent;\r\n  padding-bottom: 44px;\r\n  border-top-width: 1px;\r\n  background: #f4f4f5;\r\n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%] {\r\n  background: #f7f7f7;\r\n  border-top: 3px solid #eee;\r\n  padding: 45px 0;\r\n  padding-bottom: 30px;\r\n}\nfooter[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  color: #25CBF5;\r\n}\nfooter[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\r\n  color: #000000;\r\n  line-height: 21px;\r\n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%], .footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\r\n  color: #666;\r\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-category-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-archive-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-nav-menu-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-recent-comments-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-meta-data-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   .v-recent-entry-widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\r\n  border-color: #333333;\r\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   hr[_ngcontent-%COMP%] {\r\n  border-color: #333333;\r\n}\nfooter[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\r\n  font-family: source_sans_probold, Arial, Helvetica, Tahoma, sans-serif;\r\n  letter-spacing: 1.8px;\r\n  font-weight: 400 !important;\r\n  margin-top: 0;\r\n  margin-bottom: 20px;\r\n  padding-bottom: 0;\r\n  font-size: 13px;\r\n  line-height: 23px;\r\n  text-transform: uppercase;\r\n  display: inline-block;\r\n  width: auto;\r\n  color: #000000 !important;\r\n\r\n}\nfooter[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  color: #000000;\r\n  \r\n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  color: #444;\r\n}\nfooter[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], footer[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  text-decoration: none !important;\r\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%] {\r\n  padding-bottom: 10px;\r\n}\nfooter[_ngcontent-%COMP%]   ul.social-icons[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  border: 1px solid rgba(247, 247, 247, 0.17);\r\n  border-radius: 0 100px 100px;\r\n  margin-right: 8px;\r\n}\n.footer-v2[_ngcontent-%COMP%]   footer[_ngcontent-%COMP%]   ul.social-icons[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  border: 1px solid rgba(61, 61, 61, 0.52);\r\n}\n.copyright[_ngcontent-%COMP%] {\r\n  padding: 16px 0;\r\n  -ms-box-sizing: border-box;\r\n  box-sizing: border-box;\r\n  height: auto;\r\n  overflow: hidden;\r\n  font-size: 12px;\r\n  border-top: 0 solid transparent;\r\n  border-top-width: 1px;\r\n  background-color: #32bddd;\r\n  border-top-color: #f4f4f5;\r\n}\n.footer-v2[_ngcontent-%COMP%]   .copyright[_ngcontent-%COMP%] {\r\n  background-color: #EBEBEB;\r\n  border-top-color: #E0E0E0;\r\n}\n.copyright[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\r\n  font-size: 12px;\r\n  float: left;\r\n  margin-bottom: 0;\r\n  line-height: 24px;\r\n  color: #000000;\r\n  padding-bottom: 2px;\r\n}\n.footer-v2[_ngcontent-%COMP%]   .copyright[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\r\n  color: #555;\r\n}\n.copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%], .copyright[_ngcontent-%COMP%]   a[_ngcontent-%COMP%]:hover {\r\n  text-decoration: none;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%] {\r\n  float: right;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] {\r\n  font-size: 13px;\r\n  margin: 0 !important;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]:first-child {\r\n  border-left: 0;\r\n}\n.copyright[_ngcontent-%COMP%]   nav[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\r\n  display: none;\r\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\r\n  border: 1px solid #3F3E3E;\r\n  padding: 5px 8px;\r\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   .wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\r\n  background: #f7f7f8;\r\n  border-color: #5E5E5E;\r\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul.wp-tag-cloud[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%]:hover {\r\n  color: #fff;\r\n}\nfooter[_ngcontent-%COMP%]   .footer-contact-info[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\r\n  margin-bottom: 6px;\r\n}\nfooter[_ngcontent-%COMP%]   .footer-contact-info[_ngcontent-%COMP%]   p[_ngcontent-%COMP%]:hover{\r\n  color: #25CBF5;\r\n}\nfooter[_ngcontent-%COMP%]   .footer-contact-info[_ngcontent-%COMP%]   .fa[_ngcontent-%COMP%] {\r\n  margin-right: 10px;\r\n  font-size: 14px;\r\n  width: 12px;\r\n}\nfooter[_ngcontent-%COMP%]   .widget[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   li[_ngcontent-%COMP%] > a[_ngcontent-%COMP%] {\r\n  padding-bottom: 4px;\r\n  padding-top: 10px;\r\n}\nfooter[_n